/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.quartz.cron.util;

import com.indy.engine.core.common.FunctionType;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineRegistry;
import com.stambia.quartz.cron.BasicCronType;
import com.stambia.quartz.cron.BasicCronTypeMode;
import com.stambia.quartz.cron.CronFactory;
import com.stambia.quartz.cron.CronTrigger;
import com.stambia.quartz.cron.DailyIntervalTrigger;
import com.stambia.quartz.cron.Day;
import com.stambia.quartz.cron.DayCronType;
import com.stambia.quartz.cron.DayCronTypeMode;
import com.stambia.quartz.cron.DayOfMonthMode;
import com.stambia.quartz.cron.DeliveryType;
import com.stambia.quartz.cron.DocumentRoot;
import com.stambia.quartz.cron.ExecType;
import com.stambia.quartz.cron.IntervalUnit;
import com.stambia.quartz.cron.MonthCronType;
import com.stambia.quartz.cron.MonthCronTypeMode;
import com.stambia.quartz.cron.PurgeType;
import com.stambia.quartz.cron.PurgeUnit;
import com.stambia.quartz.cron.ScheduleParameter;
import com.stambia.quartz.cron.parser.CronParser;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;

public class CronUtils {
    private static final Logger logger = LogManager.getLogger(CronUtils.class);
    private static final String CRON_URI = "default.cron";

    private static Resource initCronResource(EditingDomain editingDomain) {
        return editingDomain.getResourceSet().createResource(URI.createURI((String)CRON_URI));
    }

    public static Resource initDeliveryScheduleResource(EditingDomain editingDomain, String deliveryName, String triggerName, String host, Integer port, String user, String password, Boolean isNew) {
        Resource resource = CronUtils.initCronResource(editingDomain);
        DocumentRoot documentRoot = CronFactory.eINSTANCE.createDocumentRoot();
        DeliveryType delivery = Boolean.TRUE.equals(isNew) ? CronUtils.createDefaultScheduleEditorModel(deliveryName, host, port, user, password) : CronParser.deliveryToModel(deliveryName, triggerName, host, port, user, password);
        documentRoot.setDeliverySchedule(delivery);
        resource.getContents().add((Object)documentRoot);
        return resource;
    }

    public static Resource initPurgeScheduleResource(EditingDomain editingDomain, String name, String host, Integer port, String user, String password, Boolean isNew) {
        Resource resource = CronUtils.initCronResource(editingDomain);
        DocumentRoot documentRoot = CronFactory.eINSTANCE.createDocumentRoot();
        PurgeType purge = Boolean.TRUE.equals(isNew) ? CronUtils.createDefaultPurgeEditorModel(name) : CronParser.purgeToModel(name, host, port, user, password);
        documentRoot.setPurgeSchedule(purge);
        resource.getContents().add((Object)documentRoot);
        return resource;
    }

    public static PurgeType createDefaultPurgeEditorModel(String name) {
        PurgeType root = CronFactory.eINSTANCE.createPurgeType();
        if (name != null && !name.isEmpty()) {
            root.setName(name);
        }
        CronTrigger cron = CronUtils.createDefaultCronTrigger();
        root.setTrigger(cron);
        root.setPurgeUnit(PurgeUnit.SESSION);
        return root;
    }

    private static void handleExecutionType(DeliveryType root, String name, String host, Integer port, String user, String password) {
        List schedules = EngineRegistry.getDefault().getLstSchedules(host, port, user, password, name);
        if (schedules != null) {
            for (Map schedule : schedules) {
                String jobName;
                if (!schedule.containsKey("jobName") || !(jobName = (String)schedule.get("jobName")).equals(name) || !schedule.containsKey("executionType")) continue;
                root.setExecutionType((Integer)schedule.get("executionType") == 1 ? ExecType.MEMORY : ExecType.COMMAND_LINE);
                break;
            }
        }
    }

    public static void handleScheduleParameter(DeliveryType root, String name, String host, Integer port, String user, String password) {
        try {
            Map mapParam;
            AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, port, user, password);
            HashMap<String, String> mapDeliv = new HashMap<String, String>();
            mapDeliv.put("name", name);
            HashMap<String, Object> mapQuestion = new HashMap<String, Object>();
            Map mapAnswer = null;
            try {
                mapQuestion.put(FunctionType.getDeliveryParams.name(), mapDeliv);
                mapAnswer = engine.get(mapQuestion);
            }
            catch (Exception e) {
                mapQuestion = new HashMap();
                mapQuestion.put(FunctionType.getDeliveryParams.name(), name);
                mapAnswer = engine.get(mapQuestion);
            }
            if (mapAnswer != null && (mapParam = (Map)mapAnswer.get(FunctionType.getDeliveryParams.name())) != null) {
                Map parameters = (Map)mapParam.get("parameters");
                for (String key : parameters.keySet()) {
                    ScheduleParameter param = CronFactory.eINSTANCE.createScheduleParameter();
                    param.setName(key);
                    param.setValue((String)((Map)parameters.get(key)).get("value"));
                    param.setIsEnabled(false);
                    root.getParameter().add((Object)param);
                }
            }
        }
        catch (Exception e1) {
            logger.warn("unexpected", (Throwable)e1);
        }
    }

    public static DeliveryType createDefaultScheduleEditorModel(String name, String host, int port, String user, String password) {
        DeliveryType root = CronFactory.eINSTANCE.createDeliveryType();
        root.setRuntimeParameter(CronFactory.eINSTANCE.createRuntimeParameter());
        root.setExecutionType(ExecType.MEMORY);
        if (name != null && !name.isEmpty()) {
            root.setName(name);
        }
        CronUtils.handleExecutionType(root, name, host, port, user, password);
        CronUtils.handleScheduleParameter(root, name, host, port, user, password);
        CronTrigger cron = CronUtils.createDefaultCronTrigger();
        root.setTrigger(cron);
        return root;
    }

    public static DailyIntervalTrigger createDefaultDailyIntervalTrigger() {
        DailyIntervalTrigger trigger = CronFactory.eINSTANCE.createDailyIntervalTrigger();
        Calendar cal = GregorianCalendar.getInstance();
        cal.set(11, 8);
        cal.set(12, 0);
        cal.set(13, 0);
        try {
            DatatypeFactory df = DatatypeFactory.newInstance();
            trigger.setStartTimeOfDay(df.newXMLGregorianCalendarTime(8, 0, 0, null, Integer.MIN_VALUE));
            trigger.setEndTimeOfDay(df.newXMLGregorianCalendarTime(18, 0, 0, null, Integer.MIN_VALUE));
            trigger.setInterval(1);
            trigger.setIntervalUnit(IntervalUnit.HOUR);
            trigger.getDayOfWeek().addAll(Day.VALUES);
        }
        catch (DatatypeConfigurationException e) {
            logger.warn("unexpected", (Throwable)e);
        }
        return trigger;
    }

    public static CronTrigger createDefaultCronTrigger() {
        CronTrigger cronTrigger = CronFactory.eINSTANCE.createCronTrigger();
        BasicCronType second = CronFactory.eINSTANCE.createBasicCronType();
        second.setMode(BasicCronTypeMode.SELECTED);
        BasicCronType minute = CronFactory.eINSTANCE.createBasicCronType();
        minute.setMode(BasicCronTypeMode.SELECTED);
        BasicCronType hour = CronFactory.eINSTANCE.createBasicCronType();
        hour.setMode(BasicCronTypeMode.SELECTED);
        DayCronType day = CronFactory.eINSTANCE.createDayCronType();
        day.setMode(DayCronTypeMode.DAY_OF_MONTH);
        day.setDayOfMonth(CronFactory.eINSTANCE.createDayOfMonth());
        day.getDayOfMonth().setMode(DayOfMonthMode.EVERY_DAY);
        day.setDayOfWeek(CronFactory.eINSTANCE.createDayOfWeek());
        MonthCronType month = CronFactory.eINSTANCE.createMonthCronType();
        month.setMode(MonthCronTypeMode.EVERY_MONTH);
        BasicCronType year = CronFactory.eINSTANCE.createBasicCronType();
        year.setMode(BasicCronTypeMode.EVERY);
        cronTrigger.setSecond(second);
        cronTrigger.setMinute(minute);
        cronTrigger.setHour(hour);
        cronTrigger.setDay(day);
        cronTrigger.setMonth(month);
        cronTrigger.setYear(year);
        return cronTrigger;
    }
}

