/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.compare.integration.egit.command;

import com.indy.emf.compare.integration.egit.command.AbstactGitLogicalCommand;
import com.indy.emf.compare.integration.egit.command.Messages;
import com.indy.emf.compare.integration.handler.EnableEMFCompareHandler;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import java.io.File;
import java.io.IOException;
import java.util.stream.Collectors;
import org.apache.felix.shell.Command;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.osgi.service.component.annotations.Component;

@ShellCommand
@Component(property={"osgi.command.scope=xdi", "osgi.command.function=gitLogicalMerge"}, service={Command.class}, enabled=true)
public class GitLogicalMergeCommand
extends AbstactGitLogicalCommand {
    @ShellCommandParameter(commutator="repositoryName")
    private String repositoryName;
    @ShellCommandParameter(commutator="reference")
    private String referenceName;
    @ShellCommandParameter(commutator="verbose")
    private boolean verbose;

    public void gitLogicalMerge(String ... params) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName() + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(s + " ");
            } else {
                b.append("\"" + s + "\" ");
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }

    @Override
    protected String doExecute() throws Exception {
        Repository repository = null;
        for (String dir : RepositoryUtil.INSTANCE.getConfiguredRepositories()) {
            File repoDir = new File(dir);
            try {
                Repository repo = RepositoryCache.INSTANCE.lookupRepository(repoDir);
                if (!repoDir.getParentFile().getName().equals(this.repositoryName)) continue;
                repository = repo;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (repository == null) {
            throw new Exception(String.format(Messages.GitLogicalMergeCommand_0, this.repositoryName));
        }
        Ref ref = repository.findRef(this.referenceName);
        if (ref == null) {
            throw new Exception(String.format(Messages.GitLogicalMergeCommand_referenceNotFoundMessage, this.referenceName));
        }
        EnableEMFCompareHandler.enableEMFCompare((boolean)true);
        MergeOperation merge = new MergeOperation(repository, this.referenceName);
        merge.setCommit(true);
        merge.setFastForwardMode(MergeCommand.FastForwardMode.FF);
        merge.execute((IProgressMonitor)new NullProgressMonitor());
        MergeResult mergeResult = merge.getResult();
        if (mergeResult != null) {
            switch (mergeResult.getMergeStatus()) {
                case FAILED: 
                case CONFLICTING: 
                case ABORTED: {
                    throw new MergeFailureException(mergeResult, this.verbose);
                }
            }
        }
        return String.format(Messages.GitLogicalMergeCommand_mergeSuccessMessage, this.referenceName);
    }

    public String getName() {
        return "gitLogicalMerge";
    }

    public String getUsage() {
        return "gitLogicalMerge -repositoryName <repository> -reference <branchName> [-verbose]";
    }

    public String getShortDescription() {
        return "Performs a merge of the specified reference. It uses xDI EMFCompare simple conflict resolution strategy.";
    }

    @Override
    protected void clearParameters() {
        this.repositoryName = null;
        this.referenceName = null;
        this.verbose = false;
    }

    static class MergeFailureException
    extends Exception {
        MergeResult result;
        boolean verbose;

        MergeFailureException(MergeResult result, boolean verbose) {
            assert (result.getConflicts() != null && !result.getConflicts().isEmpty());
            this.result = result;
            this.verbose = verbose;
        }

        @Override
        public String getMessage() {
            Object message = Messages.GitLogicalMergeCommand_mergeErrorMessage;
            if (this.result.getMergeStatus() == MergeResult.MergeStatus.CONFLICTING) {
                message = Messages.GitLogicalMergeCommand_mergeConflictMessage;
            }
            if (!this.verbose) {
                message = (String)message + Messages.GitLogicalPullCommand_verboseOptionMessage;
            }
            return String.format("%s\n%s", message, this.verbose ? this.dumpFailure() : "");
        }

        String dumpFailure() {
            String message = null;
            message = this.result.getMergeStatus() == MergeResult.MergeStatus.FAILED ? this.result.getFailingPaths().keySet().stream().map(p -> String.format("%s=%s", p, this.result.getFailingPaths().get(p))).sorted().collect(Collectors.joining("\n")) : this.result.getConflicts().keySet().stream().sorted().collect(Collectors.joining("\n"));
            return message;
        }
    }
}

