/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.compare.integration.egit.jgit;

import com.indy.emf.compare.integration.egit.jgit.StbEMFResourceMerger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.egit.core.storage.GitBlobStorage;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeSubscriber;
import org.eclipse.emf.compare.egit.internal.merge.MergeText;
import org.eclipse.emf.compare.egit.internal.merge.TreeWalkResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.storage.WorkspaceGitBlobStorage;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.BinaryBlobException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.RecursiveMerger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.submodule.SubmoduleConflict;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.TemporaryBuffer;

public class StbRecursiveMerger
extends RecursiveMerger {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private int inCoreLimit;
    private AbstractTreeIterator aBaseTree;
    private RevTree aHeadTree;
    private RevTree aMergeTree;
    private TreeWalkResourceVariantTreeProvider variantTreeProvider;
    private Set<String> emfCompareMergeFileExtension = null;

    protected StbRecursiveMerger(Repository local, boolean inCore) {
        super(local, inCore);
        this.inCoreLimit = StbRecursiveMerger.getInCoreLimit((Config)local.getConfig());
    }

    protected StbRecursiveMerger(Repository local) {
        this(local, false);
    }

    protected StbRecursiveMerger(ObjectInserter inserter, Config config) {
        super(inserter, config);
    }

    private static int getInCoreLimit(Config config) {
        return config.getInt("merge", "inCoreLimit", 0xA00000);
    }

    protected boolean processEntry(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, DirCacheBuildIterator index, WorkingTreeIterator work, boolean ignoreConflicts, Attributes[] attributes) throws IOException {
        boolean gitLinkMerging;
        this.enterSubtree = true;
        int modeO = this.tw.getRawMode(1);
        int modeT = this.tw.getRawMode(2);
        int modeB = this.tw.getRawMode(0);
        boolean bl = gitLinkMerging = StbRecursiveMerger.isGitLink(modeO) || StbRecursiveMerger.isGitLink(modeT) || StbRecursiveMerger.isGitLink(modeB);
        if (modeO == 0 && modeT == 0 && modeB == 0) {
            return true;
        }
        if (this.isIndexDirty()) {
            return false;
        }
        DirCacheEntry ourDce = null;
        if (index == null || index.getDirCacheEntry() == null) {
            if (StbRecursiveMerger.nonTree(modeO)) {
                ourDce = new DirCacheEntry(this.tw.getRawPath());
                ourDce.setObjectId((AnyObjectId)this.tw.getObjectId(1));
                ourDce.setFileMode(this.tw.getFileMode(1));
            }
        } else {
            ourDce = index.getDirCacheEntry();
        }
        if (StbRecursiveMerger.nonTree(modeO) && StbRecursiveMerger.nonTree(modeT) && this.tw.idEqual(1, 2)) {
            if (modeO == modeT) {
                this.keep(ourDce);
                return true;
            }
            int newMode = this.mergeFileModes(modeB, modeO, modeT);
            if (newMode != FileMode.MISSING.getBits()) {
                if (newMode == modeO) {
                    this.keep(ourDce);
                } else {
                    if (this.isWorktreeDirty(work, ourDce)) {
                        return false;
                    }
                    DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                    this.addToCheckout(this.tw.getPathString(), e, attributes);
                }
                return true;
            }
            if (!ignoreConflicts) {
                this.addConflict(base, ours, theirs);
                this.unmergedPaths.add(this.tw.getPathString());
                this.mergeResults.put(this.tw.getPathString(), new MergeResult(Collections.emptyList()));
            }
            return true;
        }
        if (modeB == modeT && this.tw.idEqual(0, 2)) {
            if (ourDce != null) {
                this.keep(ourDce);
            }
            return true;
        }
        if (modeB == modeO && this.tw.idEqual(0, 1)) {
            if (this.isWorktreeDirty(work, ourDce)) {
                return false;
            }
            if (StbRecursiveMerger.nonTree(modeT)) {
                DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                if (e != null) {
                    this.addToCheckout(this.tw.getPathString(), e, attributes);
                }
                return true;
            }
            if (this.tw.getTreeCount() > 4 && this.tw.getRawMode(4) == 0) {
                return true;
            }
            if (modeT != 0 && modeT == modeB) {
                return true;
            }
            this.addDeletion(this.tw.getPathString(), StbRecursiveMerger.nonTree(modeO), attributes[1]);
            return true;
        }
        if (this.tw.isSubtree()) {
            if (StbRecursiveMerger.nonTree(modeO) != StbRecursiveMerger.nonTree(modeT)) {
                if (ignoreConflicts) {
                    this.enterSubtree = false;
                    return true;
                }
                if (StbRecursiveMerger.nonTree(modeB)) {
                    this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                }
                if (StbRecursiveMerger.nonTree(modeO)) {
                    this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                }
                if (StbRecursiveMerger.nonTree(modeT)) {
                    this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                }
                this.unmergedPaths.add(this.tw.getPathString());
                this.enterSubtree = false;
                return true;
            }
            if (!StbRecursiveMerger.nonTree(modeO)) {
                return true;
            }
        }
        if (StbRecursiveMerger.nonTree(modeO) && StbRecursiveMerger.nonTree(modeT)) {
            boolean hasSymlink;
            boolean worktreeDirty = this.isWorktreeDirty(work, ourDce);
            if (!attributes[1].canBeContentMerged() && worktreeDirty) {
                return false;
            }
            if (gitLinkMerging && ignoreConflicts) {
                this.add(this.tw.getRawPath(), ours, 0, Instant.EPOCH, 0L);
                return true;
            }
            if (gitLinkMerging) {
                this.addConflict(base, ours, theirs);
                MergeResult<SubmoduleConflict> result = StbRecursiveMerger.createGitLinksMergeResult(base, ours, theirs);
                StbRecursiveMerger.setContainsConflicts(result, true);
                this.mergeResults.put(this.tw.getPathString(), result);
                this.unmergedPaths.add(this.tw.getPathString());
                return true;
            }
            if (!attributes[1].canBeContentMerged()) {
                switch (this.getContentMergeStrategy()) {
                    case OURS: {
                        this.keep(ourDce);
                        return true;
                    }
                    case THEIRS: {
                        DirCacheEntry theirEntry = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                        this.addToCheckout(this.tw.getPathString(), theirEntry, attributes);
                        return true;
                    }
                }
                this.addConflict(base, ours, theirs);
                this.unmergedPaths.add(this.tw.getPathString());
                return true;
            }
            if (worktreeDirty) {
                return false;
            }
            MergeResult result = null;
            boolean bl2 = hasSymlink = FileMode.SYMLINK.equals(modeO) || FileMode.SYMLINK.equals(modeT);
            if (!hasSymlink) {
                try {
                    result = this.contentMerge(base, ours, theirs, attributes, this.getContentMergeStrategy());
                }
                catch (BinaryBlobException binaryBlobException) {
                    // empty catch block
                }
            }
            if (result == null) {
                switch (this.getContentMergeStrategy()) {
                    case OURS: {
                        this.keep(ourDce);
                        return true;
                    }
                    case THEIRS: {
                        DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                        if (e != null) {
                            this.addToCheckout(this.tw.getPathString(), e, attributes);
                        }
                        return true;
                    }
                }
                result = new MergeResult(Collections.emptyList());
                StbRecursiveMerger.setContainsConflicts(result, true);
            }
            this.handleConflict(result, base, ours, theirs, ignoreConflicts, attributes);
        } else if (modeO != modeT && (modeO != 0 && !this.tw.idEqual(0, 1) || modeT != 0 && !this.tw.idEqual(0, 2))) {
            if (gitLinkMerging && ignoreConflicts) {
                this.add(this.tw.getRawPath(), ours, 0, Instant.EPOCH, 0L);
            } else if (gitLinkMerging) {
                this.addConflict(base, ours, theirs);
                MergeResult<SubmoduleConflict> result = StbRecursiveMerger.createGitLinksMergeResult(base, ours, theirs);
                StbRecursiveMerger.setContainsConflicts(result, true);
                this.mergeResults.put(this.tw.getPathString(), result);
                this.unmergedPaths.add(this.tw.getPathString());
            } else {
                MergeResult<RawText> result;
                boolean isSymLink;
                boolean bl3 = isSymLink = ((modeO | modeT) & 0xF000) == 40960;
                if (isSymLink) {
                    result = new MergeResult<RawText>(Collections.emptyList());
                    StbRecursiveMerger.setContainsConflicts(result, true);
                } else {
                    try {
                        result = this.contentMerge(base, ours, theirs, attributes, ContentMergeStrategy.CONFLICT);
                    }
                    catch (BinaryBlobException e) {
                        result = new MergeResult(Collections.emptyList());
                        StbRecursiveMerger.setContainsConflicts(result, true);
                    }
                }
                if (ignoreConflicts) {
                    StbRecursiveMerger.setContainsConflicts(result, true);
                    if (isSymLink) {
                        if (modeO != 0) {
                            this.keep(ourDce);
                        } else {
                            if (this.isWorktreeDirty(work, ourDce)) {
                                return false;
                            }
                            DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                            if (e != null) {
                                this.addToCheckout(this.tw.getPathString(), e, attributes);
                            }
                        }
                    } else {
                        this.updateIndex(base, ours, theirs, result, attributes[1], false);
                    }
                } else {
                    DirCacheEntry e = this.addConflict(base, ours, theirs);
                    if (modeO == 0) {
                        if (this.isWorktreeDirty(work, ourDce)) {
                            return false;
                        }
                        if (StbRecursiveMerger.nonTree(modeT) && e != null) {
                            this.addToCheckout(this.tw.getPathString(), e, attributes);
                        }
                    }
                    this.unmergedPaths.add(this.tw.getPathString());
                    this.mergeResults.put(this.tw.getPathString(), result);
                }
            }
        }
        return true;
    }

    protected boolean mergeTrees(AbstractTreeIterator baseTree, RevTree headTree, RevTree mergeTree, boolean ignoreConflicts) throws IOException {
        this.aBaseTree = baseTree;
        this.aHeadTree = headTree;
        this.aMergeTree = mergeTree;
        return super.mergeTrees(baseTree, headTree, mergeTree, ignoreConflicts);
    }

    protected boolean mergeTreeWalk(TreeWalk treeWalk, boolean ignoreConflicts) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("STARTING Recursive model merge.");
        }
        this.variantTreeProvider = new TreeWalkResourceVariantTreeProvider.Builder().setRepository(this.getRepository()).setaBaseTree(this.aBaseTree).setHeadTree(this.aHeadTree).setMergeTree(this.aMergeTree).setDircache(this.dircache).setReader(this.reader).build();
        GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber((GitResourceVariantTreeProvider)this.variantTreeProvider);
        try {
            this.refreshRoots(subscriber.roots());
        }
        catch (CoreException e) {
            this.logger.warn(MergeText.RecursiveModelMerger_RefreshError, (Throwable)e);
        }
        return super.mergeTreeWalk(treeWalk, ignoreConflicts);
    }

    private void refreshRoots(IResource[] resources) throws CoreException {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource root = iResourceArray[n2];
            if (root.isAccessible()) {
                root.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            ++n2;
        }
    }

    private void handleConflict(MergeResult<RawText> result, CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, boolean ignoreConflicts, Attributes[] attributes) throws IOException {
        String currentPath = this.tw.getPathString();
        int modeBase = this.tw.getRawMode(0);
        int modeOurs = this.tw.getRawMode(1);
        int modeTheirs = this.tw.getRawMode(2);
        int nonZeroMode = modeBase;
        if (modeBase == 0) {
            nonZeroMode = modeOurs != 0 ? modeOurs : modeTheirs;
        }
        IResource resource = this.variantTreeProvider.getResourceHandleForLocation(this.getRepository(), currentPath, FileMode.fromBits((int)nonZeroMode) == FileMode.TREE);
        boolean useEMFCompare = this.isHandledByEMFCompare(resource);
        this.updateIndex(base, ours, theirs, result, attributes[1], useEMFCompare);
        if (useEMFCompare) {
            block28: {
                if (result.containsConflicts() && !ignoreConflicts) {
                    Object oursStorage = null;
                    oursStorage = !resource.exists() ? new GitBlobStorage(this.getRepository(), currentPath, ours.getEntryObjectId(), null) : new WorkspaceGitBlobStorage(this.getRepository(), currentPath, resource.getFullPath(), ours.getEntryObjectId());
                    IStatus mergeStatus = null;
                    try {
                        StbEMFResourceMerger merger = new StbEMFResourceMerger((IStorage)oursStorage, (IStorage)new GitBlobStorage(this.getRepository(), currentPath, theirs.getEntryObjectId(), null), (IStorage)(base == null ? null : new GitBlobStorage(this.getRepository(), currentPath, base.getEntryObjectId(), null)));
                        mergeStatus = merger.merge(null, null);
                        if (!mergeStatus.isOK()) {
                            this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                            this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                            this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                            this.mergeResults.put(this.tw.getPathString(), result);
                            this.unmergedPaths.add(currentPath);
                            this.mergeResults.put(this.tw.getPathString(), result);
                            break block28;
                        }
                        File mergedFile = new File(this.nonNullRepo().getDirectory().getParentFile().getAbsolutePath() + "/" + currentPath);
                        Throwable throwable = null;
                        Object var19_21 = null;
                        try (TemporaryBuffer.LocalFile b = new TemporaryBuffer.LocalFile(this.db != null ? this.nonNullRepo().getDirectory() : null, this.inCoreLimit);){
                            block29: {
                                if (merger.savedResourceURI != null) {
                                    ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
                                    Throwable throwable2 = null;
                                    Object var23_28 = null;
                                    try (BufferedInputStream is = new BufferedInputStream(uriConverter.createInputStream(merger.savedResourceURI));){
                                        b.copy((InputStream)is);
                                        break block29;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        throw throwable2;
                                    }
                                }
                                b.copy(oursStorage.getContents());
                            }
                            Instant lastModified = mergedFile == null ? null : this.nonNullRepo().getFS().lastModifiedInstant(mergedFile);
                            int newMode = this.mergeFileModes(this.tw.getRawMode(0), this.tw.getRawMode(1), this.tw.getRawMode(2));
                            FileMode mode = newMode == FileMode.MISSING.getBits() ? FileMode.REGULAR_FILE : FileMode.fromBits((int)newMode);
                            this.workTreeUpdater.insertToIndex(b.openInputStream(), this.tw.getPathString().getBytes(StandardCharsets.UTF_8), mode, 0, lastModified, (int)b.length(), attributes[1].get("merge"));
                            this.modifiedFiles.add(currentPath);
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception ex) {
                        this.logger.warn(String.format("Git merge failed on file %s", currentPath), (Throwable)ex);
                        this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                        this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                        this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                        this.mergeResults.put(this.tw.getPathString(), result);
                        this.unmergedPaths.add(currentPath);
                        this.mergeResults.put(this.tw.getPathString(), result);
                    }
                } else {
                    this.modifiedFiles.add(currentPath);
                }
            }
            this.addToCheckout(currentPath, null, attributes);
        } else {
            if (result.containsConflicts() && !ignoreConflicts) {
                this.unmergedPaths.add(currentPath);
            }
            this.modifiedFiles.add(currentPath);
            this.addToCheckout(currentPath, null, attributes);
        }
    }

    private boolean isHandledByEMFCompare(IResource resource) {
        if (this.emfCompareMergeFileExtension == null) {
            this.emfCompareMergeFileExtension = new HashSet<String>();
            IContentType[] iContentTypeArray = ContentTypeManager.getInstance().getAllContentTypes();
            int n = iContentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] s;
                IContentType ct = iContentTypeArray[n2];
                if (ct.getId().startsWith("com.indy.emf.compare.integration.contenttype") && (s = ct.getFileSpecs(8)) != null) {
                    Collections.addAll(this.emfCompareMergeFileExtension, s);
                }
                ++n2;
            }
        }
        return this.emfCompareMergeFileExtension.contains(resource.getFileExtension());
    }

    private void updateIndex(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, MergeResult<RawText> result, Attributes attributes, boolean handledByEMFCompare) throws IOException {
        TemporaryBuffer rawMerged = null;
        try {
            File mergedFile;
            rawMerged = this.doMerge(result);
            if (result.containsConflicts() && handledByEMFCompare) {
                return;
            }
            File file = mergedFile = this.inCore ? null : this.writeMergedFile(rawMerged, attributes);
            if (result.containsConflicts()) {
                if (!handledByEMFCompare) {
                    this.addConflict(base, ours, theirs);
                    this.mergeResults.put(this.tw.getPathString(), result);
                }
                return;
            }
            Instant lastModified = mergedFile == null ? null : this.nonNullRepo().getFS().lastModifiedInstant(mergedFile);
            int newMode = this.mergeFileModes(this.tw.getRawMode(0), this.tw.getRawMode(1), this.tw.getRawMode(2));
            FileMode mode = newMode == FileMode.MISSING.getBits() ? FileMode.REGULAR_FILE : FileMode.fromBits((int)newMode);
            this.workTreeUpdater.insertToIndex(rawMerged.openInputStream(), this.tw.getPathString().getBytes(StandardCharsets.UTF_8), mode, 0, lastModified, (int)rawMerged.length(), attributes.get("merge"));
        }
        finally {
            if (rawMerged != null) {
                rawMerged.destroy();
            }
        }
    }

    private File writeMergedFile(TemporaryBuffer rawMerged, Attributes attributes) throws IOException {
        File workTree = this.nonNullRepo().getWorkTree();
        FS fs = this.nonNullRepo().getFS();
        File of = new File(workTree, this.tw.getPathString());
        File parentFolder = of.getParentFile();
        CoreConfig.EolStreamType eol = this.workTreeUpdater.detectCheckoutStreamType(attributes);
        if (!fs.exists(parentFolder)) {
            parentFolder.mkdirs();
        }
        this.workTreeUpdater.updateFileWithContent(() -> ((TemporaryBuffer)rawMerged).openInputStream(), eol, this.tw.getSmudgeCommand(attributes), of.getPath(), of);
        return of;
    }

    private TemporaryBuffer doMerge(MergeResult<RawText> result) throws IOException {
        TemporaryBuffer.LocalFile buf = new TemporaryBuffer.LocalFile(this.db != null ? this.nonNullRepo().getDirectory() : null, this.workTreeUpdater.getInCoreFileSizeLimit());
        boolean success = false;
        try {
            new MergeFormatter().formatMerge((OutputStream)buf, result, Arrays.asList(this.commitNames), StandardCharsets.UTF_8);
            buf.close();
            success = true;
        }
        finally {
            if (!success) {
                buf.destroy();
            }
        }
        return buf;
    }

    private MergeResult<RawText> contentMerge(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, Attributes[] attributes, ContentMergeStrategy strategy) throws BinaryBlobException, IOException {
        RawText baseText = base == null ? RawText.EMPTY_TEXT : this.getRawText(base.getEntryObjectId(), attributes[0]);
        RawText ourText = ours == null ? RawText.EMPTY_TEXT : this.getRawText(ours.getEntryObjectId(), attributes[1]);
        RawText theirsText = theirs == null ? RawText.EMPTY_TEXT : this.getRawText(theirs.getEntryObjectId(), attributes[2]);
        this.mergeAlgorithm.setContentMergeStrategy(strategy);
        return this.mergeAlgorithm.merge((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)baseText, (Sequence)ourText, (Sequence)theirsText);
    }

    private RawText getRawText(ObjectId id, Attributes attributes) throws IOException, BinaryBlobException {
        if (id.equals((AnyObjectId)ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        ObjectLoader loader = LfsFactory.getInstance().applySmudgeFilter(this.getRepository(), this.reader.open((AnyObjectId)id, 3), attributes.get("merge"));
        int threshold = 0x3200000;
        return RawText.load((ObjectLoader)loader, (int)threshold);
    }

    private static MergeResult<SubmoduleConflict> createGitLinksMergeResult(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs) {
        return new MergeResult(Arrays.asList(new SubmoduleConflict(base == null ? null : base.getEntryObjectId()), new SubmoduleConflict(ours == null ? null : ours.getEntryObjectId()), new SubmoduleConflict(theirs == null ? null : theirs.getEntryObjectId())));
    }

    private DirCacheEntry addConflict(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs) {
        this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
        this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
        return this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
    }

    private DirCacheEntry add(byte[] path, CanonicalTreeParser p, int stage, Instant lastMod, long len) {
        if (p != null && !p.getEntryFileMode().equals(FileMode.TREE)) {
            return this.workTreeUpdater.addExistingToIndex(p.getEntryObjectId(), path, p.getEntryFileMode(), stage, lastMod, (int)len);
        }
        return null;
    }

    private boolean isWorktreeDirty(WorkingTreeIterator work, DirCacheEntry ourDce) throws IOException {
        boolean isDirty;
        if (work == null) {
            return false;
        }
        int modeF = this.tw.getRawMode(4);
        int modeO = this.tw.getRawMode(1);
        if (ourDce != null) {
            isDirty = work.isModified(ourDce, true, this.reader);
        } else {
            isDirty = work.isModeDifferent(modeO);
            if (!isDirty && StbRecursiveMerger.nonTree(modeF)) {
                boolean bl = isDirty = !this.tw.idEqual(4, 1);
            }
        }
        if (isDirty && modeF == 16384 && modeO == 0) {
            isDirty = false;
        }
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), ResolveMerger.MergeFailureReason.DIRTY_WORKTREE);
        }
        return isDirty;
    }

    private int mergeFileModes(int modeB, int modeO, int modeT) {
        if (modeO == modeT) {
            return modeO;
        }
        if (modeB == modeO) {
            return modeT == FileMode.MISSING.getBits() ? modeO : modeT;
        }
        if (modeB == modeT) {
            return modeO == FileMode.MISSING.getBits() ? modeT : modeO;
        }
        return FileMode.MISSING.getBits();
    }

    private DirCacheEntry keep(DirCacheEntry e) {
        return this.workTreeUpdater.addExistingToIndex(e.getObjectId(), e.getRawPath(), e.getFileMode(), e.getStage(), e.getLastModifiedInstant(), e.getLength());
    }

    private static boolean isGitLink(int mode) {
        return FileMode.GITLINK.equals(mode);
    }

    private static boolean nonTree(int mode) {
        return mode != 0 && !FileMode.TREE.equals(mode);
    }

    private boolean isIndexDirty() {
        boolean isDirty;
        if (this.inCore) {
            return false;
        }
        int modeI = this.tw.getRawMode(3);
        int modeO = this.tw.getRawMode(1);
        boolean bl = isDirty = StbRecursiveMerger.nonTree(modeI) && (modeO != modeI || !this.tw.idEqual(3, 1));
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), ResolveMerger.MergeFailureReason.DIRTY_INDEX);
        }
        return isDirty;
    }

    private static final void setContainsConflicts(MergeResult<?> r, boolean value) {
        boolean accessible = false;
        Method m = null;
        try {
            try {
                m = r.getClass().getMethod("setContainsConflict", Boolean.TYPE);
                accessible = m.canAccess(r);
                m.setAccessible(value);
                m.invoke(r, true);
            }
            catch (Exception ex) {
                LogManager.getLogger(StbRecursiveMerger.class).warn("unexpected", (Throwable)ex);
                if (m != null) {
                    m.setAccessible(accessible);
                }
            }
        }
        finally {
            if (m != null) {
                m.setAccessible(accessible);
            }
        }
    }
}

