/*
 * Decompiled with CFR 0.152.
 */
package com.indy.administration.impl;

import com.indy.administration.AdministrationHelper;
import com.indy.administration.AdministrationListener;
import com.indy.administration.AdministrationService;
import com.indy.administration.Role;
import com.indy.administration.impl.BasePermission;
import com.indy.administration.impl.BaseRole;
import com.indy.administration.impl.ComponentService;
import com.semarchy.xdi.designer.core.services.IComponentService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={AdministrationService.class})
public class AdministrationServiceImpl
implements AdministrationService {
    private static final String ALIAS_UNLIMITED_ROLE = "unlimited";
    private static final String ALIAS_PUBLISH_WEBSERVICE = "feature_webservice_publication";
    private static final String ALIAS_SCHEDULER = "feature_scheduler";
    private static final String ALIAS_RUNTIME_SELECTION = "feature_select_runtime";
    private static final String ALIAS_CUSTOM_TECHNOLOGIES = "feature_workspace_technologies";
    static final MessageDigest MD5Digest;
    private Map<String, Role> allRoles = new HashMap<String, Role>();
    private Map<String, BaseRole> componentRoles = new HashMap<String, BaseRole>();
    private Collection<Role> activeRole = Collections.synchronizedCollection(new HashSet());
    private Map<String, Collection<String>> componentTransitiveRoles = new HashMap<String, Collection<String>>();
    private Collection<AdministrationListener> listeners = Collections.synchronizedCollection(new HashSet());
    private Logger logger = LogManager.getLogger(AdministrationServiceImpl.class);

    static {
        try {
            MD5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AdminServiceException(e);
        }
    }

    @Activate
    public void initialize() {
        BaseRole trialRole = new BaseRole("com.indy.administration.role.trial");
        this.initialize(trialRole);
        this.allRoles.put(AdministrationServiceImpl.toMD5("com.indy.administration.role.trial"), trialRole);
        BaseRole adminRole = new BaseRole("com.indy.administration.role.admin");
        this.initialize(adminRole);
        this.allRoles.put(AdministrationServiceImpl.toMD5("com.indy.administration.role.admin"), adminRole);
        BaseRole standardRole = new BaseRole("com.indy.administration.role.standard");
        this.initialize(standardRole);
        this.allRoles.put(AdministrationServiceImpl.toMD5("com.indy.administration.role.standard"), standardRole);
        BaseRole webServicePublication = new BaseRole("com.indy.administration.role.webservicepublisher");
        this.initialize(webServicePublication);
        this.allRoles.put(AdministrationServiceImpl.toMD5("com.indy.administration.role.webservicepublisher"), webServicePublication);
        BaseRole scheduler = new BaseRole("com.indy.administration.role.scheduler");
        this.initialize(scheduler);
        this.allRoles.put(AdministrationServiceImpl.toMD5("com.indy.administration.role.scheduler"), scheduler);
        BaseRole runtimeSelection = new BaseRole("com.indy.administration.role.selectruntime");
        this.initialize(runtimeSelection);
        this.allRoles.put(AdministrationServiceImpl.toMD5("com.indy.administration.role.selectruntime"), runtimeSelection);
        BaseRole customTechnologies = new BaseRole("com.indy.administration.role.customtechnologies");
        this.initialize(customTechnologies);
        this.allRoles.put(AdministrationServiceImpl.toMD5("com.indy.administration.role.customtechnologies"), customTechnologies);
    }

    @Deactivate
    public void deactivate() {
        AdministrationHelper.releaseService(this);
    }

    private void initialize(BaseRole role) {
        URL url = Platform.getBundle((String)"com.indy.administration").getResource("/com/indy/administration/impl/" + role.getName());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));){
                String buf = null;
                while ((buf = br.readLine()) != null) {
                    if (buf.startsWith("#")) continue;
                    String[] p = buf.split("=");
                    this.addPermission(role, p);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            this.logger.error("Faile to read permissions for role {}", (Object)role.getName(), (Object)ex);
        }
    }

    private void addPermission(BaseRole role, String[] permission) {
        try {
            role.addPermission(new BasePermission(permission[0], Boolean.valueOf(permission[1])));
        }
        catch (Exception ex) {
            this.logger.error("Failed to add permission on role {}", (Object)role.getName(), (Object)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isAllowed(String permission) {
        Collection<Role> collection = this.activeRole;
        synchronized (collection) {
            Role role;
            Iterator<Role> iterator = this.activeRole.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(role = iterator.next()).allow(permission));
            return true;
        }
    }

    @Override
    public void addListener(AdministrationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(AdministrationListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRoleChanged() {
        Collection<AdministrationListener> collection = this.listeners;
        synchronized (collection) {
            for (AdministrationListener l : this.listeners) {
                l.handleRoleChanged();
            }
        }
    }

    @Override
    public void setCurrentRole(String ... roleName) {
        List rolesHash = Arrays.stream(roleName).map(r -> {
            if (ALIAS_UNLIMITED_ROLE.equals(r)) {
                return "com.indy.administration.role.admin";
            }
            if (ALIAS_PUBLISH_WEBSERVICE.equals(r)) {
                return "com.indy.administration.role.webservicepublisher";
            }
            if (ALIAS_SCHEDULER.equals(r)) {
                return "com.indy.administration.role.scheduler";
            }
            if (ALIAS_RUNTIME_SELECTION.equals(r)) {
                return "com.indy.administration.role.selectruntime";
            }
            if (ALIAS_CUSTOM_TECHNOLOGIES.equals(r)) {
                return "com.indy.administration.role.customtechnologies";
            }
            return r;
        }).map(AdministrationServiceImpl::toMD5).filter(key -> this.allRoles.get(key) != null).collect(Collectors.toList());
        HashSet<Role> newRoles = new HashSet<Role>();
        for (String s : rolesHash) {
            Role role = this.allRoles.get(s);
            newRoles.add(role);
            Role componentRole = this.componentRoles.get(s);
            if (componentRole != role) continue;
            newRoles.addAll(this.getTransitiveRoles(role));
        }
        boolean notify = false;
        HashSet<Role> current = new HashSet<Role>(this.activeRole);
        if (!newRoles.equals(current)) {
            this.activeRole.clear();
            this.activeRole.addAll(newRoles);
            notify = true;
        }
        if (notify) {
            this.notifyRoleChanged();
        }
    }

    private Collection<Role> getTransitiveRoles(Role role) {
        List<Role> res = Collections.emptyList();
        Collection<String> transtivesRoleNames = this.componentTransitiveRoles.get(role.getName());
        if (transtivesRoleNames == null) {
            return res;
        }
        res = transtivesRoleNames.stream().map(roleName -> this.allRoles.get(roleName)).filter(r -> r != null).toList();
        return res;
    }

    public static String toMD5(String str) {
        try {
            byte[] array = MD5Digest.digest(str.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < array.length) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
                ++i;
            }
            return sb.toString();
        }
        catch (Exception ex) {
            throw new AdminServiceException(ex);
        }
    }

    @Override
    public void createRole4Component(IComponentService.IComponent component) {
        Assert.isNotNull((Object)component);
        BaseRole role = this.componentRoles.get(component.getLicensePermission());
        if (role == null) {
            role = new BaseRole(component.getLicensePermission());
            this.componentRoles.put(component.getLicensePermission(), role);
            role.addPermission(new BasePermission("com.indy.administration.permission.component." + component.getLicensePermission(), true));
            this.allRoles.put(component.getLicensePermission(), role);
        }
        if (component instanceof ComponentService.Component) {
            ComponentService.Component impl = (ComponentService.Component)component;
            for (String permission : impl.additionalPermissionsGranted()) {
                this.componentTransitiveRoles.computeIfAbsent(impl.getLicensePermission(), k -> new HashSet()).add(permission);
            }
        }
    }

    static class AdminServiceException
    extends RuntimeException {
        public AdminServiceException(Exception ex) {
        }
    }
}

