/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator;

import com.indy.ui.common.constante.Constante;
import com.indy.ui.common.listener.NavigatorListener;
import com.indy.ui.common.listener.NotificationManager;
import com.indy.ui.common.resource.IResource;
import com.indy.ui.common.resource.IResourceChanged;
import com.indy.ui.common.resource.IStambiaRuntime;
import com.indy.ui.common.resource.IStatusResource;
import com.stambia.ui.navigator.NavigatorFacade;
import com.stambia.ui.navigator.cnf.DataModelLabelProvider;
import com.stambia.ui.navigator.cnf.IDataModelViewer;
import com.stambia.ui.navigator.internal.actions.OpenEditorAction;
import com.stambia.ui.navigator.internal.data.AbstractResource;
import com.stambia.ui.navigator.internal.data.DataModel;
import com.stambia.ui.navigator.internal.data.OwnDelivery;
import com.stambia.ui.navigator.internal.data.OwnRuntime;
import com.stambia.ui.navigator.internal.data.OwnSchedule;
import com.stambia.ui.navigator.internal.data.ResourceWithChildren;
import com.stambia.ui.navigator.message.Messages;
import com.stambia.ui.resource.ResourcePluginStambia;
import java.rmi.RemoteException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.progress.WorkbenchJob;

public class StambiaResourceNavigator
extends CommonNavigator {
    private DataModel model;
    private String initialText = "";
    private NavigatorListener navigatorListener = new NavigatorListener(){

        public IResource addSchedule(IResource parentDelivery, String scheduleId) {
            return OwnSchedule.create(parentDelivery, scheduleId);
        }

        public void updateScheduleName(IResource resource, String triggerName, String name) {
            resource.setName(name);
            if (resource instanceof OwnSchedule) {
                ((OwnSchedule)resource).setTriggerName(triggerName);
            }
        }

        public void refreshRuntimes(List<IStambiaRuntime> newRuntimes) {
            StambiaResourceNavigator.this.model.refreshRuntimes(newRuntimes);
        }

        public void refreshEERepository(boolean validate) {
            StambiaResourceNavigator.this.model.getRoot(Constante.OWN_EE_REPOSITORIES).synchronize(true);
            if (validate && StambiaResourceNavigator.this.model.getRoot(Constante.OWN_EE_REPOSITORIES) instanceof IStatusResource) {
                ((IStatusResource)StambiaResourceNavigator.this.model.getRoot(Constante.OWN_EE_REPOSITORIES)).synchronizeStatus();
            }
        }

        public void updateRepositoryProjectStatus(IResource project) {
            DecoratingLabelProvider labelProvider = (DecoratingLabelProvider)StambiaResourceNavigator.this.getCommonViewer().getLabelProvider();
            DataModelLabelProvider modelLabelProvier = (DataModelLabelProvider)labelProvider.getLabelProvider();
            modelLabelProvier._fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)modelLabelProvier, (Object)project));
            for (IResource resource : project.getResources()) {
                modelLabelProvier._fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)modelLabelProvier, (Object)resource));
            }
        }

        public void updateRepositoryBuilderStatus(IResource builder) {
            DecoratingLabelProvider labelProvider = (DecoratingLabelProvider)StambiaResourceNavigator.this.getCommonViewer().getLabelProvider();
            DataModelLabelProvider modelLabelProvier = (DataModelLabelProvider)labelProvider.getLabelProvider();
            modelLabelProvier._fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)modelLabelProvier, (Object)builder.getParent()));
            modelLabelProvier._fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)modelLabelProvier, (Object)builder));
        }

        public void refreshItem(IResource element) {
            StambiaResourceNavigator.this.dataModelViewer.refreshItem(element);
        }

        public void addCriteria(String navFolderType) {
            NavigatorFacade.refreshSessionReportsRootFolder(StambiaResourceNavigator.this.model, navFolderType);
        }

        public void refreshRuntimes() {
            StambiaResourceNavigator.this.model.getOwnRuntimes().synchronize(true);
        }
    };
    private IDataModelViewer dataModelViewer;
    private Job refreshJob;
    private Composite treeComposite;
    final PatternFilter patternFilter = new PatternFilter(){

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            boolean isMatch = false;
            if (element instanceof IResource) {
                String labelText = ((IResource)element).getName();
                isMatch |= this.wordMatches(labelText);
            }
            return isMatch;
        }
    };
    private Text filterText;

    public void setFocus() {
        this.getCommonViewer().getTree().setFocus();
    }

    private void createRefreshJob() {
        this.refreshJob = this.doCreateRefreshJob();
        this.refreshJob.setSystem(true);
    }

    private String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : null;
    }

    private Job doCreateRefreshJob() {
        return new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (StambiaResourceNavigator.this.getCommonViewer().getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = StambiaResourceNavigator.this.getFilterString();
                if (text == null) {
                    return Status.OK_STATUS;
                }
                boolean bl = initial = StambiaResourceNavigator.this.initialText != null && StambiaResourceNavigator.this.initialText.equals(text);
                if (initial) {
                    StambiaResourceNavigator.this.patternFilter.setPattern(null);
                } else if (text != null) {
                    StambiaResourceNavigator.this.patternFilter.setPattern(text);
                }
                StambiaResourceNavigator.this.getCommonViewer().refresh(true);
                if (text.length() > 0 && !initial) {
                    TreeItem[] items = StambiaResourceNavigator.this.getCommonViewer().getTree().getItems();
                    int treeHeight = StambiaResourceNavigator.this.getCommonViewer().getTree().getBounds().height;
                    int numVisibleItems = treeHeight / StambiaResourceNavigator.this.getCommonViewer().getTree().getItemHeight();
                    long stopTime = 200L + System.currentTimeMillis();
                    boolean cancel = false;
                    if (items.length > 0 && this.recursiveExpand(items, monitor, stopTime, new int[]{numVisibleItems})) {
                        cancel = true;
                    }
                    if (cancel) {
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }

            private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                boolean canceled = false;
                int i = 0;
                while (!canceled && i < items.length) {
                    boolean visible;
                    TreeItem item = items[i];
                    int n = numItemsLeft[0];
                    numItemsLeft[0] = n - 1;
                    boolean bl = visible = n >= 0;
                    if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                        canceled = true;
                    } else {
                        Object itemData = item.getData();
                        if (itemData != null) {
                            if (!item.getExpanded()) {
                                StambiaResourceNavigator.this.getCommonViewer().setExpandedState(itemData, true);
                            }
                            TreeItem[] children = item.getItems();
                            if (items.length > 0) {
                                canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                            }
                        }
                    }
                    ++i;
                }
                return canceled;
            }
        };
    }

    private void textChanged() {
        this.refreshJob.schedule(200L);
    }

    public void createPartControl(Composite aParent) {
        aParent.setLayout((Layout)new GridLayout());
        this.treeComposite = new Composite(aParent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.treeComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.treeComposite);
        this.filterText = new Text(this.treeComposite, 2436);
        this.patternFilter.setIncludeLeadingWildcard(true);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StambiaResourceNavigator.this.textChanged();
            }
        });
        this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256 && StambiaResourceNavigator.this.filterText != null) {
                    StambiaResourceNavigator.this.filterText.setText("");
                    StambiaResourceNavigator.this.getCommonViewer().collapseAll();
                }
                StambiaResourceNavigator.this.textChanged();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filterText);
        super.createPartControl(this.treeComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.getCommonViewer().getTree());
        this.getCommonViewer().getTree().setData("org.eclipse.rap.rwt.customVariant", (Object)"NavigatorTree");
        this.getCommonViewer().setLabelProvider((IBaseLabelProvider)new DataModelLabelProvider());
        this.getCommonViewer().addFilter((ViewerFilter)this.patternFilter);
        this.getCommonViewer().setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ResourceWithChildren && e2 instanceof ResourceWithChildren) {
                    return ((AbstractResource)e1).getOrder().compareTo(((AbstractResource)e2).getOrder());
                }
                if (e1 instanceof AbstractResource && e2 instanceof ResourceWithChildren) {
                    return 1;
                }
                if (e1 instanceof ResourceWithChildren && e2 instanceof AbstractResource) {
                    return -1;
                }
                if (e1 instanceof AbstractResource && e2 instanceof AbstractResource) {
                    return ((AbstractResource)e1).getOrder().compareTo(((AbstractResource)e2).getOrder());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.getCommonViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                boolean ok = true;
                if (event.getSelection() instanceof StructuredSelection) {
                    Object o = ((StructuredSelection)event.getSelection()).getFirstElement();
                    OwnRuntime runtime = null;
                    if (o instanceof OwnRuntime) {
                        runtime = (OwnRuntime)o;
                    } else if (o instanceof OwnSchedule) {
                        runtime = ((OwnSchedule)o).getRuntime();
                    } else if (o instanceof OwnDelivery) {
                        runtime = ((OwnDelivery)o).getRuntime();
                    }
                    if (runtime != null && o instanceof OwnRuntime) {
                        ok = false;
                        runtime.synchronize(true);
                        if (runtime.getConnectionException() instanceof RemoteException) {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.get().StambiaResourceNavigator_3, (String)((RemoteException)runtime.getConnectionException()).getMessage());
                        }
                    }
                }
                if (ok) {
                    new OpenEditorAction((ISelectionProvider)StambiaResourceNavigator.this.getCommonViewer(), "").run();
                }
            }
        });
    }

    protected void handleDoubleClick(DoubleClickEvent anEvent) {
        Object o;
        if (anEvent.getSelection() instanceof StructuredSelection && !((o = ((StructuredSelection)anEvent.getSelection()).getFirstElement()) instanceof OwnDelivery)) {
            super.handleDoubleClick(anEvent);
        }
    }

    protected Object getInitialInput() {
        this.model = new DataModel();
        this.dataModelViewer = new IDataModelViewer(){

            @Override
            public void addItem(IResource newElement) {
                ResourcePluginStambia.getDefault().getResourceListenerManager().notifyAdded(newElement);
            }

            @Override
            public void removeItem(IResource element) {
                ResourcePluginStambia.getDefault().getResourceListenerManager().notifyRemoved(element);
            }

            @Override
            public void updateItem(IResourceChanged resourceChanged) {
                ResourcePluginStambia.getDefault().getResourceListenerManager().notifyChanged(resourceChanged);
            }

            @Override
            public void moveItem(IResource element) {
                ResourcePluginStambia.getDefault().getResourceListenerManager().notifyMoved(element);
            }

            @Override
            public void refreshItem(IResource element) {
                StambiaResourceNavigator.this.getCommonViewer().refresh((Object)element, true);
            }
        };
        NotificationManager.getInstance().addNavigatorListener(this.navigatorListener);
        this.model.getChangeListeners().add(this.dataModelViewer);
        this.model.refreshAllNavigator();
        this.createRefreshJob();
        return this.model;
    }

    public void dispose() {
        if (this.model != null) {
            this.model.dispose();
            this.model = null;
        }
        this.dataModelViewer = null;
        NotificationManager.getInstance().removeNavigatorListener(this.navigatorListener);
        super.dispose();
    }
}

