/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.actions;

import com.indy.engine.log.engine.EngineRegistry;
import com.indy.engine.log.exchange.DeliveryMapWrapper;
import com.indy.ui.common.resource.IResource;
import com.indy.ui.tools.widget.InputListDialog;
import com.indy.ui.utils.DeliveryUtils;
import com.stambia.ui.navigator.internal.actions.AbstractAction;
import com.stambia.ui.navigator.internal.data.OwnDelivery;
import com.stambia.ui.navigator.internal.data.OwnRuntime;
import com.stambia.ui.navigator.message.Messages;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;

public class ExecuteDelivery
extends AbstractAction {
    private static final Logger LOGGER = Logger.getLogger(ExecuteDelivery.class.getName());

    public void run(IAction action) {
        for (IResource item : this.selectedItems) {
            if (!(item instanceof OwnDelivery)) continue;
            OwnDelivery delivery = (OwnDelivery)item;
            OwnRuntime runtime = delivery.getRuntime();
            String host = runtime.getHost();
            int port = runtime.getPort();
            String user = runtime.getUser();
            String password = runtime.getPassword();
            String deliveryName = delivery.getName();
            Map variables = null;
            try {
                DeliveryMapWrapper delivWrapper = EngineRegistry.getDefault().getDelivery(host, Integer.valueOf(port), user, password, deliveryName, delivery.getRepoDir());
                if (!delivWrapper.getParameters().isEmpty()) {
                    InputListDialog dialog = new InputListDialog(Display.getDefault().getActiveShell(), delivWrapper.getParameters(), Messages.get().ExecuteDelivery_0, Messages.get().ExecuteDelivery_1);
                    if (dialog.open() == 1) {
                        return;
                    }
                    variables = dialog.getVariables();
                }
                DeliveryUtils.executeDelivery((String)host, (int)port, (String)user, (String)password, (String)deliveryName, null, (Map)variables, (String[])EngineRegistry.getDefault().getDeliveryConfiguration(host, port, user, password, deliveryName, delivery.getRepoDir(), delivery.getRuntime().getLogLevel()), (String)delivery.getRepoDir(), (String)delivery.getRuntime().getLogLevel());
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }
}

