/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.actions;

import com.indy.ui.common.constante.Constante;
import com.indy.ui.common.editor.input.ScheduleEditorInput;
import com.indy.ui.common.resource.IResource;
import com.stambia.ui.navigator.internal.actions.AbstractAction;
import com.stambia.ui.navigator.internal.data.OwnDelivery;
import com.stambia.ui.navigator.internal.data.OwnRuntimeRepositories;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NewSchedule
extends AbstractAction {
    private static final Logger LOGGER = Logger.getLogger(NewSchedule.class.getName());

    public void run(IAction action) {
        this.createNewSchedule();
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        TreeSelection treeSelection;
        super.selectionChanged(action, selection);
        action.setEnabled(false);
        if (selection instanceof TreeSelection && (treeSelection = (TreeSelection)selection).size() == 1) {
            for (IResource item : this.selectedItems) {
                OwnRuntimeRepositories runtimeRepo;
                if (item == null || !Boolean.TRUE.equals((runtimeRepo = (OwnRuntimeRepositories)((OwnDelivery)item).getParent()).isDefault())) continue;
                action.setEnabled(true);
            }
        }
    }

    private void createNewSchedule() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = window.getActivePage();
        for (IResource item : this.selectedItems) {
            try {
                activePage.openEditor((IEditorInput)new ScheduleEditorInput("New Schedule (" + item.getName() + ")", null, item, ((OwnDelivery)item).getRuntime().getHost(), ((OwnDelivery)item).getRuntime().getPort(), ((OwnDelivery)item).getRuntime().getUser(), ((OwnDelivery)item).getRuntime().getPassword(), true, ((OwnDelivery)item).getRepoDir(), ((OwnDelivery)item).getLogLevel()), Constante.DELIVERY_EDITOR_ID);
            }
            catch (PartInitException e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }
}

