/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.actions;

import com.indy.engine.log.engine.EngineRegistry;
import com.indy.ui.common.resource.IResource;
import com.stambia.ui.navigator.internal.actions.AbstractAction;
import com.stambia.ui.navigator.internal.data.OwnRuntime;
import com.stambia.ui.navigator.internal.data.OwnSchedule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

public class PauseSchedule
extends AbstractAction {
    public void run(IAction action) {
        for (IResource item : this.selectedItems) {
            if (!(item instanceof OwnSchedule)) continue;
            OwnSchedule schedule = (OwnSchedule)item;
            OwnRuntime runtime = schedule.getRuntime();
            EngineRegistry.getDefault().pauseTrigger(runtime.getHost(), Integer.valueOf(runtime.getPort()), runtime.getUser(), runtime.getPassword(), schedule.getTriggerName(), "Deliveries");
            item.synchronize(false);
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        for (IResource item : this.selectedItems) {
            if (!action.isEnabled() || !(item instanceof OwnSchedule)) continue;
            OwnSchedule ownSchedule = (OwnSchedule)item;
            action.setEnabled(false);
            String host = ownSchedule.getRuntime().getHost();
            int port = ownSchedule.getRuntime().getPort();
            String user = ownSchedule.getRuntime().getUser();
            String password = ownSchedule.getRuntime().getPassword();
            if (!EngineRegistry.getDefault().isRuntimes17_1_14(host, Integer.valueOf(port), user, password) || EngineRegistry.getDefault().isSchedulePaused(ownSchedule.getRuntime().getHost(), ownSchedule.getRuntime().getPort(), user, password, ownSchedule.getTriggerName(), "Deliveries")) continue;
            action.setEnabled(true);
        }
    }
}

