/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.actions;

import com.indy.ui.common.resource.IResource;
import com.stambia.ui.navigator.message.Messages;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class RenameWizard
extends Wizard {
    private String name;
    private IResource element;
    private HashSet<String> fileNames;

    public boolean performFinish() {
        return this.element.rename(this.name);
    }

    public void init(IResource element) {
        this.setWindowTitle(Messages.get().RenameWizardTitle);
        this.fileNames = new HashSet();
        this.element = element;
        for (IResource res : element.getParent().getResources()) {
            this.fileNames.add(res.getName());
        }
    }

    public void addPages() {
        RenameWizardPage initialObjectCreationPage = new RenameWizardPage("rename");
        this.addPage((IWizardPage)initialObjectCreationPage);
    }

    public String getName() {
        return this.name;
    }

    public class RenameWizardPage
    extends WizardPage {
        private Text newNameField;
        protected ModifyListener validator;

        public RenameWizardPage(String pageId) {
            super(pageId);
            this.validator = e -> this.setPageComplete(this.validatePage());
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
            GridDataFactory.fillDefaults().applyTo((Control)composite);
            Label label = new Label(composite, 0);
            label.setText(Messages.get().RenameWizardNameLabel);
            this.newNameField = new Text(composite, 2048);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.newNameField);
            this.newNameField.setText(RenameWizard.this.element.getName());
            this.newNameField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            RenameWizard.this.name = this.newNameField.getText();
            if (RenameWizard.this.fileNames.contains(RenameWizard.this.name)) {
                this.setErrorMessage(MessageFormat.format(Messages.get().RenameWizardNameExist, RenameWizard.this.name));
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.newNameField.setFocus();
            }
        }

        public void selectFileField() {
            this.newNameField.selectAll();
            this.newNameField.setFocus();
        }
    }
}

