/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.data;

import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineRegistry;
import com.indy.ui.common.constante.Constante;
import com.indy.ui.common.editor.input.RuntimeEditorInput;
import com.indy.ui.common.resource.IResource;
import com.indy.ui.common.resource.IResourceWithCache;
import com.indy.ui.common.resource.IRuntime;
import com.indy.ui.common.resource.IRuntimeChanged;
import com.indy.ui.common.resource.IStambiaRuntime;
import com.stambia.ui.navigator.RuntimeSynchronizer;
import com.stambia.ui.navigator.internal.data.ResourceWithChildren;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class OwnRuntime
extends ResourceWithChildren
implements IRuntime,
IRuntimeChanged,
IResourceWithCache {
    private IStambiaRuntime runtime;
    private Exception connectionException;
    private RuntimeSynchronizer sync;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private Map<String, List<Map<String, Object>>> deliverySchedules;
    int status = 0;
    private String version;
    private String host;

    public String getHost() {
        return this.runtime.getHost();
    }

    public int getPort() {
        return this.runtime.getPort();
    }

    public Boolean isNoSessionAccess() {
        return this.runtime.isNoSessionAccess();
    }

    public OwnRuntime(IStambiaRuntime runtime, IResource parent, RuntimeSynchronizer sync) {
        super(runtime.getName(), parent, runtime.getUUID());
        this.runtime = runtime;
        this.sync = sync;
        this.deliverySchedules = new HashMap<String, List<Map<String, Object>>>();
    }

    public void cacheSchedules(AnalyticsEngineWrapper engine) {
        try {
            if (EngineRegistry.getDefault().isRuntimes17_4_3(engine)) {
                engine.getLstSchedules(null).forEach(schedule -> this.addSchedule((String)schedule.get("deliveryName"), (Map<String, Object>)schedule, false));
            } else {
                HashMap<String, Object> mapRepo = new HashMap<String, Object>();
                mapRepo.put("dir", null);
                engine.getLstDeliveries(mapRepo).forEach(deliv -> {
                    try {
                        engine.getLstSchedules(deliv).forEach(schedule -> this.addSchedule((String)deliv, (Map<String, Object>)schedule, !EngineRegistry.getDefault().isRuntimes17_3_0(engine)));
                    }
                    catch (Exception e) {
                        this.logger.error("unexpected", (Throwable)e);
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error("unexpected", (Throwable)e);
        }
    }

    public void addSchedule(String deliveryName, Map<String, Object> schedule, boolean handleScheduleName) {
        this.deliverySchedules.computeIfAbsent(deliveryName, key -> new ArrayList());
        if (handleScheduleName) {
            String scheduleDeliveryName = (String)schedule.get("deliveryName");
            scheduleDeliveryName = scheduleDeliveryName == null ? (String)schedule.get("jobName") : scheduleDeliveryName;
            schedule.put("deliveryName", scheduleDeliveryName);
        }
        this.deliverySchedules.get(deliveryName).add(schedule);
    }

    public void clearDeliverySchedules(String deliveryName) {
        if (this.deliverySchedules.containsKey(deliveryName)) {
            this.deliverySchedules.get(deliveryName).clear();
        }
    }

    public List<Map<String, Object>> getSchedules(String deliveryName) {
        return this.deliverySchedules.containsKey(deliveryName) ? this.deliverySchedules.get(deliveryName) : Collections.emptyList();
    }

    public String getUser() {
        return this.runtime.getUser();
    }

    public String getPassword() {
        return this.runtime.getPassword();
    }

    public String getLogLevel() {
        return this.runtime.getLogLevel();
    }

    public IStambiaRuntime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(IStambiaRuntime runtime) {
        this.runtime = runtime;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setConnectionException(Exception connectionException) {
        this.connectionException = connectionException;
    }

    public void synchronize(boolean deeply) {
        this.refreshCache();
    }

    @Override
    public void dispose() {
        this.runtime = null;
        super.dispose();
    }

    public Exception getConnectionException() {
        return this.connectionException;
    }

    public String getFullName() {
        if (this.version != null && !this.version.isEmpty()) {
            return this.getName() + " (" + this.getHost() + ":" + this.getPort() + ") - " + this.version;
        }
        return this.getName() + " (" + this.getHost() + ":" + this.getPort() + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof OwnRuntime) {
            return this.resourceId.equals(((OwnRuntime)obj).resourceId);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.resourceId.hashCode();
    }

    public boolean openEditor(IWorkbenchPage activePage, String actionId) {
        try {
            activePage.openEditor((IEditorInput)new RuntimeEditorInput(this.getHost(), this.getPort(), this.getResourceId(), this.getName(), this.getUser(), this.getPassword()), Constante.RUNTIME_EDITOR_ID);
        }
        catch (PartInitException e) {
            this.logger.warn("unexpected", (Throwable)e);
            return false;
        }
        return true;
    }

    public void refreshCache() {
        this.sync.refresh(this);
    }
}

