/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.data;

import com.indy.engine.core.common.objects2.IDeliveryRepositoryInfo;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.ui.common.resource.IResource;
import com.indy.ui.common.resource.IRuntime;
import com.indy.ui.common.resource.IStambiaRuntime;
import com.stambia.ui.navigator.NavigatorActivator;
import com.stambia.ui.navigator.data.INavigatorItem;
import com.stambia.ui.navigator.data.IPotentialResource;
import com.stambia.ui.navigator.internal.data.OwnDelivery;
import com.stambia.ui.navigator.internal.data.OwnRuntime;
import com.stambia.ui.navigator.internal.data.ResourceWithChildren;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;

public class OwnRuntimeRepositories
extends ResourceWithChildren
implements INavigatorItem {
    private static final Logger LOGGER = Logger.getLogger(OwnRuntimeRepositories.class.getName());
    private String dirName;
    private IDeliveryRepositoryInfo esd;
    private AnalyticsEngineWrapper engine;

    public OwnRuntimeRepositories(String name, IResource parent, String resourceId, IDeliveryRepositoryInfo esd, AnalyticsEngineWrapper engine) {
        super(name, parent, resourceId);
        this.dirName = esd.getName();
        this.esd = esd;
        this.engine = engine;
    }

    public String getDirName() {
        return this.dirName;
    }

    public Boolean isDefault() {
        if (this.esd.isDefault() && !this.isWsdl().booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean isWsdl() {
        return this.esd.isWebservice();
    }

    public String getType() {
        return this.esd.getType();
    }

    public void synchronize(boolean deeply) {
        try {
            ArrayList<IPotentialResource> resources = new ArrayList<IPotentialResource>();
            HashMap<String, String> mapRepo = new HashMap<String, String>();
            mapRepo.put("dir", this.dirName);
            List deliveryNames = this.engine.getLstDeliveries(mapRepo);
            for (final String delivery : deliveryNames) {
                final String resourceId = this.getResourceId() + "/" + delivery;
                final String logLevel = ((OwnRuntime)this.parent).getLogLevel();
                resources.add(new IPotentialResource(){

                    @Override
                    public String getName() {
                        return delivery;
                    }

                    @Override
                    public IResource createResource() {
                        return new OwnDelivery(delivery, OwnRuntimeRepositories.this, resourceId, logLevel);
                    }

                    @Override
                    public String getId() {
                        return resourceId;
                    }
                });
            }
            this.synchronize(resources, deeply);
            resources.clear();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
    }

    public IStambiaRuntime getRuntime() {
        return ((IRuntime)this.getParent()).getRuntime();
    }

    @Override
    public Image getImage() {
        Image img = null;
        if (this.isDefault().booleanValue()) {
            if (this.getType().equals("Http")) {
                img = NavigatorActivator.getDefault().getImage("RuntimeRepositoryDefaultWSDL_grey.png");
                return img;
            }
            img = NavigatorActivator.getDefault().getImage("RuntimeRepositoryDefault_grey.png");
            return img;
        }
        if (this.getType().equals("Http")) {
            img = NavigatorActivator.getDefault().getImage("RuntimeRepositoryWSDL_grey.png");
            return img;
        }
        img = NavigatorActivator.getDefault().getImage("RuntimeRepository_grey.png");
        return img;
    }

    public boolean openEditor(IWorkbenchPage activePage, String actionId) {
        return false;
    }

    @Override
    public void remove() {
    }
}

