/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.data;

import com.indy.engine.log.engine.EngineRegistry;
import com.indy.ui.common.constante.Constante;
import com.indy.ui.common.editor.input.ScheduleEditorInput;
import com.indy.ui.common.listener.NotificationManager;
import com.indy.ui.common.resource.IResource;
import com.stambia.ui.navigator.NavigatorActivator;
import com.stambia.ui.navigator.data.ISchedule;
import com.stambia.ui.navigator.internal.data.AbstractResource;
import com.stambia.ui.navigator.internal.data.OwnDelivery;
import com.stambia.ui.navigator.internal.data.OwnRuntime;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class OwnSchedule
extends AbstractResource
implements ISchedule {
    private static final Logger LOGGER = Logger.getLogger(OwnSchedule.class.getName());
    private Map<String, Object> scheduleDetails;
    private String triggerName;

    public void setScheduleDetails(Map<String, Object> scheduleDetails) {
        this.scheduleDetails = scheduleDetails;
    }

    public OwnSchedule(String name, IResource parent, String resourceId, String triggerName) {
        super(name, parent, resourceId);
        this.triggerName = triggerName;
    }

    public Map<String, Object> getScheduleDetails() {
        return this.scheduleDetails;
    }

    public void synchronize(boolean deeply) {
        NotificationManager.getInstance().refreshItem((IResource)this);
    }

    public OwnRuntime getRuntime() {
        return (OwnRuntime)this.getParent().getParent().getParent();
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    @Override
    public void dispose() {
        this.scheduleDetails = null;
        super.dispose();
    }

    @Override
    public Image getImage() {
        if (EngineRegistry.getDefault().isSchedulePaused(this.getRuntime().getHost(), this.getRuntime().getPort(), this.getRuntime().getUser(), this.getRuntime().getPassword(), this.getTriggerName(), "Deliveries")) {
            return NavigatorActivator.getDefault().getImage("pausedSchedule.png");
        }
        return NavigatorActivator.getDefault().getImage("clock.png");
    }

    public boolean openEditor(IWorkbenchPage activePage, String actionId) {
        try {
            ScheduleEditorInput scheduleEditorInput = new ScheduleEditorInput(this.getTriggerName(), (IResource)this, this.getParent(), this.getRuntime().getHost(), this.getRuntime().getPort(), this.getRuntime().getUser(), this.getRuntime().getPassword(), false, ((OwnDelivery)this.getParent()).getRepoDir(), ((OwnDelivery)this.getParent()).getLogLevel());
            activePage.openEditor((IEditorInput)scheduleEditorInput, Constante.DELIVERY_EDITOR_ID);
        }
        catch (PartInitException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            return false;
        }
        return true;
    }

    @Override
    public void remove() {
        EngineRegistry.getDefault().removeJobTrigger(this.getRuntime().getHost(), Integer.valueOf(this.getRuntime().getPort()), this.getRuntime().getUser(), this.getRuntime().getPassword(), this.getTriggerName(), "Deliveries");
        ((OwnDelivery)this.getParent()).removeChild(this);
    }

    public static IResource create(IResource parent, String id) {
        return ((OwnDelivery)parent).synchronizeSchedule(id);
    }
}

