/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.logging.appender;

import java.text.MessageFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

@Plugin(name="ErrorLog", category="Core", elementType="appender")
public class ErrorLogAppender
extends AbstractAppender {
    private static final String PROP_BUNDLE_NAME = "bundle.name";
    private static final String MESSAGE = "{1} (Message reported by logger {0})";
    private ILog log = null;

    private ErrorLogAppender(String name, Filter filter) {
        super(name, filter, null, true, Property.EMPTY_ARRAY);
    }

    private ILog getEclipseLog() {
        Bundle systemBundle;
        if (this.log == null && (systemBundle = Platform.getBundle((String)"system.bundle")) != null) {
            this.log = Platform.getLog((Bundle)systemBundle);
        }
        return this.log;
    }

    public void append(LogEvent event) {
        ILog eclipseLog = this.getEclipseLog();
        if (eclipseLog != null) {
            ReadOnlyStringMap properties = event.getContextData();
            String bundleName = (String)properties.getValue(PROP_BUNDLE_NAME);
            if (bundleName == null) {
                bundleName = event.getLoggerName();
            }
            String message = MessageFormat.format(MESSAGE, event.getLoggerName(), event.getMessage().getFormattedMessage());
            Throwable throwable = event.getThrown();
            if (throwable == null) {
                eclipseLog.log((IStatus)new Status(this.severity(event.getLevel()), bundleName, message));
            } else {
                eclipseLog.log((IStatus)new Status(this.severity(event.getLevel()), bundleName, message, throwable));
            }
        }
    }

    private int severity(Level level) {
        if (level.isMoreSpecificThan(Level.ERROR)) {
            return 4;
        }
        if (level.isMoreSpecificThan(Level.WARN)) {
            return 2;
        }
        return 1;
    }

    @PluginFactory
    public static ErrorLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter) {
        return new ErrorLogAppender(name, filter);
    }
}

