/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp.commands;

import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.BadSyntaxException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;

public class FtpCommand_RETR
extends FtpCommand<FTPClient> {
    public FtpCommand_RETR(String command, String[] parameters) {
        super(command, parameters);
    }

    public FtpCommand_RETR(FtpCommand<FTPClient> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(FTPClient ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        if (this.getParameters()[0] != null) {
            File localFile = new File(localPath + FtpUtils.getFileName(this.getParameters()[0]));
            if (this.getParameters()[1] == null) {
                FileOutputStream local = new FileOutputStream(localFile);
                ftpCli.retrieveFile(FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]), (OutputStream)local);
                ((OutputStream)local).close();
            } else {
                FileOutputStream local = FtpUtils.isDirectoryAndExists(this.getParameters()[1]) ? new FileOutputStream(FtpUtils.buildPath(this.getParameters()[1], localPath) + FtpUtils.getFileName(this.getParameters()[0])) : new FileOutputStream(FtpUtils.buildFilePath(this.getParameters()[1], localPath));
                ftpCli.retrieveFile(FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]), (OutputStream)local);
                ((OutputStream)local).close();
            }
            this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.RETRIEVED_FILES_SIZE, localFile.length());
            this.defaultResponseManager(ftpCli, verbose, commandHandler);
        } else {
            BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.MISSING_PARAMETER);
            commandHandler.handleError("", exception);
        }
    }
}

