/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp.commands;

import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.BadSyntaxException;
import com.stambia.ftp.exceptions.FileNotFoundException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;

public class FtpCommand_STOR
extends FtpCommand<FTPClient> {
    public FtpCommand_STOR(String command, String[] parameters) {
        super(command, parameters);
    }

    public FtpCommand_STOR(FtpCommand<FTPClient> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(FTPClient ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        if (this.getParameters()[0] != null) {
            File file = new File(FtpUtils.buildPath(this.getParameters()[0], localPath) + FtpUtils.getFileName(this.getParameters()[0]));
            this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.STORED_FILES_SIZE, file.length());
            if (file.exists()) {
                FileInputStream ism;
                if (this.getParameters()[1] == null) {
                    ism = new FileInputStream(file);
                    ftpCli.storeFile("./" + file.getName(), (InputStream)ism);
                } else {
                    ism = new FileInputStream(file);
                    if (FtpUtils.isDirectory(FtpUtils.removeFirstAndLastQuotes(this.getParameters()[1]))) {
                        ftpCli.storeFile(FtpUtils.removeFirstAndLastQuotes(this.getParameters()[1]) + file.getName(), (InputStream)ism);
                    } else {
                        ftpCli.storeFile(FtpUtils.removeFirstAndLastQuotes(this.getParameters()[1]), (InputStream)ism);
                    }
                }
                ((InputStream)ism).close();
                this.defaultResponseManager(ftpCli, verbose, commandHandler);
            } else {
                FileNotFoundException e = new FileNotFoundException(file.getAbsolutePath());
                commandHandler.handleError("", e);
            }
        } else {
            BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.MISSING_PARAMETER);
            commandHandler.handleError("", exception);
        }
    }
}

