/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.sftp.Messages;
import com.stambia.sftp.SFtpSession;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;

public class SFtpCommandLine {
    public static void main(String[] args) throws FileNotFoundException, NoSuchAlgorithmException {
        boolean raiseException = false;
        boolean verbose = true;
        String username = Messages.getString("SFtpCommandLine.0");
        String host = Messages.getString("SFtpCommandLine.1");
        int port = 22;
        String password = Messages.getString("SFtpCommandLine.2");
        InputStreamReader is = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(is);
        JSch jsch = new JSch();
        try {
            Session session = jsch.getSession(username, host, port);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.setPassword(password);
            session.connect();
            Channel channel = session.openChannel("sftp");
            channel.connect();
            ChannelSftp c = (ChannelSftp)channel;
            SFtpSession f = new SFtpSession(session, c);
            f.setOutputStream(System.out);
            f.setVerbose(verbose);
            f.setRaiseException(raiseException);
            String str = "";
            System.out.print(Messages.getString("SFtpCommandLine.3"));
            while (str != null && !str.equals("exit")) {
                try {
                    str = br.readLine();
                    f.executeCommand(str);
                    if (str.contentEquals("exit")) continue;
                    System.out.print("sftp>");
                }
                catch (IOException e) {
                    e.printStackTrace(System.out);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace(System.out);
                }
                catch (FtpCommandException e) {
                    e.printStackTrace(System.out);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

