/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.diagram.custom.move;

import com.indy.md.ui.diagram.Messages;
import com.indy.md.ui.diagram.custom.move.MoveDialog;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class ReplaceFilter
implements MoveDialog.IFilter {
    private Logger logger = LogManager.getLogger(ReplaceFilter.class);
    private MdNode toReplace;
    private Map<IResource, List<String>> errors = new HashMap<IResource, List<String>>();
    private boolean stopOnFirstMissing;
    private HashMap<EObject, List<MdNode>> usages = new HashMap();
    private boolean result = false;

    public ReplaceFilter(MdNode toReplace, boolean stopOnFirstMissing) {
        this.toReplace = toReplace;
        this.stopOnFirstMissing(stopOnFirstMissing);
        this.init();
    }

    @Override
    public void stopOnFirstMissing(boolean doStop) {
        this.stopOnFirstMissing = doStop;
    }

    private void init() {
        TreeIterator it = this.toReplace.eAllContents();
        while (it.hasNext()) {
            EObject n = (EObject)it.next();
            if (!(n instanceof MdNode)) continue;
            for (EObject o : ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getDependencyHelper().getUsage(this.toReplace.eResource().getResourceSet(), n)) {
                List<MdNode> l = this.usages.get(o);
                if (l == null) {
                    l = new ArrayList<MdNode>();
                    this.usages.put(o, l);
                }
                l.add((MdNode)n);
            }
        }
    }

    private Map<IResource, List<String>> computeErrors(IProgressMonitor monitor, MdNode replacement) {
        HashMap<IResource, List<String>> errors = new HashMap<IResource, List<String>>();
        monitor.beginTask(Messages.ReplaceFilter_0, this.usages.size());
        for (EObject k : this.usages.keySet()) {
            boolean missingEncountered = false;
            if (monitor.isCanceled()) break;
            for (MdNode n : this.usages.get(k)) {
                if (monitor.isCanceled()) {
                    missingEncountered = true;
                    break;
                }
                monitor.subTask(Messages.ReplaceFilter_1 + n.getName());
                try {
                    Configuration cfg = replacement.evaluateMdNode("descendant-or-self::*[@defType=\"" + n.getDefType() + "\"][@name=\"" + n.getName() + "\"]");
                    MdNode o = n;
                    int count = 0;
                    while (o != this.toReplace) {
                        o = o.eContainer();
                        ++count;
                    }
                    if (cfg != null) {
                        o = cfg;
                        int count2 = 0;
                        while (o != replacement) {
                            o = o.eContainer();
                            ++count2;
                        }
                        if (count != count2) {
                            cfg = null;
                        }
                    }
                    if (cfg != null) continue;
                    IFile r = Util.convertEMFURIToFile((URI)k.eResource().getURI().trimFragment());
                    ArrayList<CallSite> l = null;
                    l = (ArrayList<CallSite>)errors.get(r);
                    if (l == null) {
                        l = new ArrayList<CallSite>();
                        errors.put((IResource)r, l);
                    }
                    l.add((CallSite)((Object)("- " + n.getFullPath(false))));
                    if (!this.stopOnFirstMissing) continue;
                    missingEncountered = true;
                    break;
                }
                catch (XPathExpressionException e) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.error("Failed in computeErrors", (Throwable)e);
                }
            }
            if (missingEncountered) break;
            monitor.worked(1);
        }
        return errors;
    }

    @Override
    public boolean accept(final MdNode replacement) {
        this.errors.clear();
        if (EcoreUtil.getURI((EObject)replacement).equals(EcoreUtil.getURI((EObject)this.toReplace))) {
            this.errors.put((IResource)ResourcesPlugin.getWorkspace().getRoot(), Collections.singletonList(Messages.ReplaceFilter_6));
            return false;
        }
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ReplaceFilter.this.errors = ReplaceFilter.this.computeErrors(monitor, replacement);
                    ReplaceFilter.this.result = ReplaceFilter.this.errors.isEmpty();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.result;
    }

    @Override
    public Map<IResource, List<String>> getErrors() {
        return this.errors;
    }
}

