/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.diagram.custom.move;

import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.tech.Level;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ReplaceStambiaModelsContentHandler
implements ContentHandler {
    private Logger logger;
    private XMLStreamWriter writer;
    private ByteArrayOutputStream bos;
    private HashMap<String, String> replacementMap;
    private String connectionRefToReplace;
    private String connectionRefReplacer;
    public static String XPATH_GET_CONNECTION_REF = "ancestor::*[@tech:connection='true'][1]";

    public ReplaceStambiaModelsContentHandler(EObject toReplace, EObject replacer, String filePath, String encoding) throws IOException, XMLStreamException {
        block3: {
            this.logger = LogManager.getLogger(ReplaceStambiaModelsContentHandler.class);
            this.replacementMap = new HashMap();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            this.bos = new ByteArrayOutputStream();
            this.writer = xof.createXMLStreamWriter(this.bos, encoding == null ? "UTF-8" : encoding);
            this.buildReplacementMap(toReplace, replacer);
            try {
                Configuration cf = ((MdNode)toReplace).evaluateMdNode(XPATH_GET_CONNECTION_REF);
                if (cf != null) {
                    this.connectionRefToReplace = EcoreUtil.getURI((EObject)cf).fragment();
                    cf = ((MdNode)replacer).evaluateMdNode(XPATH_GET_CONNECTION_REF);
                    this.connectionRefReplacer = EcoreUtil.getURI((EObject)cf).fragment();
                }
            }
            catch (XPathExpressionException e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.error("Failed to update ref {} with {}", (Object)toReplace, (Object)replacer, (Object)e);
            }
        }
    }

    private void buildReplacementMap(EObject toReplace, EObject replacer) {
        this.replacementMap.put(EcoreUtil.getURI((EObject)toReplace).fragment(), EcoreUtil.getURI((EObject)replacer).fragment());
        TreeIterator it = toReplace.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof MdNode)) continue;
            this.look4Matchs(obj, replacer);
        }
    }

    private void look4Matchs(EObject obj, EObject replacer) {
        Level l = ((MdNode)obj).getLevel();
        String nodeName = ((MdNode)obj).getName();
        URI uri = EcoreUtil.getURI((EObject)l);
        TreeIterator it = replacer.eAllContents();
        while (it.hasNext()) {
            URI uri1;
            EObject n = (EObject)it.next();
            if (!(n instanceof MdNode) || nodeName == null || !nodeName.equals(((MdNode)n).getName()) || !uri.equals(uri1 = EcoreUtil.getURI((EObject)((MdNode)n).getLevel()))) continue;
            this.replacementMap.put(EcoreUtil.getURI((EObject)obj).fragment(), EcoreUtil.getURI((EObject)n).fragment());
            return;
        }
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        try {
            this.writer.writeCharacters(arg0, arg1, arg2);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.writer.writeEndDocument();
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public InputStream getNewContent() {
        return new ByteArrayInputStream(this.bos.toByteArray());
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.writer.writeStartDocument("UTF-8", "1.0");
        }
        catch (XMLStreamException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.writer.writeStartElement(qName.contains(":") ? qName.substring(0, qName.indexOf(":")) : "", localName, uri);
            this.writer.flush();
            if (qName.contains(":")) {
                this.writer.writeNamespace(qName.substring(0, qName.indexOf(":")), uri);
            }
            HashMap<String, String> attributesValues = new HashMap<String, String>();
            boolean replaced = false;
            int i = 0;
            while (i < atts.getLength()) {
                String replacement;
                Object val = atts.getValue(i);
                int k = ((String)val).indexOf("#");
                if (k != -1 && (replacement = this.replacementMap.get(((String)val).substring(k + 1))) != null) {
                    val = ((String)val).substring(0, k + 1) + replacement;
                    replaced = true;
                }
                attributesValues.put(atts.getQName(i), (String)val);
                ++i;
            }
            for (String s : attributesValues.keySet()) {
                int k;
                Object val = (String)attributesValues.get(s);
                if (replaced && (k = ((String)val).indexOf("#")) != -1 && ((String)val).substring(k + 1).equals(this.connectionRefToReplace)) {
                    val = ((String)val).substring(0, k + 1) + this.connectionRefReplacer;
                }
                this.writer.writeAttribute(s, (String)val);
            }
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        try {
            this.writer.setPrefix(prefix, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }
}

