/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.diagram.custom.properties;

import com.indy.ui.custom.out.CustomExtendedComboBoxCellEditor;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import com.indy.ui.custom.out.common.properties.CustomFeatureEditorDialog;
import com.indy.ui.custom.out.common.properties.ListUnboundedControl;
import com.indy.ui.custom.out.common.properties.StringUnboundedControl;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.cfc.IConfigurationProvider;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.custom.Util;
import com.stambia.md.diagram.custom.properties.MdValues;
import com.stambia.md.impl.MdPackageImpl;
import com.stambia.md.presentation.custom.edit.KeyValueControl;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EcoreFactoryImpl;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;

public class CustomizedPropertyDescriptor
extends PropertyDescriptor {
    private Configuration node;
    private Property attr;
    MdValues val;

    public CustomizedPropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
        super(object, itemPropertyDescriptor);
    }

    public CellEditor caseEditableList(Composite composite) {
        return new CustomExtendedComboBoxCellEditor(composite, this.val.values, this.getEditLabelProvider(), true);
    }

    public CellEditor createPropertyEditor(Composite composite) {
        if (this.itemPropertyDescriptor.getFeature(this.object) == null) {
            boolean isSettable = this.itemPropertyDescriptor.canSetProperty(this.object);
            if (this.object instanceof Configuration && isSettable) {
                this.node = (Configuration)this.object;
                this.attr = Util.getPropertyByCode((Level)this.node.getLevel(), (String)this.itemPropertyDescriptor.getDescription(this.object));
                this.val = new MdValues(this.attr, this.node, 0);
                if (this.attr.getType().equals((Object)PropertyType.DATE)) {
                    return this.caseDate(composite);
                }
                if (this.attr.getType().equals((Object)PropertyType.PASSWORD)) {
                    return this.casePassword(composite);
                }
                if (this.attr.getType().equals((Object)PropertyType.LIST)) {
                    if (this.attr.isUnbounded()) {
                        if (this.attr.isKeyValue()) {
                            return this.caseUnboundedKeyValue(composite);
                        }
                        return this.caseUnbounded(composite);
                    }
                    if (!this.attr.isEditable()) {
                        return this.caseRestriction(composite);
                    }
                    if (this.attr.isEditable()) {
                        return this.caseEditableList(composite);
                    }
                } else {
                    if (this.attr.getType().equals((Object)PropertyType.REFERENCE)) {
                        if (this.attr.isUnbounded()) {
                            return this.caseUnboundedRef(composite);
                        }
                        return this.caseReference(composite);
                    }
                    if (this.attr.isMultiLine()) {
                        return this.caseMultiLine(composite);
                    }
                }
                if (this.attr.getType().equals((Object)PropertyType.STRING) && this.attr.isUnbounded()) {
                    if (this.attr.isKeyValue()) {
                        return this.caseUnboundedKeyValue(composite);
                    }
                    return this.caseStringUnbounded(composite);
                }
                if (this.attr.getType().equals((Object)PropertyType.BOOLEAN)) {
                    return new ExtendedComboBoxCellEditor(composite, Arrays.asList(Boolean.FALSE, Boolean.TRUE), this.getEditLabelProvider(), this.itemPropertyDescriptor.isSortChoices(this.object));
                }
            }
            EDataType createEDataType = EcoreFactoryImpl.eINSTANCE.createEDataType();
            createEDataType.setInstanceClass(String.class);
            int style = this.itemPropertyDescriptor.canSetProperty(this.object) ? 0 : 8;
            return new TextCellEditor(composite, style);
        }
        CellEditor result = null;
        if (this.itemPropertyDescriptor.getFeature(this.object).equals(MdPackage.eINSTANCE.getElement_Name()) && this.object instanceof Configuration && !(this.object instanceof MdNode)) {
            ArrayList<String> _values = new ArrayList<String>();
            for (String conf : ((IConfigurationProvider)E4InjectorHelper.getService(IConfigurationProvider.class)).getAllConfiguration()) {
                if (conf == null) continue;
                _values.add(conf);
            }
            result = new CustomExtendedComboBoxCellEditor(composite, _values, this.getEditLabelProvider(), true);
        } else {
            result = super.createPropertyEditor(composite);
        }
        return result;
    }

    private CellEditor caseUnbounded(Composite composite) {
        List<Object> choiceOfValues;
        EAttribute feature = MdPackageImpl.eINSTANCE.getAttribute_Value();
        EClassifier eType = feature.getEType();
        List<Object> list = choiceOfValues = this.attr.getType().equals((Object)PropertyType.REFERENCE) ? this.val.eoValues : this.val.values;
        if (eType instanceof EDataType) {
            final ILabelProvider editLabelProvider = this.getEditLabelProvider();
            ExtendedDialogCellEditor result = new ExtendedDialogCellEditor(composite, editLabelProvider){

                protected Object openDialogBox(Control cellEditorWindow) {
                    CustomFeatureEditorDialog dialog = new CustomFeatureEditorDialog(cellEditorWindow.getShell(), CustomizedPropertyDescriptor.this.object, (AbstractUnboundedControl)new ListUnboundedControl(editLabelProvider, (Collection)choiceOfValues), CustomizedPropertyDescriptor.this.getDisplayName(), this.doGetValue());
                    dialog.open();
                    return dialog.getResult();
                }
            };
            return result;
        }
        return null;
    }

    private CellEditor caseUnboundedKeyValue(Composite composite) {
        DialogCellEditor ce = new DialogCellEditor(composite){

            protected Object openDialogBox(Control cellEditorWindow) {
                CustomFeatureEditorDialog d = new CustomFeatureEditorDialog(cellEditorWindow.getShell(), CustomizedPropertyDescriptor.this.object, (AbstractUnboundedControl)new KeyValueControl(CustomizedPropertyDescriptor.this.getEditLabelProvider(), null), CustomizedPropertyDescriptor.this.getDisplayName(), (Object)((Configuration)CustomizedPropertyDescriptor.this.object).getAttributeByShortCode(CustomizedPropertyDescriptor.this.attr.getCode()).getValueEntry());
                d.open();
                return d.getResult();
            }
        };
        return ce;
    }

    private CellEditor caseStringUnbounded(Composite composite) {
        EAttribute feature = MdPackageImpl.eINSTANCE.getAttribute_Value();
        EClassifier eType = feature.getEType();
        if (eType instanceof EDataType) {
            final ILabelProvider editLabelProvider = this.getEditLabelProvider();
            ExtendedDialogCellEditor result = new ExtendedDialogCellEditor(composite, editLabelProvider){

                protected Object openDialogBox(Control cellEditorWindow) {
                    CustomFeatureEditorDialog dialog = new CustomFeatureEditorDialog(cellEditorWindow.getShell(), CustomizedPropertyDescriptor.this.object, (AbstractUnboundedControl)new StringUnboundedControl(editLabelProvider), CustomizedPropertyDescriptor.this.getDisplayName(), this.doGetValue());
                    dialog.open();
                    return dialog.getResult();
                }
            };
            return result;
        }
        return null;
    }

    private CellEditor casePassword(Composite composite) {
        TextCellEditor tce = new TextCellEditor(composite, 0x400000);
        return tce;
    }

    private CellEditor caseReference(Composite composite) {
        return new ExtendedComboBoxCellEditor(composite, this.val.eoValues, this.getEditLabelProvider(), true);
    }

    private CellEditor caseList(Composite composite) {
        final Attribute attr2 = ((Configuration)this.object).findAttributeByCode(this.itemPropertyDescriptor.getDescription(this.object));
        ExtendedDialogCellEditor diag = new ExtendedDialogCellEditor(composite, this.getEditLabelProvider()){

            protected Object openDialogBox(Control cellEditorWindow) {
                final String[] retour = new String[1];
                Dialog d = new Dialog(cellEditorWindow.getShell()){

                    protected Control createDialogArea(Composite parent) {
                        Composite dialogArea = (Composite)super.createDialogArea(parent);
                        final CCombo combo = new CCombo(parent, 8);
                        if (attr2 != null && attr2.getValue() != null) {
                            combo.setText(attr2.getValue());
                        }
                        combo.setEditable(true);
                        String[] strValues = new String[(this).CustomizedPropertyDescriptor.this.val.values.size()];
                        int i = 0;
                        while (i < (this).CustomizedPropertyDescriptor.this.val.values.size()) {
                            strValues[i] = (this).CustomizedPropertyDescriptor.this.val.values.get(i);
                            ++i;
                        }
                        combo.setItems(strValues);
                        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                retour[0] = combo.getText();
                                super.widgetSelected(e);
                            }
                        });
                        combo.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                retour[0] = combo.getText();
                            }
                        });
                        return dialogArea;
                    }
                };
                d.setBlockOnOpen(true);
                d.open();
                return retour[0];
            }
        };
        return diag;
    }

    private CellEditor caseRestriction(Composite composite) {
        ExtendedComboBoxCellEditor result = null;
        result = this.val.values.size() > 0 ? new ExtendedComboBoxCellEditor(composite, this.val.values, this.getEditLabelProvider(), this.itemPropertyDescriptor.isSortChoices(this.object)) : new ExtendedComboBoxCellEditor(composite, this.val.eoValues, this.getEditLabelProvider(), this.itemPropertyDescriptor.isSortChoices(this.object));
        return result;
    }

    private CellEditor caseEditableUnbounded(Composite composite) {
        EAttribute feature = MdPackageImpl.eINSTANCE.getAttribute_Value();
        final EClassifier eType = feature.getEType();
        if (eType instanceof EDataType) {
            final ILabelProvider editLabelProvider = this.getEditLabelProvider();
            ExtendedDialogCellEditor result = new ExtendedDialogCellEditor(composite, editLabelProvider){

                protected Object openDialogBox(Control cellEditorWindow) {
                    FeatureEditorDialog dialog = new FeatureEditorDialog(cellEditorWindow.getShell(), editLabelProvider, CustomizedPropertyDescriptor.this.object, eType, (List)this.doGetValue(), CustomizedPropertyDescriptor.this.getDisplayName(), null, CustomizedPropertyDescriptor.this.itemPropertyDescriptor.isMultiLine(CustomizedPropertyDescriptor.this.object), false);
                    dialog.open();
                    return dialog.getResult();
                }
            };
            return result;
        }
        return null;
    }

    private CellEditor caseUnboundedRef(Composite composite) {
        EReference feature = MdPackageImpl.eINSTANCE.getAttribute_Ref();
        EClassifier eType = feature.getEType();
        final ILabelProvider editLabelProvider = this.getEditLabelProvider();
        ExtendedDialogCellEditor result = new ExtendedDialogCellEditor(composite, editLabelProvider){

            protected Object openDialogBox(Control cellEditorWindow) {
                CustomFeatureEditorDialog dialog = new CustomFeatureEditorDialog(cellEditorWindow.getShell(), CustomizedPropertyDescriptor.this.object, (AbstractUnboundedControl)new ListUnboundedControl(editLabelProvider, CustomizedPropertyDescriptor.this.val.eoValues), CustomizedPropertyDescriptor.this.getDisplayName(), this.doGetValue());
                dialog.open();
                return dialog.getResult();
            }
        };
        return result;
    }

    private CellEditor caseDate(Composite composite) {
        return new ExtendedDialogCellEditor(composite, this.getEditLabelProvider()){

            protected Object openDialogBox(Control cellEditorWindow) {
                final DateTime[] dateTime = new DateTime[1];
                final Date[] date = new Date[1];
                Dialog d = new Dialog(cellEditorWindow.getShell()){

                    protected Control createDialogArea(Composite parent) {
                        Composite dialogArea = (Composite)super.createDialogArea(parent);
                        dateTime[0] = new DateTime(dialogArea, 1024);
                        dateTime[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                Date dateValue = new Date();
                                dateValue.setMonth(dateTime[0].getMonth());
                                dateValue.setDate(dateTime[0].getDay());
                                date[0] = dateValue;
                                super.widgetSelected(e);
                            }
                        });
                        return dialogArea;
                    }
                };
                d.setBlockOnOpen(true);
                d.open();
                if (d.getReturnCode() == 0) {
                    return date[0];
                }
                return null;
            }
        };
    }

    private CellEditor caseMultiLine(Composite composite) {
        Object genericFeature = this.itemPropertyDescriptor.getFeature(this.object);
        EAttribute feature = MdPackageImpl.eINSTANCE.getAttribute_Value();
        EClassifier eType = feature.getEType();
        if (eType instanceof EDataType) {
            return this.createEDataTypeCellEditor((EDataType)eType, composite);
        }
        return super.createPropertyEditor(composite);
    }

    public ILabelProvider getLabelProvider() {
        final IItemLabelProvider itemLabelProvider = this.itemPropertyDescriptor.getLabelProvider(this.object);
        return new LabelProvider(){

            public String getText(Object _object) {
                if (_object instanceof MdNode && ((MdNode)_object).eContainer() instanceof MdNode) {
                    return itemLabelProvider.getText((Object)((MdNode)_object).eContainer()) + "." + itemLabelProvider.getText(_object);
                }
                if (CustomizedPropertyDescriptor.this.object instanceof Configuration) {
                    CustomizedPropertyDescriptor.this.node = (Configuration)CustomizedPropertyDescriptor.this.object;
                    CustomizedPropertyDescriptor.this.attr = Util.getPropertyByCode((Level)CustomizedPropertyDescriptor.this.node.getLevel(), (String)CustomizedPropertyDescriptor.this.itemPropertyDescriptor.getDescription(CustomizedPropertyDescriptor.this.object));
                    if (CustomizedPropertyDescriptor.this.attr != null && CustomizedPropertyDescriptor.this.attr.getType().equals((Object)PropertyType.PASSWORD)) {
                        Object retour = "";
                        int i = 0;
                        while (i < itemLabelProvider.getText(_object).length()) {
                            retour = (String)retour + "*";
                            ++i;
                        }
                        return retour;
                    }
                }
                return itemLabelProvider.getText(_object);
            }

            public Image getImage(Object object) {
                return ExtendedImageRegistry.getInstance().getImage(itemLabelProvider.getImage(object));
            }
        };
    }
}

