/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.diagram.custom.properties;

import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.custom.Util;
import com.stambia.md.diagram.custom.properties.CustomizedPropertyDescriptor;
import com.stambia.md.diagram.custom.properties.Messages;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class CustomizedPropertySource
extends PropertySource {
    private EditingDomain editingDomain;
    private IPropertySource propertySource;

    public CustomizedPropertySource(Object object, IItemPropertySource itemPropertySource, EditingDomain editingDomain) {
        super(object, itemPropertySource);
        this.editingDomain = editingDomain;
    }

    public CustomizedPropertySource(Object object, IItemPropertySource itemPropertySource) {
        super(object, itemPropertySource);
        this.editingDomain = TransactionUtil.getEditingDomain((Object)object);
    }

    protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
        return new CustomizedPropertyDescriptor(this.object, itemPropertyDescriptor);
    }

    public Object getEditableValue() {
        return super.getEditableValue();
    }

    public void setPropertyValue(Object propertyId, Object value) {
        IItemPropertyDescriptor ipd = null;
        ipd = this.itemPropertySource.getPropertyDescriptor(this.object, propertyId);
        if (ipd.getFeature(this.object) != null) {
            super.setPropertyValue(propertyId, value);
        } else {
            Configuration node = (Configuration)this.object;
            String code = ipd.getDescription(this.object);
            Attribute attr = node.findAttributeByCode(code);
            Property prop = Util.getPropertyByCode((Level)node.getLevel(), (String)code);
            if (attr == null) {
                attr = CustomizedPropertySource.createAttribute(this.editingDomain, node, prop.getFullCode());
            }
            if (prop.getType().equals((Object)PropertyType.PASSWORD)) {
                if (value != null && !value.toString().isEmpty()) {
                    try {
                        SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                        semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                        String encrypt = semaphoreManager.setSemaphore(true, (String)value);
                        value = encrypt;
                    }
                    catch (OtherExceptionI e) {
                        e.printStackTrace();
                    }
                } else {
                    value = null;
                }
            } else if (prop.getType().equals((Object)PropertyType.BOOLEAN)) {
                Object object = value == Boolean.TRUE ? "true" : (value = value == Boolean.FALSE ? "false" : null);
            }
            if (!prop.isUnbounded()) {
                if (prop.getType().equals((Object)PropertyType.REFERENCE)) {
                    this.setAttribute(attr, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Ref(), value);
                } else {
                    this.setAttribute(attr, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Value(), value);
                }
            } else if (prop.getType().equals((Object)PropertyType.REFERENCE)) {
                this.setAttribute(attr, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Refs(), value);
            } else if (prop.isKeyValue()) {
                this.setAttribute(attr, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_ValueEntry(), value);
            } else {
                this.setAttribute(attr, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Values(), value);
            }
        }
    }

    private Command setAttributeCommand(EditingDomain editingDomain, Attribute attr, EStructuralFeature feature, Object value) {
        CompoundCommand cc = new CompoundCommand(Messages.customizedPropertySource);
        if (!feature.equals(MdPackage.eINSTANCE.getAttribute_Value()) && attr.getValue() != null) {
            cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)attr, (Object)MdPackage.eINSTANCE.getAttribute_Value(), null));
        }
        if (!feature.equals(MdPackage.eINSTANCE.getAttribute_Ref()) && attr.getRef() != null) {
            cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)attr, (Object)MdPackage.eINSTANCE.getAttribute_Ref(), null));
        }
        if (!feature.equals(MdPackage.eINSTANCE.getAttribute_Refs()) && attr.getRefs() != null && !attr.getRefs().isEmpty()) {
            cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)attr, (Object)MdPackage.eINSTANCE.getAttribute_Refs(), (Object)Collections.EMPTY_LIST));
        }
        if (!feature.equals(MdPackage.eINSTANCE.getAttribute_Values()) && attr.getValues() != null && !attr.getValues().isEmpty()) {
            cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)attr, (Object)MdPackage.eINSTANCE.getAttribute_Values(), (Object)Collections.EMPTY_LIST));
        }
        if (!feature.equals(MdPackage.eINSTANCE.getAttribute_ValueEntry()) && attr.getValueEntry() != null && !attr.getValueEntry().isEmpty()) {
            cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)attr, (Object)MdPackage.eINSTANCE.getAttribute_ValueEntry(), (Object)new BasicEMap()));
        }
        cc.append((Command)new SetCommand(editingDomain, (EObject)attr, feature, value));
        return cc;
    }

    private void setAttribute(Attribute attr, EStructuralFeature feature, Object value) {
        Object _value = attr.getTechProperty().setValue(value);
        Command cmd = this.setAttributeCommand(this.editingDomain, attr, feature, value);
        this.editingDomain.getCommandStack().execute(cmd);
    }

    public static Attribute createAttribute(EditingDomain editingDomain, Configuration node, String code) {
        Attribute attr = MdFactory.eINSTANCE.createAttribute();
        attr.setDefType(code);
        CreateChildCommand ccc = new CreateChildCommand(editingDomain, (EObject)node, (EStructuralFeature)MdPackage.Literals.CONFIGURATION__ATTRIBUTE, (Object)attr, null);
        editingDomain.getCommandStack().execute((Command)ccc);
        return attr;
    }

    public Object getPropertyValue(Object propertyId) {
        IItemPropertyDescriptor ipd = null;
        if (this.propertySource != null) {
            Object object = this.propertySource.getPropertyValue(propertyId);
        }
        if (this.itemPropertySource != null && propertyId != null) {
            ipd = this.itemPropertySource.getPropertyDescriptor(this.object, propertyId);
            if (ipd.getFeature(this.object) != null) {
                Object ret = super.getPropertyValue(propertyId);
                return propertyId.equals("name") && ret == null ? "" : ret;
            }
            Configuration node = (Configuration)this.object;
            Level level = node.getLevel();
            Property prop = Util.getPropertyByDisplayName((Level)level, (String)((String)propertyId));
            Object result = CustomizedPropertySource.getValue(node, prop);
            if (result != null) {
                return result;
            }
            return new String("");
        }
        return new String("");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getValue(Configuration node, Property prop) {
        if (prop == null) {
            return null;
        }
        try {
            List list;
            Attribute att;
            String confName = "Default";
            MdNode mdNode = null;
            if (node instanceof MdNode) {
                mdNode = (MdNode)node;
            } else if (node instanceof Configuration) {
                confName = node.getName();
                mdNode = (MdNode)node.eContainer();
            }
            MdNode parentMd = null;
            if (mdNode.isSubMetaDataChildFile()) {
                parentMd = (MdNode)mdNode.getRef();
            }
            if (!((att = node.findAttributeByCode(prop.getFullCode())) != null && att.hasValue(prop) || node instanceof MdNode)) {
                att = mdNode.findAttributeByCode(prop.getFullCode());
            }
            if (!(att != null && att.hasValue(prop) || parentMd == null)) {
                att = parentMd.findAttributeByCode(prop.getFullCode());
            }
            PropertyType type = prop.getType();
            Object value = prop.getValue((Object)(att != null ? att.getValue() : null));
            if ((value == null || value.equals("")) && prop.supportDefaultValue()) {
                Boolean bl;
                String defaultValue;
                block34: {
                    defaultValue = null;
                    IEvaluationConfigurationService confService = (IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class);
                    String currConf = confService.getCurrentConfigurationName();
                    try {
                        try {
                            String evaluatedValue;
                            confService.setCurrentConfigurationName(confName, false);
                            if (prop.getMdDefaultXpath() != null && !prop.getMdDefaultXpath().trim().isEmpty() && (evaluatedValue = node.evaluate(prop.getMdDefaultXpath())) != null) {
                                defaultValue = evaluatedValue;
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            confService.setCurrentConfigurationName(currConf, false);
                            break block34;
                        }
                    }
                    catch (Throwable throwable) {
                        confService.setCurrentConfigurationName(currConf, false);
                        throw throwable;
                    }
                    confService.setCurrentConfigurationName(currConf, false);
                }
                if (defaultValue == null || defaultValue.isEmpty()) {
                    defaultValue = prop.getDefault();
                }
                if (prop.getType() != PropertyType.BOOLEAN) return defaultValue;
                if (defaultValue.equals("true")) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                if (!defaultValue.equals("false")) return null;
                bl = Boolean.FALSE;
                return bl;
            }
            if (prop.getType().equals((Object)PropertyType.BOOLEAN)) {
                Boolean bl;
                if (value != null && value.equals("true")) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                if (value == null) return null;
                if (!value.equals("false")) return null;
                bl = Boolean.FALSE;
                return bl;
            }
            if (!prop.isUnbounded()) {
                if (prop.getType().equals((Object)PropertyType.REFERENCE)) {
                    if (att == null) return null;
                    boolean deliver = att.eDeliver();
                    try {
                        att.eSetDeliver(false);
                        EObject eObject = att.getRef();
                        return eObject;
                    }
                    finally {
                        att.eSetDeliver(deliver);
                    }
                }
                if (att == null) return null;
                if (value == null) return null;
                if (type != PropertyType.PASSWORD) return value;
                try {
                    SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                    semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                    return semaphoreManager.getStringAsciiInfo(att.getValue());
                }
                catch (Exception exception) {
                    return value;
                }
            }
            if (prop.getType().equals((Object)PropertyType.REFERENCE)) {
                List list2;
                if (prop.isKeyValue()) {
                    List list3;
                    if (att == null) {
                        list3 = Collections.EMPTY_LIST;
                        return list3;
                    }
                    list3 = att.getValueEntry();
                    return list3;
                }
                if (att == null) {
                    list2 = Collections.EMPTY_LIST;
                    return list2;
                }
                list2 = att.getRefs();
                return list2;
            }
            if (prop.isKeyValue()) {
                BasicEMap basicEMap;
                if (att == null) {
                    basicEMap = new BasicEMap();
                    return basicEMap;
                }
                basicEMap = att.getValueEntry();
                return basicEMap;
            }
            if (att == null) {
                list = Collections.EMPTY_LIST;
                return list;
            }
            list = att.getValues();
            return list;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

