/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.diagram.custom.properties;

import com.indy.engine.core.module.IModuleService;
import com.indy.gmf.proc.ActionProcess;
import com.indy.libraries.management.ui.wizard.ModuleWizard;
import com.indy.md.ui.diagram.custom.UISelector;
import com.indy.ui.custom.out.common.properties.ControlFactory;
import com.indy.ui.custom.out.common.properties.UIControl;
import com.indy.ui.custom.out.common.properties.UIControlDescriptor;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.stambia.md.Configuration;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.diagram.custom.properties.IMdSectionHelper;
import com.stambia.md.diagram.custom.properties.Messages;
import com.stambia.md.diagram.custom.properties.NameUIControlDescriptor;
import com.stambia.md.diagram.custom.properties.SelectPopup;
import com.stambia.md.diagram.custom.properties.UIControlDescriptorImpl;
import com.stambia.md.diagram.custom.properties.VariableUsageDecorator;
import com.stambia.md.diagram.navigator.MdDomainNavigatorItem;
import com.stambia.md.presentation.MdEditorPlugin;
import com.stambia.md.util.MdAttributeNativeEvaluator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

class MdSectionControlFactory
extends ControlFactory {
    private static final String MD_EDITOR_ID = "com.indy.md.ui.editor";
    public static final Image openMetadataIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.indy.md.ui.editor", (String)"icons/full/obj16/MdModelFileLinkEditor.gif").createImage();
    public static final Image browseMetadataIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.indy.md.ui.diagram", (String)"icons/full/obj16/metadata-find.png").createImage();
    public static final Image warningIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jface", (String)"/org/eclipse/jface/dialogs/images/message_warning.png").createImage();
    IMdSectionHelper helper;

    public MdSectionControlFactory(IMdSectionHelper helper, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(widgetFactory);
        this.helper = helper;
    }

    private void removeStyledTextListeners(Control control, VariableUsageDecorator d) {
        control.removeListener(3, (Listener)d);
        control.removeListener(5, (Listener)d);
        control.removeListener(32, (Listener)d);
        control.removeListener(6, (Listener)d);
        control.removeListener(7, (Listener)d);
        control.removeListener(1, (Listener)d);
        control.removeListener(2, (Listener)d);
        control.removePaintListener((PaintListener)d);
        ((StyledText)control).removeModifyListener((ModifyListener)d);
    }

    private void createVariableUsageDecorator(Control control) {
        VariableUsageDecorator d = new VariableUsageDecorator(this.helper);
        control.addDisposeListener(e -> this.removeStyledTextListeners(control, d));
        ((StyledText)control).addModifyListener((ModifyListener)d);
        control.addListener(3, (Listener)d);
        control.addListener(5, (Listener)d);
        control.addListener(32, (Listener)d);
        control.addListener(6, (Listener)d);
        control.addListener(7, (Listener)d);
        control.addListener(1, (Listener)d);
        control.addListener(2, (Listener)d);
        control.addPaintListener((PaintListener)d);
    }

    private void handleFileSelection(UIControlDescriptorImpl descriptor, UIControl uiControl) {
        String s = (String)descriptor.property.getHint().get((Object)"com.indy.ui.custom.out.common.properties.hint.fileditor.folder");
        String path = null;
        path = MdAttributeNativeEvaluator.evaluate((String)((StyledText)uiControl.getMainControl()).getText(), (Configuration)this.helper.getEObject(), null);
        if (path != null && !path.trim().isEmpty()) {
            path = new File(path).getParent();
        }
        String selectedFile = null;
        if (s != null && Boolean.valueOf(s) == Boolean.TRUE) {
            fdlg = new DirectoryDialog(uiControl.getMainControl().getShell());
            if (path != null) {
                fdlg.setFilterPath(path);
            }
            selectedFile = fdlg.open();
        } else {
            fdlg = new FileDialog(uiControl.getMainControl().getShell(), 4096);
            String hintExtensions = (String)descriptor.property.getHint().get((Object)"com.indy.ui.custom.out.common.properties.hint.fileditor.extensions");
            ArrayList<String> extensions = new ArrayList<String>();
            if (hintExtensions != null) {
                extensions.addAll(Arrays.asList(hintExtensions.split(",")));
            }
            extensions.add("*");
            fdlg.setFilterExtensions(extensions.toArray(new String[extensions.size()]));
            if (path != null) {
                fdlg.setFilterPath(path);
            }
            selectedFile = fdlg.open();
        }
        if (selectedFile != null) {
            File f = new File(selectedFile);
            String newVal = null;
            try {
                newVal = MdAttributeNativeEvaluator.preserveNatuveEvaluationBlock((Configuration)this.helper.getEObject(), (String)((String)descriptor.getValueFromObject()), (String)f.getAbsolutePath());
            }
            catch (Exception ex) {
                newVal = f.getAbsolutePath();
            }
            ((StyledText)uiControl.getMainControl()).setText(newVal);
            descriptor.getPropertySetter().changeValue((Object)newVal);
        }
    }

    public UIControl createControl(Composite parent, final UIControlDescriptor desc) {
        if (desc.getType() == UIControlDescriptor.Type.BOOLEAN && desc.isHyperlink()) {
            Composite p = this.widgetFactory.createComposite(parent);
            p.setLayout((Layout)new GridLayout(2, false));
            ((GridLayout)p.getLayout()).marginHeight = 0;
            ((GridLayout)p.getLayout()).marginWidth = 0;
            p.setLayoutData((Object)new GridData(1, 1, false, false, 3, 1));
            return super.createControl(p, desc);
        }
        final UIControl res = super.createControl(parent, desc);
        if (res.getMainControl() instanceof StyledText) {
            this.createVariableUsageDecorator(res.getMainControl());
        }
        if (desc.getType() == UIControlDescriptor.Type.FILE && !desc.isUnbounded()) {
            Button b = this.widgetFactory.createButton(res.getAdditionalControlComposite(), "...", 8);
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MdSectionControlFactory.this.handleFileSelection((UIControlDescriptorImpl)desc, res);
                }
            });
            res.addControl((Control)b, true);
        }
        if (desc instanceof NameUIControlDescriptor) {
            res.getMainControl().setData("qa", (Object)"com.stambia.qa.name");
            res.getLabelControl().setData("qa", (Object)"com.stambia.qa.name");
        }
        return res;
    }

    public void createModuleListControl(final UIControl uiControl, final UIControlDescriptorImpl desc, final Configuration conf) {
        Button b = this.getWidgetFactory().createButton(uiControl.getAdditionalControlComposite(), "...", 8);
        b.setToolTipText(Messages.tooltipModuleMgt);
        uiControl.addControl((Control)b, true);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashSet<String> baseModuleFilter = new HashSet<String>();
                baseModuleFilter.add("com.indy.baseModule.default");
                baseModuleFilter.add("com.indy.baseModule.generic");
                try {
                    Collection s = (Collection)conf.evaluateXpathExpressionCached("INTERNAL_BASE_MODULE");
                    if (s != null && !s.isEmpty()) {
                        baseModuleFilter.addAll(s);
                    }
                }
                catch (Exception s) {
                    // empty catch block
                }
                IModuleService.IModule m = null;
                try {
                    m = ((IModuleService)PlatformUI.getWorkbench().getService(IModuleService.class)).getModule((String)desc.getValueFromObject());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ModuleWizard z = new ModuleWizard(baseModuleFilter, m == null ? null : m.getDescriptor(), false, false);
                WizardDialog d = new WizardDialog(uiControl.getMainControl().getShell(), (IWizard)z);
                d.setPageSize(800, 600);
                if (d.open() == 0) {
                    Object realValue = desc.getValueProvider().getValueFromObject();
                    desc.getValue4Control(realValue);
                    desc.getPropertySetter().changeValue((Object)z.getResult().getName());
                    uiControl.setValue((Object)z.getResult().getName());
                }
            }
        });
    }

    private Button createAddtionalReferenceButton(UIControl ctr, boolean alwaysEnabled) {
        Button bb = null;
        boolean grabHorizontalSpace = false;
        if (ctr.getAdditionalControlComposite() != null) {
            bb = this.getWidgetFactory().createButton(ctr.getAdditionalControlComposite(), null, 8);
            grabHorizontalSpace = true;
        } else {
            bb = this.getWidgetFactory().createButton(ctr.getMainControl().getParent(), null, 8);
        }
        bb.setLayoutData((Object)new GridData(1, 1, grabHorizontalSpace, false));
        ctr.addControl((Control)bb, !alwaysEnabled);
        return bb;
    }

    public void createMdReferenceAdditionalControls(final UIControl ctr, final UIControlDescriptorImpl desc) {
        final Button browse = this.createAddtionalReferenceButton(ctr, false);
        browse.setImage(browseMetadataIcon);
        browse.setToolTipText(Messages.mdSectionControlFactoryTooltipSelectMd);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UISelector<MdNode> selector = MdSectionControlFactory.this.createMdRefSelector(desc);
                SelectPopup popup = new SelectPopup(browse.getShell(), selector, Messages.selectMdPopupTitleMdSelector);
                Consumer<MdNode> selectionHandler = popup::checkOKEnabled;
                selector.setConsumer(selectionHandler);
                if (popup.open() == 0) {
                    MdNode proxyNode = MdFactory.eINSTANCE.createMdNode();
                    ((InternalEObject)proxyNode).eSetProxyURI(popup.getSelectedEObjectURI());
                    desc.getPropertySetter().changeValue((Object)proxyNode);
                    ctr.setValue((Object)proxyNode);
                }
            }
        });
        Button openRef = this.createAddtionalReferenceButton(ctr, true);
        openRef.setImage(openMetadataIcon);
        openRef.setToolTipText(Messages.tooltipOpenMdReference);
        openRef.addSelectionListener((SelectionListener)this.createOpenRefListener(desc, "com.stambia.md.presentation.MdEditorID"));
    }

    private UISelector<MdNode> createMdRefSelector(UIControlDescriptorImpl desc) {
        String fileExtension = "md";
        Function<IStructuredSelection, MdNode> selectionAdapterFunction = ss -> {
            MdDomainNavigatorItem selection;
            EObject obj;
            Object object;
            if (!ss.isEmpty() && (object = ss.getFirstElement()) instanceof MdDomainNavigatorItem && (obj = (selection = (MdDomainNavigatorItem)((Object)((Object)object))).getEObject()) instanceof MdNode) {
                return (MdNode)obj;
            }
            return null;
        };
        Predicate<IFile> validateFileCondition = file -> {
            IFile resource = file;
            if (this.isMd((IFile)file)) {
                boolean xPathExpressionExists;
                MdNode node = this.getNodeFromResource(resource);
                String xPathExpressionName = this.getXPathExpressionName(desc.getPropertyCode());
                boolean bl = xPathExpressionExists = this.helper.getEObject().getLevel().findXPathExpression(xPathExpressionName) != null;
                if (xPathExpressionExists) {
                    return this.evaluateXPathExpressionFromNode(node, xPathExpressionName);
                }
                return this.isDuplicated(resource);
            }
            return false;
        };
        return new UISelector<MdNode>(selectionAdapterFunction, validateFileCondition, fileExtension);
    }

    private String getXPathExpressionName(String code) {
        String attributeSuffix = this.getAttributeSuffixFromCode(code);
        return "INTERNAL_MDLINK_" + attributeSuffix;
    }

    private String getAttributeSuffixFromCode(String code) {
        Object res = code;
        int i = 0;
        while (i < code.length()) {
            if (Character.isUpperCase(code.charAt(i))) {
                res = code.substring(0, i) + "_" + code.substring(i);
            }
            ++i;
        }
        return ((String)res).toUpperCase();
    }

    private boolean evaluateXPathExpressionFromNode(MdNode node, String xPathExpression) {
        try {
            Collection o = (Collection)this.helper.getEObject().evaluateXpathExpressionMdSet(xPathExpression);
            return o != null && !o.isEmpty() && o.contains(node.getLevel().getCode());
        }
        catch (XPathExpressionException e) {
            return false;
        }
    }

    private boolean isMd(IFile file) {
        return file.getFileExtension() != null && file.getFileExtension().equals("md");
    }

    private boolean isDuplicated(IFile element) {
        try {
            IMarker[] m = element.findMarkers("com.stambia.resource.marker.duplicate", true, 0);
            return m == null || m.length == 0;
        }
        catch (CoreException e) {
            return false;
        }
    }

    private MdNode getNodeFromResource(IFile resource) {
        URI uri = URIUtils.convertIPathToEMFURI2((IPath)resource.getFullPath());
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
        Resource res = rs.getResource(uri, true);
        return ((DocumentRoot)res.getContents().get(0)).getNode();
    }

    public void createProcessReferenceAdditionalControls(final UIControl ctr, final UIControlDescriptorImpl desc) {
        final Button browse = this.createAddtionalReferenceButton(ctr, false);
        browse.setImage(browseMetadataIcon);
        browse.setToolTipText(Messages.mdSectionControlFactoryTooltipSelectProc);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UISelector<ActionProcess> selector = MdSectionControlFactory.this.createProcRefSelector();
                SelectPopup popup = new SelectPopup(browse.getShell(), selector, Messages.selectProcRefPopupTitleProcSelector);
                Consumer<ActionProcess> selectionHandler = popup::checkOKEnabled;
                selector.setConsumer(selectionHandler);
                if (popup.open() == 0) {
                    Resource resource = MdSectionControlFactory.this.helper.getEditingDomain().getResourceSet().getResource(popup.getSelectedEObjectURI(), true);
                    ActionProcess proc = ((com.indy.gmf.proc.DocumentRoot)resource.getContents().get(0)).getProcess();
                    desc.getPropertySetter().changeValue((Object)proc.getProcessRef());
                    ctr.setValue((Object)proc.getProcessRef());
                }
            }
        });
        Button openRef = this.createAddtionalReferenceButton(ctr, true);
        openRef.setImage(openMetadataIcon);
        openRef.setToolTipText(Messages.tooltipOpenProcReference);
        openRef.addSelectionListener((SelectionListener)this.createOpenRefListener(desc, "com.indy.gmf.proc.diagram.non_rcp.part.ProcDiagramEditorID"));
    }

    private SelectionAdapter createOpenRefListener(final UIControlDescriptorImpl desc, final String editorId) {
        return new SelectionAdapter(){

            private void openRef(EObject obj) {
                URI uri = null;
                uri = obj.eIsProxy() ? ((InternalEObject)obj).eProxyURI() : EcoreUtil.getURI((EObject)obj);
                URIEditorInput input = new URIEditorInput(uri);
                try {
                    IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, editorId);
                    EObject toSelect = null;
                    if (part instanceof IEditingDomainProvider) {
                        toSelect = ((IEditingDomainProvider)part).getEditingDomain().getResourceSet().getEObject(uri, false);
                    } else {
                        AnyType proxy = XMLTypeFactory.eINSTANCE.createAnyType();
                        ((InternalEObject)proxy).eSetProxyURI(uri);
                        toSelect = proxy;
                    }
                    if (part instanceof IViewerProvider) {
                        ((IViewerProvider)part).getViewer().setSelection((ISelection)new StructuredSelection((Object)toSelect));
                    }
                }
                catch (PartInitException e) {
                    MdEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, MdSectionControlFactory.MD_EDITOR_ID, Messages.errorOpenProcEditor, (Throwable)e));
                }
            }

            public void widgetSelected(SelectionEvent e) {
                Object value = desc.getValueFromObject();
                if (value instanceof EObject) {
                    this.openRef((EObject)desc.getValueFromObject());
                }
            }
        };
    }

    private UISelector<ActionProcess> createProcRefSelector() {
        String fileExtension = "proc";
        Function<IStructuredSelection, ActionProcess> selectionAdapterFunction = ss -> {
            Object object;
            if (!ss.isEmpty() && (object = ss.getFirstElement()) instanceof IFile) {
                IFile resource = (IFile)object;
                ResourceSetImpl rs = new ResourceSetImpl();
                rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
                URI uri = URI.createURI((String)resource.getLocationURI().toString());
                com.indy.gmf.proc.DocumentRoot res = (com.indy.gmf.proc.DocumentRoot)rs.getResource(uri, true).getContents().get(0);
                return res.getProcess();
            }
            return null;
        };
        Predicate<IFile> validateFileCondition = file -> file.getFileExtension() != null && file.getFileExtension().equals(fileExtension);
        return new UISelector<ActionProcess>(selectionAdapterFunction, validateFileCondition, fileExtension);
    }
}

