/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.diagram.custom.properties;

import com.stambia.md.Configuration;
import com.stambia.md.diagram.custom.properties.MdSectionDescriptor;
import com.stambia.md.diagram.custom.properties.PropertySection;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.views.properties.tabbed.AbstractTabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISection;

public class MdTabDescriptor
extends AbstractTabDescriptor {
    String category;
    String id;
    String label;
    Function<Object, Configuration> adapterFunction;

    public MdTabDescriptor(String category, String id, String label, String categoryFilter) {
        this.category = category;
        this.label = label;
        this.id = category + "/" + id + "/" + label;
        this.getSectionDescriptors().add(this.createSectionDescritor(id, label, categoryFilter));
    }

    protected MdSectionDescriptor createSectionDescritor(String tabId, String sectionLabel, final String categoryFilter) {
        return new MdSectionDescriptor(tabId, sectionLabel){

            @Override
            protected ISection createSection() {
                return new PropertySection(categoryFilter){

                    @Override
                    protected void setEObject(EObject object) {
                        if ((this).MdTabDescriptor.this.adapterFunction != null) {
                            object = (EObject)(this).MdTabDescriptor.this.adapterFunction.apply(object);
                        }
                        super.setEObject(object);
                    }
                };
            }
        };
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getCategory() {
        return this.category;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label.substring(0, 1).toUpperCase() + (this.label.length() > 1 ? this.label.substring(1) : "");
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAdapter(Function<Object, Configuration> adapterFunction) {
        this.adapterFunction = adapterFunction;
        for (Object o : this.getSectionDescriptors()) {
            ((MdSectionDescriptor)((Object)o)).setFilter(e -> adapterFunction != null && adapterFunction.apply(e) != null);
        }
    }
}

