/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.diagram.custom.properties;

import com.indy.md.ui.diagram.Messages;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.diagram.custom.properties.MdTabAdvancedDescriptor;
import com.stambia.md.diagram.custom.properties.MdTabDescriptor;
import com.stambia.md.diagram.custom.properties.MdTabExternalizeDescriptor;
import com.stambia.md.diagram.navigator.MdDomainNavigatorItem;
import com.stambia.tech.Tech;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;

public class MdTabDescriptorProvider
implements ITabDescriptorProvider {
    public static String[] getTabAndGroupName(String category) {
        String[] res = new String[2];
        if (category != null) {
            if (category.contains(":")) {
                res[0] = category.substring(0, category.indexOf(":"));
                res[1] = category.substring(category.indexOf(":") + 1).trim();
            } else {
                res[0] = category;
            }
        } else {
            res[0] = Messages.MdTabDescriptorProvider_2;
        }
        if (res[1] == null) {
            res[1] = "";
        }
        if (res[0] == null || res[0].isEmpty()) {
            res[0] = Messages.MdTabDescriptorProvider_2;
        }
        return res;
    }

    protected Configuration adapt(Object object) {
        EObject o;
        Configuration res = null;
        if (object instanceof Configuration) {
            res = (Configuration)object;
        } else if (object instanceof MdDomainNavigatorItem && (o = ((MdDomainNavigatorItem)((Object)object)).getEObject()) instanceof Configuration) {
            res = (Configuration)o;
        }
        return res;
    }

    protected String computeTabId(ISelection s) {
        Configuration conf = this.getConfiguration(s);
        if (conf == null) {
            return null;
        }
        String techCode = ((Tech)conf.getLevel().eContainer()).getId();
        String techExtensions = ((Tech)conf.getLevel().eContainer()).getAppendedExtensions().stream().distinct().collect(Collectors.joining(";"));
        return String.format("techCode=%s:%s:%s-extensions=%s", techCode, conf.getDefType(), conf instanceof MdNode ? "MdNode" : "Configuration", techExtensions);
    }

    private Configuration getConfiguration(ISelection s) {
        if (!(s instanceof IStructuredSelection) || s.isEmpty()) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)s;
        Configuration conf = this.adapt(ss.getFirstElement());
        if (conf == null || conf.getLevel() == null) {
            return null;
        }
        return conf;
    }

    private ITabDescriptor[] computeTabDescriptors(ISelection s) {
        String defTypeCode = this.computeTabId(s);
        Configuration conf = this.getConfiguration(s);
        if (defTypeCode == null || conf == null) {
            return new ITabDescriptor[]{MdTabAdvancedDescriptor.createMdDescriptor()};
        }
        List tabsFromProperties = conf.getLevel().getAttribute().stream().map(prop -> MdTabDescriptorProvider.getTabAndGroupName(prop.getCategory())[0]).distinct().collect(Collectors.toList());
        tabsFromProperties.remove(Messages.MdTabDescriptorProvider_2);
        tabsFromProperties.add(0, Messages.MdTabDescriptorProvider_2);
        List<ITabDescriptor> l = tabsFromProperties.stream().map(tabName -> this.createTabDescriptor((String)tabName, defTypeCode, (String)tabName)).collect(Collectors.toList());
        l.add((ITabDescriptor)MdTabExternalizeDescriptor.createMdDescriptor());
        l.add((ITabDescriptor)MdTabAdvancedDescriptor.createMdDescriptor());
        return l.toArray(new ITabDescriptor[l.size()]);
    }

    protected MdTabDescriptor createTabDescriptor(String tabName, String id, String propertyCategoryFilter) {
        return new MdTabDescriptor("domain", id, tabName, propertyCategoryFilter);
    }

    public ITabDescriptor[] getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        if (part instanceof DiagramEditor && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 1) {
            return new ITabDescriptor[0];
        }
        return this.computeTabDescriptors(selection);
    }
}

