/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.custom;

import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.custom.AttributeRefResolver;
import com.stambia.md.custom.ReverseEvent;
import com.stambia.md.custom.ReverseListener;
import com.stambia.md.custom.exception.ReverseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class MdReverse {
    private List<ReverseListener> listeners = new ArrayList<ReverseListener>();
    private IProgressMonitor monitor;
    private Properties confProperties = new Properties();

    public abstract void setConnection(Object var1) throws ReverseException;

    public abstract void setNode(MdNode var1);

    public abstract void setConf(String var1);

    public abstract List<String> getChildren(String var1, String var2, String var3, String ... var4) throws ReverseException;

    public abstract List<MdNode> getMdNodeChildren(String var1, String var2, String var3, String ... var4) throws ReverseException;

    public abstract List<MdNode> doReverse(Object[] var1) throws ReverseException;

    public abstract AttributeRefResolver getAttributeRefResolver();

    public abstract List<Attribute> getMandatoryField();

    public abstract void close();

    public void addReverseListener(ReverseListener reverseListener) {
        if (this.listeners.contains(reverseListener)) {
            return;
        }
        this.listeners.add(reverseListener);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public boolean isCanceled() {
        return this.monitor != null && this.monitor.isCanceled();
    }

    protected void fireObjectReverseStarted(String name, String type) throws ReverseException {
        ReverseEvent event = new ReverseEvent(name, type, this.monitor);
        for (ReverseListener listener : this.listeners) {
            listener.objectReverseStart(event);
        }
    }

    protected void fireReverseStarted(Object[] selectedChildren, String type) throws ReverseException {
        ReverseEvent event = new ReverseEvent(selectedChildren, type, this.monitor);
        for (ReverseListener listener : this.listeners) {
            listener.reverseStart(event);
        }
    }

    protected void fireObjectReverseEnded(String name, String type) throws ReverseException {
        ReverseEvent event = new ReverseEvent(name, type, this.monitor);
        for (ReverseListener listener : this.listeners) {
            listener.objectReverseEnd(event);
        }
    }

    public Properties getProperties() {
        return this.confProperties;
    }

    public void setProperties(Properties properties) {
        this.confProperties.putAll((Map<?, ?>)properties);
    }

    public void setProperty(String string, String string2) {
        this.confProperties.put(string, string2);
    }
}

