/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.custom.reverse;

import com.semarchy.xdi.designer.core.Constants;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.util.MdAttributeNativeEvaluator;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class AttributeUpdateCommandFactory {
    public static final AttributeUpdateCommandFactory INSTANCE = new AttributeUpdateCommandFactory();

    private AttributeUpdateCommandFactory() {
    }

    public UpdateAttributeResult updateAttribute(EditingDomain domain, Attribute current, Attribute newValue, boolean updatePosition, IncrementalReverser.ReverserExceptionHandler exceptionHandler) {
        UpdateAttributeResult res = new UpdateAttributeResult();
        CompoundCommand cc = new CompoundCommand();
        Property prop = current.getTechProperty();
        if (Constants.equals((Object)current.getPosition(), (Object)newValue.getPosition())) {
            cc.append((Command)new SetCommand(domain, (EObject)current, (EStructuralFeature)MdPackage.eINSTANCE.getElement_Position(), (Object)newValue.getPosition()));
        }
        if (prop != null) {
            if (prop.isUnbounded()) {
                if (prop.isKeyValue()) {
                    if (!current.getValueEntry().equals(newValue.getValueEntry())) {
                        cc.append((Command)new SetCommand(domain, (EObject)current, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_ValueEntry(), newValue.getValueEntry()));
                    }
                } else if (prop.getType() == PropertyType.REFERENCE) {
                    if (!current.getRefs().containsAll(newValue.getRefs()) || current.getRefs().size() != newValue.getRefs().size()) {
                        cc.append((Command)new SetCommand(domain, (EObject)current, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Refs(), newValue.getRefs()));
                    }
                } else {
                    Object values = null;
                    try {
                        values = MdAttributeNativeEvaluator.readAttributeList(prop.getCode(), (MdNode)current.eContainer(), exceptionHandler);
                    }
                    catch (Exception ex) {
                        values = current.getValues();
                    }
                    if (!values.containsAll((Collection<?>)newValue.getValues()) || values.size() != newValue.getValues().size()) {
                        cc.append((Command)new SetCommand(domain, (EObject)current, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Values(), newValue.getValues()));
                    }
                }
            } else if (prop.getType() != PropertyType.REFERENCE) {
                if (current.getValue() == null) {
                    cc.append((Command)new SetCommand(domain, (EObject)current, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Value(), (Object)newValue.getValue()));
                } else {
                    String oldVal = current.getValue();
                    if (!oldVal.equals(newValue.getValue())) {
                        cc.append((Command)new SetCommand(domain, (EObject)current, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Value(), (Object)newValue.getValue()));
                    }
                }
            } else if (current.getRef() != newValue.getRef()) {
                if (newValue.getRef() != null) {
                    cc.append((Command)new SetCommand(domain, (EObject)current, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Ref(), (Object)newValue.getRef()));
                    if (newValue.getRef().eResource() == null) {
                        res.toResolve.add(current);
                    }
                } else {
                    cc.append((Command)new SetCommand(domain, (EObject)current, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Ref(), (Object)newValue.getRef()));
                }
            }
        }
        if (!cc.isEmpty()) {
            res.cmd = cc;
        }
        return res;
    }

    public class UpdateAttributeResult {
        Command cmd;
        Set<Attribute> toResolve = new HashSet<Attribute>();

        public Command getCommand() {
            return this.cmd;
        }

        public Set<Attribute> getToResolve() {
            return this.toResolve;
        }
    }
}

