/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.custom.reverse;

import com.semarchy.xdi.designer.core.collections.BidiMap;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class MdMatchingVisitor {
    private IncrementalReverser.IReverseMatchingStrategy defaultReverseMode;
    private Map<String, IncrementalReverser.IReverseMatchingStrategy> reverseModePerLvlDefType = new HashMap<String, IncrementalReverser.IReverseMatchingStrategy>();
    private Map<MdNode, MdNode> replacement;
    private BidiMap<MdNode, MdNode> matchMap = new BidiMap();

    public MdMatchingVisitor(IncrementalReverser.IReverseMatchingStrategy defaultReverseMode, Map<String, IncrementalReverser.IReverseMatchingStrategy> reverseModePerLvlDefType) {
        this.defaultReverseMode = defaultReverseMode;
        if (reverseModePerLvlDefType != null) {
            this.reverseModePerLvlDefType = reverseModePerLvlDefType;
        }
    }

    public void accept(Map<MdNode, MdNode> replacement) throws Exception {
        this.matchMap.clear();
        this.replacement = replacement;
        try {
            for (MdNode newNode : replacement.keySet()) {
                MdNode existingNode = replacement.get(newNode);
                this.matchMap.put((Object)newNode, (Object)existingNode);
                newNode.getNode().forEach(n -> this.visit((MdNode)n));
            }
        }
        catch (OriginalParentNotFoundException ex) {
            throw new Exception(ex);
        }
    }

    private MdNode getOriginalParent(MdNode newNode) throws OriginalParentNotFoundException {
        EObject newNodeParent = newNode.getSubstituteContainer();
        MdNode parent = this.replacement.get(newNodeParent);
        if (parent == null) {
            parent = (MdNode)this.matchMap.getTo((Object)newNodeParent);
        }
        if (parent == null) {
            parent = (MdNode)newNodeParent;
        }
        if (parent == null) {
            throw new OriginalParentNotFoundException();
        }
        return parent;
    }

    private MdNode match(MdNode newNode) throws OriginalParentNotFoundException {
        MdNode parent = this.getOriginalParent(newNode);
        AtomicReference<IncrementalReverser.IReverseMatchingStrategy> refReverseMode = new AtomicReference<IncrementalReverser.IReverseMatchingStrategy>(this.reverseModePerLvlDefType.get(newNode.getDefType()));
        if (refReverseMode.get() == null) {
            refReverseMode.set(this.defaultReverseMode);
        }
        if (parent == null) {
            return null;
        }
        Optional<MdNode> opt = parent.getNode().stream().filter(n -> ((IncrementalReverser.IReverseMatchingStrategy)refReverseMode.get()).getMatcher().match(newNode, (MdNode)n)).findFirst();
        if (opt.isPresent()) {
            return opt.get();
        }
        return null;
    }

    private void visit(MdNode newNode) throws OriginalParentNotFoundException {
        MdNode oldNode = this.match(newNode);
        this.matchMap.put((Object)newNode, (Object)oldNode);
        if (oldNode == null) {
            return;
        }
        newNode.getNode().forEach(n -> this.visit((MdNode)n));
    }

    public Collection<MdNode> getNodesToDelete() {
        HashSet<MdNode> toDelete = new HashSet<MdNode>();
        for (MdNode n : this.replacement.values()) {
            if (n == null) continue;
            TreeIterator it = n.eAllContents();
            while (it.hasNext()) {
                EObject e = (EObject)it.next();
                if (!(e instanceof MdNode)) {
                    it.prune();
                    continue;
                }
                if (this.matchMap.getFrom((Object)e) != null) continue;
                toDelete.add((MdNode)e);
                it.prune();
            }
        }
        return toDelete;
    }

    public Map<MdNode, Collection<MdNode>> getNodesToAddByParent() throws Exception {
        HashSet toAdd = new HashSet();
        this.matchMap.keySet().stream().filter(n -> this.matchMap.getTo(n) == null).forEach(n -> {
            boolean bl = toAdd.add((MdNode)n);
        });
        HashMap<MdNode, Collection<MdNode>> res = new HashMap<MdNode, Collection<MdNode>>();
        for (MdNode n2 : toAdd) {
            MdNode originalParent = this.getOriginalParent(n2);
            ArrayList<MdNode> c = (ArrayList<MdNode>)res.get(originalParent);
            if (c == null) {
                c = new ArrayList<MdNode>();
                res.put(originalParent, c);
            }
            c.add(n2);
        }
        return res;
    }

    public Map<MdNode, MdNode> getNodesToUpdate() {
        HashMap<MdNode, MdNode> res = new HashMap<MdNode, MdNode>();
        this.matchMap.keySet().stream().filter(n -> this.matchMap.getTo(n) != null).forEach(n -> {
            MdNode mdNode = res.put((MdNode)n, (MdNode)this.matchMap.getTo(n));
        });
        return res;
    }

    private class OriginalParentNotFoundException
    extends RuntimeException {
        private OriginalParentNotFoundException() {
        }
    }
}

