/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.custom.xpath;

import com.indy.engine.core.module.IModuleService;
import com.indy.libraries.management.util.ModuleJDBCHelper;
import com.semarchy.xdi.designer.core.indexation.IMdTechRegistry;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.IBaseModuleProvider;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.services.registry.ReferencableObject;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import com.stambia.md.Attribute;
import com.stambia.md.MdLink;
import com.stambia.md.MdNode;
import com.stambia.md.custom.xpath.MdNodeWrapper2;
import com.stambia.md.custom.xpath.Messages;
import com.stambia.md.custom.xpath.NativeEvaluationNamespaceContext;
import com.stambia.md.util.ReferencableObjectFactory;
import com.stambia.md.util.StbMdResourceImpl;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import com.stambia.tech.XpathExpression;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ExtensionFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.JavaExtensionFunctionFactory;
import net.sf.saxon.functions.JavaExtensionLibrary;
import net.sf.saxon.jdom.DocumentWrapper;
import net.sf.saxon.jdom.NodeWrapper;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathEvaluator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class Evaluation {
    private static final Logger logger = LogManager.getLogger(Evaluation.class);

    private Evaluation() {
    }

    public static Object evaluateNodeWrapper(NodeWrapper node, String expression, QName mode, XPathVariableResolver variableResolver) throws XPathExpressionException {
        Object result;
        block3: {
            XPathExpression exp = Evaluation.initXpathExpressionNodeWrapper(node, expression, variableResolver);
            result = null;
            try {
                result = exp.evaluate(node, mode);
            }
            catch (XPathExpressionException e) {
                throw e;
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Failed to evaluate {}", (Object)expression, (Object)e);
            }
        }
        return result;
    }

    public static List getRootNode(XPathContext context, String startExpression, String refExpression) throws XPathExpressionException {
        MdNodeWrapper2 item = (MdNodeWrapper2)context.getContextItem();
        if (!(item.getNode() instanceof MdNode)) {
            return Collections.emptyList();
        }
        MdNode node = (MdNode)item.getNode();
        ArrayList<EObject> select = new ArrayList<EObject>();
        Object childrenList = node.evaluateMdSet(startExpression, false);
        if (childrenList instanceof List) {
            HashMap<MdNode, Set<MdNode>> parents = new HashMap<MdNode, Set<MdNode>>();
            for (Object _child : (List)childrenList) {
                MdNode child;
                Object parentList;
                if (!(_child instanceof MdNode) || !((parentList = (child = (MdNode)_child).evaluateMdSet(refExpression, false)) instanceof List)) continue;
                HashSet<MdNode> _parents = new HashSet<MdNode>();
                parents.put(child, _parents);
                for (Object parent : (List)parentList) {
                    if (!(parent instanceof MdNode)) continue;
                    _parents.add((MdNode)parent);
                }
            }
            for (MdNode _node : parents.keySet()) {
                int i = Evaluation.searchDeeply(_node, _node, parents);
                if (i >= 2) continue;
                select.add(_node);
            }
        }
        return Evaluation.wrappList(item, select);
    }

    private static int searchDeeply(MdNode startnode, MdNode current, Map<MdNode, Set<MdNode>> refs) {
        Set<MdNode> nodes = refs.get(current);
        if (nodes != null) {
            if (nodes.contains(startnode)) {
                return 1;
            }
            if (current != startnode && nodes.contains(current)) {
                return 2;
            }
            for (MdNode node : nodes) {
                int b = Evaluation.searchDeeply(startnode, node, refs);
                if (b == 0) continue;
                return b;
            }
        }
        return 0;
    }

    public static List<String> getURLPattern4Module(XPathContext context) {
        block6: {
            MdNodeWrapper2 item = (MdNodeWrapper2)context.getContextItem();
            MdNode node = (MdNode)item.getNode();
            try {
                String module = node.evaluateXpathExpressionCached("INTERNAL_MODULE", null);
                String driverClassName = node.evaluate("@driver");
                if (driverClassName == null || module == null) {
                    return Collections.EMPTY_LIST;
                }
                IModuleService s = (IModuleService)E4InjectorHelper.getService(IModuleService.class);
                IModuleService.IModule m = s.getModule(module);
                if (m == null) {
                    return Collections.EMPTY_LIST;
                }
                ModuleJDBCHelper helper = new ModuleJDBCHelper((IBaseModuleProvider)E4InjectorHelper.getService(IBaseModuleProvider.class), s);
                helper.refreshModules(Collections.singletonList(m.getDescriptor().getBaseModuleInfo().getId()));
                for (ModuleJDBCHelper.ModuleDescription d : helper.getModules()) {
                    if (!d.getName().equals(m.getName())) continue;
                    for (IModuleService.IJDBCDriverDescriptor p : d.getJDBCProviders()) {
                        if (!driverClassName.equals(p.getDriverClassName())) continue;
                        return new ArrayList<String>(p.getSamplesURLs());
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("Failed to evaluate internal:getURLPattern4Module", (Throwable)e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static String getResourceName(XPathContext context) {
        MdNodeWrapper2 item = (MdNodeWrapper2)context.getContextItem();
        MdNode node = (MdNode)item.getNode();
        URI uri = node.eResource().getURI().trimFragment();
        String extension = uri.fileExtension();
        String name = uri.lastSegment();
        if (extension != null && !extension.isEmpty()) {
            name = name.substring(0, name.length() - extension.length() - 1);
        }
        return name;
    }

    public static NodeInfo getMdNodeById(XPathContext context, String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        String fileID = CacheHelper.extractFileID((String)id);
        String eltID = CacheHelper.extractEltID((String)id);
        if (eltID == null) {
            eltID = id;
        }
        MdNodeWrapper2 item = (MdNodeWrapper2)context.getContextItem();
        MdNode node = (MdNode)item.getNode();
        MdNode eo = null;
        if (fileID == null || ((StbMdResourceImpl)node.eResource()).getId().equals(fileID)) {
            eo = (MdNode)((StbMdResourceImpl)node.eResource()).getEObjectByID(eltID);
        } else {
            URI uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(fileID);
            if (uri != null) {
                eo = (MdNode)((StbMdResourceImpl)node.eResource()).getResourceSet().getEObject(uri.appendFragment(eltID), true);
            }
        }
        if (eo != null) {
            MdNodeWrapper2 ret = (MdNodeWrapper2)eo.getNodeWrapper();
            ret.setDocumentWrapper((DocumentWrapper)item.getDocumentRoot());
            return ret;
        }
        return null;
    }

    private static List<NodeInfo> wrappList(MdNodeWrapper2 context, List<EObject> eos) {
        ArrayList<NodeInfo> list;
        block4: {
            list = new ArrayList<NodeInfo>();
            try {
                for (EObject eo : eos) {
                    MdNodeWrapper2 ret;
                    if (eo instanceof MdNode) {
                        ((MdNode)eo).resetNodeWrapper();
                        ret = (MdNodeWrapper2)((MdNode)eo).getNodeWrapper();
                        ret.setDocumentWrapper((DocumentWrapper)context.getDocumentRoot());
                        list.add((NodeInfo)ret);
                    }
                    if (!(eo instanceof Attribute)) continue;
                    ret = (MdNodeWrapper2)((Attribute)eo).getNodeWrapper();
                    ret.setDocumentWrapper((DocumentWrapper)context.getDocumentRoot());
                    list.add((NodeInfo)ret);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Unexpected error", (Throwable)e);
            }
        }
        return list;
    }

    public static String getMessage(XPathContext context, String key, String ... parameters) throws Exception {
        MdNodeWrapper2 item = (MdNodeWrapper2)context.getContextItem();
        MdNode node = (MdNode)item.getNode();
        String message = node.getLevel().getMessage(key);
        if (message == null) {
            throw new Exception(String.format("Missing message with key=%s on %s", key, node.getLevel()));
        }
        Pattern p = Pattern.compile("(%[1-9]+[0-9]*)");
        StringBuilder b = new StringBuilder();
        Matcher m = p.matcher(message);
        int lastIndex = 0;
        while (m.find()) {
            b.append(message.substring(lastIndex, m.start()));
            int index = Integer.parseInt(message.substring(m.start() + 1, m.end()));
            if (index >= parameters.length) {
                throw new Exception(String.format(Messages.Evaluation_1, index, message, key));
            }
            b.append(parameters[index]);
            lastIndex = m.end();
        }
        b.append(message.substring(lastIndex));
        return b.toString();
    }

    private static String charSpe(String str) {
        if (str != null) {
            return str.replace("\\n", "\n").replace("\\t", "\t").replace("\\r", "\r");
        }
        return null;
    }

    public static String list(XPathContext xPathcontext, ValueRepresentation context, String separator, String start, String end, String replacement, Boolean replaceCharSpe) throws Exception {
        if (replaceCharSpe == null) {
            replaceCharSpe = true;
        }
        ArrayList<String> list = new ArrayList<String>();
        SequenceIterator si1 = null;
        if (context instanceof StringValue) {
            list.add(((StringValue)context).getStringValue());
        } else if (context instanceof NodeWrapper) {
            list.add(((NodeWrapper)context).getStringValue());
        } else if (context instanceof SequenceExtent) {
            si1 = ((SequenceExtent)context).iterate();
            Item i = null;
            do {
                if ((i = si1.next()) == null) continue;
                list.add(i.getStringValue());
            } while (i != null);
        }
        StringBuilder sb = new StringBuilder();
        if (!list.isEmpty()) {
            if (start != null) {
                sb.append(start);
            }
            int i = 0;
            while (i < list.size()) {
                if (separator != null && i > 0) {
                    sb.append(separator);
                }
                sb.append((String)list.get(i));
                ++i;
            }
            if (end != null) {
                sb.append(end);
            }
        } else if (replacement != null) {
            sb.append(replacement);
        }
        if (replaceCharSpe.booleanValue()) {
            return Evaluation.charSpe(sb.toString());
        }
        return sb.toString();
    }

    public static String encloseIfNotEmpty(XPathContext context, String value, String start, String end, String replacement) {
        StringBuilder sb = new StringBuilder();
        if (value != null && !value.isEmpty()) {
            if (start != null) {
                sb.append(start);
            }
            sb.append(value);
            if (end != null) {
                sb.append(end);
            }
        } else if (replacement != null) {
            sb.append(replacement);
        }
        return sb.toString();
    }

    public static List<NodeInfo> getRef(XPathContext context) {
        NodeWrapper item;
        Object o;
        if (context.getContextItem() instanceof MdNodeWrapper2) {
            MdNodeWrapper2 item2 = (MdNodeWrapper2)context.getContextItem();
            if (item2.getNode() instanceof Attribute) {
                Attribute attr = (Attribute)item2.getNode();
                ArrayList<EObject> list = new ArrayList<EObject>();
                if (attr.getRef() != null) {
                    list.add(attr.getRef());
                }
                list.addAll((Collection<EObject>)attr.getRefs());
                return Evaluation.wrappList(item2, list);
            }
        } else if (context.getContextItem() instanceof NodeWrapper && (o = (item = (NodeWrapper)context.getContextItem()).getUnderlyingNode()) instanceof MdNodeWrapper2.RefWrapper) {
            NodeWrapper ret = ((MdNodeWrapper2.RefWrapper)((Object)o)).getNodeWrapper();
            ((MdNodeWrapper2)ret).setDocumentWrapper((DocumentWrapper)item.getDocumentRoot());
            return Collections.singletonList(ret);
        }
        return null;
    }

    private static void doJoinPopulList(ValueRepresentation param1, List<ValueRepresentation> list) {
        block8: {
            SequenceIterator si1 = null;
            try {
                if (param1 instanceof Closure) {
                    si1 = ((Closure)param1).iterate();
                } else if (param1 instanceof SequenceExtent) {
                    si1 = ((SequenceExtent)param1).iterate();
                }
                if (si1 != null) {
                    Item i = null;
                    do {
                        if ((i = si1.next()) == null) continue;
                        list.add((ValueRepresentation)i);
                    } while (i != null);
                } else {
                    list.add(param1);
                }
            }
            catch (XPathException e) {
                if (!logger.isDebugEnabled()) break block8;
                logger.debug("Unexpected error", (Throwable)e);
            }
        }
    }

    public static List<ValueRepresentation> join(XPathContext context1, ValueRepresentation param1, ValueRepresentation param2, ValueRepresentation param3, ValueRepresentation param4, ValueRepresentation param5, ValueRepresentation param6, ValueRepresentation param7, ValueRepresentation param8, ValueRepresentation param9, ValueRepresentation param10) {
        ValueRepresentation[] params;
        ArrayList<ValueRepresentation> list = new ArrayList<ValueRepresentation>();
        ValueRepresentation[] valueRepresentationArray = params = new ValueRepresentation[]{param1, param2, param3, param4, param5, param6, param7, param8, param9, param10};
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            ValueRepresentation vr = valueRepresentationArray[n2];
            if (vr != null) {
                Evaluation.doJoinPopulList(vr, list);
            }
            ++n2;
        }
        return list;
    }

    private static MdLink doFindMdLink(MdNodeWrapper2 item, String name) {
        if (item.getNode() instanceof MdNode) {
            MdNode node = (MdNode)item.getNode();
            for (MdLink mdLink : node.getMetaDataLink()) {
                if (name != null && !name.isEmpty() && !name.equals(mdLink.getName())) continue;
                return mdLink;
            }
            NodeInfo parent = item.getParent();
            if (parent instanceof MdNodeWrapper2) {
                return Evaluation.doFindMdLink((MdNodeWrapper2)parent, name);
            }
        }
        return null;
    }

    public static List<NodeInfo> getMetaDataLinkRef(XPathContext context, String name) {
        MdNodeWrapper2 item;
        MdLink link;
        if (context.getContextItem() instanceof MdNodeWrapper2 && (link = Evaluation.doFindMdLink(item = (MdNodeWrapper2)context.getContextItem(), name)) != null) {
            ArrayList<EObject> list = new ArrayList<EObject>();
            list.add(link.getTarget());
            return Evaluation.wrappList(item, list);
        }
        return null;
    }

    private static List<EObject> doGetCrossRef(MdNode node, String xmlName, int deep) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        for (Attribute attr : node.getUsage()) {
            if (xmlName != null && !attr.getTechProperty().getXmlName().equals(xmlName)) continue;
            Attribute o = attr;
            int i = 0;
            while (i < deep) {
                o = o.eContainer();
                ++i;
            }
            list.add(o);
        }
        return list;
    }

    public static List<NodeInfo> getCrossRef(XPathContext context, String xmlName) {
        List<EObject> list;
        MdNodeWrapper2 item = (MdNodeWrapper2)context.getContextItem();
        if (item.getNode() instanceof MdNode && !(list = Evaluation.doGetCrossRef((MdNode)item.getNode(), xmlName, 1)).isEmpty()) {
            return Evaluation.wrappList(item, list);
        }
        return Collections.EMPTY_LIST;
    }

    private static void setJavaExtensionLibrary(Configuration conf) {
        JavaExtensionLibrary jel = (JavaExtensionLibrary)conf.getExtensionBinder("java");
        if (!(jel instanceof CustomJavaExtensionLibrary)) {
            conf.setExtensionBinder("java", (FunctionLibrary)new CustomJavaExtensionLibrary(conf, jel));
        }
    }

    public static String toJavaProperties(XPathContext ctx) throws Exception {
        MdNodeWrapper2 n = (MdNodeWrapper2)ctx.getContextItem();
        MdNode mdNode = (MdNode)n.getNode();
        Properties prop = new Properties();
        for (Attribute a : mdNode.getAttribute()) {
            Property p = a.getTechProperty();
            if (p == null) continue;
            if (p.isUnbounded()) {
                if (p.isKeyValue()) {
                    int i = 0;
                    while (i < a.getValueEntry().size()) {
                        prop.put(p.getXmlName() + "." + i, ((Map.Entry)a.getValueEntry().get(i)).getValue());
                        prop.put(p.getXmlName() + "." + i + ".key", ((Map.Entry)a.getValueEntry().get(i)).getKey());
                        ++i;
                    }
                    continue;
                }
                if (p.getType() == PropertyType.REFERENCE) {
                    int i = 0;
                    while (i < a.getRefs().size()) {
                        block12: {
                            try {
                                prop.put(p.getXmlName() + "." + i, CacheHelper.getURIFragment((EObject)((EObject)a.getRefs().get(i))));
                            }
                            catch (Exception ex) {
                                if (!logger.isDebugEnabled()) break block12;
                                logger.debug("Unexpected error", (Throwable)ex);
                            }
                        }
                        ++i;
                    }
                    continue;
                }
                int i = 0;
                while (i < a.getValues().size()) {
                    prop.put(p.getXmlName() + "." + i, a.getValues().get(i));
                    ++i;
                }
                continue;
            }
            if (p.getType() == PropertyType.REFERENCE) {
                try {
                    prop.put(p.getXmlName(), CacheHelper.getURIFragment((EObject)a.getRef()));
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Unexpected error", (Throwable)ex);
                }
                continue;
            }
            prop.put(p.getXmlName(), a.getValue());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        prop.store(bos, null);
        return new String(bos.toByteArray(), StandardCharsets.UTF_8);
    }

    private static XPathExpression initXpathExpressionNodeWrapper(NodeWrapper node, String expression, XPathVariableResolver variableResolver) throws XPathExpressionException {
        Evaluation.setJavaExtensionLibrary(node.getConfiguration());
        XPathEvaluator xpath = new XPathEvaluator(node.getConfiguration());
        xpath.setXPathVariableResolver(variableName -> {
            if ("current".equals(variableName.toString())) {
                return node;
            }
            return variableResolver == null ? null : variableResolver.resolveVariable(variableName);
        });
        xpath.setNamespaceContext((NamespaceContext)new NativeEvaluationNamespaceContext());
        return xpath.compile(expression);
    }

    public static List<String> getAvailableProductCodes(XPathContext context, String defTypeFilter) {
        IMdTechRegistry techRegistry = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getMdTechRegistry();
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", true);
        rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
        HashSet<String> res = new HashSet<String>();
        for (URI uri : defTypeFilter == null ? techRegistry.getAllMdURI() : techRegistry.getMdUriFor(defTypeFilter)) {
            Resource resource2 = null;
            try {
                try {
                    resource2 = rs.getResource(uri, true);
                    MdNode node = (MdNode)EMFResourceUtil.getRootElement((Resource)resource2);
                    String val = node.evaluateXpathExpressionCached("INTERN_PRODUCT_CODE_GUI", null);
                    if (val != null) {
                        res.add(val);
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed to extract productCode from {}", (Object)uri, (Object)ex);
                    }
                    if (resource2 == null) continue;
                    resource2.unload();
                    rs.getResources().remove((Object)resource2);
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (resource2 != null) {
                    resource2.unload();
                    rs.getResources().remove((Object)resource2);
                }
                throw throwable;
            }
            if (resource2 == null) continue;
            resource2.unload();
            rs.getResources().remove((Object)resource2);
        }
        for (Resource c : rs.getResources()) {
            c.unload();
        }
        rs.getResources().clear();
        return new ArrayList<String>(res);
    }

    public static List<MdNode> getReferencableNodes(XPathContext context, String defTypeFilter, String xPathCondition) {
        IRegistryService.IRegistry registry = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(ReferencableObject.class);
        ArrayList<MdNode> res = new ArrayList<MdNode>();
        for (ReferencableObject ref : registry.find((IRegistryService.IRegistryMatcher)new ReferencableObject.DefTypeMatcher(defTypeFilter))) {
            EObject ctx = (EObject)((MdNodeWrapper2)context.getContextItem()).getNode();
            EObject n = ctx.eResource().getResourceSet().getEObject(ref.getModelObjectURI(), true);
            if (!(n instanceof MdNode)) continue;
            MdNode md = (MdNode)n;
            XpathExpression xpeLevel = ReferencableObjectFactory.findReferenceableExpression(md);
            Level lvl = md.getLevel();
            try {
                if (xpeLevel == null || !md.evaluateMdBoolean(xpeLevel.getExpression())) continue;
                if (xPathCondition != null) {
                    if (!md.evaluateMdBoolean(xPathCondition)) continue;
                    res.add(md);
                    continue;
                }
                res.add(md);
            }
            catch (XPathExpressionException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Failed to evaluate xPathExpression {}", (Object)(lvl.getCode() + ":" + String.valueOf(xpeLevel.getCode().get(0))), (Object)e);
            }
        }
        return res;
    }

    private static class CustomJavaExtensionLibrary
    extends JavaExtensionLibrary {
        private static final long serialVersionUID = 6757919926013758390L;
        private JavaExtensionLibrary defaultJel;
        private Configuration config;

        public CustomJavaExtensionLibrary(Configuration config, JavaExtensionLibrary defaultJel) {
            super(config);
            this.config = config;
            this.defaultJel = defaultJel;
        }

        private Expression bindFunction(StructuredQName functionName, Configuration conf, Expression[] staticArgs, Class ... args) throws SecurityException, NoSuchMethodException {
            JavaExtensionFunctionFactory factory = (JavaExtensionFunctionFactory)conf.getExtensionFunctionFactory("java");
            Class[] argsWithContext = new Class[args.length + 1];
            int i = 0;
            argsWithContext[i++] = XPathContext.class;
            Class[] classArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Class clazz = classArray[n2];
                argsWithContext[i++] = args[i - 2];
                ++n2;
            }
            return factory.makeExtensionFunctionCall(functionName, Evaluation.class, (AccessibleObject)Evaluation.class.getMethod(functionName.getLocalName(), argsWithContext), staticArgs);
        }

        public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
            String prefix = functionName.getPrefix();
            if (prefix != null && (prefix.equals("ref") || prefix.equals("internal"))) {
                String local = functionName.getLocalName();
                try {
                    if (local.equals("getMessage")) {
                        JavaExtensionFunctionFactory factory = (JavaExtensionFunctionFactory)this.config.getExtensionFunctionFactory("java");
                        Class[] argsWithCtx = new Class[]{XPathContext.class, String.class, String[].class};
                        factory.setExtensionFunctionClass(MessageExtensionCall.class);
                        return factory.makeExtensionFunctionCall(functionName, Evaluation.class, (AccessibleObject)Evaluation.class.getMethod(functionName.getLocalName(), argsWithCtx), staticArgs);
                    }
                    if (local.equals("toJavaProperties")) {
                        return this.bindFunction(functionName, this.config, staticArgs, new Class[0]);
                    }
                    if (local.equals("getMdNodeById")) {
                        return this.bindFunction(functionName, this.config, staticArgs, String.class);
                    }
                    if (local.equals("getCrossRef")) {
                        return this.bindFunction(functionName, this.config, staticArgs, String.class);
                    }
                    if (local.equals("getRef")) {
                        return this.bindFunction(functionName, this.config, staticArgs, new Class[0]);
                    }
                    if (local.equals("join")) {
                        return this.bindFunction(functionName, this.config, staticArgs, ValueRepresentation.class, ValueRepresentation.class, ValueRepresentation.class, ValueRepresentation.class, ValueRepresentation.class, ValueRepresentation.class, ValueRepresentation.class, ValueRepresentation.class, ValueRepresentation.class, ValueRepresentation.class);
                    }
                    if (local.equals("getRootNode")) {
                        return this.bindFunction(functionName, this.config, staticArgs, String.class, String.class);
                    }
                    if (local.equals("getMetaDataLinkRef")) {
                        return this.bindFunction(functionName, this.config, staticArgs, String.class);
                    }
                    if (local.equals("getAvailableProductCodes")) {
                        return this.bindFunction(functionName, this.config, staticArgs, String.class);
                    }
                    if (local.equals("getReferencableNodes")) {
                        return this.bindFunction(functionName, this.config, staticArgs, String.class, String.class);
                    }
                    if (local.equals("getURLPattern4Module")) {
                        return this.bindFunction(functionName, this.config, staticArgs, new Class[0]);
                    }
                    if (local.equals("list")) {
                        return this.bindFunction(functionName, this.config, staticArgs, ValueRepresentation.class, String.class, String.class, String.class, String.class, Boolean.class);
                    }
                    if (local.equals("encloseIfNotEmpty")) {
                        return this.bindFunction(functionName, this.config, staticArgs, String.class, String.class, String.class, String.class);
                    }
                    if (local.equals("getResourceName")) {
                        return this.bindFunction(functionName, this.config, staticArgs, new Class[0]);
                    }
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new XPathException((Throwable)e);
                }
            }
            return this.defaultJel.bind(functionName, staticArgs, env);
        }
    }

    public static class MessageExtensionCall
    extends ExtensionFunctionCall {
        public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
            block4: {
                try {
                    Field f = ExtensionFunctionCall.class.getDeclaredField("theParameterTypes");
                    f.setAccessible(true);
                    if (f.get((Object)this) == null) {
                        Class[] v = new Class[this.argument.length + 1];
                        v[0] = XPathContext.class;
                        int i = 0;
                        while (i < this.argument.length) {
                            v[i + 1] = String.class;
                            ++i;
                        }
                        f.set((Object)this, v);
                    }
                    f.setAccessible(false);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug("Unexpected error", (Throwable)e);
                }
            }
            return super.typeCheck(visitor, contextItemType);
        }

        protected Object invokeMethod(Method method, Object instance, Object[] params) throws IllegalAccessException, InvocationTargetException {
            block4: {
                try {
                    if (method.equals(Evaluation.class.getMethod("getMessage", XPathContext.class, String.class, String[].class))) {
                        Object[] p = new Object[]{params[0], params[1], new String[params.length - 1]};
                        int i = 1;
                        while (i < params.length) {
                            ((String[])p[2])[i - 1] = (String)params[i];
                            ++i;
                        }
                        return super.invokeMethod(method, instance, p);
                    }
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug("Unexpected error", (Throwable)ex);
                }
            }
            return super.invokeMethod(method, instance, params);
        }
    }
}

