/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.util;

import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.util.Messages;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class MdAttributeReader {
    private static Set<String> currentDefaultValueEvaluations = Collections.newSetFromMap(new WeakHashMap());

    private MdAttributeReader() {
    }

    public static String readAttribute(String shortCode, MdNode node, String nullValue) throws UnknownTechPropertyException {
        String s = (String)MdAttributeReader._readAttribute(shortCode, node);
        if (s == null) {
            return nullValue;
        }
        return s;
    }

    public static List<String> readAttributeList(String shortCode, MdNode node) throws UnknownTechPropertyException {
        return (List)MdAttributeReader._readAttribute(shortCode, node);
    }

    public static Map<String, String> readAttributeMap(String shortCode, MdNode node) throws UnknownTechPropertyException {
        return (Map)MdAttributeReader._readAttribute(shortCode, node);
    }

    public static MdNode readAttributeRef(String shortCode, MdNode node) throws UnknownTechPropertyException {
        return (MdNode)MdAttributeReader._readAttribute(shortCode, node);
    }

    private static Object _readAttribute(String shortCode, MdNode node) throws UnknownTechPropertyException {
        Property p = node.getLevel().getAttributeByShortCode(shortCode);
        if (p == null) {
            throw new UnknownTechPropertyException(shortCode);
        }
        Attribute att = null;
        String conf = ((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).getCurrentConfigurationName();
        if (conf != null) {
            for (Configuration c : node.getConfiguration()) {
                if (!conf.equals(c.getName())) continue;
                att = c.getAttributeByShortCode(shortCode);
                break;
            }
        }
        if (att == null) {
            att = node.getAttributeByShortCode(shortCode);
        }
        if (att == null) {
            if (p != null && p.supportDefaultValue()) {
                if (p.getMdDefaultXpath() != null && !p.getMdDefaultXpath().isEmpty()) {
                    try {
                        String val = node.evaluate(p.getMdDefaultXpath());
                        if (val != null) {
                            return val;
                        }
                    }
                    catch (Throwable val) {
                        // empty catch block
                    }
                }
                if (p.getDefault() != null && !p.getDefault().isEmpty()) {
                    return p.getDefault();
                }
            }
            return null;
        }
        if (att.getTechProperty().getType() != PropertyType.PASSWORD) {
            if (p.isUnbounded()) {
                if (p.isKeyValue()) {
                    return att.getValueEntry().map();
                }
                if (p.getType() == PropertyType.REFERENCE) {
                    return att.getRefs();
                }
                return att.getValues();
            }
            if (p.getType() == PropertyType.REFERENCE) {
                return att.getRef();
            }
            return att.getValue();
        }
        if (att.getTechProperty().getType() == PropertyType.PASSWORD && att.getValue() != null) {
            try {
                SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                String decrypt = semaphoreManager.getStringAsciiInfo(att.getValue());
                return decrypt;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String readAttribute(String shortCode, MdNode node) throws UnknownTechPropertyException {
        return (String)MdAttributeReader._readAttribute(shortCode, node);
    }

    public static boolean readAttribute(String shortCode, MdNode node, Boolean defaultValue) throws UnknownTechPropertyException, Exception {
        String s = (String)MdAttributeReader._readAttribute(shortCode, node);
        if (s == null || s.isEmpty()) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public static String evaluateDefaultValue(String propertyCode, MdNode node, String confName) throws Exception {
        Attribute att = null;
        Configuration ctx = node;
        for (Configuration c : node.getConfiguration()) {
            if ((c.getName() != null && !c.getName().isEmpty() || confName != null && !confName.isEmpty()) && !c.getName().equals(confName)) continue;
            att = c.getAttributeByShortCode(propertyCode);
            ctx = c;
            break;
        }
        if (att == null) {
            att = node.getAttributeByCode(propertyCode);
        }
        if (att != null && att.getValue() != null && !att.getValue().isEmpty()) {
            throw new Exception(String.format(Messages.MdAttributeReader_3, node.getId(), propertyCode));
        }
        if (node.getLevel() == null) {
            throw new Exception(String.format(Messages.MdAttributeReader_4, node.getId()));
        }
        Property p = node.getPropertyByShortCode(propertyCode);
        if (p != null) {
            if (p.supportDefaultValue()) {
                String defaultValue;
                block14: {
                    defaultValue = null;
                    if (p.getMdDefaultXpath() != null && !p.getMdDefaultXpath().isEmpty() && currentDefaultValueEvaluations.add(node.getId() + "/" + propertyCode)) {
                        try {
                            try {
                                defaultValue = ctx.evaluate(p.getMdDefaultXpath());
                            }
                            catch (Exception exception) {
                                currentDefaultValueEvaluations.remove(node.getId() + "/" + propertyCode);
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            currentDefaultValueEvaluations.remove(node.getId() + "/" + propertyCode);
                            throw throwable;
                        }
                        currentDefaultValueEvaluations.remove(node.getId() + "/" + propertyCode);
                    }
                }
                if (defaultValue == null || defaultValue.isEmpty()) {
                    defaultValue = p.getDefault();
                }
                if (defaultValue != null && defaultValue.isEmpty()) {
                    return null;
                }
                return defaultValue;
            }
            return null;
        }
        throw new Exception(String.format(Messages.MdAttributeReader_7, propertyCode, node.getId()));
    }

    public static class UnknownTechPropertyException
    extends Exception {
        private static final long serialVersionUID = -2885489578031745058L;

        public UnknownTechPropertyException(String propertyCode) {
            super(String.format(Messages.MdAttributeReader_0, propertyCode));
        }
    }
}

