/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.util;

import com.semarchy.xdi.designer.core.services.registry.ProcessToolDescriptor;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Attribute;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdNode;
import com.stambia.md.MdRootNode;
import com.stambia.md.util.Messages;
import com.stambia.md.util.StbMdResourceImpl;
import com.stambia.tech.PropertyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.service.log.LogService;

public class ProcessToolFactory {
    private static final String DEF_TYPE_TOOLS = "com.stambia.tools.processTool";
    private static final String DEF_TYPE_ACTION_DEF = "com.stambia.tools.actionDefinition";
    private static final String DEF_TYPE_ACTION_DEF_EXTENSION = "com.stambia.tools.actionDefExtension";
    private static final String DEF_TYPE_PARAMETER = "com.stambia.tools.parameter";
    private static final String DEF_TYPE_PARAMETER_VALUE = "com.stambia.tools.parameterValue";
    private static final String DEF_TYPE_MDLINK = "com.stambia.tools.metadata";
    private static final String DEF_TYPE_XSLVAR = "com.stambia.tools.xslVariable";
    private static final Object DEF_TYPE_BIND_VARIABLE = "com.stambia.tools.bindVariable";
    private static final Object DEF_TYPE_PARAM_INITIALIZER = "com.stambia.tools.parameter.initializer";
    private static final String P_NAME = "name";
    private static final String P_VALUE = "value";
    private static final String P_PARAM_REF = "parameterRef";
    private static final String P_MANDATORY = "required";
    private static final String P_DESCRIPTION = "description";
    private static final String P_DISPLAY_NAME = "displayName";
    private static final String P_TYPE = "type";
    private static final String P_DEFAULT_VALUE = "defaultValue";
    private static final String P_SYSTEM = "system";
    private static final String P_HIDDEN = "hidden";
    private static final String P_RESTRICTION = "restriction";
    private static final String P_PUBLICATION = "publication";
    private static final String P_BINDABLE = "bindable";
    private static final String P_CLASS_NAME = "class";
    private static final String P_PROCESS_REF_URI = "processRef";
    private static final String P_BINDABLE_SRC = "bindableSrc";
    private static final String P_BINDABLE_TRG = "bindableTrg";
    private static final String P_CYCLE_NUMBER = "cycleNumber";
    private static final String P_TOLERATED_ERROR = "toleratedError";
    private static final String P_CATEGORY = "paletteCategory";
    private static final String P_VISIBILITY = "visibility";
    private static final String P_LEVEL = "level";
    private static final String P_PUBLISH = "publish";
    private static final String DEF_TYPE_ENABLEMENT = "com.stambia.tools.enablement";
    private static final String P_LONG_DESCRIPTION = "longDescription";
    private static final String DEF_TYPE_ICON = "com.stambia.tools.icon";
    private static final String P_URI = "iconURI";
    private static final String P_LARGEICON = "isLarge";
    private static final String P_IS_ICONURI = "isUri";
    private static final String P_ICON_DATA = "iconData";
    private static final String P_ACTION_DEF_REF = "actionDefRef";
    private static final String P_XPATH_EXPRESSION = "xPathExpression";
    private static final String P_INIT_CODE = "initializationCode";
    private static final String OP_OR = "or";
    private static final String OP_AND = "and";
    private static final String OP_NOT = "not";
    private static final String CHECK_EXIST = "Exist";
    private static final String CHECK_VALUE = "Value";
    private static final String DEF_TYPE_OPERATOR = "com.stambia.tools.enablement.operator";
    private static final String DEF_TYPE_CHECK = "com.stambia.tools.enablement.parametercheck";
    private static final String P_OPERATOR_KIND = "type";
    private static final String P_PARAMETER_NAME = "parameterName";
    private static final String P_PARAMETER_VALUE = "parameterValue";
    private static final String P_TEST_TYPE = "testType";

    public List<ProcessToolDescriptor> createDescriptors(StbMdResourceImpl resource) throws Exception {
        ArrayList<ProcessToolDescriptor> res = new ArrayList<ProcessToolDescriptor>();
        MdRootNode main = ((DocumentRoot)resource.getContents().get(0)).getNode();
        for (MdNode actionDef : main.getNode()) {
            ProcessToolDescriptor desc;
            if (actionDef.getDefType().equals(DEF_TYPE_ACTION_DEF)) {
                try {
                    desc = this.createActionDefinition(resource.getId(), actionDef);
                    for (MdNode n : actionDef.getNode()) {
                        if (n.getDefType().equals(DEF_TYPE_PARAMETER)) {
                            desc.getParameters().add(this.parseParameter(n));
                            continue;
                        }
                        if (n.getDefType().equals(DEF_TYPE_XSLVAR)) {
                            desc.getXslVariables().add(this.parseXslVar(n));
                            continue;
                        }
                        if (!n.getDefType().equals(DEF_TYPE_BIND_VARIABLE)) continue;
                        desc.getBindVariables().add(this.parseBindVar(n));
                    }
                    res.add(desc);
                }
                catch (Exception ex) {
                    ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.md.ui").error(String.format(Messages.ProcessToolFactory_0, actionDef.getName(), resource.getURI()), (Object)ex);
                }
                continue;
            }
            if (actionDef.getDefType().equals(DEF_TYPE_TOOLS)) {
                try {
                    desc = this.createProcessTool(resource.getId(), actionDef);
                    for (MdNode n : actionDef.getNode()) {
                        if (!n.getDefType().equals(DEF_TYPE_MDLINK)) continue;
                        desc.getMetaDatalinks().add(this.parseMdLink(n));
                    }
                    res.add(desc);
                    for (MdNode n : actionDef.getNode()) {
                        String paramName;
                        Attribute a;
                        if (!n.getDefType().equals(DEF_TYPE_PARAMETER_VALUE) || (a = n.getAttributeByShortCode(P_VALUE)) == null || a.getValue() == null || (paramName = n.getAttributeValueByShortCode(P_NAME)) == null || paramName.trim().isEmpty()) continue;
                        ProcessToolDescriptor.ParameterDescriptor pd = new ProcessToolDescriptor.ParameterDescriptor(paramName, false, "", "", "", "String", "", false, false);
                        pd.setForcedValue(a.getValue());
                        desc.getParameters().add(pd);
                    }
                }
                catch (Exception ex) {
                    ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.md.ui").error(String.format(Messages.ProcessToolFactory_1, actionDef.getName(), resource.getURI()), (Object)ex);
                }
                continue;
            }
            if (!actionDef.getDefType().equals(DEF_TYPE_ACTION_DEF_EXTENSION)) continue;
            try {
                desc = this.createActionDefinitionExtension(resource.getId(), actionDef);
                if (desc == null) continue;
                for (MdNode n : actionDef.getNode()) {
                    if (n.getDefType().equals(DEF_TYPE_PARAMETER)) {
                        desc.getParameters().add(this.parseParameter(n));
                        continue;
                    }
                    if (n.getDefType().equals(DEF_TYPE_XSLVAR)) {
                        desc.getXslVariables().add(this.parseXslVar(n));
                        continue;
                    }
                    if (n.getDefType().equals(DEF_TYPE_BIND_VARIABLE)) {
                        desc.getBindVariables().add(this.parseBindVar(n));
                        continue;
                    }
                    if (!n.getDefType().equals(DEF_TYPE_MDLINK)) continue;
                    desc.getMetaDatalinks().add(this.parseMdLink(n));
                }
                res.add(desc);
            }
            catch (Exception ex) {
                ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.md.ui").error(String.format(Messages.ProcessToolFactory_2, actionDef.getName(), resource.getURI()), (Object)ex);
            }
        }
        return res;
    }

    private Object[] parseIconNode(MdNode c) throws Exception {
        String url = c.getAttributeValueByShortCode(P_URI);
        String _large = c.getAttributeValueByShortCode(P_LARGEICON);
        String _isURI = c.getAttributeValueByShortCode(P_IS_ICONURI);
        String iconData = c.getAttributeValueByShortCode(P_ICON_DATA);
        ProcessToolDescriptor.IconDescriptor descriptor = null;
        boolean large = false;
        boolean isURI = true;
        try {
            large = Boolean.parseBoolean(_large);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_isURI != null) {
            try {
                isURI = Boolean.parseBoolean(_isURI);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isURI) {
            if (url == null) {
                return null;
            }
            descriptor = new ProcessToolDescriptor.IconDescriptor(url, null);
        } else {
            String imageKey = c.getId() + "_tool_Icon";
            byte[] decode = Base64.decode((byte[])iconData.getBytes("UTF-8"));
            descriptor = new ProcessToolDescriptor.IconDescriptor(imageKey, decode);
        }
        return new Object[]{descriptor, large};
    }

    private ProcessToolDescriptor createProcessTool(String mdFileID, MdNode n) throws Exception {
        String name = n.getAttributeValueByShortCode(P_NAME);
        String description = n.getAttributeValueByShortCode(P_DESCRIPTION);
        String displayName = n.getAttributeValueByShortCode(P_DISPLAY_NAME);
        String refURI = null;
        Attribute att = n.getAttributeByShortCode(P_PROCESS_REF_URI);
        if (att != null) {
            if (att.getTechProperty().getType() == PropertyType.REFERENCE) {
                EObject obj = att.getRef();
                if (obj != null) {
                    refURI = obj.eIsProxy() ? ((InternalEObject)obj).eProxyURI().toString() : EcoreUtil.getURI((EObject)obj).toString();
                }
            } else {
                refURI = att.getValue();
            }
        }
        if (refURI == null || refURI.trim().isEmpty() || !refURI.contains("#")) {
            throw new Exception(String.format(Messages.ProcessToolFactory_3, n.getId(), n.eResource().getURI()));
        }
        String paletteCategory = n.getAttributeValueByShortCode(P_CATEGORY);
        String longdesc = n.getAttributeValueByShortCode(P_LONG_DESCRIPTION);
        ProcessToolDescriptor.IconDescriptor smallIcon = null;
        ProcessToolDescriptor.IconDescriptor largeIcon = null;
        for (MdNode c : n.getNodeByCode(DEF_TYPE_ICON)) {
            try {
                Object[] iconInfo = this.parseIconNode(c);
                if (iconInfo == null) continue;
                if (iconInfo[1] == Boolean.TRUE) {
                    largeIcon = (ProcessToolDescriptor.IconDescriptor)iconInfo[0];
                    continue;
                }
                smallIcon = (ProcessToolDescriptor.IconDescriptor)iconInfo[0];
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        URI toolDefinitionMdNodeURI = EcoreUtil.getURI((EObject)n);
        return new ProcessToolDescriptor.ToolDefinition(mdFileID, name, smallIcon, largeIcon, refURI, displayName, description, longdesc, paletteCategory, toolDefinitionMdNodeURI);
    }

    private ProcessToolDescriptor.MetadataLinkDescriptor parseMdLink(MdNode n) {
        String name = n.getAttributeValueByShortCode(P_NAME);
        Attribute publicationsA = n.getAttributeByShortCode(P_PUBLICATION);
        Attribute levelsA = n.getAttributeByShortCode(P_LEVEL);
        String _publish = n.getAttributeValueByShortCode(P_PUBLISH);
        String _description = n.getAttributeValueByShortCode(P_DESCRIPTION);
        boolean publish = false;
        try {
            publish = Boolean.parseBoolean(_publish);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String visibility = n.getAttributeValueByShortCode(P_VISIBILITY);
        ProcessToolDescriptor.MetadataLinkDescriptor res = new ProcessToolDescriptor.MetadataLinkDescriptor(name, publish, visibility, _description);
        if (publicationsA != null) {
            res.getPublicationModes().addAll(publicationsA.getValues());
        }
        if (levelsA != null) {
            for (Map.Entry e : levelsA.getValueEntry()) {
                res.getAllowedLevels().put((String)e.getKey(), (String)e.getValue());
            }
        }
        return res;
    }

    private ProcessToolDescriptor.XslVariableDescriptor parseXslVar(MdNode n) {
        String name = n.getAttributeValueByShortCode(P_NAME);
        String type = n.getAttributeValueByShortCode("type");
        String visibility = n.getAttributeValueByShortCode(P_VISIBILITY);
        return new ProcessToolDescriptor.XslVariableDescriptor(name, type, visibility);
    }

    private ProcessToolDescriptor.BindVariableDescriptor parseBindVar(MdNode n) {
        String name = n.getAttributeValueByShortCode(P_NAME);
        String description = n.getAttributeValueByShortCode(P_DESCRIPTION);
        return new ProcessToolDescriptor.BindVariableDescriptor(name, description);
    }

    private ProcessToolDescriptor createActionDefinitionExtension(String mdFileID, MdNode n) throws Exception {
        Attribute att = n.getAttributeByShortCode(P_ACTION_DEF_REF);
        if (att != null && att.getRef() instanceof MdNode) {
            ProcessToolDescriptor.ActionDefinition desc = (ProcessToolDescriptor.ActionDefinition)this.createActionDefinition(mdFileID, (MdNode)att.getRef());
            String name = n.getAttributeValueByShortCode(P_NAME);
            String description = n.getAttributeValueByShortCode(P_DESCRIPTION);
            String displayName = n.getAttributeValueByShortCode(P_DISPLAY_NAME);
            String paletteCategory = n.getAttributeValueByShortCode(P_CATEGORY);
            String longdesc = n.getAttributeValueByShortCode(P_LONG_DESCRIPTION);
            String initCode = n.getAttributeValueByShortCode(P_INIT_CODE);
            ProcessToolDescriptor.IconDescriptor smallIcon = null;
            ProcessToolDescriptor.IconDescriptor largeIcon = null;
            for (MdNode c : n.getNodeByCode(DEF_TYPE_ICON)) {
                try {
                    Object[] iconInfo = this.parseIconNode(c);
                    if (iconInfo == null) continue;
                    if (iconInfo[1] == Boolean.TRUE) {
                        largeIcon = (ProcessToolDescriptor.IconDescriptor)iconInfo[0];
                        continue;
                    }
                    smallIcon = (ProcessToolDescriptor.IconDescriptor)iconInfo[0];
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            URI toolDefinitionMdNodeURI = EcoreUtil.getURI((EObject)n);
            EObject o = att.getRef();
            ProcessToolDescriptor.ActionDefinitionExtension res = new ProcessToolDescriptor.ActionDefinitionExtension(mdFileID, name, smallIcon, largeIcon, displayName, description, longdesc, paletteCategory, desc, toolDefinitionMdNodeURI, initCode);
            for (MdNode c : ((MdNode)o).getNode()) {
                if (c.getDefType().equals(DEF_TYPE_PARAMETER)) {
                    res.getParameters().add(this.parseParameter(c));
                    continue;
                }
                if (c.getDefType().equals(DEF_TYPE_XSLVAR)) {
                    res.getXslVariables().add(this.parseXslVar(c));
                    continue;
                }
                if (!c.getDefType().equals(DEF_TYPE_BIND_VARIABLE)) continue;
                res.getBindVariables().add(this.parseBindVar(c));
            }
            block4: for (MdNode c : n.getNode()) {
                String paramName;
                Attribute a;
                if (!c.getDefType().equals(DEF_TYPE_PARAMETER_VALUE) || (a = c.getAttributeByShortCode(P_PARAM_REF)) == null || !(a.getRef() instanceof MdNode) || (paramName = ((MdNode)a.getRef()).getAttributeValueByShortCode(P_NAME)) == null || paramName.trim().isEmpty()) continue;
                for (ProcessToolDescriptor.ParameterDescriptor d : res.getParameters()) {
                    if (!d.getName().equals(paramName)) continue;
                    d.setForcedValue(c.getAttributeValueByShortCode(P_VALUE));
                    continue block4;
                }
            }
            return res;
        }
        return null;
    }

    private ProcessToolDescriptor createActionDefinition(String mdFileID, MdNode n) throws Exception {
        String name = n.getAttributeValueByShortCode(P_NAME);
        String description = n.getAttributeValueByShortCode(P_DESCRIPTION);
        String displayName = n.getAttributeValueByShortCode(P_DISPLAY_NAME);
        String className = n.getAttributeValueByShortCode(P_CLASS_NAME);
        String _bindableAsSrc = n.getAttributeValueByShortCode(P_BINDABLE_SRC);
        String initCode = n.getAttributeValueByShortCode(P_INIT_CODE);
        boolean bindableAsSrc = false;
        try {
            bindableAsSrc = Boolean.parseBoolean(_bindableAsSrc);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String _bindableAsTrg = n.getAttributeValueByShortCode(P_BINDABLE_TRG);
        boolean bindableAsTrg = false;
        try {
            bindableAsTrg = Boolean.parseBoolean(_bindableAsTrg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String _hidden = n.getAttributeValueByShortCode(P_HIDDEN);
        boolean hidden = false;
        try {
            hidden = Boolean.parseBoolean(_hidden);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String _cycleNumber = n.getAttributeValueByShortCode(P_CYCLE_NUMBER);
        Integer cycleNumber = null;
        try {
            cycleNumber = Integer.parseInt(_cycleNumber);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String _toleratedError = n.getAttributeValueByShortCode(P_TOLERATED_ERROR);
        Boolean toleratedError = null;
        try {
            toleratedError = Boolean.parseBoolean(_toleratedError);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String paletteCategory = n.getAttributeValueByShortCode(P_CATEGORY);
        String longdesc = n.getAttributeValueByShortCode(P_LONG_DESCRIPTION);
        ProcessToolDescriptor.IconDescriptor smallIcon = null;
        ProcessToolDescriptor.IconDescriptor largeIcon = null;
        for (MdNode c : n.getNodeByCode(DEF_TYPE_ICON)) {
            try {
                Object[] iconInfo = this.parseIconNode(c);
                if (iconInfo == null) continue;
                if (iconInfo[1] == Boolean.TRUE) {
                    largeIcon = (ProcessToolDescriptor.IconDescriptor)iconInfo[0];
                    continue;
                }
                smallIcon = (ProcessToolDescriptor.IconDescriptor)iconInfo[0];
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return new ProcessToolDescriptor.ActionDefinition(mdFileID, name, smallIcon, largeIcon, className, bindableAsSrc, bindableAsTrg, displayName, description, longdesc, hidden, cycleNumber, toleratedError, paletteCategory, initCode);
    }

    private ProcessToolDescriptor.ParameterDescriptor parseParameter(MdNode n) {
        String name = n.getAttributeValueByShortCode(P_NAME);
        String mandatory = n.getAttributeValueByShortCode(P_MANDATORY);
        String desc = n.getAttributeValueByShortCode(P_DESCRIPTION);
        String longdesc = n.getAttributeValueByShortCode(P_LONG_DESCRIPTION);
        String displayName = n.getAttributeValueByShortCode(P_DISPLAY_NAME);
        String type = n.getAttributeValueByShortCode("type");
        String defaultValue = n.getAttributeValueByShortCode(P_DEFAULT_VALUE);
        String system = n.getAttributeValueByShortCode(P_SYSTEM);
        String hidden = n.getAttributeValueByShortCode(P_HIDDEN);
        Attribute restrictionsA = n.getAttributeByShortCode(P_RESTRICTION);
        Attribute publicationsA = n.getAttributeByShortCode(P_PUBLICATION);
        ProcessToolDescriptor.ParameterDescriptor pd = new ProcessToolDescriptor.ParameterDescriptor(name, Boolean.valueOf(mandatory).booleanValue(), desc, longdesc, displayName, type, defaultValue, Boolean.parseBoolean(system), Boolean.parseBoolean(hidden));
        if (restrictionsA != null) {
            pd.getRestrictedValues().addAll(restrictionsA.getValues());
        }
        if (publicationsA != null) {
            pd.getPublicationModes().addAll(publicationsA.getValues());
        }
        block2: for (MdNode node : n.getNode()) {
            if (node.getDefType().equals(DEF_TYPE_ENABLEMENT)) {
                for (MdNode c : node.getNode()) {
                    if (!c.getDefType().equals(DEF_TYPE_OPERATOR) && !c.getDefType().equals(DEF_TYPE_CHECK)) continue;
                    pd.setEnablementExpression(this.createEnablementExpression(c));
                    continue block2;
                }
                continue;
            }
            if (!node.getDefType().equals(DEF_TYPE_PARAM_INITIALIZER)) continue;
            ArrayList<String> levelCodes = new ArrayList<String>();
            String valueXpathExpression = null;
            Attribute att = node.getAttributeByShortCode(P_LEVEL);
            if (att != null) {
                levelCodes.addAll((Collection<String>)att.getValues());
            }
            if ((att = node.getAttributeByShortCode(P_XPATH_EXPRESSION)) != null) {
                valueXpathExpression = att.getValue();
            }
            if (levelCodes.isEmpty() || valueXpathExpression == null || valueXpathExpression.trim().isEmpty()) continue;
            try {
                pd.addInitializer(valueXpathExpression, levelCodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pd;
    }

    private ProcessToolDescriptor.EnablementExpression createEnablementExpression(MdNode n) {
        ProcessToolDescriptor.EnablementExpression exp = null;
        if (n.getDefType().equals(DEF_TYPE_OPERATOR)) {
            String type = n.getAttributeValueByShortCode("type");
            if (OP_OR.equals(type)) {
                exp = new ProcessToolDescriptor.EnablementExpression(2, null, null);
            } else if (OP_AND.equals(type)) {
                exp = new ProcessToolDescriptor.EnablementExpression(3, null, null);
            } else if (OP_NOT.equals(type)) {
                exp = new ProcessToolDescriptor.EnablementExpression(1, null, null);
            }
        } else if (n.getDefType().equals(DEF_TYPE_CHECK)) {
            String pName = n.getAttributeValueByShortCode(P_PARAMETER_NAME);
            String pState = n.getAttributeValueByShortCode(P_PARAMETER_VALUE);
            String type = n.getAttributeValueByShortCode(P_TEST_TYPE);
            int kind = -1;
            if (CHECK_EXIST.equals(type)) {
                kind = 5;
            } else if (CHECK_VALUE.equals(type)) {
                kind = 4;
            }
            if (kind != -1) {
                exp = new ProcessToolDescriptor.EnablementExpression(kind, pName, pState);
            }
        }
        if (exp != null) {
            for (MdNode child : n.getNode()) {
                ProcessToolDescriptor.EnablementExpression e = this.createEnablementExpression(child);
                if (e == null) continue;
                exp.getChildren().add(e);
            }
        }
        return exp;
    }
}

