/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.util;

import com.semarchy.xdi.designer.core.services.registry.RuntimeEngine;
import com.stambia.md.Configuration;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdNode;
import com.stambia.md.MdRootNode;
import com.stambia.md.util.StbMdResourceImpl;
import java.util.ArrayList;
import java.util.List;

public class RuntimeEngineFactory {
    private static final String DEF_TYPE_ENGINE = "com.stambia.runtime.engine";
    private static final String ATT_HOST = "host";
    private static final String ATT_PORT = "port";
    private static final String ATT_USER = "user";
    private static final String ATT_PASSWORD = "password";
    private static final String ATT_DESC = "description";

    public List<RuntimeEngine> createEngines(StbMdResourceImpl resource) throws Exception {
        MdRootNode main = ((DocumentRoot)resource.getContents().get(0)).getNode();
        ArrayList<RuntimeEngine> res = new ArrayList<RuntimeEngine>();
        for (MdNode n : main.getNode()) {
            if (!n.getDefType().equals(DEF_TYPE_ENGINE)) continue;
            String name = n.getName();
            String host = n.getAttributeValueByShortCode(ATT_HOST);
            String port = n.getAttributeValueByShortCode(ATT_PORT);
            String user = n.getAttributeValueByShortCode(ATT_USER);
            String password = n.getAttributeValueByShortCode(ATT_PASSWORD);
            String description = n.getAttributeValueByShortCode(ATT_DESC);
            try {
                RuntimeEngine e = null;
                e = new RuntimeEngine(resource.getId(), name, host, port, description, user, password);
                res.add(e);
                for (Configuration c : n.getConfiguration()) {
                    e.addConfiguration(c.getName(), host == null ? null : n.getAttributeByShortCode(ATT_HOST).getValue(c.getName()), port == null ? null : n.getAttributeByShortCode(ATT_PORT).getValue(c.getName()), user == null ? null : n.getAttributeByShortCode(ATT_USER).getValue(c.getName()), password == null ? null : n.getAttributeByShortCode(ATT_PASSWORD).getValue(c.getName()));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return res;
    }
}

