/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.util;

import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.cache.CacheDuplicateException;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.services.registry.UDFImplementation;
import com.semarchy.xdi.designer.core.services.registry.UDFParameter;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Attribute;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdNode;
import com.stambia.md.MdRootNode;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.Messages;
import com.stambia.md.util.StbMdResourceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class UDFFactory {
    private static final String DEF_TYPE_FUNCTION = "com.stambia.function.function";
    private static final String DEF_TYPE_PARAMETER = "com.stambia.function.parameter";
    private static final String DEF_TYPE_IMPLEMENTATION = "com.stambia.function.implementation";
    private IRegistryService registryService = (IRegistryService)E4InjectorHelper.getService(IRegistryService.class);

    public List<UDF> createUDF(StbMdResourceImpl resource) throws Exception {
        ArrayList<UDF> res = new ArrayList<UDF>();
        MdRootNode main = ((DocumentRoot)resource.getContents().get(0)).getNode();
        String prefix = main.getAttributeValueByShortCode("prefix");
        if (prefix == null || prefix.trim().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        String libName = main.getName();
        if (libName == null || libName.trim().isEmpty()) {
            libName = "Default";
        }
        ArrayList<String> requiredLibs = new ArrayList<String>();
        try {
            HashSet<String> s = new HashSet<String>(MdAttributeReader.readAttributeList("requiredLibs", main));
            requiredLibs.addAll(s);
            Collections.sort(requiredLibs);
        }
        catch (Exception s) {
            // empty catch block
        }
        IRegistryService.IRegistry reg = this.registryService.getRegistry(UDF.class);
        List _l = reg.find((IRegistryService.IRegistryMatcher)new UDFMatcher(resource.getId(), prefix));
        if (_l != null && !_l.isEmpty()) {
            throw new CacheDuplicateException(String.format(Messages.UDFFactory_0, prefix), ((UDF)_l.get(0)).getMdNodeSourceURI().trimFragment());
        }
        for (MdNode l : main.getNode()) {
            if (!l.getDefType().equals(DEF_TYPE_FUNCTION)) continue;
            ArrayList<UDFParameter> params = new ArrayList<UDFParameter>();
            ArrayList<UDFImplementation> impl = new ArrayList<UDFImplementation>();
            for (MdNode n : l.getNode()) {
                if (n.getDefType().equals(DEF_TYPE_PARAMETER)) {
                    params.add(new UDFParameter(n.getName(), n.getAttributeValueByShortCode("description")));
                }
                if (!n.getDefType().equals(DEF_TYPE_IMPLEMENTATION)) continue;
                Attribute a = n.getAttributeByShortCode("productCode");
                if (a != null) {
                    for (String s : a.getValues()) {
                        impl.add(new UDFImplementation(n.getName(), s, n.getAttributeValueByShortCode("expression"), n.getId(), n.getAttributeValueByShortCode("description")));
                    }
                    continue;
                }
                impl.add(new UDFImplementation(n.getName(), null, n.getAttributeValueByShortCode("expression"), n.getId(), n.getAttributeValueByShortCode("description")));
            }
            res.add(new UDF(l.getName(), libName, prefix, l.getAttributeValueByShortCode("description"), impl, params, EcoreUtil.getURI((EObject)l), requiredLibs));
        }
        return res;
    }

    private static class UDFMatcher
    implements IRegistryService.IRegistryMatcher {
        private String mdFileID;
        private String libPrefix;

        UDFMatcher(String mdFileID, String prefix) {
            this.mdFileID = mdFileID;
            this.libPrefix = prefix;
        }

        public boolean match(Object o) {
            if (o instanceof UDF.UDFKey) {
                return ((UDF.UDFKey)o).getPrefix().equals(this.libPrefix) && !((UDF.UDFKey)o).getProviderFileID().equals(this.mdFileID);
            }
            return false;
        }
    }
}

