/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.internal.workspace;

import com.indy.emf.uri.action.ActionReinitId;
import com.indy.emf.uri.internal.workspace.LinkedFileOperationBuilder;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

class ResetIdsOperation
implements LinkedFileOperationBuilder.Operation {
    Collection<IFile> models;
    private IWorkspace workspace;

    ResetIdsOperation(IWorkspace wksp, Collection<IPath> copiedModel) {
        this.workspace = wksp;
        this.models = copiedModel.stream().map(this::getFile).collect(Collectors.toSet());
    }

    @Override
    public void perform() {
        ActionReinitId.reinit(null, this.models, (IProgressMonitor)new NullProgressMonitor(), null);
    }

    @Override
    public ISchedulingRule getRule() {
        AtomicReference ruleRef = new AtomicReference();
        IResourceRuleFactory ruleFactory = this.workspace.getRuleFactory();
        this.models.stream().forEach(e -> ruleRef.set(MultiRule.combine((ISchedulingRule)((ISchedulingRule)ruleRef.get()), (ISchedulingRule)ruleFactory.modifyRule((IResource)e))));
        return (ISchedulingRule)ruleRef.get();
    }

    private IFile getFile(IPath p) {
        return this.workspace.getRoot().getFile(p);
    }
}

