/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.validation2.internal;

import com.indy.emf.uri.ValidationStatus;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.licence.StaticLicence;
import com.semarchy.xdi.designer.preferences.license.License;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TrialKey {
    private static SemaphoreManagerI semaphoreManager;
    private static SimpleDateFormat formatter;
    protected String publicKey;
    protected String privateKey;
    private Date expirationDate;
    private boolean parseDateOk;
    private boolean parseMacOk;
    private String macAddress;
    private boolean parseVerif;
    private StaticLicence generator = new StaticLicence();

    static {
        TrialKey.init();
    }

    private static void init() {
        try {
            semaphoreManager = new SemaphoreManagerI();
            semaphoreManager.getIsSemaphore("Incorrect Semaphore");
            formatter = new SimpleDateFormat(semaphoreManager.getStringAsciiInfo("A8E0B8E3131CA630A6E9AA5D77EF8C37"));
        }
        catch (OtherExceptionI e) {
            e.printStackTrace();
        }
    }

    private String getPrivateKey() {
        return this.privateKey;
    }

    private String getUncryptInfo(String key) {
        int index = key.lastIndexOf(":");
        if (index > -1) {
            return key.substring(0, index);
        }
        return null;
    }

    private String getCryptInfo(String key) {
        int index = key.lastIndexOf(":");
        if (index > -1) {
            return key.substring(index + 1);
        }
        return key;
    }

    public void setPublicKey(String key) {
        try {
            this.publicKey = key;
            String before = this.getUncryptInfo(this.publicKey);
            String tmp = this.deCrypt(this.getCryptInfo(this.publicKey));
            String after = null;
            if (tmp.length() >= 27) {
                after = tmp.substring(26);
            }
            this.setPrivateKey(this.generator.unshuffle(tmp), before, after);
        }
        catch (Exception e) {
            this.setPrivateKey(null, null, null);
            this.publicKey = null;
        }
    }

    private void setPrivateKey(String privateKey, String before, String after) {
        this.parseVerif = before == null && after == null || before.equals(after);
        this.parseDateOk = false;
        this.parseMacOk = false;
        this.privateKey = privateKey;
        if (privateKey != null) {
            String str001 = privateKey.substring(0, 8);
            String str002 = privateKey.substring(9, 26);
            if (str001.length() == 8) {
                this.parseDateOk = true;
                this.expirationDate = str001.equals("10000101") ? null : formatter.parse(str001, new ParsePosition(0));
            }
            if (str002.length() == 17) {
                this.parseMacOk = true;
                this.macAddress = str002.equals("FF-FF-FF-FF-FF-FF") ? null : str002;
            }
        }
    }

    public ValidationStatus checkValidity() {
        ValidationStatus status = ValidationStatus.ERROR;
        if (this.getPrivateKey() == null) {
            status = ValidationStatus.ERROR;
        } else if (!this.parseVerif) {
            status = ValidationStatus.ERROR;
        } else {
            String privateKey = this.getPrivateKey();
            boolean prestatus = false;
            Date maintenant = new Date();
            try {
                maintenant = formatter.parse(formatter.format(maintenant));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (privateKey.length() == 26 && !privateKey.equals("10000101-FF-FF-FF-FF-FF-FF")) {
                if (this.parseDateOk) {
                    if (this.getExpirationDate() == null) {
                        prestatus = true;
                    } else if (this.getExpirationDate() != null && maintenant.compareTo(this.getExpirationDate()) < 1) {
                        prestatus = true;
                    }
                }
                if (prestatus && this.parseMacOk) {
                    if (this.macAddress == null) {
                        status = ValidationStatus.VALID;
                    } else if (License.matchAdressMac(this.macAddress)) {
                        status = ValidationStatus.VALID;
                    }
                }
            }
        }
        return status;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    private String deCrypt(String tmp) throws OtherExceptionI {
        return semaphoreManager.getStringAsciiInfo(tmp);
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getMacAddress() {
        return this.macAddress;
    }
}

