/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.preferences.license;

import com.indy.emf.uri.Activator;
import com.indy.emf.uri.Messages;
import com.indy.emf.uri.ValidationStatus;
import com.indy.emf.uri.validation2.Validation;
import com.indy.emf.uri.validation2.internal.TrialKey;
import com.indy.licence.TrialLicence;
import com.semarchy.xdi.designer.preferences.license.HostInformation;
import com.semarchy.xdi.designer.preferences.license.License;
import com.semarchy.xdi.designer.preferences.license.LicenseToleranceData;
import com.semarchy.xdi.designer.preferences.license.RegistryHelper;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class LicenseTrial
extends License {
    public static final int TRIAL_LICENSE_DURATION_IN_DAYS = 7;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
    private TrialKey key;
    private long nbday;

    public LicenseTrial() {
        this.mode = Validation.Mode.TRIAL;
    }

    @Override
    public ValidationStatus checkValidity(LicenseToleranceData timeInfo) {
        this.setErrorMessage(null);
        TrialKey elligibleKey = this.key;
        ValidationStatus status = elligibleKey.checkValidity();
        Date maintenant = new Date();
        try {
            maintenant = this.formatter.parse(this.formatter.format(maintenant));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        timeInfo.refreshDelay = 86400000 - maintenant.getHours() * 60 * 60 * 1000 - maintenant.getMinutes() * 60 * 1000;
        if (status == ValidationStatus.VALID && elligibleKey.getExpirationDate() != null) {
            this.nbday = (elligibleKey.getExpirationDate().getTime() - maintenant.getTime()) / 86400000L;
            status = this.nbday > 7L ? ValidationStatus.ERROR : (this.nbday >= 0L ? (this.getStatus() == ValidationStatus.EXPIRED_START ? ValidationStatus.EXPIRATION : (this.getStatus() == ValidationStatus.EXPIRATION ? ValidationStatus.EXPIRATION : ValidationStatus.EXPIRED_START)) : ValidationStatus.EXPIRED);
        }
        if (status != ValidationStatus.ERROR && status != ValidationStatus.EXPIRED) {
            this.key = elligibleKey;
        }
        this.setValidationStatus(status);
        return status;
    }

    @Override
    public Date getExpirationDate() {
        return this.key.getExpirationDate();
    }

    @Override
    protected List<String> getPermissions() {
        return Collections.singletonList("com.indy.administration.role.trial");
    }

    @Override
    public String readFromRegistry() throws License.InvalidLicenseChecksumException {
        String registryKey = RegistryHelper.INSTANCE.read("TrialKey");
        if (registryKey != null) {
            this.key = new TrialKey();
            this.key.setPublicKey(registryKey);
            this.controlTrialLicenceDuration();
            String checksum = RegistryHelper.INSTANCE.read("Checksum");
            return checksum;
        }
        this.key = new TrialKey();
        try {
            HostInformation host = new HostInformation();
            String macAdress = host.findMacAdress(InetAddress.getLocalHost());
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            ((Calendar)calendar).add(5, 7);
            String expirationDate = this.formatter.format(calendar.getTime());
            this.key.setPublicKey(new TrialLicence().generateLicence(expirationDate, macAdress, null));
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.emf.uri", Messages.Validation_11, (Throwable)e));
        }
        return null;
    }

    public long getNbday() {
        return this.nbday;
    }

    @Override
    public String computeChecksum(LicenseToleranceData timeInfo) {
        String str = String.join((CharSequence)"/", this.getMode().name(), this.getFormatExpirationDate(), this.getTrialKey());
        try {
            return this.computeHash(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void controlTrialLicenceDuration() throws License.InvalidLicenseChecksumException {
        try {
            long nbday;
            Date expirationDate = this.dateFormater.parse(RegistryHelper.INSTANCE.read("ExpirationDate"));
            Date now = new Date();
            if (expirationDate != null && (nbday = (expirationDate.getTime() - now.getTime()) / 86400000L) > 7L) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.emf.uri", Messages.Validation_12));
                throw new License.InvalidLicenseChecksumException();
            }
        }
        catch (ParseException e) {
            Object expirationDate = null;
        }
    }

    public String getTrialKey() {
        return this.key.getPublicKey();
    }

    public String getMacAddress() {
        return this.key.getMacAddress();
    }
}

