/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log.rdbms;

import com.indy.engine.core.classloader.IClassLoader;
import com.indy.engine.log.AbstractLog;
import com.indy.engine.log.EngineSessionManager;
import com.indy.engine.log.object.ActionCriteria;
import com.indy.engine.log.object.Criteria;
import com.indy.engine.log.object.IEngineActionHeader;
import com.indy.engine.log.object.IEngineLogHeader;
import com.indy.engine.log.object.IEngineSessionHeader;
import com.indy.engine.log.object.SessionCriteria;
import com.indy.engine.log.object.impl.ActionList;
import com.indy.engine.log.rdbms.DriverShim;
import com.indy.engine.log.rdbms.RdbmsActionHeaderReader;
import com.indy.engine.log.rdbms.RdbmsAltIdReader;
import com.indy.engine.log.rdbms.RdbmsDeliveryReader;
import com.indy.engine.log.rdbms.RdbmsEngineVariableReader;
import com.indy.engine.log.rdbms.RdbmsErrorReader;
import com.indy.engine.log.rdbms.RdbmsLogHeaderReader;
import com.indy.engine.log.rdbms.RdbmsLogQueryUtils;
import com.indy.engine.log.rdbms.RdbmsRuntimeReader;
import com.indy.engine.log.rdbms.RdbmsSessionHeaderReader;
import com.indy.engine.log.rdbms.RdbmsStatisticReader;
import com.indy.engine.userLog.Format;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RdbmsLog
extends AbstractLog {
    int intVersion;
    private String version;
    EngineSessionManager.ObjectReader objectReader;
    String engineUrl;
    private Logger logger;
    private String id;
    private Logger queryLogger;
    private MyConnection myConnection;
    private String jdbcSchema;
    private String name;
    private String timeStampQuery;
    private IClassLoader jdbcClassLoader;
    private boolean isEngine;
    private static final String BEGIN_DATE = "_BEGIN_DATE";
    private static final String END_DATE = "_END_DATE";
    private static final String BOUNDARY_MODE_INCLUSIVE = "Inclusive";
    SimpleDateFormat startDayFormat = new SimpleDateFormat("yyyy/MM/dd 00:00:00.000");
    SimpleDateFormat endDayFormat = new SimpleDateFormat("yyyy/MM/dd 23:59:59.999");
    SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private int maxElementIn = 250;
    private boolean is11602 = false;
    private boolean is1602Set = false;
    private boolean is1700Set = false;
    private boolean is1700;
    HashMap<String, Object> deliveries = null;
    Set<String> configurations = null;
    private boolean isLogTableExists = false;
    private boolean isLogTableExistsSet = false;

    public String getTimeStampQuery() {
        return this.timeStampQuery;
    }

    private String getSessionQuerySelector(SessionCriteria criteria) {
        Object dateFilter;
        Set<String> packageIds;
        String prefix1 = "SESS";
        Object sessionIdFilter = this.getSessionFilter(criteria, prefix1);
        sessionIdFilter = !((String)sessionIdFilter).isEmpty() ? " and " + (String)sessionIdFilter : "";
        Object filterName = "";
        Set<String> names = criteria.getSessionNames();
        if (names != null && !names.isEmpty()) {
            boolean caseSensitiv = criteria.isSessionNamesCaseSensitiv();
            int index = 0;
            filterName = (String)filterName + " AND (";
            for (String name : names) {
                filterName = index > 0 ? (!caseSensitiv ? (String)filterName + " OR UPPER (" + prefix1 + ".SESS_NAME ) like UPPER('" + name.replaceAll("\\*", "%") + "')" : (String)filterName + " OR " + prefix1 + ".SESS_NAME like '" + name.replaceAll("\\*", "%") + "'") : (!caseSensitiv ? (String)filterName + "UPPER ( " + prefix1 + ".SESS_NAME ) like UPPER('" + name.replaceAll("\\*", "%") + "')" : (String)filterName + prefix1 + ".SESS_NAME like '" + name.replaceAll("\\*", "%") + "'");
                ++index;
            }
            filterName = (String)filterName + ")\n";
        }
        Set<Integer> statusList = criteria.getStatusList();
        Object statusFilter = "";
        String prefix2 = "SESS2";
        if (statusList != null && statusList.size() > 0) {
            int deadIndex;
            ArrayList<Integer> _statusList = new ArrayList<Integer>(statusList);
            statusFilter = " AND (";
            int runningIndex = _statusList.indexOf(2);
            if (runningIndex > -1) {
                statusFilter = (String)statusFilter + "(";
                statusFilter = (String)statusFilter + prefix2 + ".SESS_RET_CODE is null\n";
                Integer val = (Integer)_statusList.get(runningIndex);
                _statusList.remove(val);
                if (this.is1700()) {
                    statusFilter = (String)statusFilter + "AND ";
                    statusFilter = (String)statusFilter + " (" + prefix2 + ".SESS_INACT_TIMEOUT is null or " + prefix2 + ".SESS_LAST_TSTAMP+" + prefix2 + ".SESS_TSTAMP_OFFSET+" + prefix2 + ".SESS_INACT_TIMEOUT-" + this.myConnection.getBddCurrentTimeStamp() + ">=0 )";
                }
                statusFilter = (String)statusFilter + ")";
            }
            if ((deadIndex = _statusList.indexOf(-4)) > -1 && this.is1700()) {
                if (runningIndex > -1) {
                    statusFilter = (String)statusFilter + " OR ";
                }
                statusFilter = (String)statusFilter + " (" + prefix2 + ".SESS_INACT_TIMEOUT is null or " + prefix2 + ".SESS_LAST_TSTAMP+" + prefix2 + ".SESS_TSTAMP_OFFSET+" + prefix2 + ".SESS_INACT_TIMEOUT-" + this.myConnection.getBddCurrentTimeStamp() + "<0 )";
            }
            if (_statusList.size() > 0) {
                if (runningIndex > -1 || deadIndex > -1) {
                    statusFilter = (String)statusFilter + " OR ";
                }
                if (_statusList.size() == 1) {
                    statusFilter = (String)statusFilter + prefix2 + ".SESS_RET_CODE = " + String.valueOf(_statusList.get(0));
                } else {
                    statusFilter = (String)statusFilter + prefix2 + ".SESS_RET_CODE in (";
                    int i = 0;
                    while (i < _statusList.size()) {
                        Integer status = (Integer)_statusList.get(i);
                        if (i != 0) {
                            statusFilter = (String)statusFilter + ",";
                        }
                        statusFilter = (String)statusFilter + String.valueOf(status);
                        ++i;
                    }
                    statusFilter = (String)statusFilter + ") ";
                }
            }
            statusFilter = (String)statusFilter + ")\n";
            statusFilter = "\nAND exists (select 'X' from " + this.jdbcSchema + "SESSION_SESS " + prefix2 + " where " + prefix1 + ".SESS_ID=" + prefix2 + ".SESS_ID " + (String)statusFilter + ")";
        }
        Set<String> deliveries = criteria.getDeliveryNames();
        Set<String> configurations = criteria.getConfigurations();
        Object confFilter = "";
        if (configurations != null && !configurations.isEmpty()) {
            int index = 0;
            confFilter = (String)confFilter + " AND (";
            for (String conf : configurations) {
                confFilter = index > 0 ? (String)confFilter + " OR " + prefix1 + ".SESS_CONF like '" + conf.replaceAll("\\*", "%") + "'" : (String)confFilter + prefix1 + ".SESS_CONF like '" + conf.replaceAll("\\*", "%") + "'";
                ++index;
            }
            confFilter = (String)confFilter + ")\n";
        }
        Set<String> execModes = criteria.getExecMode();
        Object execModeFilter = "";
        if (execModes != null && execModes.size() > 0) {
            int index = 0;
            execModeFilter = (String)execModeFilter + " AND " + prefix1 + ".SESS_EXECUTION_MODE in (";
            for (String execMode : execModes) {
                if (index > 0) {
                    execModeFilter = (String)execModeFilter + ", ";
                }
                execModeFilter = (String)execModeFilter + "'" + execMode + "'";
                ++index;
            }
            execModeFilter = (String)execModeFilter + ")\n";
        }
        Set<String> launchModes = criteria.getLaunchMode();
        Object launchModeFilter = "";
        if (launchModes != null && launchModes.size() > 0) {
            int index = 0;
            launchModeFilter = (String)launchModeFilter + " AND " + prefix1 + ".SESS_LAUNCH_MODE in (";
            for (String launchMode : launchModes) {
                if (index > 0) {
                    launchModeFilter = (String)launchModeFilter + ", ";
                }
                launchModeFilter = (String)launchModeFilter + "'" + launchMode + "'";
                ++index;
            }
            launchModeFilter = (String)launchModeFilter + ")\n";
        }
        Object deliveryFilter = "";
        if (deliveries != null && deliveries.size() > 0) {
            deliveryFilter = " AND exists (select 'X' from  " + this.jdbcSchema + "DELIVERY_DLV DLV where DLV.DLV_ID=" + prefix1 + ".DLV_ID";
            int index = 0;
            deliveryFilter = (String)deliveryFilter + " AND (";
            for (String name : deliveries) {
                if (index > 0) {
                    deliveryFilter = (String)deliveryFilter + " OR ";
                }
                deliveryFilter = (String)deliveryFilter + " (DLV_NAME like '%/%' and DLV_NAME like '%/" + name + ".deliv' OR DLV_NAME='" + name + ".deliv' OR DLV_NAME='" + name + "')";
                ++index;
            }
            deliveryFilter = (String)deliveryFilter + ")";
            deliveryFilter = (String)deliveryFilter + ")\n";
        }
        Set<String> deliveryIds = criteria.getDeliveryIds();
        Object deliveryIdsFilter = "";
        if (deliveryIds != null && deliveryIds.size() > 0) {
            int index = 0;
            deliveryIdsFilter = (String)deliveryIdsFilter + " AND " + prefix1 + ".DLV_ID in (";
            for (String id : deliveryIds) {
                if (index > 0) {
                    deliveryIdsFilter = (String)deliveryIdsFilter + ", ";
                }
                deliveryIdsFilter = (String)deliveryIdsFilter + "'" + id + "'";
                ++index;
            }
            deliveryIdsFilter = (String)deliveryIdsFilter + ")\n";
        }
        Set<String> processIds = criteria.getProcessIds();
        Object processIdsFilter = "";
        if (processIds != null && processIds.size() > 0) {
            int index = 0;
            processIdsFilter = (String)processIdsFilter + " AND exists (select 'X' from  " + this.jdbcSchema + "DELIVERY_DLV DLV where DLV.DLV_ID=" + prefix1 + ".DLV_ID";
            processIdsFilter = (String)processIdsFilter + " AND DLV.PROC_ID in (";
            for (String id : processIds) {
                if (index > 0) {
                    processIdsFilter = (String)processIdsFilter + ", ";
                }
                processIdsFilter = (String)processIdsFilter + "'" + id + "'";
                ++index;
            }
            processIdsFilter = (String)processIdsFilter + "))\n";
        }
        Object packageIdsFilter = " ";
        if (this.is1709() && (packageIds = criteria.getPackageIds()) != null && packageIds.size() > 0) {
            int index = 0;
            packageIdsFilter = (String)packageIdsFilter + " AND PCK_ID in (";
            for (String id : packageIds) {
                if (index > 0) {
                    packageIdsFilter = (String)packageIdsFilter + ", ";
                }
                packageIdsFilter = (String)packageIdsFilter + "'" + id + "'";
                ++index;
            }
            packageIdsFilter = (String)packageIdsFilter + ")\n";
        }
        String guestHostFilter = "";
        Set<String> guestHostList = criteria.getGuestHosts();
        if (guestHostList != null && !guestHostList.isEmpty()) {
            int index = 0;
            confFilter = (String)confFilter + " AND (";
            for (String guestHost : guestHostList) {
                confFilter = index > 0 ? (String)confFilter + " OR " + prefix1 + ".SESS_GUEST_HOST like '" + guestHost.replaceAll("\\*", "%") + "'" : (String)confFilter + prefix1 + ".SESS_GUEST_HOST like '" + guestHost.replaceAll("\\*", "%") + "'";
                ++index;
            }
            confFilter = (String)confFilter + ")\n";
        }
        Object runtimeFilter = "";
        Set<String> runtimeList = criteria.getRuntimes();
        if (runtimeList != null && runtimeList.size() > 0) {
            runtimeFilter = " AND (";
            boolean first = true;
            for (String runtime : runtimeList) {
                if (!first) {
                    runtimeFilter = (String)runtimeFilter + " OR ";
                }
                runtimeFilter = (String)runtimeFilter + "(";
                String[] split = runtime.split(":");
                if (split.length > 0) {
                    runtimeFilter = (String)runtimeFilter + prefix1 + ".SESS_ENGINE_HOST like '" + split[0].replaceAll("\\*", "%") + "'";
                }
                if (split.length > 1) {
                    runtimeFilter = (String)runtimeFilter + "AND " + prefix1 + ".SESS_ENGINE_PORT=" + split[1];
                }
                runtimeFilter = (String)runtimeFilter + ")";
                first = false;
            }
            runtimeFilter = (String)runtimeFilter + ")\n";
        }
        if (!((String)(dateFilter = this.getDateTimeFilter(prefix1, criteria))).isEmpty()) {
            dateFilter = " AND " + (String)dateFilter;
        }
        Object query = "";
        query = (String)query + " FROM " + this.jdbcSchema + "SESSION_SESS " + prefix1 + " , " + this.jdbcSchema + "DELIVERY_DLV DLV2";
        query = (String)query + " WHERE 1=1\nAND " + prefix1 + ".DLV_ID=DLV2.DLV_ID\nand " + prefix1 + ".SESS_BEGIN_DATE is not null\n" + (String)sessionIdFilter + (String)filterName + (String)dateFilter + (String)statusFilter + (String)deliveryFilter + (String)runtimeFilter + guestHostFilter + (String)confFilter + (String)launchModeFilter + (String)execModeFilter + (String)deliveryIdsFilter + (String)processIdsFilter + (String)packageIdsFilter;
        return query;
    }

    @Override
    public Map<String, IEngineSessionHeader> refreshSessionHeader(Map<String, Object> map, boolean allIteration) throws Exception {
        HashMap<String, IEngineSessionHeader> result;
        SessionCriteria criteria = new SessionCriteria(map);
        Statement st = this.myConnection.createStatement();
        ResultSet rs = null;
        try {
            boolean stopWithReal;
            this.logger.debug("Criteria: " + String.valueOf(criteria != null ? Integer.valueOf(criteria.size()) : "null"));
            Object query = "SELECT ";
            query = (String)query + "SESS_ID";
            query = (String)query + ",SESS_BEGIN_DATE";
            query = (String)query + ",SESS_END_DATE";
            query = (String)query + ",SESS_RET_CODE";
            query = (String)query + ",SESS_NAME";
            query = (String)query + ",SESS_ENGINE_HOST";
            query = (String)query + ",SESS_ENGINE_PORT";
            query = (String)query + ",SESS_GUEST_HOST";
            query = (String)query + ",SESS_LAUNCH_MODE";
            query = (String)query + ",SESS_EXECUTION_MODE";
            query = (String)query + ",SESS_CONF";
            query = (String)query + ",SESS_PARENT_ID";
            query = (String)query + ",SESS_ITER";
            query = (String)query + ",SESS.DLV_ID";
            query = (String)query + ",PROC_ID";
            if (this.is1700()) {
                query = (String)query + ",SESS_INACT_TIMEOUT";
                query = (String)query + ",SESS_LAST_TSTAMP";
                query = (String)query + ",SESS_TSTAMP_OFFSET";
                query = (String)query + ",SESS_BEGIN_TSTAMP";
                query = (String)query + ",SESS_ACT_ROOT_ID";
                query = (String)query + ",V_VERSION";
                query = (String)query + ",DLV_CONF";
                query = (String)query + ",DLV_VERSION";
                query = (String)query + ",DLV_USER";
                query = (String)query + ",DLV_COMMENT";
                query = (String)query + ",DLV_TSTAMP";
            }
            if (this.is1709()) {
                query = (String)query + ",PCK_ID";
            }
            if (this.is1755()) {
                query = (String)query + ",CHECKSUM";
            }
            query = (String)query + this.getSessionQuerySelector(criteria);
            query = (String)query + " ORDER BY SESS_BEGIN_DATE desc, SESS_ITER desc";
            int nbSessions = criteria.getNbSesions();
            this.logger.debug("refreshSessionHeader START");
            this.queryLogger.debug("refreshSessionHeader START");
            this.queryLogger.debug("\n" + (String)query);
            if (nbSessions > 0) {
                st.setFetchSize(nbSessions);
            } else {
                st.setFetchSize(1000);
            }
            long tstamp = this.myConnection.getBddCurrentTimeStamp();
            rs = st.executeQuery((String)query);
            this.queryLogger.debug("refreshSessionHeader END");
            this.logger.debug("refreshSessionHeader END");
            result = new HashMap<String, IEngineSessionHeader>();
            int nbParent = 0;
            int nbReal = 0;
            HashSet<Object> already = new HashSet<Object>();
            long time = System.currentTimeMillis();
            int nbRows = 0;
            int nbStop = 0;
            String _minDuration = criteria.getMinDuration();
            String _maxDuration = criteria.getMaxDuration();
            Long minDuration = null;
            if (_minDuration != null && !_minDuration.isEmpty()) {
                String[] split = _minDuration.split(":");
                minDuration = 0L;
                if (split.length > 0) {
                    minDuration = Long.parseLong(split[0]) * 3600L * 1000L;
                }
                if (split.length > 1) {
                    minDuration = minDuration + Long.parseLong(split[1]) * 60L * 1000L;
                }
            } else if (criteria.getMinDurationMs() != null) {
                minDuration = criteria.getMinDurationMs();
            }
            Long maxDuration = null;
            if (_maxDuration != null && !_maxDuration.isEmpty()) {
                String[] split = _maxDuration.split(":");
                maxDuration = 0L;
                if (split.length > 0) {
                    maxDuration = Long.parseLong(split[0]) * 3600L * 1000L;
                }
                if (split.length > 1) {
                    maxDuration = maxDuration + Long.parseLong(split[1]) * 60L * 1000L;
                }
            } else if (criteria.getMaxDurationMs() != null) {
                maxDuration = criteria.getMaxDurationMs();
            }
            Set<Integer> statusList = criteria.getStatusList();
            boolean bl = stopWithReal = criteria.getFilter() != null && !criteria.getFilter().isEmpty() || statusList.size() > 0 || minDuration != null || maxDuration != null;
            if (!criteria.isSessionChildStandalone() && criteria.getNbSesions() > 0) {
                stopWithReal = false;
            }
            while (rs.next() && (nbSessions == -2 || nbStop < nbSessions)) {
                ++nbRows;
                Object key = null;
                String id = rs.getString("SESS_ID");
                int iter = -1;
                if (allIteration) {
                    iter = rs.getInt("SESS_ITER");
                    key = id + "." + iter;
                } else {
                    key = id;
                }
                if (!already.contains(key)) {
                    already.add(key);
                    if (!result.containsKey(key)) {
                        boolean ok;
                        RdbmsSessionHeaderReader reader = new RdbmsSessionHeaderReader(this.name, this.isEngine ? "runtime" : "rdbms", rs, id, tstamp, this.is1700(), this.myConnection.getOffset());
                        if (iter != -1) {
                            reader.setIter(iter);
                        }
                        boolean bl2 = ok = statusList == null || statusList.size() <= 0;
                        if (!ok) {
                            int status = reader.getStatus();
                            ok = statusList.contains(status);
                        }
                        if (ok && (minDuration != null || maxDuration != null)) {
                            Date beginDate = reader.getBeginDate();
                            Date endDate = reader.getEndDate();
                            if (endDate == null) {
                                endDate = new Date();
                            }
                            Long duration = endDate.getTime() - beginDate.getTime();
                            if (minDuration != null && minDuration > duration) {
                                ok = false;
                            }
                            if (ok && maxDuration != null && maxDuration < duration) {
                                ok = false;
                            }
                        }
                        if (ok) {
                            ++nbReal;
                            IEngineSessionHeader session = this.objectReader.createSessionHeader(reader, this);
                            result.put((String)key, session);
                            String parentId = session.getParentSessionId();
                            if (parentId == null) {
                                ++nbParent;
                            }
                        }
                    }
                }
                if (stopWithReal) {
                    nbStop = nbReal;
                    continue;
                }
                if (criteria.isSessionChildStandalone()) {
                    ++nbStop;
                    continue;
                }
                nbStop = nbParent;
            }
            this.logger.debug("Session Header Result Analyzed: " + nbReal + "/" + nbRows + "/" + nbStop + "/" + nbParent + " (" + (System.currentTimeMillis() - time) + " milliseconds)");
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        return result;
    }

    private Map<String, Object> getProperties(ResultSet rs) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ResultSetMetaData resultSetMetaData = rs.getMetaData();
        int j = 1;
        while (j <= resultSetMetaData.getColumnCount()) {
            String type = resultSetMetaData.getColumnName(j);
            type = type != null ? type.toUpperCase() : type;
            Object value = null;
            try {
                value = rs.getObject(j);
                if (value != null) {
                    map.put(type, value);
                }
            }
            catch (SQLException e) {
                String string = "Error impossible to get \"" + type + "\n Cause : " + e.getMessage();
            }
            ++j;
        }
        return map;
    }

    public static void main(String[] args) {
    }

    public RdbmsLog() {
    }

    public RdbmsLog(String name, String url, String driver, String user, String password, String schemaName, String tablePrefix, String tStampQuery, String id, IClassLoader jdbcClassLoader, boolean isEngine) {
        this.isEngine = isEngine;
        this.timeStampQuery = tStampQuery;
        this.jdbcClassLoader = jdbcClassLoader;
        this.queryLogger = LogManager.getLogger((String)"RdbmsLogQuery");
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.myConnection = new MyConnection();
        this.myConnection.url = url;
        this.myConnection.driver = driver;
        this.myConnection.user = user;
        this.myConnection.password = password != null && password.isEmpty() ? null : password;
        this.myConnection.tablePrefix = tablePrefix;
        this.myConnection.timeStampQuery = this.timeStampQuery;
        this.myConnection.schemaName = schemaName;
        this.myConnection.jdbcSchema = (String)(schemaName == null || schemaName.isEmpty() ? "" : schemaName + ".") + (tablePrefix != null && !tablePrefix.isEmpty() ? tablePrefix : "STB_LOG_");
        this.jdbcSchema = this.myConnection.jdbcSchema;
        this.id = id;
        this.name = name;
    }

    public RdbmsLog(String connectionName, String schemaName, String tablePrefix, String tStampQuery, String id, IClassLoader jdbcClassLoader, boolean isEngine) {
        this.isEngine = isEngine;
        this.timeStampQuery = tStampQuery;
        this.jdbcClassLoader = jdbcClassLoader;
        this.queryLogger = LogManager.getLogger((String)(this.getClass().getName() + "Query"));
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.myConnection = new MyJndiConnection();
        ((MyJndiConnection)this.myConnection).connectionName = connectionName;
        this.myConnection.tablePrefix = tablePrefix;
        this.myConnection.timeStampQuery = this.timeStampQuery;
        this.myConnection.schemaName = schemaName;
        this.myConnection.jdbcSchema = (String)(schemaName == null || schemaName.isEmpty() ? "" : schemaName + ".") + (tablePrefix != null && !tablePrefix.isEmpty() ? tablePrefix : "STB_LOG_");
        this.jdbcSchema = this.myConnection.jdbcSchema;
        this.id = id;
        this.name = connectionName;
    }

    private String getDateTimeFilter(String prefix, SessionCriteria criteria) {
        Object query = "";
        if (criteria != null && criteria.getMinDate() != null && criteria.getMaxDate() != null) {
            Date beginDate = criteria.getMinDate();
            Date endDate = criteria.getMaxDate();
            Date now = new Date();
            boolean addRuningSession = endDate != null && endDate.after(now);
            String boundaryMode = criteria.getBoundaryMode();
            String beginDateString = beginDate != null ? this.dateTimeFormat.format(beginDate) : null;
            String endDateString = endDate != null ? this.dateTimeFormat.format(endDate) : null;
            query = (String)query + "( ";
            query = (String)query + this.createStrictDateTimeQuery(prefix, beginDateString, endDateString, addRuningSession);
            if (boundaryMode != null && boundaryMode.equals(BOUNDARY_MODE_INCLUSIVE)) {
                query = (String)query + this.addInclusivSessions(prefix, beginDateString, endDateString, addRuningSession, now, beginDate);
            }
            query = (String)query + " )";
        }
        return query;
    }

    private String addInclusivSessions(String prefix, String beginDateString, String endDateString, boolean addRuningSession, Date now, Date beginDate) {
        Object query = "";
        query = (String)query + " OR (" + prefix + "_BEGIN_DATE>='" + beginDateString + "' AND " + prefix + "_BEGIN_DATE<='" + endDateString + "')";
        query = (String)query + " OR ( " + prefix + "_END_DATE>='" + beginDateString + "' AND (" + prefix + "_END_DATE<='" + endDateString + "'";
        if (addRuningSession) {
            query = (String)query + this.createSessionRunningQuery(prefix);
        }
        query = (String)query + ")) ";
        if (now.after(beginDate)) {
            query = (String)query + " OR (" + prefix + "_BEGIN_DATE<='" + beginDateString + "' AND ( " + prefix + "_END_DATE>='" + endDateString + "'" + this.createSessionRunningQuery(prefix) + " )) ";
        }
        return query;
    }

    private String createSessionRunningQuery(String prefix) {
        return " OR ( " + prefix + "_END_DATE IS NULL AND " + prefix + "_RET_CODE IS NULL AND ( " + prefix + "_INACT_TIMEOUT IS NULL OR " + prefix + "_LAST_TSTAMP+" + prefix + "_TSTAMP_OFFSET+" + prefix + "_INACT_TIMEOUT-" + this.myConnection.getBddCurrentTimeStamp() + " >=0 ) )";
    }

    private String createStrictDateTimeQuery(String prefix, String beginDateString, String endDateString, boolean addRuningSession) {
        Object query = "";
        query = (String)query + prefix + "_BEGIN_DATE>='" + beginDateString + "'";
        query = (String)query + " AND (" + prefix + "_END_DATE <= '" + endDateString + "'";
        if (addRuningSession) {
            query = (String)query + this.createSessionRunningQuery(prefix);
        }
        query = (String)query + ")";
        return query;
    }

    private String getSessionFilter(Criteria criteria, String prefix) {
        String filter = "";
        filter = this.getIdFilter(criteria.get("sessionId"), (String)(prefix != null ? prefix + "." : "") + "SESS_ID");
        return filter;
    }

    private String getActionIdFilter(ActionCriteria criteria, String prefix) {
        String tmp = this.getIdFilter(criteria.get("actionId"), (String)(prefix != null ? prefix + "." : "") + "ACT_ID");
        String tmp2 = this.getIdFilter(criteria.get("actionFatherId"), (String)(prefix != null ? prefix + "." : "") + "ACT_FATHER_ENGINE_ID");
        if (!tmp2.isEmpty() && !tmp.isEmpty()) {
            return "(" + tmp + " or " + tmp2 + ")";
        }
        return tmp + tmp2;
    }

    private String getIdFilter(Object id, String fieldName, String propName) {
        String idFilter = "";
        if (id != null) {
            idFilter = this.getIdFilter(id, fieldName);
        }
        return idFilter;
    }

    private String getIdFilter(Object id, String fieldName) {
        Object idFilter = "";
        ArrayList<String> list = null;
        if (id instanceof Set) {
            list = new ArrayList<String>((Set)id);
        } else {
            ArrayList<String> arrayList = list = id instanceof List ? (ArrayList<String>)id : null;
        }
        if (list == null) {
            if (id instanceof String) {
                idFilter = fieldName + " ='" + String.valueOf(id) + "'";
            }
        } else if (list.size() == 1) {
            idFilter = fieldName + " ='" + (String)list.get(0) + "'";
        } else if (list.size() > 1) {
            if (list.size() > 999) {
                idFilter = (String)idFilter + RdbmsLogQueryUtils.splitQueryWithMultipleIn(this.maxElementIn, list, fieldName);
            } else {
                idFilter = fieldName + " in (";
                int i = 0;
                while (i < list.size()) {
                    String _id = (String)list.get(i);
                    idFilter = (String)idFilter + "'" + _id + "'";
                    if (i < list.size() - 1) {
                        idFilter = (String)idFilter + ",";
                    }
                    ++i;
                }
                idFilter = (String)idFilter + ")";
            }
        }
        return idFilter;
    }

    public boolean is1602() throws Exception {
        Statement st = null;
        if (!this.is1602Set) {
            try {
                try {
                    this.is1602Set = true;
                    String query = "select ACP_VALUE from  " + this.jdbcSchema + "ACTION_PROP_ACP  where 1=2";
                    st = this.myConnection.createStatement();
                    st.executeQuery(query);
                    this.is11602 = true;
                }
                catch (Exception exception) {
                    if (st != null) {
                        st.close();
                    }
                }
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
        return this.is11602;
    }

    public boolean is1700() {
        return this.is1700(this.intVersion);
    }

    public boolean is1709() {
        return this.intVersion >= 1709 && this.intVersion >= 1709;
    }

    public boolean is1755() {
        return this.intVersion >= 1755 && this.intVersion >= 1755;
    }

    private boolean is1700(int intVersion) {
        return this.intVersion >= 1700 && intVersion >= 1700;
    }

    private boolean is1700(String version) throws Exception {
        if (version == null) {
            return false;
        }
        return this.is1700(Integer.valueOf(version.replaceAll("\\.", "")));
    }

    @Override
    public Map<String, IEngineActionHeader> refreshActionHeader(Map<String, Object> map) throws Exception {
        Statement st = this.myConnection.createStatement();
        ResultSet rs = null;
        try {
            ActionCriteria criteria = new ActionCriteria(map);
            Object sessionFilter = this.getSessionFilter(criteria, null);
            sessionFilter = !((String)sessionFilter).isEmpty() ? " and " + (String)sessionFilter : sessionFilter;
            Object actionIdFilter = this.getActionIdFilter(criteria, null);
            actionIdFilter = !((String)actionIdFilter).isEmpty() ? " or " + (String)actionIdFilter : actionIdFilter;
            actionIdFilter = ((String)actionIdFilter).replaceAll("\\.[0-9]+'", "'").replaceAll("'[0-9]+\\|", "'");
            String query = "SELECT * from " + this.jdbcSchema + "ACTION_ACT";
            query = query + "\nwhere 1=1\nand ((ACT_FATHER_ENGINE_ID ='' or ACT_FATHER_ENGINE_ID is null)\n" + (String)actionIdFilter + ")" + (String)sessionFilter + " order by SESS_ITER desc, ACT_ITER desc";
            this.logger.debug("Before Query Header");
            this.queryLogger.debug("refreshActionHeader START");
            this.queryLogger.debug("\n" + query);
            st.setFetchSize(100);
            rs = st.executeQuery(query);
            this.queryLogger.debug("refreshActionHeader END");
            this.logger.debug("After Query Header");
            HashMap<String, IEngineActionHeader> result = new HashMap<String, IEngineActionHeader>();
            int nbAction = 0;
            HashSet allready = new HashSet();
            HashMap<CallSite, ArrayList<IEngineActionHeader>> iterations = new HashMap<CallSite, ArrayList<IEngineActionHeader>>();
            while (rs.next()) {
                ++nbAction;
                IEngineActionHeader action = this.objectReader.createActionHeader(new RdbmsActionHeaderReader(rs), this.myConnection.getOffset());
                String uid = action.getSessionIter() + "|" + action.getId() + "." + action.getIter();
                result.put(uid, action);
                ArrayList<IEngineActionHeader> list = (ArrayList<IEngineActionHeader>)iterations.get(action.getSessionIter() + "|" + action.getId());
                if (list == null) {
                    list = new ArrayList<IEngineActionHeader>();
                    iterations.put((CallSite)((Object)(action.getSessionIter() + "|" + action.getId())), list);
                }
                list.add(action);
            }
            for (IEngineActionHeader header : result.values()) {
                String parentId = header.getParentId();
                IEngineActionHeader retainParent = null;
                List list = (List)iterations.get(header.getSessionIter() + "|" + parentId);
                if (list != null) {
                    for (IEngineActionHeader parent : list) {
                        if (header.getStrBeginDate() == null || parent.getStrBeginDate() == null || parent.getStrBeginDate().compareTo(header.getStrBeginDate()) > 0) continue;
                        if (header.getStrEndDate() == null) {
                            if (parent.getStrEndDate() != null) continue;
                            retainParent = parent;
                            break;
                        }
                        if (parent.getStrEndDate() != null && parent.getStrEndDate().compareTo(header.getStrEndDate()) < 0) continue;
                        if (retainParent == null) {
                            retainParent = parent;
                            continue;
                        }
                        if (parent.getStrBeginDate().compareTo(retainParent.getStrBeginDate()) <= 0) continue;
                        retainParent = parent;
                    }
                }
                if (retainParent == null) continue;
                this.objectReader.updateActionHeader(header, retainParent.getIter());
            }
            this.logger.debug("NbActions: " + nbAction);
            HashMap<String, IEngineActionHeader> hashMap = result;
            return hashMap;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
    }

    @Override
    public Map<String, Map<String, Object>> refreshSessionVariable(Map<String, Integer> sessions, Map<String, Object> map) throws Exception {
        HashMap<String, Map<String, Object>> variables;
        SessionCriteria criteria = new SessionCriteria(map);
        Statement st = this.myConnection.createStatement();
        ResultSet rs = null;
        try {
            variables = new HashMap<String, Map<String, Object>>();
            Object sessionFilter = this.getSessionFilter(criteria, null);
            Object object = sessionFilter = !((String)sessionFilter).isEmpty() ? " and P1." + (String)sessionFilter : "";
            if (sessions.size() > 0) {
                String tmp = this.is1602() ? ",P1.ACP_VALUE" : "";
                String query = "SELECT\tP1.SESS_ID,P1.ACP_NAME,P1.SESS_ITER,P1.ACT_ITER,P1.ACP_SHORT_NAME,P1.ACP_TYPE,  P1.ACP_EXE_CLO, P1.ACP_EXE_BLO,P1.ACP_EXE_FORMAT,P1.ACP_SRC_VAR,P1.ACP_SRC_CLO,P1.ACP_SRC_BLO, P1.ACP_CUMUL,P1.ACP_EXE_VAR,P1.ACP_SRC_FORMAT" + tmp + "\n\t\tFROM " + this.jdbcSchema + "ACTION_PROP_ACP P1\n\t\t, " + this.jdbcSchema + "ACTION_ACT ACT\nWHERE 1=1\nAnd (P1.ACP_SHORT_NAME= P1.ACP_NAME)\nand ACT.SESS_ID=P1.SESS_ID\nand ACT.SESS_ITER=P1.SESS_ITER\nand ACT.ACT_ITER=P1.ACT_ITER\nand ACT.ACT_ID=P1.ACT_ID\nand (ACT.ACT_FATHER_ENGINE_ID='' or ACT.ACT_FATHER_ENGINE_ID is null) \n" + (String)sessionFilter + "ORDER BY 1, 3 desc, 4 desc";
                this.logger.debug("Variable Before Query");
                this.queryLogger.debug("refreshSessionVariable START");
                this.queryLogger.debug("\n" + query);
                this.connect();
                int fetchSize = 1000;
                st.setFetchSize(fetchSize);
                this.queryLogger.debug("fetch size: " + fetchSize);
                rs = st.executeQuery(query);
                this.queryLogger.debug("refreshSessionVariable END");
                this.logger.debug("Variable Query Executed");
                int nb = 0;
                long time = System.currentTimeMillis();
                int nbRows = 0;
                while (rs.next()) {
                    ++nbRows;
                    RdbmsEngineVariableReader reader = new RdbmsEngineVariableReader(rs, this.is1602());
                    String id = reader.getSessionId();
                    int iter = reader.getSessionIter();
                    if (sessions.get(id) != iter) continue;
                    HashMap vars = (HashMap)variables.get(id);
                    if (vars == null) {
                        vars = new HashMap();
                        variables.put(id, vars);
                    }
                    ++nb;
                    Object var = this.objectReader.createVariable(reader, false);
                    vars.put(reader.getName(), var);
                }
                long delta = System.currentTimeMillis() - time;
                this.logger.debug("Variable Result Analyzed: " + nb + "/" + nbRows + " (" + delta + " milliseconds)");
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        return variables;
    }

    @Override
    public Map<String, Map<Integer, Map<String, Long>>> refreshSessionStatistics2(Map<String, Object> map, Set<String> statisticsName) throws Exception {
        SessionCriteria criteria = new SessionCriteria(map);
        Object sessionFilter = this.getSessionFilter(criteria, null);
        sessionFilter = !((String)sessionFilter).isEmpty() ? " and " + (String)sessionFilter : "";
        HashMap<String, Map<Integer, Map<String, Long>>> statistics = new HashMap<String, Map<Integer, Map<String, Long>>>();
        if (this.is1700()) {
            Statement st = this.myConnection.createStatement();
            ResultSet rs = null;
            try {
                if (statisticsName.size() > 0) {
                    Object sqlStatsVariablesInPart = "";
                    Iterator<String> it = statisticsName.iterator();
                    while (it.hasNext()) {
                        sqlStatsVariablesInPart = (String)sqlStatsVariablesInPart + "'" + it.next() + "'";
                        if (!it.hasNext()) continue;
                        sqlStatsVariablesInPart = (String)sqlStatsVariablesInPart + ",";
                    }
                    String valueSumExp = "SUM(P1.ACP_CUMUL)";
                    String sessionQuerySelector = this.getSessionQuerySelector(criteria);
                    String queryBefore1700 = "Select P1.SESS_ID,P1.SESS_ITER, P1.ACP_SHORT_NAME, " + valueSumExp + " SUM_VALUE,COUNT(P1.SESS_ID) COUNT_VALUE  \nFROM " + this.jdbcSchema + "ACTION_PROP_ACP P1\nWHERE 1=1 ";
                    Object sessionIdFilter = this.getSessionFilter(criteria, "P1");
                    Object object = sessionIdFilter = !((String)sessionIdFilter).isEmpty() ? " and " + (String)sessionIdFilter : "";
                    queryBefore1700 = !((String)sessionIdFilter).isEmpty() ? queryBefore1700 + "\n" + (String)sessionIdFilter : queryBefore1700 + "and exists (select 'X' " + sessionQuerySelector + " AND SESS.SESS_ID=P1.SESS_ID " + (this.is1700() ? " AND SESS.V_VERSION<'1.7.0.0')" : ")");
                    queryBefore1700 = queryBefore1700 + "\n And P1.ACP_SHORT_NAME in (" + (String)sqlStatsVariablesInPart + ") \nGroup by P1.SESS_ID,P1.SESS_ITER, P1.ACP_SHORT_NAME\n";
                    String queryAfter1700 = "select SESS_ID,SESS_ITER,ACP_SHORT_NAME,SST_STAT_SUM  SUM_VALUE,SST_STAT_COUNT  COUNT_VALUE \nFROM " + this.jdbcSchema + "SESSION_STAT_SST SST\nWHERE 1=1 ";
                    sessionIdFilter = this.getSessionFilter(criteria, "SST");
                    sessionIdFilter = !((String)sessionIdFilter).isEmpty() ? " and " + (String)sessionIdFilter : "";
                    queryAfter1700 = !((String)sessionIdFilter).isEmpty() ? queryAfter1700 + "\n" + (String)sessionIdFilter : queryAfter1700 + "and exists (select 'X' " + sessionQuerySelector + " AND SESS.SESS_ID=SST.SESS_ID AND SESS.V_VERSION>='1.7.0.0')";
                    String query2 = !this.is1700() ? queryBefore1700 : queryAfter1700 + "\nORDER BY 1 ,2, 3 desc";
                    this.logger.debug("Statistic Before Query");
                    this.queryLogger.debug("refreshSessionStatistics START");
                    this.queryLogger.debug("\n" + query2);
                    int fetchSize = 1000;
                    st.setFetchSize(fetchSize);
                    this.queryLogger.debug("fetch size: " + fetchSize);
                    rs = st.executeQuery(query2);
                    this.queryLogger.debug("refreshSessionStatistics END");
                    this.logger.debug("Statistic Session Query Executed");
                    int nb = 0;
                    long time = System.currentTimeMillis();
                    while (rs.next()) {
                        HashMap<String, Long> statsIter;
                        RdbmsStatisticReader reader = new RdbmsStatisticReader(rs, true);
                        String id = reader.getSessionId();
                        int iter = reader.getSessionIter();
                        HashMap<Integer, HashMap<String, Long>> statsId = (HashMap<Integer, HashMap<String, Long>>)statistics.get(id);
                        if (statsId == null) {
                            statsId = new HashMap<Integer, HashMap<String, Long>>();
                            statistics.put(id, statsId);
                        }
                        if ((statsIter = (HashMap<String, Long>)statsId.get(iter)) == null) {
                            statsIter = new HashMap<String, Long>();
                            statsId.put(iter, statsIter);
                        }
                        ++nb;
                        statsIter.put(reader.getName(), reader.getSumValue());
                    }
                    this.logger.debug("Statistic Session Result Analyzed: " + nb + " (" + (System.currentTimeMillis() - time) + " milliseconds)");
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                st.close();
            }
        }
        return statistics;
    }

    @Override
    public Map<String, Map<String, Object>> refreshSessionStatistics(Map<String, Integer> sessions, Map<String, Object> map, Set<String> statisticsName) throws Exception {
        SessionCriteria criteria = new SessionCriteria(map);
        Object sessionFilter = this.getSessionFilter(criteria, null);
        sessionFilter = !((String)sessionFilter).isEmpty() ? " and " + (String)sessionFilter : "";
        HashMap<String, Map<String, Object>> statistics = new HashMap<String, Map<String, Object>>();
        Statement st = this.myConnection.createStatement();
        ResultSet rs = null;
        try {
            if (sessions.size() > 0 && statisticsName.size() > 0) {
                statistics = new HashMap();
                Object sqlStatsVariablesInPart = "";
                Iterator<String> it = statisticsName.iterator();
                while (it.hasNext()) {
                    sqlStatsVariablesInPart = (String)sqlStatsVariablesInPart + "'" + it.next() + "'";
                    if (!it.hasNext()) continue;
                    sqlStatsVariablesInPart = (String)sqlStatsVariablesInPart + ",";
                }
                String valueSumExp = "SUM(P1.ACP_CUMUL)";
                String query2 = "Select P1.SESS_ID,P1.SESS_ITER, P1.ACP_SHORT_NAME, " + valueSumExp + " SUM_VALUE,COUNT(P1.SESS_ID) COUNT_VALUE  \nFROM " + this.jdbcSchema + "ACTION_PROP_ACP P1\nWHERE 1=1 " + (String)sessionFilter + "\n And P1.ACP_SHORT_NAME in (" + (String)sqlStatsVariablesInPart + ") \nGroup by P1.SESS_ID,P1.SESS_ITER, P1.ACP_SHORT_NAME ORDER BY 1 ,2, 3 desc";
                this.logger.debug("Statistic Before Query");
                this.queryLogger.debug("refreshSessionStatistics START");
                this.queryLogger.debug("\n" + query2);
                int fetchSize = 1000;
                st.setFetchSize(fetchSize);
                this.queryLogger.debug("fetch size: " + fetchSize);
                rs = st.executeQuery(query2);
                this.queryLogger.debug("refreshSessionStatistics END");
                this.logger.debug("Statistic Session Query Executed");
                int nb = 0;
                long time = System.currentTimeMillis();
                while (rs.next()) {
                    RdbmsStatisticReader reader = new RdbmsStatisticReader(rs, true);
                    String id = reader.getSessionId();
                    int iter = reader.getSessionIter();
                    if (sessions.get(id) != iter) continue;
                    HashMap<String, Object> stats = (HashMap<String, Object>)statistics.get(id);
                    if (stats == null) {
                        stats = new HashMap<String, Object>();
                        statistics.put(id, stats);
                    }
                    Object stat = this.objectReader.createStatistic(reader);
                    ++nb;
                    stats.put(reader.getName(), stat);
                }
                this.logger.debug("Statistic Session Result Analyzed: " + nb + " (" + (System.currentTimeMillis() - time) + " milliseconds)");
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        return statistics;
    }

    @Override
    public Map<String, Map<String, Map<String, Object>>> refreshSessionErrorAndWarning(Map<String, Integer> sessions, Map<String, Object> _map) throws Exception {
        HashMap<String, Map<String, Map<String, Object>>> result;
        SessionCriteria criteria = new SessionCriteria(_map);
        Statement st = this.myConnection.createStatement();
        ResultSet rs = null;
        try {
            Object sessionFilter = this.getSessionFilter(criteria, null);
            sessionFilter = !((String)sessionFilter).isEmpty() ? " and " + (String)sessionFilter : "";
            HashMap errors = new HashMap();
            HashMap warnings = new HashMap();
            result = new HashMap<String, Map<String, Map<String, Object>>>();
            result.put("errors", errors);
            result.put("warnings", warnings);
            if (sessions.size() > 0) {
                RdbmsErrorReader reader;
                String tmp = this.is1602() ? ",P1.ACP_VALUE" : "";
                String query = "SELECT \tP1.SESS_ID,P1.ACP_NAME,P1.SESS_ITER,P1.ACT_ITER,P1.ACP_SHORT_NAME,P1.ACP_TYPE, P1.ACP_EXE_VAR,P1.ACT_ID, P1.ACP_EXE_CLO, P1.ACP_EXE_BLO,P1.ACP_EXE_FORMAT,P1.ACP_SRC_VAR,P1.ACP_SRC_CLO,P1.ACP_SRC_BLO,P1.ACP_SRC_FORMAT, P1.ACP_CUMUL" + tmp + "\nFROM " + this.jdbcSchema + "ACTION_PROP_ACP P1\nWHERE 1=1\nAND ( ACP_SHORT_NAME in ('CORE_STACK_TRACE','CORE_RET_MESS','CORE_ACTION_TECHNOLOGY' )\nor (ACP_SHORT_NAME ='CORE_TOLERATED_ERROR' and ACP_EXE_VAR='true'))\nAND exists (select 'X' from " + this.jdbcSchema + "ACTION_PROP_ACP P2 where P1.SESS_ID=P2.SESS_ID and P1.SESS_ITER=P2.SESS_ITER and P1.ACT_ID=P2.ACT_ID and P1.ACT_ITER=P2.ACT_ITER and ACP_SHORT_NAME='CORE_RET_MESS')\n" + (String)sessionFilter + "\nORDER BY 1, 3 desc, 4 desc";
                this.logger.debug("Error Before Query");
                this.queryLogger.debug("refreshSessionErrorAndWarning START");
                this.connect();
                int fetchSize = 1000;
                st.setFetchSize(fetchSize);
                this.queryLogger.debug("fetch size: " + fetchSize);
                this.queryLogger.debug(query);
                rs = st.executeQuery(query);
                this.queryLogger.debug("refreshSessionErrorAndWarning END");
                this.logger.debug("Error Query Executed");
                int nb = 0;
                HashMap map = new HashMap();
                long time = System.currentTimeMillis();
                int nbRows = 0;
                String precSessId = "";
                while (rs.next()) {
                    int actIter;
                    String actId;
                    RdbmsErrorReader error;
                    HashMap<CallSite, RdbmsErrorReader> warns;
                    ++nbRows;
                    String id = rs.getString("SESS_ID");
                    int iter = rs.getInt("SESS_ITER");
                    if (sessions.get(id) != iter) continue;
                    HashMap<Object, Object> errs = (HashMap<Object, Object>)errors.get(id);
                    if (errs == null) {
                        errs = new HashMap<Object, Object>();
                        errors.put(id, errs);
                    }
                    if ((warns = (HashMap<CallSite, RdbmsErrorReader>)warnings.get(id)) == null) {
                        warns = new HashMap<CallSite, RdbmsErrorReader>();
                        warnings.put(id, warns);
                    }
                    if ((error = (RdbmsErrorReader)errs.get((actId = rs.getString("ACT_ID")) + (actIter = rs.getInt("ACT_ITER")))) == null) {
                        error = (RdbmsErrorReader)warns.get(actId + actIter);
                    }
                    if (error == null) {
                        ++nb;
                        error = new RdbmsErrorReader();
                        error.actionId = actId;
                        error.sessIter = iter;
                        error.iter = actIter;
                        String path = rs.getString("ACP_NAME");
                        if (path.contains("/")) {
                            path = path.substring(0, path.lastIndexOf(47));
                        }
                        error.path = path;
                        errs.put(actId + actIter, error);
                    } else if (iter < error.getSessIter()) break;
                    String name = rs.getString("ACP_SHORT_NAME");
                    String value = null;
                    if (this.is1602()) {
                        value = rs.getString("ACP_VALUE");
                    }
                    if (value == null) {
                        value = Format.getString((ResultSet)rs, (String)"ACP_EXE_");
                    }
                    if (name.equals("CORE_STACK_TRACE")) {
                        error.stackTrace = value;
                        continue;
                    }
                    if (name.equals("CORE_RET_MESS")) {
                        error.message = value;
                        continue;
                    }
                    if (name.equals("CORE_TOLERATED_ERROR")) {
                        errs.remove(actId + actIter);
                        warns.put((CallSite)((Object)(actId + actIter)), error);
                        if (value != null && value.equals("true")) {
                            error.isTolerated = true;
                            continue;
                        }
                        error.isTolerated = false;
                        continue;
                    }
                    if (!name.equals("CORE_ACTION_TECHNOLOGY")) continue;
                    error.technology = value;
                }
                long delta = System.currentTimeMillis() - time;
                this.logger.debug("Error and warning Result Analyzed: " + nb + "/" + nbRows + " (" + delta + " milliseconds)");
                rs.close();
                for (HashMap<Object, Object> errs : errors.values()) {
                    for (String name : errs.keySet()) {
                        reader = (RdbmsErrorReader)errs.get(name);
                        errs.put(name, this.objectReader.createError(reader));
                    }
                }
                for (Map warns : warnings.values()) {
                    for (String name : warns.keySet()) {
                        reader = (RdbmsErrorReader)warns.get(name);
                        warns.put(name, this.objectReader.createWarning(reader));
                    }
                }
                this.logger.debug("Error Result Analyzed: " + nb);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        return result;
    }

    private String getSessionFilter(Set<String> sessions, Map<String, Object> criteria) {
        int nbSessions;
        int n = nbSessions = criteria != null && criteria.get("nbSessions") != null ? (Integer)criteria.get("nbSessions") : -1;
        if (nbSessions == -1) {
            nbSessions = 20;
        }
        ArrayList<String> allIds = new ArrayList<String>();
        allIds.addAll(sessions);
        Object sessionFilter = "";
        if (nbSessions != -2) {
            sessionFilter = " AND ";
            sessionFilter = (String)sessionFilter + "P1." + this.getIdFilter(allIds, "SESS_ID");
        }
        return sessionFilter;
    }

    @Override
    public Map<String, Map<String, Object>> refreshStaticActionVariable(String deliveryId) throws Exception {
        if (this.is1700()) {
            Statement st = this.myConnection.createStatement();
            ResultSet rs = null;
            try {
                HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
                String selectVarStatic = "SELECT 'STAT' TPY,P1.ACP_SHORT_NAME, '/' ACP_NAME, null ACP_TYPE,          ACT_ID, null ACP_EXE_VAR, null ACP_EXE_CLO, null ACP_EXE_BLO, null ACP_EXE_FORMAT, P1.ASP_SRC_VAR ACP_SRC_VAR,P1.ASP_SRC_CLO ACP_SRC_CLO,P1.ASP_SRC_BLO ACP_SRC_BLO,P1.ASP_SRC_FORMAT ACP_SRC_FORMAT, null ACP_CUMUL, null ACP_NUM";
                String queryVariable = selectVarStatic + " \nFROM " + this.jdbcSchema + "ACTION_SPROP_ASP P1\nWHERE 1=1 AND DLV_ID='" + deliveryId + "'";
                this.logger.debug("refreshStaticActionVariable Before Query");
                this.queryLogger.debug("refreshStaticActionVariable START");
                this.queryLogger.debug("\n" + queryVariable);
                rs = st.executeQuery(queryVariable);
                st.setFetchSize(1000);
                this.queryLogger.debug("refreshStaticActionVariable END");
                this.logger.debug("refreshStaticActionVariable Query Executed");
                int nb = 0;
                int nbReal = 0;
                long time = System.currentTimeMillis();
                while (rs.next()) {
                    ++nbReal;
                    RdbmsEngineVariableReader reader = new RdbmsEngineVariableReader(rs, this.is1602());
                    String id = reader.getActionId();
                    String uid = id;
                    HashMap vars = (HashMap)variables.get(uid);
                    if (vars == null) {
                        vars = new HashMap();
                        variables.put(uid, vars);
                    }
                    if (!reader.getName().contains("/")) continue;
                    Object var = this.objectReader.createVariable(reader, true);
                    vars.put(reader.getShortName(), var);
                    ++nb;
                }
                this.logger.debug("Static Variable Result Analyzed: " + nb + "/" + nbReal + " (" + (System.currentTimeMillis() - time) + " milliseconds)");
                HashMap<String, Map<String, Object>> hashMap = variables;
                return hashMap;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                st.close();
            }
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public Map<String, Map<String, Object>> refreshActionVariable(Set<String> actions, String sessionId, int sessionIter, String deliveryId, String intVersion, ActionList list) throws Exception {
        Statement st = this.myConnection.createStatement();
        ResultSet rs = null;
        try {
            HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("actionId", actions);
            map.put("sessionId", sessionId);
            ActionCriteria criteria = new ActionCriteria(map);
            Object actionFilter = this.getActionIdFilter(criteria, "P1");
            actionFilter = !((String)actionFilter).isEmpty() ? " AND " + (String)actionFilter : "";
            actionFilter = ((String)actionFilter).replaceAll("\\.[0-9]+'", "'").replaceAll("'[0-9]+\\|", "'");
            String sessionFilter = this.getSessionFilter(criteria, null);
            Object tmp = this.is1602() ? ",P1.ACP_VALUE" : ",null ACP_VALUE";
            tmp = (String)tmp + (this.is1700(intVersion) ? ",P1.PTY_TYPE_N" : "");
            Object selectVarDynamic = "SELECT  P1.ACP_SHORT_NAME, P1.SESS_ITER, P1.ACT_ITER,  P1.ACP_NAME,   P1.ACP_TYPE,  P1.ACT_ID, P1.ACP_EXE_VAR, \t P1.ACP_EXE_CLO,   P1.ACP_EXE_BLO,   P1.ACP_EXE_FORMAT, P1.ACP_SRC_VAR,P1.ACP_SRC_CLO,P1.ACP_SRC_BLO,P1.ACP_SRC_FORMAT,   P1.ACP_CUMUL";
            selectVarDynamic = this.is1700(intVersion) ? (String)selectVarDynamic + ",P1.ACP_NUM" : (String)selectVarDynamic + ",null ACP_NUM";
            selectVarDynamic = (String)selectVarDynamic + (String)tmp;
            String queryVariable = (String)selectVarDynamic + " \nFROM " + this.jdbcSchema + "ACTION_PROP_ACP P1\nWHERE 1=1  AND " + sessionFilter;
            queryVariable = this.is1700(intVersion) ? queryVariable + " AND P1.ACP_NUM>" + list.getLastMaxNum() : queryVariable + (String)actionFilter;
            queryVariable = queryVariable + "\nORDER BY 2 desc, 3 desc";
            this.logger.debug("refreshActionVariable Before Query");
            this.queryLogger.debug("refreshActionVariable START");
            this.queryLogger.debug("\n" + queryVariable);
            rs = st.executeQuery(queryVariable);
            int fetchSize = actions.size() * 5;
            fetchSize = fetchSize > 1000 ? 1000 : fetchSize;
            st.setFetchSize(fetchSize);
            this.queryLogger.debug("refreshActionVariable END");
            this.logger.debug("refreshActionVariable Query Executed");
            int nb = 0;
            int nbReal = 0;
            long time = System.currentTimeMillis();
            int maxNum = list.getLastMaxNum();
            list.setMaxLogNum(0);
            while (rs.next()) {
                ++nbReal;
                RdbmsEngineVariableReader reader = new RdbmsEngineVariableReader(rs, this.is1602());
                int num = reader.getNum();
                if (maxNum < num) {
                    maxNum = num;
                }
                String id = reader.getActionId();
                int iter = reader.getActionIter();
                String uid = reader.getSessionIter() + "|" + id + "." + iter;
                if (!actions.contains(uid)) continue;
                HashMap vars = (HashMap)variables.get(uid);
                if (vars == null) {
                    vars = new HashMap();
                    variables.put(uid, vars);
                }
                if (!reader.getName().contains("/")) continue;
                Object var = this.objectReader.createVariable(reader, false);
                vars.put(reader.getShortName(), var);
                ++nb;
            }
            list.setLastMaxNum(maxNum);
            this.logger.debug("Variable Result Analyzed: " + nb + "/" + nbReal + " (" + (System.currentTimeMillis() - time) + " milliseconds)");
            HashMap<String, Map<String, Object>> hashMap = variables;
            return hashMap;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
    }

    @Override
    public String getLogId() {
        return this.id;
    }

    @Override
    public Map<String, Map<String, Long>> refreshActionStatistic(Map<String, IEngineActionHeader> actions, String sessionId, int sessionIter, Set<String> statisticsName, String version) throws Exception {
        Statement st = this.myConnection.createStatement();
        ResultSet rs = null;
        try {
            HashMap<String, Map<String, Long>> statistics = new HashMap<String, Map<String, Long>>();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sessionId", sessionId);
            ActionCriteria criteria = new ActionCriteria(map);
            String sessionFilter = this.getSessionFilter(criteria, "P1");
            if (statisticsName.size() > 0) {
                Object sqlStatsVariablesInPart = "";
                Iterator<String> it = statisticsName.iterator();
                while (it.hasNext()) {
                    sqlStatsVariablesInPart = (String)sqlStatsVariablesInPart + "'" + it.next() + "'";
                    if (!it.hasNext()) continue;
                    sqlStatsVariablesInPart = (String)sqlStatsVariablesInPart + ",";
                }
                Object query = "";
                query = version != null && version.compareTo("1.7.0.0") >= 0 ? "Select P1.SESS_ID,P1.SESS_ITER,P1.ACT_ITER,P1.ACT_ID, P1.ACP_SHORT_NAME,P1.AST_STAT_SUM ACP_CUMUL\nFROM\n" + this.jdbcSchema + "ACTION_STAT_AST P1\nWHERE 1=1  AND " + sessionFilter : "Select P1.SESS_ID,P1.SESS_ITER,P1.ACT_ITER,P1.ACT_ID, P1.ACP_SHORT_NAME,P1.ACP_CUMUL\nFROM\n" + this.jdbcSchema + "ACTION_PROP_ACP P1\nWHERE 1=1  AND " + sessionFilter + " And P1.ACP_SHORT_NAME in (" + (String)sqlStatsVariablesInPart + ") ";
                this.logger.debug("refreshActionStatistic Before Query");
                this.queryLogger.debug("refreshActionStatistic START");
                this.queryLogger.debug("\n" + (String)query);
                rs = st.executeQuery((String)query);
                this.queryLogger.debug("refreshActionStatistic END");
                this.logger.debug("refreshActionStatistic Query Executed");
                int nb = 0;
                long time = System.currentTimeMillis();
                while (rs.next()) {
                    RdbmsStatisticReader reader = new RdbmsStatisticReader(rs, false);
                    String id = reader.getActionId();
                    int iter = reader.getActionIter();
                    String uid = id + "." + iter;
                    HashMap<String, Long> stats = (HashMap<String, Long>)statistics.get(reader.getActionUUID());
                    if (stats == null) {
                        stats = new HashMap<String, Long>();
                        statistics.put(reader.getActionUUID(), stats);
                    }
                    ++nb;
                    stats.put(reader.getName(), reader.getValue());
                }
                long delta = System.currentTimeMillis() - time;
                this.logger.debug("Statistic Action Result Analyzed: " + nb + " (" + delta + " milliseconds)");
            }
            HashMap<String, Map<String, Long>> hashMap = statistics;
            return hashMap;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
    }

    @Override
    public EngineSessionManager.ObjectReader getObjectReader() {
        return this.objectReader;
    }

    @Override
    public void setObjectReader(EngineSessionManager.ObjectReader objectReader) {
        this.objectReader = objectReader;
    }

    @Override
    public void clear() throws SQLException {
        this.myConnection.clear();
        this.myConnection = null;
        this.engineUrl = null;
        this.id = null;
        this.jdbcSchema = null;
        this.logger = null;
        this.objectReader = null;
    }

    @Override
    public Map<String, Object> refreshRuntimes() throws Exception {
        Statement st = this.myConnection.createStatement();
        ResultSet rs = null;
        try {
            this.logger.debug("refreshRuntimes Query Executed");
            HashMap<String, Object> runtimes = new HashMap<String, Object>();
            Object query = "select distinct SESS_ENGINE_HOST, SESS_ENGINE_PORT";
            query = (String)query + "\nFROM " + this.jdbcSchema + "SESSION_SESS SESS";
            this.logger.debug("refreshRuntimes Before Query");
            this.queryLogger.debug("refreshRuntimes START");
            this.queryLogger.debug("\n" + (String)query);
            rs = st.executeQuery((String)query);
            this.queryLogger.debug("refreshRuntimes END");
            this.logger.debug("refreshRuntimes After Query");
            int nb = 0;
            long time = System.currentTimeMillis();
            while (rs.next()) {
                ++nb;
                RdbmsRuntimeReader reader = new RdbmsRuntimeReader(rs, this.is1602());
                Object runtime = this.objectReader.createRuntime(reader);
                runtimes.put(reader.getName(), runtime);
            }
            this.logger.debug("refreshRuntimes Result Analyzed: " + nb + " (" + (System.currentTimeMillis() - time) + " milliseconds)");
            HashMap<String, Object> hashMap = runtimes;
            return hashMap;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
    }

    @Override
    public void refreshDeliveriesAndConfigurations() throws Exception {
        this.deliveries = new HashMap();
        this.configurations = new HashSet<String>();
        Statement st = this.myConnection.createStatement();
        ResultSet rs = null;
        try {
            Object query = "select  DLV_ID, DLV_NAME, PROC_ID,DLV_CONF";
            query = (String)query + "\nFROM " + this.jdbcSchema + "DELIVERY_DLV SESS /*where DLV_NAME IS NOT NULL*/";
            this.logger.debug("refreshDeliveriesAndConfigurations Before Query");
            this.queryLogger.debug("refreshDeliveriesAndConfigurations START");
            this.queryLogger.debug("\n" + (String)query);
            rs = st.executeQuery((String)query);
            this.queryLogger.debug("refreshDeliveriesAndConfigurations END");
            this.logger.debug("refreshDeliveriesAndConfigurations After Query");
            long time = System.currentTimeMillis();
            int nb = 0;
            int nbRealConf = 0;
            int nbRealDeliv = 0;
            while (rs.next()) {
                ++nb;
                RdbmsDeliveryReader reader = new RdbmsDeliveryReader(rs, this.is1602());
                String conf = reader.getConf();
                String name = reader.getName();
                if (name != null) {
                    ++nbRealDeliv;
                    Object delivery = this.objectReader.createDelivery(reader);
                    this.deliveries.put(reader.getName(), delivery);
                }
                if (conf == null) continue;
                ++nbRealDeliv;
                this.configurations.add(conf);
            }
            this.logger.debug("refreshDeliveriesAndConfigurations Result Analyzed: " + nb + "/conf:" + nbRealConf + "/deliv:" + nbRealDeliv + " (" + (System.currentTimeMillis() - time) + " milliseconds)");
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
    }

    @Override
    public Map<String, Object> getDeliveries() {
        return this.deliveries;
    }

    @Override
    public Set<String> getConfigurations() {
        return this.configurations;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public static boolean test(String url, String driver, String user, String password, String schemaName, String tablePrefix, String id, IClassLoader jdbcClassLoader) throws Exception {
        RdbmsLog rlog = null;
        try {
            rlog = new RdbmsLog("", url, driver, user, password, schemaName, tablePrefix, null, id, jdbcClassLoader, false);
            boolean bl = rlog.connect();
            return bl;
        }
        finally {
            if (rlog != null) {
                rlog.clear();
            }
        }
    }

    public static boolean test(String connectionName, String schemaName, String tablePrefix, String id, IClassLoader jdbcClassLoader) throws Exception {
        RdbmsLog rlog = null;
        try {
            rlog = new RdbmsLog(connectionName, schemaName, tablePrefix, null, id, jdbcClassLoader, false);
            boolean bl = rlog.connect();
            return bl;
        }
        finally {
            if (rlog != null) {
                rlog.clear();
            }
        }
    }

    @Override
    public boolean connect() throws Exception {
        return this.connect(true);
    }

    @Override
    public boolean connect(boolean notifyUI) throws Exception {
        try {
            boolean b = this.myConnection.connect();
            this.connectionException = null;
            if (notifyUI) {
                this.notifyAllListener();
            }
            return b;
        }
        catch (Exception e) {
            this.connectionException = e;
            if (notifyUI) {
                this.notifyAllListener();
            }
            throw e;
        }
    }

    public String getDriver() {
        return this.myConnection.driver;
    }

    public String getUrl() {
        return this.myConnection.url;
    }

    public String getUser() {
        return this.myConnection.user;
    }

    public String getPassword() {
        return this.myConnection.password;
    }

    public String getPrefix() {
        return this.myConnection.tablePrefix;
    }

    public String getSchemaName() {
        return this.myConnection.schemaName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Exception getConnectionException() {
        return this.connectionException;
    }

    @Override
    public Boolean isConnected() {
        if (this.myConnection != null && this.myConnection.isConnected()) {
            return true;
        }
        return false;
    }

    private String getActionQuerySelector(ActionCriteria criteria, int intVersion) throws Exception {
        String query = "\nfrom " + this.jdbcSchema + "ACTION_ACT ACT";
        if (this.is1700(intVersion)) {
            query = query + ", " + this.jdbcSchema + "ACTION_S_ACT SACT";
            query = query + ", " + this.jdbcSchema + "SESSION_SESS SESS";
        }
        String maxBeginActionDate = criteria.getMaxBeginDateTime();
        String maxEndActionDate = criteria.getMaxEndDateTime();
        String sessionFilter = " AND SESS.SESS_ID='" + criteria.getSessionId() + "'\n";
        Object actionFilter = "(";
        actionFilter = maxBeginActionDate != null ? (String)actionFilter + "ACT.ACT_BEGIN_DATE<='" + maxBeginActionDate + "' " : (String)actionFilter + "ACT.ACT_BEGIN_DATE is not null ";
        actionFilter = (String)actionFilter + " OR ACT.ACT_END_DATE is null";
        if (maxEndActionDate != null) {
            actionFilter = (String)actionFilter + " OR ACT.ACT_END_DATE>='" + maxEndActionDate + "'";
        }
        actionFilter = (String)actionFilter + ")\n";
        query = query + "\nwhere 1=1\nand \n" + (String)actionFilter + sessionFilter;
        if (criteria.getSessionIter() != null) {
            query = query + " AND SESS.SESS_ITER = " + String.valueOf(criteria.getSessionIter()) + " ";
        }
        if (this.is1700(intVersion)) {
            query = query + "AND ACT.ACT_ID=SACT.ACT_ID ";
            query = query + "AND SESS.SESS_ITER = ACT.SESS_ITER ";
            query = query + "AND SESS.SESS_ID=ACT.SESS_ID ";
            query = query + "AND SESS.DLV_ID=SACT.DLV_ID ";
            query = query + "AND ACT.ACT_ID=SACT.ACT_ID ";
        }
        return query;
    }

    @Override
    public Map<String, IEngineActionHeader> refreshActionHeader2(String sessionId, String maxBeginActionDate, String maxEndActionDate, String version, Integer iter) throws Exception {
        Statement st = this.myConnection.createStatement();
        ResultSet rs = null;
        try {
            Object query = "SELECT ";
            int i = 0;
            int intVersion = version == null ? 0 : Integer.valueOf(version.replaceAll("\\.", ""));
            RdbmsActionHeaderReader.ActionField[] actionFieldArray = RdbmsActionHeaderReader.ActionField.values();
            int n = actionFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                RdbmsActionHeaderReader.ActionField field = actionFieldArray[n2];
                if (field.version <= intVersion) {
                    if (i > 0) {
                        query = (String)query + ", ";
                    }
                    query = (String)query + field.getQueryExpression() + "\n";
                    ++i;
                }
                ++n2;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sessionId", sessionId);
            map.put("maxBeginDateTime", maxBeginActionDate);
            map.put("maxEndDateTime", maxEndActionDate);
            map.put("sessionIter", iter);
            query = (String)query + this.getActionQuerySelector(new ActionCriteria(map), intVersion);
            this.logger.debug("Before Query Header");
            this.queryLogger.debug("refreshActionHeader START");
            this.queryLogger.debug("\n" + (String)query);
            st.setFetchSize(100);
            rs = st.executeQuery((String)query);
            this.queryLogger.debug("refreshActionHeader END");
            this.logger.debug("After Query Header");
            HashMap<String, IEngineActionHeader> result = new HashMap<String, IEngineActionHeader>();
            int nbAction = 0;
            HashMap<CallSite, ArrayList<IEngineActionHeader>> iterations = new HashMap<CallSite, ArrayList<IEngineActionHeader>>();
            while (rs.next()) {
                ++nbAction;
                RdbmsActionHeaderReader reader = new RdbmsActionHeaderReader(rs);
                reader.setVersion(intVersion);
                IEngineActionHeader action = this.objectReader.createActionHeader(reader, this.myConnection.getOffset());
                if (this.is1700(version)) {
                    action.setParentIter(reader.getParentIter());
                }
                String uid = action.getSessionIter() + "|" + action.getId() + "." + action.getIter();
                result.put(uid, action);
                ArrayList<IEngineActionHeader> list = (ArrayList<IEngineActionHeader>)iterations.get(action.getSessionIter() + "|" + action.getId());
                if (list == null) {
                    list = new ArrayList<IEngineActionHeader>();
                    iterations.put((CallSite)((Object)(action.getSessionIter() + "|" + action.getId())), list);
                }
                list.add(action);
            }
            if (!this.is1700(version)) {
                for (IEngineActionHeader header : result.values()) {
                    String parentId = header.getParentId();
                    IEngineActionHeader retainParent = null;
                    List list = (List)iterations.get(header.getSessionIter() + "|" + parentId);
                    if (list != null) {
                        for (IEngineActionHeader parent : list) {
                            if (header.getStrBeginDate() == null || parent.getStrBeginDate() == null || parent.getStrBeginDate().compareTo(header.getStrBeginDate()) > 0) continue;
                            if (header.getStrEndDate() == null) {
                                if (parent.getStrEndDate() != null) continue;
                                retainParent = parent;
                                break;
                            }
                            if (parent.getStrEndDate() != null && parent.getStrEndDate().compareTo(header.getStrEndDate()) < 0) continue;
                            if (retainParent == null) {
                                retainParent = parent;
                                continue;
                            }
                            if (parent.getStrBeginDate().compareTo(retainParent.getStrBeginDate()) <= 0) continue;
                            retainParent = parent;
                        }
                    }
                    if (retainParent == null) continue;
                    this.objectReader.updateActionHeader(header, retainParent.getIter());
                }
            }
            this.logger.debug("NbActions: " + nbAction);
            HashMap<String, IEngineActionHeader> hashMap = result;
            return hashMap;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
    }

    @Override
    public Map<Integer, IEngineLogHeader> refreshLogHeader(String sessionId, int lastNum) throws Exception {
        Statement st = this.myConnection.createStatement();
        ResultSet rs = null;
        try {
            if (!this.isLogTableExistsSet) {
                block12: {
                    Statement st2 = this.myConnection.createStatement();
                    try {
                        try {
                            st2.execute("SELECT 1 FROM " + this.jdbcSchema + "USER_ACTION_LOG_UAL");
                            this.isLogTableExists = true;
                        }
                        catch (Exception e) {
                            this.isLogTableExists = false;
                            st2.close();
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        st2.close();
                        throw throwable;
                    }
                    st2.close();
                }
                this.isLogTableExistsSet = true;
            }
            if (this.isLogTableExists) {
                String filter = " SESS_ID='" + sessionId + "'\n";
                filter = filter + " AND UAL_NUM>" + lastNum;
                String query = "SELECT * from " + this.jdbcSchema + "USER_ACTION_LOG_UAL";
                query = query + "\nwhere " + filter;
                this.logger.debug("refreshLogHeader START");
                this.queryLogger.debug("refreshLogHeader START");
                this.queryLogger.debug("\n" + query);
                st.setFetchSize(100);
                rs = st.executeQuery(query);
                this.queryLogger.debug("refreshLogHeader END");
                this.logger.debug("refreshLogHeader Header");
                HashMap<Integer, IEngineLogHeader> result = new HashMap<Integer, IEngineLogHeader>();
                int nbLog = 0;
                HashSet allready = new HashSet();
                while (rs.next()) {
                    ++nbLog;
                    IEngineLogHeader log = this.objectReader.createLogHeader(new RdbmsLogHeaderReader(rs));
                    Integer uid = log.getNum();
                    result.put(uid, log);
                }
                this.logger.debug("NbLogs: " + nbLog);
                HashMap<Integer, IEngineLogHeader> hashMap = result;
                return hashMap;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        return null;
    }

    @Override
    public Map<String, Map<String, String>> refreshAltIds(String deliveryId) throws Exception {
        if (this.is1700()) {
            Statement st = this.myConnection.createStatement();
            ResultSet rs = null;
            try {
                HashMap<String, Map<String, String>> variables = new HashMap<String, Map<String, String>>();
                Object queryVariable = "SELECT ACT_ID, AAI_ORIGIN, AAI_ID";
                queryVariable = (String)queryVariable + "\nFROM " + this.jdbcSchema + "ACTION_ALTID_AAI\nWHERE 1=1 AND DLV_ID='" + deliveryId + "'";
                this.logger.debug("refreshAltIds Before Query");
                this.queryLogger.debug("refreshAltIds START");
                this.queryLogger.debug("\n" + (String)queryVariable);
                rs = st.executeQuery((String)queryVariable);
                st.setFetchSize(1000);
                this.queryLogger.debug("refreshAltIds END");
                this.logger.debug("refreshAltIds Query Executed");
                int nb = 0;
                long time = System.currentTimeMillis();
                while (rs.next()) {
                    RdbmsAltIdReader reader = new RdbmsAltIdReader(rs);
                    String id = reader.getActionId();
                    HashMap<String, String> altids = (HashMap<String, String>)variables.get(id);
                    if (altids == null) {
                        altids = new HashMap<String, String>();
                        variables.put(id, altids);
                    }
                    altids.put(reader.getOrigin(), reader.getAltId());
                    ++nb;
                }
                this.logger.debug("Alt Ids Result Analyzed: " + nb + " (" + (System.currentTimeMillis() - time) + " milliseconds)");
                HashMap<String, Map<String, String>> hashMap = variables;
                return hashMap;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                st.close();
            }
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public Set<String> getSessionExecutedByAction(String sessionId, String actionId) throws Exception {
        HashSet<String> ids = new HashSet<String>();
        Statement st = this.myConnection.createStatement();
        ResultSet rs = null;
        try {
            Object query = "select CSES_ID ";
            query = (String)query + "\nFROM " + this.jdbcSchema + "SESSION_CHILDS_CSES where SESS_ID != CSES_ID AND ACT_ID = '" + actionId + "' and SESS_ID = '" + sessionId + "'";
            rs = st.executeQuery((String)query);
            while (rs.next()) {
                ids.add(rs.getString("CSES_ID"));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        return ids;
    }

    @Override
    public List<IEngineSessionHeader> getSessionChildSession(String sessionId) throws Exception {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<IEngineSessionHeader> sessionsHeader = new ArrayList<IEngineSessionHeader>();
        Statement st = this.myConnection.createStatement();
        ResultSet rs = null;
        try {
            Object query = "select SESS_ID ";
            query = (String)query + "\nFROM " + this.jdbcSchema + "SESSION_SESS where SESS_PARENT_ID = '" + sessionId + "'";
            rs = st.executeQuery((String)query);
            while (rs.next()) {
                ids.add(rs.getString("SESS_ID"));
            }
            if (!ids.isEmpty()) {
                HashMap<String, Object> criteria = new HashMap<String, Object>();
                criteria.put("sessionId", ids);
                sessionsHeader.addAll(this.refreshSessionHeader(criteria, false).values());
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        return sessionsHeader;
    }

    class MultiConnection {
        Connection[] conn;

        MultiConnection() {
        }
    }

    class MyConnection {
        public String timeStampQuery;
        public String schemaName;
        public String tablePrefix;
        String driver;
        String url;
        String user;
        String password;
        Connection connection;
        Statement statement;
        protected String jdbcSchema = "LOGS";
        String idLog;
        protected long offset;

        MyConnection() {
        }

        public long getOffset() {
            return this.offset;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean connect() throws Exception {
            Object tmp;
            Object query;
            if (this.connection != null && !this.connection.isClosed()) return true;
            RdbmsLog.this.logger.info("connect to:" + this.url);
            RdbmsLog.this.logger.info("driver:" + this.driver);
            RdbmsLog.this.logger.info("user:" + this.user);
            this.connection = null;
            if (RdbmsLog.this.jdbcClassLoader != null) {
                Class clazz = RdbmsLog.this.jdbcClassLoader.loadClass(this.driver);
                Driver o = (Driver)clazz.newInstance();
                DriverManager.registerDriver(new DriverShim(o));
                this.connection = DriverManager.getConnection(this.url, this.user, this.password);
            }
            this.statement = this.connection.createStatement();
            this.statement.setFetchSize(100);
            Statement st = null;
            ResultSet rs = null;
            try {
                query = "select V_VERSION from  " + this.jdbcSchema + "VERSION_V  ";
                st = RdbmsLog.this.myConnection.createStatement();
                rs = st.executeQuery((String)query);
                if (rs.next()) {
                    tmp = rs.getString(1);
                    if (tmp != null) {
                        RdbmsLog.this.intVersion = Integer.valueOf(((String)tmp).replaceAll("\\.", ""));
                    }
                    RdbmsLog.this.version = tmp;
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            st = null;
            rs = null;
            if (this.timeStampQuery != null && !this.timeStampQuery.isEmpty()) {
                try {
                    try {
                        query = this.timeStampQuery;
                        st = RdbmsLog.this.myConnection.createStatement();
                        rs = st.executeQuery((String)query);
                        if (!rs.next()) return true;
                        tmp = rs.getTimestamp(1);
                        if (tmp != null) {
                            this.offset = ((Timestamp)tmp).getTime() - System.currentTimeMillis();
                            return true;
                        }
                        this.offset = 0L;
                        return true;
                    }
                    catch (Exception e) {
                        this.offset = 0L;
                        RdbmsLog.this.logger.warn("unexpected", (Throwable)e);
                        if (rs != null) {
                            rs.close();
                        }
                        if (st == null) return true;
                        st.close();
                    }
                    return true;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                }
            } else {
                this.offset = 0L;
            }
            return true;
        }

        public long getBddCurrentTimeStamp() {
            return System.currentTimeMillis() + this.offset;
        }

        public boolean isConnected() {
            try {
                return this.connection != null && !this.connection.isClosed();
            }
            catch (SQLException e) {
                return false;
            }
        }

        public Statement createStatement() throws SQLException {
            return this.connection.createStatement();
        }

        public void close() throws SQLException {
            this.connection.close();
        }

        public void clear() {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception e) {
                    RdbmsLog.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception e) {
                    RdbmsLog.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.driver = null;
            this.password = null;
            this.user = null;
            this.password = null;
        }
    }

    class MyJndiConnection
    extends MyConnection {
        public String connectionName;
        Connection connection;
        Statement statement;
        String idLog;

        MyJndiConnection() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean connect() throws Exception {
            Object tmp;
            Object query;
            if (this.connection != null && !this.connection.isClosed()) return true;
            this.connection = null;
            try {
                InitialContext initialContext = new InitialContext();
                DataSource datasource = (DataSource)initialContext.lookup(this.connectionName);
                if (datasource == null) {
                    throw new Exception("Failed to lookup datasource.");
                }
                this.connection = datasource.getConnection();
            }
            catch (NamingException ex) {
                throw new Exception("Cannot get connection: " + String.valueOf(ex));
            }
            catch (SQLException ex) {
                throw new Exception("Cannot get connection: " + String.valueOf(ex));
            }
            this.statement = this.connection.createStatement();
            this.statement.setFetchSize(100);
            Statement st = null;
            ResultSet rs = null;
            try {
                query = "select V_VERSION from  " + this.jdbcSchema + "VERSION_V  ";
                st = RdbmsLog.this.myConnection.createStatement();
                rs = st.executeQuery((String)query);
                if (rs.next()) {
                    tmp = rs.getString(1);
                    if (tmp != null) {
                        RdbmsLog.this.intVersion = Integer.valueOf(((String)tmp).replaceAll("\\.", ""));
                    }
                    RdbmsLog.this.version = tmp;
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            st = null;
            rs = null;
            if (this.timeStampQuery != null && !this.timeStampQuery.isEmpty()) {
                try {
                    try {
                        query = this.timeStampQuery;
                        st = RdbmsLog.this.myConnection.createStatement();
                        rs = st.executeQuery((String)query);
                        if (!rs.next()) return true;
                        tmp = rs.getTimestamp(1);
                        if (tmp != null) {
                            this.offset = ((Timestamp)tmp).getTime() - System.currentTimeMillis();
                            return true;
                        }
                        this.offset = 0L;
                        return true;
                    }
                    catch (Exception e) {
                        this.offset = 0L;
                        RdbmsLog.this.logger.warn("unexpected", (Throwable)e);
                        if (rs != null) {
                            rs.close();
                        }
                        if (st == null) return true;
                        st.close();
                    }
                    return true;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                }
            } else {
                this.offset = 0L;
            }
            return true;
        }

        @Override
        public long getBddCurrentTimeStamp() {
            return System.currentTimeMillis() + this.offset;
        }

        @Override
        public boolean isConnected() {
            try {
                return this.connection != null && !this.connection.isClosed();
            }
            catch (SQLException e) {
                return false;
            }
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.connection.createStatement();
        }

        @Override
        public void close() throws SQLException {
            this.connection.close();
        }

        @Override
        public void clear() {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception e) {
                    RdbmsLog.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception e) {
                    RdbmsLog.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.driver = null;
            this.password = null;
            this.user = null;
            this.password = null;
        }
    }
}

