/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools;

import java.lang.reflect.Constructor;
import java.text.MessageFormat;

public class ImplementationLoader {
    public static Object newInstance(Class type) {
        return ImplementationLoader.newInstance(type.getClassLoader(), type.getName() + "Impl");
    }

    public static Object newInstance(ClassLoader loader, String name) {
        Object result = null;
        try {
            result = loader.loadClass(name).newInstance();
        }
        catch (Throwable throwable) {
            String txt = "Could not load implementation for {0} ";
            String msg = MessageFormat.format(txt, name);
            throw new RuntimeException(msg, throwable);
        }
        return result;
    }

    public static Object newInstance(ClassLoader loader, String name, Object ... params) {
        Object result = null;
        try {
            Class<?> clazz = loader.loadClass(name);
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                if (constructor.getParameterTypes().length == params.length) {
                    result = constructor.newInstance(params);
                    break;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            String txt = "Could not load implementation for {0} ";
            String msg = MessageFormat.format(txt, name);
            throw new RuntimeException(msg, throwable);
        }
        return result;
    }
}

