/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools.binding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BindingRadioButtons {
    private EStructuralFeature feature;
    private EObject eObject;
    private DataBindingContext ctx = new DataBindingContext();
    private Binding binding;
    private Composite buttonsComposite;
    private FormToolkit toolkit;
    private SelectObservableValue select;
    private EditingDomain domain;
    private List<Button> buttons;

    public BindingRadioButtons(Composite parent, FormToolkit toolkit, EStructuralFeature features, EditingDomain domain) {
        this.feature = features;
        this.domain = domain;
        this.buttonsComposite = parent;
        this.toolkit = toolkit;
        this.buttons = new ArrayList<Button>();
        this.select = new SelectObservableValue((Object)EMFEditProperties.value((EditingDomain)domain, (EStructuralFeature)features));
        this.select.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                for (Button button : BindingRadioButtons.this.buttons) {
                    if (!button.getData().equals(event.diff.getNewValue())) continue;
                    button.notifyListeners(13, null);
                }
            }
        });
    }

    public Button addRadioButton(String text, Enumerator data) {
        Button btn = this.toolkit.createButton(this.buttonsComposite, text, 16);
        btn.setData((Object)data);
        this.buttons.add(btn);
        this.select.addOption((Object)data, (IObservableValue)WidgetProperties.buttonSelection().observe((Widget)btn));
        return btn;
    }

    public Button addRadioButton(String text, Enumerator data, boolean enable) {
        Button btn = this.toolkit.createButton(this.buttonsComposite, text, 16);
        btn.setData((Object)data);
        btn.setEnabled(enable);
        this.buttons.add(btn);
        this.select.addOption((Object)data, (IObservableValue)WidgetProperties.buttonSelection().observe((Widget)btn));
        return btn;
    }

    public Button addCheckButton(String text, Object data) {
        Button btn = this.toolkit.createButton(this.buttonsComposite, text, 32);
        btn.setData(data);
        this.buttons.add(btn);
        this.select.addOption(data, (IObservableValue)WidgetProperties.buttonSelection().observe((Widget)btn));
        return btn;
    }

    public void dispose() {
        if (this.binding != null && !this.binding.isDisposed()) {
            this.binding.dispose();
        }
    }

    public void setEObject(EObject eObject) {
        if (eObject != this.eObject) {
            this.eObject = eObject;
            if (this.binding != null) {
                this.binding.dispose();
            }
            if (eObject != null) {
                this.binding = this.ctx.bindValue((IObservableValue)this.select, EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)this.feature).observe((Object)eObject), null, null);
            }
        }
    }
}

