/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools.binding;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;

public abstract class BindingValue {
    protected EStructuralFeature features;
    protected EObject eObject;
    protected EditingDomain domain;
    protected DataBindingContext ctx;
    private Binding binding;
    private IObservableValue target;
    private IObservableValue model;
    private UpdateValueStrategy targetStrategy;
    private UpdateValueStrategy modelStrategy;

    public BindingValue(DataBindingContext ctx, EStructuralFeature features, EditingDomain domain, EObject eObject) {
        this.features = features;
        this.domain = domain;
        this.eObject = eObject;
        this.ctx = ctx;
        this.targetStrategy = new EMFUpdateValueStrategy();
        this.modelStrategy = new EMFUpdateValueStrategy();
    }

    public BindingValue(DataBindingContext ctx, EStructuralFeature features, EditingDomain domain, EObject eObject, EMFUpdateValueStrategy targetStrategy, EMFUpdateValueStrategy modelStrategy) {
        this(ctx, features, domain, eObject);
        this.targetStrategy = targetStrategy;
        this.modelStrategy = modelStrategy;
    }

    public UpdateValueStrategy getTargetStrategy() {
        return this.targetStrategy;
    }

    public UpdateValueStrategy getModelStrategy() {
        return this.modelStrategy;
    }

    protected void setTarget(IObservableValue target) {
        this.target = target;
    }

    protected void setModel(IObservableValue model) {
        this.model = model;
    }

    protected void setTargetConverter(IConverter converter) {
        this.targetStrategy.setConverter(converter);
    }

    protected void setModelConverter(IConverter converter) {
        this.modelStrategy.setConverter(converter);
    }

    public void setTargetValidator(IValidator validator) {
        this.targetStrategy.setAfterGetValidator(validator);
    }

    public void setModelValidator(IValidator validator) {
        this.modelStrategy.setAfterGetValidator(validator);
    }

    protected abstract void updateModel();

    public void dispose() {
        if (this.binding != null && !this.binding.isDisposed()) {
            this.binding.dispose();
            this.target.setValue(null);
        }
    }

    public void bind(EObject eObject) {
        if (eObject != null) {
            this.eObject = eObject;
            if (this.binding != null) {
                this.binding.dispose();
            }
            if (eObject != null) {
                this.updateModel();
                this.binding = this.ctx.bindValue(this.target, this.model, this.targetStrategy, this.modelStrategy);
            }
        }
    }
}

