/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools.pages;

import com.indy.ui.tools.activity.ActivityManager;
import com.stambia.ui.tools.OnClickMouseListener;
import com.stambia.ui.tools.pages.IPageController;
import com.stambia.ui.tools.table.TableFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class Page
extends FormPage {
    protected EObject root;
    protected TableViewer tv;
    protected EditingDomain editingDomain;
    private ComposedAdapterFactory adapterFactory;
    private EObject selectedElement;
    protected AdapterFactoryItemDelegator afid;
    protected ScrolledForm form;
    protected FormToolkit toolkit;
    protected ILabelProvider labelProvider;
    protected Composite client;
    private Table objectsTable;
    private boolean createActionEnable;
    private boolean deleteActionEnable;
    protected EMFDataBindingContext ctx;
    protected Text searchText;
    private TableFilter tableFilter;
    protected IPageController controller;
    protected IStructuredContentProvider cp;
    private boolean showButtonComposite = true;
    private Map<Long, EObject> errorObjects = new HashMap<Long, EObject>();

    public Page(FormEditor editor, EObject root, EditingDomain domain, IPageController controller, ComposedAdapterFactory adapterFactory, boolean createActionEnable, boolean deleteActionEnable, String id, boolean showButtonComposite) {
        this(editor, root, domain, controller, adapterFactory, createActionEnable, deleteActionEnable, id);
        this.showButtonComposite = showButtonComposite;
    }

    public Page(FormEditor editor, EObject root, EditingDomain domain, IPageController controller, ComposedAdapterFactory adapterFactory, boolean createActionEnable, boolean deleteActionEnable, String id) {
        super(editor, id, "");
        this.root = root;
        this.editingDomain = domain;
        this.adapterFactory = adapterFactory;
        this.afid = new AdapterFactoryItemDelegator((AdapterFactory)adapterFactory);
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        this.afid.getText((Object)root);
        this.createActionEnable = createActionEnable;
        this.deleteActionEnable = deleteActionEnable;
        this.ctx = new EMFDataBindingContext();
        this.tableFilter = new TableFilter(){

            @Override
            public boolean match(Object element, String searchString) {
                return Page.this.filterMatch(element, searchString);
            }
        };
        this.controller = controller;
    }

    protected void addFilter(ViewerFilter filter) {
        this.tv.addFilter(filter);
    }

    public DataBindingContext getContext() {
        return this.ctx;
    }

    public abstract boolean filterMatch(Object var1, String var2);

    protected void createFormContent(IManagedForm managedForm, String formTitle, String title, String desc) {
        this.form = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)new GridLayout());
        Composite notScrolledComposite = managedForm.getToolkit().createComposite(body);
        GridData gdata = GridDataFactory.fillDefaults().grab(true, true).hint(body.getClientArea().width, body.getClientArea().height).create();
        notScrolledComposite.setLayoutData((Object)gdata);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(notScrolledComposite);
        this.createTableSection(notScrolledComposite, this.toolkit);
        this.createEditionComposite(notScrolledComposite);
    }

    protected void setElement(EObject elt) {
        this.selectedElement = elt;
        this.selectionChanged(elt);
    }

    public abstract void selectionChanged(EObject var1);

    protected void setLabelProvider() {
        ObservableMapLabelProvider observableLabelProvider = new ObservableMapLabelProvider(this.getMasterListProperty().observeDetail(((ObservableListContentProvider)this.cp).getKnownElements())){

            public String getColumnText(Object element, int columnIndex) {
                return Page.this.labelProvider.getText(element);
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return Page.this.labelProvider.getImage(element);
            }
        };
        this.tv.setLabelProvider((IBaseLabelProvider)observableLabelProvider);
    }

    protected void createSearchSection(Composite parent) {
        this.searchText = new Text(parent, 2176);
        GridDataFactory.fillDefaults().applyTo((Control)this.searchText);
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Page.this.tableFilter.setSearchText(Page.this.searchText.getText());
                Page.this.tv.refresh();
            }
        });
    }

    private void createTableSection(Composite parent, FormToolkit toolkit) {
        Composite filterTableComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)filterTableComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(filterTableComposite);
        this.createSearchSection(filterTableComposite);
        Composite tableComposite = toolkit.createComposite(filterTableComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(tableComposite);
        this.objectsTable = toolkit.createTable(tableComposite, this.getTableStyle());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.objectsTable);
        this.tv = new TableViewer(this.objectsTable);
        this.setContentProvider();
        this.setLabelProvider();
        this.setInput();
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)Page.this.tv.getSelection();
                Object o = selection.getFirstElement();
                if (o instanceof EObject) {
                    ActivityManager.setEnableComposite(Page.this.client, true);
                    Page.this.setElement((EObject)o);
                } else {
                    ActivityManager.setEnableComposite(Page.this.client, false);
                    Page.this.setElement(null);
                }
            }
        });
        this.tv.addFilter((ViewerFilter)this.tableFilter);
        if (this.showButtonComposite) {
            Composite buttonContainer = new Composite(tableComposite, 0);
            GridLayout buttonContaineLayout = new GridLayout(1, true);
            buttonContainer.setLayout((Layout)buttonContaineLayout);
            buttonContainer.setLayoutData((Object)new GridData(3));
            Button addButton = ActivityManager.createButton(toolkit, buttonContainer, 8, "Add", this.createActionEnable);
            addButton.addMouseListener((MouseListener)new OnClickMouseListener(){

                public void mouseUp(MouseEvent e) {
                    EObject Item = Page.this.controller.addMasterListElement();
                    Page.this.setNewItemSelected(Item);
                }
            });
            Button deleteButton = ActivityManager.createButton(toolkit, buttonContainer, 8, "Remove", this.deleteActionEnable);
            deleteButton.addMouseListener((MouseListener)new OnClickMouseListener(){

                public void mouseUp(MouseEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)Page.this.tv.getSelection();
                    Page.this.removeElement(selection.toList());
                }
            });
            deleteButton.setLayoutData((Object)new GridData(4, 4, true, true));
            addButton.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        this.tv.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    IStructuredSelection selection = (IStructuredSelection)Page.this.tv.getSelection();
                    Page.this.removeElement(selection.toList());
                }
            }
        });
        this.setComparator();
    }

    protected void setComparator() {
        this.tv.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return Page.this.compareForTableSorting(e1, e2);
            }
        });
    }

    protected int getTableStyle() {
        return 2;
    }

    protected void setContentProvider() {
        this.cp = new ObservableListContentProvider();
        this.tv.setContentProvider((IContentProvider)this.cp);
    }

    protected void setInput() {
        this.tv.setInput((Object)EMFEditProperties.list((EditingDomain)this.editingDomain, (EStructuralFeature)this.getMasterListFeature()).observe((Object)this.root));
    }

    public Set<String> getSiblingsNames() {
        HashSet<String> existingNames = new HashSet<String>();
        Object[] objectArray = ((ObservableListContentProvider)this.tv.getContentProvider()).getKnownElements().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            existingNames.add(this.getItemName(obj));
            ++n2;
        }
        return existingNames;
    }

    public abstract EStructuralFeature getMasterListFeature();

    public abstract IEMFEditValueProperty getMasterListProperty();

    public abstract int compareForTableSorting(Object var1, Object var2);

    private void createEditionComposite(Composite parent) {
        this.client = this.toolkit.createComposite(parent, 64);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(20, 10).numColumns(2).applyTo(this.client);
        GridDataFactory.fillDefaults().indent(20, 30).grab(true, true).applyTo((Control)this.client);
        this.client.setEnabled(false);
    }

    public EObject getSelectedElement() {
        return this.selectedElement;
    }

    public void setNewItemSelected(EObject newItem) {
        this.objectsTable.deselectAll();
        this.objectsTable.select(this.objectsTable.getItemCount() - 1);
        this.objectsTable.showSelection();
        this.setElement(newItem);
        this.selectedElement = newItem;
        ActivityManager.setEnableComposite(this.client, true);
        this.client.setFocus();
    }

    public boolean isOnError() {
        return !this.errorObjects.isEmpty();
    }

    public abstract void cleanClient();

    public abstract String getItemName(Object var1);

    public abstract Long getItemId(Object var1);

    public void removeElement(List<EObject> elts) {
        this.editingDomain.getCommandStack().execute(DeleteCommand.create((EditingDomain)this.editingDomain, elts));
        for (EObject eObject : elts) {
            Long id = this.getItemId(this.selectedElement);
            this.errorObjects.remove(id);
        }
        if (((ObservableListContentProvider)this.tv.getContentProvider()).getKnownElements().toArray().length > 0) {
            this.tv.setSelection((ISelection)new StructuredSelection(((ObservableListContentProvider)this.tv.getContentProvider()).getKnownElements().toArray()[0]));
        } else {
            this.tv.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public class NameRequiredValidator
    implements IValidator {
        private final ControlDecoration controlDecoration;

        public NameRequiredValidator(ControlDecoration controlDecoration) {
            this.controlDecoration = controlDecoration;
        }

        public IStatus validate(Object value) {
            String text;
            Long id = Page.this.getItemId(Page.this.selectedElement);
            if (Page.this.selectedElement.eContainer() == null) {
                this.controlDecoration.hide();
                Page.this.errorObjects.remove(id);
                return Status.OK_STATUS;
            }
            if (value instanceof String && ((text = (String)value) == null || text.isEmpty())) {
                this.controlDecoration.setDescriptionText("Enter a name");
                this.controlDecoration.show();
                Page.this.errorObjects.put(id, Page.this.selectedElement);
                return ValidationStatus.error((String)"Enter a name");
            }
            Page.this.errorObjects.remove(id);
            this.controlDecoration.hide();
            return Status.OK_STATUS;
        }
    }

    protected class NumberRequiredValidator
    implements IValidator {
        private final String errorText;
        private final ControlDecoration controlDecoration;

        public NumberRequiredValidator(String errorText, ControlDecoration controlDecoration) {
            this.errorText = errorText;
            this.controlDecoration = controlDecoration;
            controlDecoration.hide();
        }

        public IStatus validate(Object value) {
            if (Page.this.selectedElement.eContainer() == null) {
                this.controlDecoration.hide();
                return Status.OK_STATUS;
            }
            if (value instanceof String) {
                try {
                    Integer.parseInt((String)value);
                }
                catch (Exception e) {
                    this.controlDecoration.show();
                    Long id = Page.this.getItemId(Page.this.selectedElement);
                    Page.this.errorObjects.put(id, Page.this.selectedElement);
                    return ValidationStatus.error((String)this.errorText);
                }
            }
            this.controlDecoration.hide();
            Long id = Page.this.getItemId(Page.this.selectedElement);
            Page.this.errorObjects.remove(id);
            return Status.OK_STATUS;
        }
    }
}

