/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.tools;

import com.stambia.jdbc.driver.file.fileManagment.StambiaBufferedReaderI;
import com.stambia.jdbc.driver.file.tools.Pointer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DelimitedLineParser {
    String delimiter = null;
    String escapeChar = null;
    boolean delimiterIsSet = false;
    StambiaBufferedReaderI.SeparatorComparator delimiterComparator;
    private StambiaBufferedReaderI.SeparatorComparator separatorComparator;
    Iterator<Field> it = null;
    String separator = "";
    List<Field> fields = null;
    String str = "";
    boolean inDelimiterBlock = false;
    boolean hasDelimiterOpen = false;
    boolean searchNextSeparator = false;
    int lastStringDelimiterPosition = -1;
    public boolean newParserMode = false;
    StringBuilder strBuf = new StringBuilder();

    public DelimitedLineParser(String separator, String delimiter, String escapeChar) {
        this.delimiter = delimiter;
        if (delimiter != null && !delimiter.isEmpty()) {
            this.delimiterIsSet = true;
            this.delimiterComparator = new StambiaBufferedReaderI.SeparatorComparator(delimiter.toCharArray());
        }
        this.separator = separator;
        if (escapeChar != null && !escapeChar.isEmpty()) {
            this.escapeChar = escapeChar;
        }
        this.separatorComparator = new StambiaBufferedReaderI.SeparatorComparator(separator.toCharArray());
    }

    public Field next() {
        if (this.it == null) {
            this.it = this.fields.iterator();
        }
        return this.it.next();
    }

    public boolean hasNext() {
        if (this.it == null) {
            this.it = this.fields.iterator();
        }
        return this.it.hasNext();
    }

    private Field addField() {
        Field field = new Field(this.str);
        this.fields.add(field);
        this.str = "";
        this.inDelimiterBlock = false;
        this.hasDelimiterOpen = false;
        this.lastStringDelimiterPosition = -1;
        this.searchNextSeparator = false;
        return field;
    }

    public void parse(String line) {
        this.parse(new Pointer<String>(line));
    }

    public void parse(Pointer<String> line) {
        if (this.newParserMode) {
            this.parse2(line);
        } else {
            this.parse0(line);
        }
    }

    public void parse0(Pointer<String> line) {
        this.str = "";
        this.inDelimiterBlock = false;
        this.hasDelimiterOpen = false;
        this.searchNextSeparator = false;
        boolean skipNextChar = false;
        this.it = null;
        this.fields = new ArrayList<Field>();
        int i = 0;
        while (i < ((String)line.value).length()) {
            char c = ((String)line.value).charAt(i);
            this.str = String.valueOf(this.str) + c;
            if (!this.delimiterIsSet && this.escapeChar != null && !this.escapeChar.isEmpty() && !skipNextChar && this.str.endsWith(this.escapeChar)) {
                skipNextChar = true;
                this.str = this.str.substring(0, this.str.length() - this.escapeChar.length());
            } else {
                if (!this.searchNextSeparator) {
                    if (this.inDelimiterBlock) {
                        if (this.hasDelimiterOpen) {
                            if (!skipNextChar && this.str.endsWith(this.delimiter)) {
                                this.hasDelimiterOpen = false;
                                this.str = this.str.substring(0, this.str.length() - this.delimiter.length());
                            } else if (!skipNextChar && this.str.endsWith(this.separator)) {
                                this.str = this.str.substring(0, this.str.length() - this.separator.length() - this.delimiter.length());
                                this.addField();
                            } else if (i == ((String)line.value).length() - 1) {
                                if (this.lastStringDelimiterPosition > -1) {
                                    this.str = this.str.substring(0, this.lastStringDelimiterPosition);
                                }
                                Field field = this.addField();
                            } else {
                                this.str = this.str.substring(0, this.str.length() - this.delimiter.length() - 1);
                                this.addField();
                                this.searchNextSeparator = true;
                            }
                        } else {
                            if (!skipNextChar && this.str.endsWith(this.delimiter)) {
                                this.lastStringDelimiterPosition = this.str.length() - this.delimiter.length();
                                this.hasDelimiterOpen = true;
                            }
                            if (i == ((String)line.value).length() - 1) {
                                if (this.hasDelimiterOpen) {
                                    this.str = this.str.substring(0, this.lastStringDelimiterPosition);
                                    this.addField();
                                } else {
                                    Field field = this.addField();
                                    field.missingStringDelimiter = true;
                                }
                            }
                        }
                    } else if (!skipNextChar && this.delimiterIsSet && this.str.endsWith(this.delimiter)) {
                        this.inDelimiterBlock = true;
                        this.str = "";
                    } else if (!skipNextChar && this.str.endsWith(this.separator)) {
                        this.str = this.str.substring(0, this.str.length() - this.separator.length());
                        this.addField();
                    } else if (i == ((String)line.value).length() - 1) {
                        this.addField();
                    }
                } else if (!skipNextChar && this.str.endsWith(this.separator)) {
                    this.searchNextSeparator = false;
                    this.str = "";
                }
                if (skipNextChar) {
                    skipNextChar = false;
                }
            }
            ++i;
        }
    }

    private Field addField2() {
        Field field = new Field(this.strBuf.toString());
        this.fields.add(field);
        this.resetStringBuffer();
        this.inDelimiterBlock = false;
        this.hasDelimiterOpen = false;
        this.lastStringDelimiterPosition = -1;
        this.searchNextSeparator = false;
        return field;
    }

    private void resetStringBuffer() {
        this.strBuf.setLength(0);
    }

    public static void main(String[] args) {
        String delimiter = "\"";
        String separator = ",";
        String str = "azerty";
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(str);
        strBuf = new StringBuilder();
        strBuf.append(str);
        System.out.println(strBuf.delete(strBuf.length() - delimiter.length(), strBuf.length()));
        System.out.println(str.substring(0, str.length() - delimiter.length()));
        strBuf = new StringBuilder();
        strBuf.append(str);
        System.out.println(strBuf.delete(3, strBuf.length()));
        System.out.println(str.substring(0, 3));
        strBuf = new StringBuilder();
        strBuf.append(str);
        System.out.println(strBuf.delete(strBuf.length() - delimiter.length() - 1, strBuf.length()));
        System.out.println(str.substring(0, str.length() - delimiter.length() - 1));
        strBuf.delete(6, strBuf.length());
        strBuf.delete(strBuf.length() - separator.length(), strBuf.length());
    }

    public void parse2(Pointer<String> line) {
        this.resetStringBuffer();
        this.inDelimiterBlock = false;
        this.hasDelimiterOpen = false;
        this.searchNextSeparator = false;
        this.it = null;
        this.fields = new ArrayList<Field>();
        int i = 0;
        while (i < ((String)line.value).length()) {
            char c = ((String)line.value).charAt(i);
            this.strBuf.append(c);
            if (!this.searchNextSeparator) {
                if (this.inDelimiterBlock) {
                    if (this.hasDelimiterOpen) {
                        if (this.delimiterComparator.endsWith(this.strBuf, c)) {
                            this.hasDelimiterOpen = false;
                            this.strBuf.delete(this.strBuf.length() - this.delimiter.length(), this.strBuf.length());
                        } else if (this.separatorComparator.endsWith(this.strBuf, c)) {
                            this.strBuf.delete(this.strBuf.length() - this.separator.length() - this.delimiter.length(), this.strBuf.length());
                            this.addField2();
                        } else if (i == ((String)line.value).length() - 1) {
                            if (this.lastStringDelimiterPosition > -1) {
                                this.strBuf.delete(this.lastStringDelimiterPosition, this.strBuf.length());
                            }
                            this.addField2();
                        } else {
                            this.strBuf.delete(this.strBuf.length() - this.delimiter.length() - 1, this.strBuf.length());
                            this.addField2();
                            this.searchNextSeparator = true;
                        }
                    } else {
                        if (this.delimiterIsSet && this.delimiterComparator.endsWith(this.strBuf, c)) {
                            this.lastStringDelimiterPosition = this.strBuf.length() - this.delimiter.length();
                            this.hasDelimiterOpen = true;
                        }
                        if (i == ((String)line.value).length() - 1) {
                            if (this.hasDelimiterOpen) {
                                this.strBuf.delete(this.lastStringDelimiterPosition, this.strBuf.length());
                                this.addField2();
                            } else {
                                Field field = this.addField2();
                                field.missingStringDelimiter = true;
                            }
                        }
                    }
                } else if (this.delimiterIsSet && this.delimiterComparator.endsWith(this.strBuf, c)) {
                    this.inDelimiterBlock = true;
                    this.resetStringBuffer();
                } else if (this.separatorComparator.endsWith(this.strBuf, c)) {
                    this.strBuf.delete(this.strBuf.length() - this.separator.length(), this.strBuf.length());
                    this.addField2();
                } else if (i == ((String)line.value).length() - 1) {
                    this.addField2();
                }
            } else if (this.separatorComparator.endsWith(this.strBuf, c)) {
                this.searchNextSeparator = false;
                this.resetStringBuffer();
            }
            ++i;
        }
    }

    public class Field {
        String data;
        boolean missingStringDelimiter;

        public Field(String str) {
            this.data = str;
        }

        public String getData() {
            return this.data;
        }

        public boolean isMissingStringDelimiter() {
            return this.missingStringDelimiter;
        }
    }
}

