/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.AMQPBaseAction;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.amqp.AMQPMessageReceiver;
import com.indy.engine.actionCodes.amqp.AMQPUtils;
import com.indy.engine.core.IActionBind;
import com.indy.runtime.api.impl.jdbc.JdbcPreparedStatementToResultSet;
import com.rabbitmq.client.Delivery;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class AMQPReceiveMessageActionCodeI
extends AMQPBaseAction {
    protected AMQPMessageReceiver jfs;
    boolean needToBeBinded = true;
    boolean askToClose = false;

    public AMQPReceiveMessageActionCodeI() {
        super("JMSReceiveActionCodeI", true);
    }

    @Override
    public void _execute() throws Throwable {
        JdbcPreparedStatementToResultSet jpstrs = null;
        try {
            IActionBind aBind = this.getActionContext().getActionBind();
            AMQPMessageReceiver.DeliveryListener listener = null;
            if (aBind != null) {
                final JdbcPreparedStatementToResultSet jpstrs2 = jpstrs = (JdbcPreparedStatementToResultSet)this.getActionContext().createBindePreparedStatement();
                int index = 1;
                jpstrs.setColumnName(index, AMQPUtils.AMQPProperty.AMQP_ROUTING_KEY.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_ROUTING_KEY.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_STRING_CONTENT.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_STRING_CONTENT.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_DELIVERY_TAG.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_DELIVERY_TAG.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_EXCHANGE_NAME.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_EXCHANGE_NAME.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_MESSAGE_ID.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_MESSAGE_ID.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_CORRELATION_ID.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_CORRELATION_ID.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_EXPIRATION.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_EXPIRATION.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_APP_ID.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_APP_ID.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_CLASS_NAME.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_CLASS_NAME.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_CLUSTER_ID.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_CLUSTER_ID.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_CONTENT_ENCODING.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_CONTENT_ENCODING.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_CONTENT_TYPE.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_CONTENT_TYPE.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_REPLY_TO.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_REPLY_TO.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_TYPE.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_TYPE.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_USER_ID.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_USER_ID.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_BODY_SIZE.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_BODY_SIZE.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_TIMESTAMP.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_TIMESTAMP.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_DELIVERY_MODE.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_DELIVERY_MODE.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_PRIORITY.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_PRIORITY.getSqlType());
                jpstrs.setColumnName(++index, AMQPUtils.AMQPProperty.AMQP_MESSAGE_NUMBER.name(), false);
                jpstrs.setColumnType(index, AMQPUtils.AMQPProperty.AMQP_MESSAGE_NUMBER.getSqlType());
                final int tempIndex = index;
                this.getActionContext().bindWithTarget(jpstrs.getNotFetchedResultSetBindI());
                listener = new AMQPMessageReceiver.DeliveryListener(){
                    boolean first = true;
                    Map<Integer, String> headerKey = new HashMap<Integer, String>();

                    @Override
                    public void handle(Delivery delivery, int messageCount) {
                        try {
                            Map headers = delivery.getProperties().getHeaders();
                            if (this.first) {
                                if (headers != null) {
                                    int i = tempIndex;
                                    for (String key : headers.keySet()) {
                                        this.headerKey.put(++i, key);
                                        jpstrs2.setColumnName(i, key, false);
                                        jpstrs2.setColumnType(i, "VARCHAR");
                                    }
                                }
                                this.first = false;
                                jpstrs2.clearParameters();
                            }
                            jpstrs2.setString(1, delivery.getEnvelope().getRoutingKey());
                            if (AMQPReceiveMessageActionCodeI.this.encoding != null) {
                                jpstrs2.setString(2, new String(delivery.getBody(), AMQPReceiveMessageActionCodeI.this.encoding));
                            } else {
                                String contentEncoding = delivery.getProperties().getContentEncoding();
                                if (contentEncoding != null && !contentEncoding.isEmpty()) {
                                    jpstrs2.setString(2, new String(delivery.getBody(), contentEncoding));
                                } else {
                                    jpstrs2.setString(2, new String(delivery.getBody()));
                                }
                            }
                            jpstrs2.setLong(3, delivery.getEnvelope().getDeliveryTag());
                            jpstrs2.setString(4, delivery.getEnvelope().getExchange());
                            jpstrs2.setString(5, delivery.getProperties().getMessageId());
                            jpstrs2.setString(6, delivery.getProperties().getCorrelationId());
                            jpstrs2.setString(7, delivery.getProperties().getExpiration());
                            jpstrs2.setString(8, delivery.getProperties().getAppId());
                            jpstrs2.setString(9, delivery.getProperties().getClassName());
                            jpstrs2.setString(10, delivery.getProperties().getClusterId());
                            jpstrs2.setString(11, delivery.getProperties().getContentEncoding());
                            jpstrs2.setString(12, delivery.getProperties().getContentType());
                            jpstrs2.setString(13, delivery.getProperties().getReplyTo());
                            jpstrs2.setString(14, delivery.getProperties().getType());
                            jpstrs2.setString(15, delivery.getProperties().getUserId());
                            jpstrs2.setLong(16, delivery.getProperties().getBodySize());
                            if (delivery.getProperties().getTimestamp() != null) {
                                jpstrs2.setDate(17, new Date(delivery.getProperties().getTimestamp().getTime()));
                            } else {
                                jpstrs2.setDate(17, null);
                            }
                            if (delivery.getProperties().getDeliveryMode() == null) {
                                jpstrs2.setNull(18, 4);
                            } else {
                                jpstrs2.setInt(18, delivery.getProperties().getDeliveryMode().intValue());
                            }
                            if (delivery.getProperties().getPriority() == null) {
                                jpstrs2.setNull(19, 4);
                            } else {
                                jpstrs2.setInt(19, delivery.getProperties().getPriority().intValue());
                            }
                            jpstrs2.setInt(20, messageCount);
                            for (Map.Entry<Integer, String> entry : this.headerKey.entrySet()) {
                                Object value;
                                String key = entry.getValue();
                                Object object = value = headers != null ? (Object)headers.get(key) : null;
                                if (value == null) {
                                    jpstrs2.setString(entry.getKey().intValue(), null);
                                    continue;
                                }
                                jpstrs2.setString(entry.getKey().intValue(), value.toString());
                            }
                            jpstrs2.executeUpdate();
                            AMQPReceiveMessageActionCodeI.this.fireStatistic(messageCount);
                        }
                        catch (UnsupportedEncodingException | SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            } else {
                listener = new AMQPMessageReceiver.DeliveryListener(){

                    @Override
                    public void handle(Delivery delivery, int messageCount) throws IOException {
                        AMQPReceiveMessageActionCodeI.this.fireStatistic(messageCount);
                    }
                };
            }
            this.jfs.receive(this.amqpConnection, listener);
            this.commit();
        }
        finally {
            this.jfs.clear();
            if (jpstrs != null) {
                jpstrs.close();
            }
        }
    }

    protected void initReceiver() {
        this.jfs = new AMQPMessageReceiver();
    }

    protected void fireStatistic(int messageCount) {
        this.publishVariable("MQ_MESSAGE_RECEIVED", messageCount + 1);
    }

    @Override
    public void prepare(ResultSet rSet) throws EngineExceptionI {
        super.prepare(rSet);
        if (this.needToBeBinded) {
            boolean bindAction;
            boolean bl = bindAction = this.getActionContext().getActionBind() != null;
            if (!bindAction) {
                throw new EngineExceptionI(Messages.getString("AMQP.ERROR_008"));
            }
        }
        this.initReceiver();
        this.jfs.setMessageNumber(this.getLocalIntegerBindedParameter(rSet, "AMQP_MESSAGE_COUNT", -1));
        this.jfs.setReceiveTimeout(this.getLocalIntegerBindedParameter(rSet, "AMQP_RECEIVE_TIMEOUT", 1000));
        this.jfs.queueName = this.amqpQueueName;
        this.jfs.setChannelName(this.amqpChannelName);
    }

    @Override
    public void stopAction(Thread th) {
        this.setStoppingAction(true);
        if (th != null) {
            th.interrupt();
        }
        if (!this.askToClose) {
            this.askToClose = true;
        }
    }
}

