/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.AbstractAction;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.jms.JMSConnection;
import com.indy.engine.actionCodes.jms.JMSConnectionProperties;
import com.indy.engine.actionCodes.jms.JMSRuntimeConnection;
import com.indy.engine.core.UtilsService;
import com.indy.engine.core.main.connections.ConnectionManagerI;
import com.indy.engine.core.main.connections.RuntimeDatasource;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import jakarta.jms.JMSException;
import java.sql.ResultSet;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class JMSBaseAction
extends AbstractAction {
    int acknowLedgePolicy;
    private JMSConnectionProperties properties;
    String jmsSessionName;
    JMSConnection jmsConnection;
    String jmsDestinationName;
    public static final Logger log = LogManager.getLogger((String)"com.indy.engine.actionCodes");
    ClassLoader cl;

    protected JMSBaseAction(String actionCodeName, boolean bNullCodeAllowed) {
        super(actionCodeName, bNullCodeAllowed);
    }

    protected void setConnection() throws Exception {
        String managerName = "JMS." + this.connectionName;
        ReentrantLock lockObject = this.engineContext.getConnectionlock();
        lockObject.lockInterruptibly();
        try {
            RuntimeDatasource dataSource;
            ConnectionManagerI connManager;
            if (!this.actionContext.existsConnectionManager(managerName)) {
                this.actionContext.addNewConnectionManager(managerName, this.connectionName, "JMS");
                connManager = this.actionContext.getConnectionManager(managerName);
            } else {
                connManager = this.actionContext.getConnectionManager(managerName);
            }
            if (!connManager.hasRuntimeDataSource()) {
                dataSource = this.createRuntimeConnectionJMS();
                connManager.setRuntimeDataSource(dataSource);
                lockObject.unlock();
                connManager.unlockAll();
            } else {
                dataSource = connManager.getRuntimeDataSource();
                lockObject.unlock();
            }
            this.jmsConnection = (JMSConnection)dataSource.getConnection(managerName).getUnderlyingConnection();
        }
        finally {
            if (lockObject.isHeldByCurrentThread() && lockObject.isLocked()) {
                lockObject.unlock();
            }
        }
    }

    RuntimeDatasource<JMSConnection> createRuntimeConnectionJMS() {
        return new RuntimeDatasource<JMSConnection>(){
            private JMSRuntimeConnection runtimeConnection = null;

            public JMSRuntimeConnection getConnection(String name) throws EngineExceptionI {
                if (this.runtimeConnection == null) {
                    JMSConnection c = new JMSConnection(JMSBaseAction.this.properties);
                    c.connect(JMSBaseAction.this);
                    this.runtimeConnection = new JMSRuntimeConnection(c);
                }
                return this.runtimeConnection;
            }

            public void close(boolean commit) throws EngineExceptionI {
                if (this.runtimeConnection != null) {
                    this.runtimeConnection.close(commit);
                }
            }
        };
    }

    protected void setSession() throws JMSException {
        this.jmsConnection.createSession(this.jmsSessionName, this.acknowLedgePolicy, false);
    }

    @Override
    public void prepare(ResultSet rSet) throws EngineExceptionI {
        String acknowLedgeModeParameter;
        this.connectionName = this.getLocalStringBindedParameter(rSet, "JMS_CONNECTION");
        switch (acknowLedgeModeParameter = this.getLocalStringBindedParameter(rSet, "JMS_ACKNOWLEDGE_MODE", "SESSION_TRANSACTED")) {
            case "SESSION_TRANSACTED": {
                this.acknowLedgePolicy = 0;
                break;
            }
            case "AUTO_ACKNOWLEDGE": {
                this.acknowLedgePolicy = 1;
                break;
            }
            case "CLIENT_ACKNOWLEDGE": {
                this.acknowLedgePolicy = 2;
                break;
            }
            case "DUPS_OK_ACKNOWLEDGE": {
                this.acknowLedgePolicy = 3;
                break;
            }
            default: {
                throw new EngineExceptionI(Messages.getString("JMSBaseAction.0") + acknowLedgeModeParameter);
            }
        }
        this.properties = new JMSConnectionProperties();
        this.properties.setInitialContextFactory(this.getLocalStringBindedParameter(rSet, "JMS_INITIAL_CONTEXT_FACTORY"));
        String moduleName = this.getLocalStringBindedParameter(rSet, "MODULE", null);
        this.getClassLoader(moduleName);
        this.properties.setJmsLogin(this.getLocalSecretBindedParameter(rSet, "JMS_LOGIN", null));
        this.properties.setJmsPassword(this.getLocalSecretBindedParameter(rSet, "JMS_PASSWORD", this.getLocalStringBindedParameter(rSet, "JMS_UNCRYPTED_PASSWORD", null)));
        this.properties.setConnectionFactoryName(this.getLocalStringBindedParameter(rSet, "JMS_CONNECTION_FACTORY_NAME", "ConnectionFactory"));
        this.properties.setJndiProviderUrl(this.getLocalStringBindedParameter(rSet, "JMS_PROVIDER_URL"));
        this.properties.setJmsClientId(this.getLocalStringBindedParameter(rSet, "JMS_CLIENT_ID", null));
        this.jmsSessionName = this.getLocalStringBindedParameter(rSet, "JMS_SESSION_NAME", "T1");
        this.jmsDestinationName = this.getLocalStringBindedParameter(rSet, "JMS_DESTINATION_NAME", null);
        String jmsServerProperties = this.getLocalStringBindedParameter(rSet, "JMS_SERVER_PROPERTIES", null);
        if (jmsServerProperties != null) {
            Document doc = null;
            try {
                doc = UtilsService.getXmlUtils().stringToDOMDocument("<root>" + jmsServerProperties + "</root>");
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
            Node root = doc.getFirstChild();
            NodeList children = root.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeName().equals("property")) {
                    Node nameAttr = child.getAttributes().getNamedItem("name");
                    Node valueAttr = child.getAttributes().getNamedItem("value");
                    if (nameAttr != null && valueAttr != null) {
                        this.properties.setProperty(nameAttr.getNodeValue(), valueAttr.getNodeValue());
                    }
                }
                ++i;
            }
        }
    }

    private void getClassLoader(String moduleName) throws EngineExceptionI {
        try {
            if (moduleName != null) {
                this.cl = ClassLoaderServiceProvider.instance().getClassLoader(moduleName);
            }
            if (this.cl == null) {
                try {
                    this.cl = ClassLoaderServiceProvider.instance().getClassLoader("default");
                    Class.forName((String)this.properties.getProperties().get("java.naming.factory.initial"), true, this.cl);
                }
                catch (ClassNotFoundException ex) {
                    this.cl = ClassLoaderServiceProvider.instance().getClassLoader("internal");
                    Class.forName((String)this.properties.getProperties().get("java.naming.factory.initial"), true, this.cl);
                }
            }
        }
        catch (ClassLoaderServiceProvider.ClassLoaderServiceException | ClassNotFoundException e) {
            throw new EngineExceptionI(e);
        }
    }

    @Override
    public void execute() throws Throwable {
        ClassLoader clOld = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.cl);
            this.doExecute();
        }
        finally {
            Thread.currentThread().setContextClassLoader(clOld);
        }
    }

    abstract void doExecute() throws Throwable;
}

