/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.mail.MailActionCode;
import com.indy.engine.actionCodes.utils.BidiMap;
import com.indy.engine.actionCodes.utils.Tools;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretValue;
import com.semarchy.xdi.base.core.auth.AuthenticationFactory;
import com.semarchy.xdi.base.core.auth.OAuth2Utils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SendMailActionCodeI
extends MailActionCode {
    private static final String DEFAULT_MAIL_PORT = "25";
    private static final String DEFAULT_SSL_MAIL_PORT = "995";
    private static final String DEFAULT_SSL_PROTOCOL = "SSL";
    private static final String TLS_PROTOCOL = "TLS";
    ISecretValue mailHost;
    ISecretValue mailPort;
    String mailFrom;
    String mailTo;
    boolean mailUseSecuredTransport = false;
    String mailSecuryProtocol = "SSL";
    boolean enableHostnameValidation = true;
    String mailBCC;
    String mailCC;
    String mailSubject;
    String mailAttach;
    String mailText;
    String mailTextType = "txt";
    ISecretValue mailUser;
    ISecretValue mailPassword;
    int nbMessages = 0;
    Transport mailTransport = null;
    String contentType;
    private String mailBodyFile;

    public SendMailActionCodeI() {
        this.actionCodeName = "Send Mail Operation";
        this.bNullCodeAllowed = true;
    }

    public void stopAction(Thread th) {
        this.setStoppingAction(true);
        if (this.mailTransport != null && this.mailTransport.isConnected()) {
            try {
                this.mailTransport.close();
            }
            catch (MessagingException e) {
                this.logger.warn("Error closing mail transport", (Throwable)e);
            }
        }
        if (th != null) {
            th.interrupt();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.debugLog("prepare", Messages.getString("SendMailActionCodeI.0"), 3, "DEBUG");
        this.setStandardConnectionParameters(rSet);
        this.mailHost = this.getLocalSecretBindedParameter(rSet, "MAIL_HOSTNAME", null);
        this.mailFrom = this.getLocalStringBindedParameter(rSet, "MAIL_FROM", null);
        if (this.mailHost.isNull() || this.mailFrom == null) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), "MAIL_HOSTNAME and MAIL_FROM are mandatory", "String", false);
            throw new EngineExceptionI("MAIL_HOSTNAME and MAIL_FROM are mandatory");
        }
        this.mailUseSecuredTransport = this.getLocalBooleanBindedParameter(rSet, "MAIL_USE_SSL", false);
        if (this.mailUseSecuredTransport) {
            this.mailSecuryProtocol = this.getLocalStringBindedParameter(rSet, "MAIL_SSL_PROTOCOL", DEFAULT_SSL_PROTOCOL);
        }
        this.enableHostnameValidation = this.getLocalBooleanBindedParameter(rSet, "MAIL_ENABLE_HOSTNAME_VALIDATION", true);
        this.mailPort = this.getLocalSecretBindedParameter(rSet, "MAIL_PORT", null);
        if (this.mailPort.isNull()) {
            if (this.mailUseSecuredTransport) {
                this.mailPort.setDefaultValue(DEFAULT_SSL_MAIL_PORT);
            } else {
                this.mailPort.setDefaultValue(DEFAULT_MAIL_PORT);
            }
        }
        this.mailUser = this.getLocalSecretBindedParameter(rSet, "MAIL_USER", null);
        this.mailPassword = this.getLocalSecretBindedParameter(rSet, "MAIL_PASSWORD", this.getLocalStringBindedParameter(rSet, "MAIL_UNCRYPTED_PASSWORD", ""));
        this.oauth2JsonString = this.getLocalStringBindedParameter(rSet, "SECURITY_MD_TO_JSON", null);
        this.mailTo = this.getLocalStringBindedParameter(rSet, "MAIL_TO", "");
        this.mailCC = this.getLocalStringBindedParameter(rSet, "MAIL_CC", "");
        this.mailBCC = this.getLocalStringBindedParameter(rSet, "MAIL_BCC", "");
        if (this.mailTo.isEmpty() && this.mailCC.isEmpty() && this.mailBCC.isEmpty()) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), "Either MAIL_TO or MAIL_CC or MAIL_BCC should be filled", "String", false);
            throw new EngineExceptionI("Either MAIL_TO or MAIL_CC or MAIL_BCC should be filled");
        }
        this.mailSubject = this.getLocalStringBindedParameter(rSet, "MAIL_SUBJECT", "");
        this.mailAttach = this.getLocalStringBindedParameter(rSet, "MAIL_ATTACH", "");
        this.mailBodyFile = this.getLocalStringBindedParameter(rSet, "MAIL_CONTENT_FILE", null);
        String mailBodyFileEncoding = this.getLocalStringBindedParameter(rSet, "MAIL_CONTENT_FILE_ENCODING", null);
        String txt = null;
        if (this.mailBodyFile != null && !this.mailBodyFile.isEmpty()) {
            File file = new File(this.mailBodyFile);
            if (!file.exists()) throw new EngineExceptionI(Messages.getString("SendMailActionCodeI.2") + this.mailBodyFile + Messages.getString("SendMailActionCodeI.3"));
            try {
                txt = Tools.readFileAsString((String)this.mailBodyFile, (String)mailBodyFileEncoding);
            }
            catch (IOException e) {
                throw new EngineExceptionI(Messages.getString("SendMailActionCodeI.1") + this.mailBodyFile + " file", (Throwable)e);
            }
        } else {
            this.mailBodyFile = null;
        }
        String volatileActionCode = null;
        if (rSet == null) {
            if (txt != null) {
                txt = this.actionContext.executeSubstitutionScript(txt, "s");
            }
            volatileActionCode = txt != null ? txt : this.actionTxtCode;
        } else {
            String codeTxtToExecute;
            String string = codeTxtToExecute = txt != null ? txt : this.actionTxtCode;
            if (codeTxtToExecute != null) {
                volatileActionCode = this.getFinalBindedCode(rSet, txt != null ? txt : this.actionTxtCode);
            }
        }
        this.mailText = volatileActionCode == null || volatileActionCode.isEmpty() ? this.getLocalStringBindedParameter(rSet, "MAIL_TEXT", "") : volatileActionCode;
        this.contentType = this.getLocalBooleanBindedParameter(rSet, "MAIL_HTML_MODE", false) != false ? "text/html" : "";
        this.mailExtraProperties = this.getLocalStringBindedParameter(rSet, "MAIL_EXTRA_PROPERTIES", null);
        this.debugLog("prepare", Messages.getString("SendMailActionCodeI.4"), 3, "DEBUG");
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws EngineExceptionI {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    String[] getlstAttachedFiles(String pAddr) throws EngineExceptionI {
        String[] lstFound = null;
        try {
            lstFound = pAddr.split(";");
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return lstFound;
    }

    InternetAddress[] getlstAdresses(String pAddr) throws EngineExceptionI {
        InternetAddress[] internetAddresses = null;
        String[] lstFound = pAddr.split(";");
        int i = 0;
        internetAddresses = new InternetAddress[lstFound.length];
        while (i != lstFound.length) {
            try {
                internetAddresses[i] = new InternetAddress(lstFound[i]);
            }
            catch (Exception e) {
                this.debugLog("getlstAdresses", "Exception : " + e.getMessage(), 0, "ERROR");
                throw new EngineExceptionI((Throwable)e);
            }
            ++i;
        }
        return internetAddresses;
    }

    private MimeMessage createMimeMessage(Session session) throws MessagingException, EngineExceptionI {
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(this.mailFrom));
        if (!this.mailTo.isEmpty()) {
            mimeMessage.addRecipients(Message.RecipientType.TO, (Address[])this.getlstAdresses(this.mailTo));
        }
        if (!this.mailCC.isEmpty()) {
            mimeMessage.addRecipients(Message.RecipientType.CC, (Address[])this.getlstAdresses(this.mailCC));
        }
        if (!this.mailBCC.isEmpty()) {
            mimeMessage.addRecipients(Message.RecipientType.BCC, (Address[])this.getlstAdresses(this.mailBCC));
        }
        mimeMessage.setSubject(this.mailSubject);
        return mimeMessage;
    }

    private void configureMailContent(MimeMessage message) throws MessagingException, EngineExceptionI {
        String newText;
        BidiMap inlineAttachments = new BidiMap();
        String[] lstFiles = this.getlstAttachedFiles(this.mailAttach);
        ArrayList<File> attachmentsFiles = new ArrayList<File>();
        String[] stringArray = lstFiles;
        int n = lstFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (!file.isEmpty()) {
                attachmentsFiles.add(new File(file));
            }
            ++n2;
        }
        if (this.contentType.contains("text/html")) {
            newText = this.extractImage(this.mailText, (BidiMap<String, String>)inlineAttachments, this.mailBodyFile, attachmentsFiles);
            newText = this.extractCss(newText, this.mailBodyFile);
        } else {
            newText = this.mailText;
        }
        if (!attachmentsFiles.isEmpty() || inlineAttachments.size() > 0) {
            MimeMultipart root;
            MimeMultipart attachments = root = new MimeMultipart("mixed");
            Multipart alternative = this.newChild((Multipart)root, "alternative");
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            if (!this.contentType.isEmpty()) {
                Multipart htmlAndInline = this.newChild(alternative, "related");
                htmlAndInline.addBodyPart((BodyPart)messageBodyPart);
                messageBodyPart.setContent((Object)newText, this.contentType);
                for (Object obj : inlineAttachments.keySet()) {
                    MimeBodyPart mimePart = new MimeBodyPart();
                    String file = (String)obj;
                    String id = (String)inlineAttachments.get((Object)file);
                    FileDataSource fds = new FileDataSource(file);
                    mimePart.setFileName(fds.getName());
                    mimePart.setDataHandler(new DataHandler((DataSource)fds));
                    mimePart.setHeader("Content-ID", "<" + id + ">");
                    htmlAndInline.addBodyPart((BodyPart)mimePart);
                }
            } else {
                alternative.addBodyPart((BodyPart)messageBodyPart);
                messageBodyPart.setText(newText);
            }
            for (File file : attachmentsFiles) {
                MimeBodyPart mimePart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(file);
                mimePart.setDataHandler(new DataHandler((DataSource)source));
                mimePart.setFileName(file.getName());
                attachments.addBodyPart((BodyPart)mimePart);
            }
            message.setContent((Multipart)root);
        } else if (this.contentType != null && !this.contentType.isEmpty()) {
            message.setContent((Object)newText, this.contentType);
        } else {
            message.setText(newText, StandardCharsets.UTF_8.name());
        }
    }

    private void configureContentType() {
        if (this.contentType != null && !this.contentType.isEmpty() && !this.contentType.contains("charset=")) {
            this.contentType = String.valueOf(this.contentType) + "; charset=UTF-8";
        }
    }

    private Session getAuthenticatedSession(final ISecretContext context, Properties props) {
        props.put("mail.smtp.auth", "true");
        return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                try {
                    String password;
                    if (SendMailActionCodeI.this.oauth2JsonString == null) {
                        password = SendMailActionCodeI.this.mailPassword.decryptString(context);
                    } else {
                        Properties properties = OAuth2Utils.authJsonToProperties((String)SendMailActionCodeI.this.oauth2JsonString);
                        password = AuthenticationFactory.getOAuth2Token((Map)OAuth2Utils.convertPropertiesToMap((Properties)properties));
                    }
                    return new PasswordAuthentication(SendMailActionCodeI.this.mailUser.getString(context), password);
                }
                catch (Exception e) {
                    SendMailActionCodeI.this.logger.warn("unexpected", (Throwable)e);
                    return null;
                }
            }
        });
    }

    private void configureSmtpTransport(ISecretContext context, Properties props) throws Exception {
        props.put("mail.smtp.host", this.mailHost.getString(context));
        props.put("mail.smtp.port", this.mailPort.getString(context));
        if (this.mailUseSecuredTransport) {
            if (this.mailSecuryProtocol.equals(TLS_PROTOCOL)) {
                props.put("mail.smtp.starttls.enable", (Object)true);
            } else {
                props.put("mail.smtp.ssl.enable", (Object)true);
            }
            if (this.enableHostnameValidation) {
                props.put("mail.smtp.ssl.checkserveridentity", (Object)true);
            } else {
                props.put("mail.smtp.ssl.checkserveridentity", (Object)false);
                props.put("mail.smtp.ssl.trust", "*");
            }
        }
        this.appendSessionExtraProperties(props);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        if (this.connectionName != null && !this.connectionName.equals("")) {
            this.debugLog("executeSimpleCode", Messages.getString("SendMailActionCodeI.5") + this.connectionName, 3, "DEBUG");
            this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
            this.createMailTables();
            this.isRdbmsLinked = true;
        }
        String msgId = UUID.randomUUID().toString();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(Messages.getString("SendMailActionCodeI.6"), (Object)msgId);
            this.logger.info(Messages.getString("SendMailActionCodeI.7"), (Object)msgId, (Object)this.mailSubject, (Object)this.mailTo, (Object)this.mailCC, (Object)this.mailBCC);
        }
        try {
            try {
                this.debugLog("executeSimpleCode", Messages.getString("SendMailActionCodeI.11"), 3, "DEBUG");
                Properties props = new Properties();
                this.nbMessages = 0;
                MimeMessage message = (MimeMessage)this.secret(context -> {
                    this.configureSmtpTransport(context, props);
                    Session session = !this.mailUser.isNull() ? this.getAuthenticatedSession(context, props) : Session.getInstance((Properties)props, null);
                    this.mailTransport = session.getTransport("smtp");
                    this.mailTransport.connect();
                    this.configureContentType();
                    return this.createMimeMessage(session);
                });
                this.configureMailContent(message);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(Messages.getString("SendMailActionCodeI.12"), (Object)msgId);
                }
                this.secret(context -> {
                    this.mailTransport.sendMessage((Message)message, message.getAllRecipients());
                    if (this.isRdbmsLinked) {
                        this.insertHeaderDataInTables((Message)message, null, null, null, true);
                    }
                    return null;
                });
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(Messages.getString("SendMailActionCodeI.13"), (Object)msgId);
                }
                ++this.nbMessages;
                this.publishCumulativeVariable("MAIL_NB", String.valueOf(this.nbMessages), "Integer", false);
            }
            catch (Exception e) {
                this.logger.error(Messages.getString("SendMailActionCodeI.14"), (Object)msgId, (Object)e);
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), "Exception : " + e.getMessage(), "String", false);
                this.debugLog("executeSimpleCode", "Exception " + e.getMessage(), 0, "ERROR");
                if (e instanceof EngineExceptionI) {
                    EngineExceptionI ee = (EngineExceptionI)((Object)e);
                    throw ee;
                }
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            if (this.mailTransport != null && this.mailTransport.isConnected()) {
                try {
                    this.mailTransport.close();
                }
                catch (MessagingException e) {
                    this.logger.warn("unexpected close issue", (Throwable)e);
                }
            }
        }
        return 0;
    }

    String extractCss(String txt, String parent) {
        Pattern pDeb2 = Pattern.compile("(@import[ ]+\"([^\"]*)\"[;]?)");
        Matcher mDeb2 = pDeb2.matcher(txt);
        int deb = 0;
        Object nexText = "";
        while (mDeb2.find()) {
            int iDeb2 = mDeb2.start(2);
            int iFin2 = mDeb2.end(2);
            if (iDeb2 <= -1) continue;
            nexText = (String)nexText + txt.substring(deb, iDeb2);
            String file = txt.substring(iDeb2, iFin2);
            File tempFile = new File(file);
            if (!tempFile.isAbsolute() && parent != null) {
                File tempParent = new File(parent).getParentFile();
                tempFile = new File(tempParent, file);
            }
            if (tempFile.exists()) {
                try {
                    String tt = Tools.readFileAsString((String)tempFile.getAbsolutePath(), null);
                    nexText = (String)nexText + tt;
                }
                catch (IOException e) {
                    nexText = (String)nexText + file;
                    this.debugLog("extractCss", e.getMessage(), 0, "ERROR");
                }
            }
            deb = iFin2;
        }
        if (txt.length() > deb) {
            nexText = (String)nexText + txt.substring(deb);
        }
        return nexText;
    }

    String extractImage(String txt, BidiMap<String, String> inlineAttachments, String parent, List<File> attachmentsFiles) {
        Pattern pDeb2 = Pattern.compile("(<img[^>]*?src=\"([^\"]+)\"[^>]*>)");
        Matcher mDeb2 = pDeb2.matcher(txt);
        int deb = 0;
        Object nexText = "";
        int i = 0;
        while (mDeb2.find()) {
            int iDeb = mDeb2.start(2);
            int iFin = mDeb2.end(2);
            int iD = iDeb;
            int iF = iFin;
            if (iD <= -1) continue;
            boolean ok = false;
            String file = txt.substring(iD, iF);
            try {
                File tempFile = new File(file);
                if (!tempFile.isAbsolute() && parent != null) {
                    File tempParent = new File(parent).getParentFile();
                    tempFile = new File(tempParent, file);
                    ok = tempFile.exists();
                    file = tempFile.getAbsolutePath();
                } else {
                    ok = tempFile.exists();
                    if (!ok && file.startsWith("cid:")) {
                        String name = file.substring(4);
                        if (attachmentsFiles != null) {
                            for (File __file : attachmentsFiles) {
                                if (!__file.getName().equals(name)) continue;
                                attachmentsFiles.remove(__file);
                                tempFile = __file;
                                ok = true;
                                break;
                            }
                        }
                    }
                    file = tempFile.getAbsolutePath();
                }
            }
            catch (Exception e) {
                this.debugLog("extractImage", e.getMessage(), 0, "ERROR");
            }
            if (ok) {
                Object index = (String)inlineAttachments.getTo((Object)file);
                if (index == null) {
                    index = "img" + i++;
                    inlineAttachments.put((Object)file, index);
                }
                nexText = (String)nexText + txt.substring(deb, iD);
                nexText = (String)nexText + "cid:" + (String)index;
                deb = iF;
                continue;
            }
            nexText = (String)nexText + txt.substring(deb, iF);
            deb = iF;
        }
        if (txt.length() > deb) {
            nexText = (String)nexText + txt.substring(deb);
        }
        return nexText;
    }

    private Multipart newChild(Multipart parent, String type) throws MessagingException {
        MimeMultipart child = new MimeMultipart(type);
        MimeBodyPart mbp = new MimeBodyPart();
        parent.addBodyPart((BodyPart)mbp);
        mbp.setContent((Multipart)child);
        return child;
    }
}

