/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.amqp;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.amqp.AMQPConnectionProperties;
import com.indy.engine.actionCodes.amqp.AMQPUtils;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AMQPConnection {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private Connection connection;
    private AMQPConnectionProperties jcp;
    boolean connected;
    Map<String, InnerChannel> channels = new HashMap<String, InnerChannel>();

    public AMQPConnection(AMQPConnectionProperties jcp) {
        this.jcp = jcp;
    }

    public synchronized void connect(ActionCodeTypeI action) throws Exception {
        this.connect(true, action);
    }

    public synchronized void connect(boolean connectIfNotConnected, ActionCodeTypeI action) throws EngineExceptionI {
        if (!this.connected && !connectIfNotConnected) {
            throw new RuntimeException(Messages.getString("AMQP.ERROR_015"));
        }
        if (!this.connected) {
            final ConnectionFactory connectionFactory = new ConnectionFactory();
            this.connection = (Connection)action.secret((ISecretStatement)new ISecretStatement<Connection>(){

                public Connection execute(ISecretContext context) throws Throwable {
                    if (!AMQPConnection.this.jcp.getJmsLogin().isNull()) {
                        connectionFactory.setUsername(AMQPConnection.this.jcp.getJmsLogin().getString(context));
                    }
                    if (!AMQPConnection.this.jcp.getJmsPassword().isNull()) {
                        connectionFactory.setPassword(AMQPConnection.this.jcp.getJmsPassword().decryptString(context));
                    }
                    if (AMQPConnection.this.jcp.getConnectionTimeout() != null) {
                        connectionFactory.setConnectionTimeout(AMQPConnection.this.jcp.getConnectionTimeout().intValue());
                    }
                    if (AMQPConnection.this.jcp.getHandShakeTimeout() != null) {
                        connectionFactory.setHandshakeTimeout(AMQPConnection.this.jcp.getHandShakeTimeout().intValue());
                    }
                    if (!AMQPConnection.this.jcp.getVirtualHost().isNull()) {
                        connectionFactory.setVirtualHost(AMQPConnection.this.jcp.getVirtualHost().getString(context));
                    }
                    connectionFactory.setHost("localhost");
                    return connectionFactory.newConnection(AMQPConnection.this.jcp.getAddresses(context));
                }
            });
            this.connected = true;
        }
    }

    private synchronized InnerChannel doGetChannel(String channelName, boolean excpetion) {
        AMQPUtils._assert(channelName != null, Messages.getString("AMQP.ERROR_016"));
        InnerChannel channel = this.channels.get(channelName);
        if (channel == null && excpetion) {
            throw new RuntimeException(String.format(Messages.getString("AMQP.ERROR_017"), channelName));
        }
        return channel;
    }

    public synchronized Channel getChannel(String channelName) {
        InnerChannel channel = this.doGetChannel(channelName, true);
        return channel.channel;
    }

    public void lockChannel(String channelName) throws InterruptedException {
        InnerChannel channel = this.doGetChannel(channelName, true);
        channel.semaphore.acquire();
    }

    public void unlockChannel(String channelName) {
        InnerChannel channel = this.doGetChannel(channelName, true);
        channel.semaphore.release();
    }

    public synchronized Channel getChannel(String channelName, int timeout, boolean transac, ActionCodeTypeI action) throws IOException, EngineExceptionI {
        this.connect(false, action);
        InnerChannel channel = this.doGetChannel(channelName, false);
        if (channel == null) {
            channel = new InnerChannel();
            channel.channel = timeout > 0 ? this.connection.createChannel(timeout) : this.connection.createChannel();
            if (transac) {
                channel.channel.txSelect();
            }
            channel.transac = transac;
            this.channels.put(channelName, channel);
        }
        if (channel.transac != transac) {
            throw new IOException(Messages.getString("AMQP.ERROR_018"));
        }
        return channel.channel;
    }

    public synchronized void qos(String channelName, int prefetchSize, int prefetchCount, boolean global) throws IOException {
        InnerChannel channel = this.doGetChannel(channelName, true);
        channel.channel.basicQos(prefetchSize, prefetchCount, global);
    }

    public synchronized void commit(String channelName) throws IOException {
        InnerChannel channel = this.doGetChannel(channelName, true);
        channel.channel.txCommit();
    }

    public synchronized void commit() throws IOException {
        for (InnerChannel channel : this.channels.values()) {
            if (!channel.channel.isOpen() || !channel.transac) continue;
            channel.channel.txCommit();
        }
    }

    public synchronized void rollback() throws IOException {
        for (InnerChannel channel : this.channels.values()) {
            if (!channel.transac) continue;
            channel.channel.txRollback();
        }
    }

    public synchronized void rollback(String channelName) throws IOException {
        InnerChannel channel = this.doGetChannel(channelName, true);
        channel.channel.txRollback();
    }

    public synchronized void closeChannel(String channelName) throws IOException, TimeoutException {
        InnerChannel channel = this.doGetChannel(channelName, true);
        if (channel.channel.isOpen()) {
            channel.channel.close();
        }
    }

    public synchronized void close() throws IOException, TimeoutException {
        for (InnerChannel channel : this.channels.values()) {
            try {
                if (!channel.channel.isOpen()) continue;
                channel.channel.close();
            }
            catch (IOException e) {
                this.logger.warn("exception while close", (Throwable)e);
            }
        }
        if (this.connection.isOpen()) {
            this.connection.close();
        }
    }

    public synchronized void declareExchange(String channelName, String exchangeName, String exchangeDeclareType, boolean exchangeDeclareDurable, boolean exchangeDeclareAutoDelete) throws IOException {
        InnerChannel channel = this.doGetChannel(channelName, true);
        channel.channel.exchangeDeclare(exchangeName, exchangeDeclareType, exchangeDeclareDurable, exchangeDeclareAutoDelete, false, null);
    }

    public synchronized void declareQueue(String channelName, String queueName, boolean queueDeclareDurable, boolean queueDeclareExclusive, boolean queueDeclareAutoDelete) throws IOException {
        InnerChannel channel = this.doGetChannel(channelName, true);
        channel.channel.queueDeclare(queueName, queueDeclareDurable, queueDeclareExclusive, queueDeclareAutoDelete, null);
    }

    public synchronized void bindQueue(String channelName, String exchangeName, String queueName, String routingKey, Map<String, Object> headers) throws IOException {
        InnerChannel channel = this.doGetChannel(channelName, true);
        if (routingKey == null) {
            if (headers != null && headers.size() > 0) {
                channel.channel.queueBind(queueName, exchangeName, "", headers);
            } else {
                channel.channel.queueBind(queueName, exchangeName, "");
            }
        } else if (headers != null && headers.size() > 0) {
            channel.channel.queueBind(queueName, exchangeName, routingKey, headers);
        } else {
            channel.channel.queueBind(queueName, exchangeName, routingKey);
        }
    }

    public void unBind(String amqpChannelName, String amqpExchangeName, String amqpQueueName, String routingKey, Map<String, Object> headers) throws IOException {
        InnerChannel channel = this.doGetChannel(amqpChannelName, true);
        if (routingKey != null) {
            if (headers != null && headers.size() > 0) {
                channel.channel.queueUnbind(amqpQueueName, amqpExchangeName, routingKey, headers);
            } else {
                channel.channel.queueUnbind(amqpQueueName, amqpExchangeName, routingKey);
            }
        } else if (headers != null && headers.size() > 0) {
            channel.channel.queueUnbind(amqpQueueName, amqpExchangeName, "", headers);
        } else {
            channel.channel.queueUnbind(amqpQueueName, amqpExchangeName, "");
        }
    }

    public void deleteQueue(String amqpChannelName, String amqpQueueName) throws IOException {
        InnerChannel channel = this.doGetChannel(amqpChannelName, true);
        channel.channel.queueDelete(amqpQueueName);
    }

    public void deleteExchange(String amqpChannelName, String amqpExchangeName) throws IOException {
        InnerChannel channel = this.doGetChannel(amqpChannelName, true);
        channel.channel.exchangeDelete(amqpExchangeName);
    }

    class InnerChannel {
        Channel channel;
        boolean transac;
        public String locker;
        Semaphore semaphore = new Semaphore(1);

        InnerChannel() {
        }
    }
}

