/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.amqp;

import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.amqp.AMQPConnection;
import com.indy.engine.actionCodes.amqp.AMQPUtils;
import com.indy.engine.actionCodes.amqp.QueueingConsumer;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Delivery;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class AMQPMessageReceiver {
    String channelName;
    public String queueName;
    boolean autoAck = false;
    private int pMaxMessageCount;
    private int receiveTimeout;

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void clear() {
    }

    public void setMessageNumber(int i) {
        this.pMaxMessageCount = i;
    }

    public void receive(AMQPConnection conn, DeliveryListener listener) throws InterruptedException, IOException, TimeoutException {
        AMQPUtils._assert(listener != null, Messages.getString("AMQP.ERROR_025"));
        AMQPUtils._assert(this.channelName != null, Messages.getString("AMQP.ERROR_016"));
        Channel channel = conn.getChannel(this.channelName);
        QueueingConsumer qc = new QueueingConsumer(channel);
        channel.basicConsume(this.queueName, this.autoAck, (Consumer)qc);
        int messageCount = 0;
        boolean timeoutOccured = false;
        while (!(this.pMaxMessageCount != -1 && messageCount >= this.pMaxMessageCount || timeoutOccured)) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Delivery delivery = null;
            if (this.receiveTimeout > 0) {
                delivery = qc.nextDelivery(this.receiveTimeout);
            } else if (this.receiveTimeout <= 0) {
                delivery = qc.nextDelivery();
            }
            if (delivery == null) {
                timeoutOccured = true;
                continue;
            }
            listener.handle(delivery, messageCount++);
            if (this.autoAck) continue;
            channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static interface DeliveryListener {
        public void handle(Delivery var1, int var2) throws IOException;
    }
}

