/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.jms;

import com.indy.engine.actionCodes.jms.JMSConnection;
import com.indy.engine.actionCodes.jms.JMSUtils;
import com.indy.engine.actionCodes.jms.Messages;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.io.IOUtils;

public class JMSFileSender {
    String sendDirectory;
    String fileMask;
    String sessionName;
    String destinationName;
    List<File> sendFiles = new ArrayList<File>();
    private JMSMessageType messageType = JMSMessageType.BytesMessage;
    List<UserDefinedParameter> userDefinedParameters = new ArrayList<UserDefinedParameter>();
    List<JMSPropertySetter> jmsPropertySetters = new ArrayList<JMSPropertySetter>();

    public void setSendDirectory(String sendDirectory) {
        this.sendDirectory = sendDirectory;
    }

    public void setFileMask(String fileMask) {
        this.fileMask = fileMask;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public void setMessageType(JMSMessageType messageType) {
        this.messageType = messageType;
    }

    public synchronized void deleteSendFiles() {
        for (File file : this.sendFiles) {
            file.delete();
        }
        this.sendFiles.clear();
    }

    public void addUserDefinedParmater(String name, String value, String type) {
        UserDefinedParameter parameter = new UserDefinedParameter();
        parameter.name = name;
        parameter.stringValue = value;
        parameter.parameterType = TypeParameter.valueOf(type == null ? "STRING" : type.toUpperCase());
        this.userDefinedParameters.add(parameter);
    }

    private Message createNewMessage(Session session) throws JMSException {
        if (this.messageType == JMSMessageType.TextMessage) {
            return session.createTextMessage();
        }
        if (this.messageType == JMSMessageType.BytesMessage) {
            return session.createBytesMessage();
        }
        if (this.messageType == JMSMessageType.StreamMessage) {
            return session.createStreamMessage();
        }
        throw new JMSException(Messages.getString("JMSFileSender.0"));
    }

    public synchronized void send(JMSConnection connection) throws JMSException, NamingException, IOException, InterruptedException {
        assert (this.sendDirectory != null) : Messages.getString("JMSFileSender.1");
        assert (this.fileMask != null) : Messages.getString("JMSFileSender.2");
        assert (this.sessionName != null) : Messages.getString("JMSFileSender.3");
        assert (this.destinationName != null) : Messages.getString("JMSFileSender.4");
        File directory = new File(this.sendDirectory);
        if (!directory.exists()) {
            throw new JMSException(Messages.getString("JMSFileSender.6") + this.sendDirectory + Messages.getString("JMSFileSender.5"));
        }
        if (directory.isFile()) {
            throw new JMSException(Messages.getString("JMSFileSender.7") + this.sendDirectory + Messages.getString("JMSFileSender.8"));
        }
        Session session = connection.getSession(this.sessionName);
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (MessageProducer producer = connection.createMessageProducer(this.sessionName, this.destinationName);){
                File[] fileArray = directory.listFiles(new MyFileFilter(this.fileMask));
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File loopFile = fileArray[n2];
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (loopFile.isFile()) {
                        Throwable throwable2 = null;
                        Object var12_15 = null;
                        try (FileInputStream in = new FileInputStream(loopFile);){
                            Message message = this.createNewMessage(session);
                            for (JMSPropertySetter setter : this.jmsPropertySetters) {
                                setter.setProperty(message);
                            }
                            for (UserDefinedParameter parameter : this.userDefinedParameters) {
                                parameter.addToMessage(message);
                            }
                            JMSUtils.inputStreamToMessage(in, message);
                            producer.send(message);
                            this.sendFiles.add(loopFile);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    ++n2;
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            this.closeMessageProducer(connection);
        }
    }

    public void closeMessageProducer(JMSConnection connection) throws JMSException, NamingException {
        if (connection != null) {
            connection.closeMessageProducer(this.sessionName, this.destinationName);
        }
    }

    public synchronized void copySentFiles(String dir, boolean move) throws IOException {
        File localDir = new File(dir);
        if (!localDir.exists()) {
            localDir.mkdirs();
        }
        for (File file : this.sendFiles) {
            File dest = new File(localDir, file.getName());
            if (move) {
                dest.delete();
                file.renameTo(dest);
                continue;
            }
            Throwable throwable = null;
            Object var8_9 = null;
            try {
                FileInputStream is = new FileInputStream(file);
                try {
                    try (FileOutputStream os = new FileOutputStream(dest);){
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    if (is == null) continue;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    throw throwable;
                }
                ((InputStream)is).close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        this.sendFiles.clear();
    }

    public void addJMSpropertySetter(JMSPropertySetter setter) {
        this.jmsPropertySetters.add(setter);
    }

    public static enum JMSMessageType {
        BytesMessage,
        TextMessage,
        StreamMessage;

    }

    public static interface JMSPropertySetter {
        public void setProperty(Message var1) throws JMSException, NamingException;
    }

    class MyFileFilter
    implements FilenameFilter {
        final String localMask;

        public MyFileFilter(String pFileMask) {
            this.localMask = StringOperations.replaceWildChars((String)pFileMask);
        }

        @Override
        public boolean accept(File pDir, String pFileName) {
            return pFileName.matches(this.localMask);
        }
    }

    public static enum TypeParameter {
        LONG,
        BOOLEAN,
        INT,
        OBJECT,
        STRING,
        DOUBLE,
        FLOAT,
        BYTE,
        SHORT;

    }

    public static class UserDefinedParameter {
        public String name;
        public TypeParameter parameterType = TypeParameter.STRING;
        public int sqlType;
        public String stringValue;
        public String alias;

        void addToMessage(Message message) throws JMSException {
            if (this.parameterType == TypeParameter.STRING) {
                message.setStringProperty(this.name, this.stringValue);
            } else if (this.parameterType == TypeParameter.INT) {
                message.setIntProperty(this.name, Integer.valueOf(this.stringValue).intValue());
            } else if (this.parameterType == TypeParameter.BOOLEAN) {
                message.setBooleanProperty(this.name, Boolean.valueOf(this.stringValue).booleanValue());
            } else if (this.parameterType == TypeParameter.DOUBLE) {
                message.setDoubleProperty(this.name, Double.valueOf(this.stringValue).doubleValue());
            } else if (this.parameterType == TypeParameter.LONG) {
                message.setLongProperty(this.name, Long.valueOf(this.stringValue).longValue());
            } else if (this.parameterType == TypeParameter.FLOAT) {
                message.setFloatProperty(this.name, Float.valueOf(this.stringValue).floatValue());
            } else if (this.parameterType == TypeParameter.BYTE) {
                message.setByteProperty(this.name, Byte.valueOf(this.stringValue).byteValue());
            } else if (this.parameterType == TypeParameter.SHORT) {
                message.setShortProperty(this.name, Short.valueOf(this.stringValue).shortValue());
            }
        }

        public void addToPreparedStatement(int index, PreparedStatement st, Message message) throws SQLException, JMSException {
            if (this.parameterType == TypeParameter.STRING) {
                st.setString(index, message.getStringProperty(this.name));
            } else if (this.parameterType == TypeParameter.INT) {
                st.setInt(index, message.getIntProperty(this.name));
            } else if (this.parameterType == TypeParameter.BOOLEAN) {
                st.setBoolean(index, message.getBooleanProperty(this.name));
            } else if (this.parameterType == TypeParameter.DOUBLE) {
                st.setDouble(index, message.getDoubleProperty(this.name));
            } else if (this.parameterType == TypeParameter.LONG) {
                st.setLong(index, message.getLongProperty(this.name));
            } else if (this.parameterType == TypeParameter.FLOAT) {
                st.setFloat(index, message.getFloatProperty(this.name));
            } else if (this.parameterType == TypeParameter.BYTE) {
                st.setByte(index, message.getByteProperty(this.name));
            } else if (this.parameterType == TypeParameter.SHORT) {
                st.setShort(index, message.getShortProperty(this.name));
            }
        }
    }
}

