/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.jms;

import com.indy.engine.actionCodes.jms.Messages;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class JMSUtils {
    public static void copyBytesMessageToOutputStream(BytesMessage input, OutputStream output) throws IOException, JMSException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = input.readBytes(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }

    public static long copyStreamMessageToOutputStream(StreamMessage input, OutputStream output) throws IOException, JMSException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        long nb = 0L;
        while ((bytesRead = input.readBytes(buffer)) != -1) {
            nb += (long)bytesRead;
            output.write(buffer, 0, bytesRead);
        }
        return nb;
    }

    public static long messageToOutputStream(Message message, OutputStream out, boolean reset) throws JMSException, IOException {
        if (message instanceof BytesMessage) {
            BytesMessage byteMessage = (BytesMessage)message;
            if (reset) {
                byteMessage.reset();
            }
            JMSUtils.copyBytesMessageToOutputStream(byteMessage, out);
            return byteMessage.getBodyLength();
        }
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            byte[] b = textMessage.getText().getBytes();
            out.write(b);
            return b.length;
        }
        if (message instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)message;
            if (reset) {
                streamMessage.reset();
            }
            return JMSUtils.copyStreamMessageToOutputStream(streamMessage, out);
        }
        throw new JMSException(Messages.getString("JMSUtils.2") + message.getClass().getName() + Messages.getString("JMSUtils.3"));
    }

    public static void inputStreamToMessage(InputStream myStream, Message message) throws JMSException, IOException {
        block14: {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedInputStream bis = new BufferedInputStream(myStream);){
                if (message instanceof BytesMessage) {
                    BytesMessage byteMessage = (BytesMessage)message;
                    int tmpChar = bis.read();
                    while (tmpChar > -1) {
                        byteMessage.writeByte((byte)tmpChar);
                        tmpChar = bis.read();
                    }
                    break block14;
                }
                if (message instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)message;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)bis, (OutputStream)baos);
                    String str = new String(baos.toByteArray());
                    textMessage.setText(str);
                    break block14;
                }
                if (message instanceof StreamMessage) {
                    StreamMessage streamMessage = (StreamMessage)message;
                    int tmpChar = bis.read();
                    while (tmpChar > -1) {
                        streamMessage.writeByte((byte)tmpChar);
                        tmpChar = bis.read();
                    }
                    break block14;
                }
                throw new JMSException(Messages.getString("JMSUtils.4") + message.getClass().getName() + Messages.getString("JMSUtils.5"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static long fileToMessage(String file, Message message) throws JMSException, IOException {
        File currentFile = new File(file);
        if (!currentFile.exists()) {
            throw new IOException(Messages.getString("JMSUtils.6") + file);
        }
        if (!currentFile.isFile()) {
            throw new IOException(Messages.getString("JMSUtils.7") + file);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream is = new FileInputStream(file);){
            JMSUtils.inputStreamToMessage(new FileInputStream(file), message);
            return currentFile.length();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getJMSNormalizedMessageId(Message message) throws JMSException {
        String msgId = message.getJMSMessageID();
        if (msgId != null) {
            return msgId.replace(":", "_").replace("?", "_").replace("/", "_").replace("\\", "_").replace("*", "_").replace("<", "_").replace(">", "_").replace("|", "_").replace("\"", "_");
        }
        return null;
    }
}

