/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.wsdl;

import com.indy.engine.actionCodes.utils.XmlReaderToWriter;
import com.indy.engine.actionCodes.wsdl.HttpPort;
import com.indy.engine.actionCodes.wsdl.Messages;
import com.indy.engine.actionCodes.wsdl.Operation;
import com.indy.engine.actionCodes.xml.unload.AbstractXmlWriterAPI;
import com.indy.engine.common.ntlm.NtlmMetadata;
import com.indy.engine.core.RuntimeContext;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.runtime.json.JsonUtils;
import com.semarchy.xdi.base.core.auth.OAuth;
import com.semarchy.xdi.base.core.auth.OAuthMetadata;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.net.proxy.URLUtil;
import jakarta.xml.bind.DatatypeConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HttpOperation
extends Operation {
    String uuid = UUID.randomUUID().toString();
    private final Logger logger = LogManager.getLogger(this.getClass());
    private String methodAddress;
    private Param currentParam;
    private InputStream is;
    private InputStream err;
    private String urlEncoding;
    InputMode inputMode = null;
    RuntimeContext rc;
    private Set<HttpURLConnection> openedHttpConnections = Collections.synchronizedSet(new HashSet());
    boolean disableParamsEncoding = false;
    Params contentEncodedParams = new Params();
    Params queryEncodedParams = new Params();
    Params queryReplacementParams = new Params();
    Params headerParams = new Params();
    Set<String> outputHeaderParamsName = new HashSet<String>();
    String responseCodeName = null;
    String errorExceptionName = null;
    String errorMessageName = null;
    boolean parameterStatus = true;
    private String responseMessage;
    private String msgName;
    OAuthMetadata oauth;
    private NtlmMetadata ntlmMetadata = null;
    private int responseCode;
    private String responseMessageName;
    private Param method;
    private HttpURLConnection conn;
    IOException exception;
    String inputContentType = null;
    PartType inputType;
    PartType outputType;
    PartType faultType;
    private String xmlVersion = "1.0";
    int fileConunter = 0;
    XMLInputFactory factory = XMLInputFactory.newInstance();
    String lastQueryString = null;
    Element currentElement;
    Document document;
    Element rootElement;
    private StringBuilder text;
    Transformer transformer;
    String outputContentType;
    String outputEncoding;
    String inputEncoding;
    String faultEncoding;
    String tempFolder;

    public HttpOperation(RuntimeContext rc) {
        this.rc = rc;
    }

    public InputMode getInputMode() {
        return this.inputMode;
    }

    public void setInputMode(InputMode inputMode) {
        this.inputMode = inputMode;
    }

    public void openParameter(String localName, int paramType) {
        this.parameterStatus = false;
        if (this.currentParam == null) {
            this.currentParam = new Param(localName);
            if (paramType == 1) {
                this.queryEncodedParams.add(this.currentParam);
            } else if (paramType == 2) {
                this.contentEncodedParams.add(this.currentParam);
            } else if (paramType == 3) {
                this.headerParams.add(this.currentParam);
            } else if (paramType == 4 || paramType == 9) {
                this.queryReplacementParams.add(this.currentParam);
                if (paramType == 9) {
                    this.currentParam.setEncode(false);
                }
            } else if (paramType == 5) {
                this.responseCodeName = localName;
            } else if (paramType == 6) {
                this.outputHeaderParamsName.add(localName);
            } else if (paramType == 7) {
                this.responseMessageName = localName;
            } else if (paramType == 8) {
                this.method = this.currentParam;
            } else if (paramType == 10) {
                this.errorMessageName = localName;
            } else if (paramType == 11) {
                this.errorExceptionName = localName;
            }
        }
    }

    public void closeParameter() {
        this.currentParam = null;
        this.parameterStatus = true;
    }

    public void addParameterValue(String string) {
        this.currentParam.setValue(string);
    }

    public void setOauth(OAuthMetadata oauth) {
        this.oauth = oauth;
    }

    public void setNtlmMetadata(NtlmMetadata ntlmMetadata) {
        this.ntlmMetadata = ntlmMetadata;
    }

    private void setRequestMethod(HttpURLConnection c, String value) {
        try {
            Object target;
            if (c.getClass().getName().equals("sun.net.www.protocol.https.HttpsURLConnectionImpl")) {
                Field delegate = c.getClass().getDeclaredField("delegate");
                delegate.setAccessible(true);
                target = delegate.get(c);
            } else {
                target = c;
            }
            Field f = HttpURLConnection.class.getDeclaredField("method");
            f.setAccessible(true);
            f.set(target, value);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    HttpURLConnection getConnection() throws Exception {
        String urlString = this.getUrlString();
        URL url = this.initURL(urlString);
        Proxy proxy = this.ctx.getProxy();
        final HttpURLConnection localConn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        if (localConn instanceof HttpsURLConnection) {
            if (this.ctx.getHostnameVerifier() != null) {
                ((HttpsURLConnection)localConn).setHostnameVerifier(this.ctx.getHostnameVerifier());
            }
            if (this.ctx.getSslSocketFactory() != null) {
                ((HttpsURLConnection)localConn).setSSLSocketFactory(this.ctx.getSslSocketFactory());
            }
        }
        this.ctx.secret((ISecretStatement)new ISecretStatement<Object>(){

            public Object execute(ISecretContext context) throws Throwable {
                URLUtil.setUserHeader((URLConnection)localConn, (String)HttpOperation.this.ctx.getUser(), (String)HttpOperation.this.ctx.getPassword().decryptString(context), (String)HttpOperation.this.ctx.getProxyUser(), (String)HttpOperation.this.ctx.getProxyPassword().decryptString(context));
                return null;
            }
        });
        String verb = null;
        verb = this.method != null && this.method.value != null ? this.method.value.toUpperCase() : ((HttpPort)this.port).verb.name();
        localConn.setReadTimeout(this.ctx.getReadTimeout());
        localConn.setConnectTimeout(this.ctx.getConnectionTimeout());
        if (this.ntlmMetadata != null) {
            this.addNtlmAuthenticator();
        }
        if (this.oauth != null) {
            String oauthHeader = null;
            TreeMap<String, String> parameters = new TreeMap<String, String>();
            if (this.queryEncodedParams.paramList != null) {
                for (Param param : this.queryEncodedParams.paramList) {
                    parameters.put(param.name, param.value);
                }
            }
            if (this.contentEncodedParams.paramList != null) {
                for (Param param : this.contentEncodedParams.paramList) {
                    parameters.put(param.name, param.value);
                }
            }
            oauthHeader = OAuth.generateHeader((String)urlString, (String)verb, (OAuthMetadata)this.oauth, parameters);
            localConn.setRequestProperty("Authorization", oauthHeader);
        }
        if (this.headerParams.paramList != null) {
            for (Param param : this.headerParams.paramList) {
                localConn.setRequestProperty(param.name, param.value);
            }
        }
        if (verb.equals("PATCH")) {
            this.setRequestMethod(localConn, verb);
        } else {
            localConn.setRequestMethod(verb);
        }
        this.addHeader(localConn);
        return localConn;
    }

    private void addNtlmAuthenticator() throws Exception {
        try {
            Method setAuthMethod = this.conn.getClass().getMethod("setAuthenticator", Authenticator.class);
            setAuthMethod.invoke((Object)this.conn, new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(HttpOperation.this.ntlmMetadata.getFullNtlmUser(), HttpOperation.this.ntlmMetadata.getNtlmPassword().toCharArray());
                }
            });
        }
        catch (NoSuchMethodException e) {
            throw new EngineExceptionI(Messages.getString("HttpOperation.0"));
        }
    }

    int call(HttpURLConnection conn) throws IOException {
        this.openedHttpConnections.add(conn);
        this.exception = null;
        this.responseMessage = null;
        this.responseCode = 0;
        this.conn = conn;
        try {
            this.serializeUrl(conn.getURL());
            this.is = conn.getInputStream();
            this.is = this.serializeInput(this.is);
            this.responseMessage = conn.getResponseMessage();
            this.responseCode = conn.getResponseCode();
            return 1;
        }
        catch (IOException e) {
            this.err = conn.getErrorStream();
            this.err = this.serializeInput(this.err);
            this.exception = e;
            try {
                this.responseMessage = conn.getResponseMessage();
                this.responseCode = conn.getResponseCode();
            }
            catch (Exception e2) {
                this.logger.warn(Messages.getString("HttpOperation.12"), (Throwable)e2);
            }
            return -1;
        }
        finally {
            this.openedHttpConnections.remove(conn);
            try {
                this.serializeResponseHeader(conn);
            }
            catch (Exception e) {
                this.logger.warn(Messages.getString("HttpOperation.12"), (Throwable)e);
            }
        }
    }

    private int getInvoke() throws Exception {
        HttpURLConnection tempConn = this.getConnection();
        tempConn.setDoOutput(true);
        return this.call(tempConn);
    }

    public void setFaultType(PartType faultType) {
        this.faultType = faultType;
    }

    public void setOutputPartType(PartType type) {
        this.outputType = type;
    }

    public void setInputContentType(String inputContentType) throws Exception {
        if (this.inputContentType != null && inputContentType != null && !this.inputContentType.equals(inputContentType)) {
            throw new Exception(Messages.getString("HttpOperation.1") + this.inputContentType + Messages.getString("HttpOperation.2") + inputContentType);
        }
        this.inputContentType = inputContentType;
    }

    private String getUrlString() throws UnsupportedEncodingException {
        String tempMethoddAdress = this.methodAddress;
        if (this.queryReplacementParams != null) {
            tempMethoddAdress = this.queryReplacementParams.replace(this.methodAddress, true);
        }
        return ((HttpPort)this.port).mainAdress + tempMethoddAdress;
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    private URL initURL(String urlString) throws UnsupportedEncodingException, MalformedURLException, SecurityException, IllegalArgumentException {
        this.lastQueryString = this.queryEncodedParams.encode();
        String sUrl = null;
        sUrl = urlString.contains("?") ? urlString + (String)(this.lastQueryString != null ? "&" + this.lastQueryString : "") : urlString + (String)(this.lastQueryString != null ? "?" + this.lastQueryString : "");
        this.msgName = Long.toString(System.currentTimeMillis());
        return new URL(sUrl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int postInvoke() throws Exception {
        HttpURLConnection localConn = null;
        try {
            block84: {
                Object var3_12;
                Throwable throwable;
                block83: {
                    localConn = this.getConnection();
                    localConn.setDoOutput(true);
                    localConn.setDoInput(true);
                    this.lastQueryString = this.contentEncodedParams.encode();
                    if (this.lastQueryString != null) {
                        localConn.setRequestProperty("Content-Type", this.inputContentType);
                        Throwable throwable2 = null;
                        Object var3_10 = null;
                        try (OutputStreamWriter wr = new OutputStreamWriter(localConn.getOutputStream());){
                            if (this.lastQueryString == null) return this.call(localConn);
                            wr.write(this.lastQueryString);
                            wr.flush();
                            return this.call(localConn);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    if (this.document == null && this.inputType == null) return this.call(localConn);
                    if (this.inputContentType != null) {
                        localConn.setRequestProperty("Content-Type", this.inputContentType);
                    }
                    this.serializeRequestHeader(localConn);
                    if (this.port.wsdl.sentMessagesFolder != null) {
                        throwable = null;
                        var3_12 = null;
                        try (FileOutputStream fos = new FileOutputStream(new File(this.port.wsdl.sentMessagesFolder, this.msgName + ".content.in"));){
                            if (this.document != null) {
                                if (this.inputType == PartType.JSON) {
                                    this.transformXmlToJson(fos, this.ctx.getEncoding(), this.inputEncoding);
                                } else {
                                    this.transformDocumentToOutputStream(new DOMSource(this.document), fos);
                                }
                                break block83;
                            }
                            if (this.inputType == PartType.STRING) {
                                Throwable throwable4 = null;
                                Object var6_26 = null;
                                try (ByteArrayInputStream fis = new ByteArrayInputStream(this.text.toString().getBytes());){
                                    IOUtils.copy((InputStream)fis, (OutputStream)fos);
                                    break block83;
                                }
                                catch (Throwable throwable5) {
                                    if (throwable4 == null) {
                                        throwable4 = throwable5;
                                        throw throwable4;
                                    } else {
                                        if (throwable4 == throwable5) throw throwable4;
                                        throwable4.addSuppressed(throwable5);
                                    }
                                    throw throwable4;
                                }
                            }
                            if (this.inputType == PartType.BINARY) {
                                Throwable throwable6 = null;
                                Object var6_28 = null;
                                try (ByteArrayInputStream fis = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)this.text.toString()));){
                                    IOUtils.copy((InputStream)fis, (OutputStream)fos);
                                    break block83;
                                }
                                catch (Throwable throwable7) {
                                    if (throwable6 == null) {
                                        throwable6 = throwable7;
                                        throw throwable6;
                                    } else {
                                        if (throwable6 == throwable7) throw throwable6;
                                        throwable6.addSuppressed(throwable7);
                                    }
                                    throw throwable6;
                                }
                            }
                            if (this.inputType != PartType.URI) break block83;
                            Throwable throwable8 = null;
                            Object var6_30 = null;
                            try (FileInputStream fis = new FileInputStream(new File(new URI(this.text.toString())));){
                                IOUtils.copy((InputStream)fis, (OutputStream)fos);
                            }
                            catch (Throwable throwable9) {
                                if (throwable8 == null) {
                                    throwable8 = throwable9;
                                    throw throwable8;
                                } else {
                                    if (throwable8 == throwable9) throw throwable8;
                                    throwable8.addSuppressed(throwable9);
                                }
                                throw throwable8;
                            }
                        }
                        catch (Throwable throwable10) {
                            if (throwable == null) {
                                throwable = throwable10;
                                throw throwable;
                            } else {
                                if (throwable == throwable10) throw throwable;
                                throwable.addSuppressed(throwable10);
                            }
                            throw throwable;
                        }
                    }
                }
                if (this.document != null) {
                    if (this.inputType == null || this.inputType != PartType.JSON) {
                        this.transformDocumentToOutputStream(new DOMSource(this.document), localConn.getOutputStream());
                    } else {
                        this.transformXmlToJson(localConn.getOutputStream(), this.ctx.getEncoding(), this.inputEncoding);
                    }
                } else {
                    InputStream fis;
                    if (this.inputType == PartType.STRING) {
                        throwable = null;
                        var3_12 = null;
                        try {
                            fis = new ByteArrayInputStream(this.text.toString().getBytes());
                            try {
                                this.text = null;
                                IOUtils.copy((InputStream)fis, (OutputStream)localConn.getOutputStream());
                                break block84;
                            }
                            finally {
                                if (fis != null) {
                                    fis.close();
                                }
                            }
                        }
                        catch (Throwable throwable11) {
                            if (throwable == null) {
                                throwable = throwable11;
                                throw throwable;
                            } else {
                                if (throwable == throwable11) throw throwable;
                                throwable.addSuppressed(throwable11);
                            }
                            throw throwable;
                        }
                    }
                    if (this.inputType == PartType.BINARY) {
                        throwable = null;
                        var3_12 = null;
                        try {
                            fis = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)this.text.toString()));
                            try {
                                this.text = null;
                                IOUtils.copy((InputStream)fis, (OutputStream)localConn.getOutputStream());
                                break block84;
                            }
                            finally {
                                if (fis != null) {
                                    fis.close();
                                }
                            }
                        }
                        catch (Throwable throwable12) {
                            if (throwable == null) {
                                throwable = throwable12;
                                throw throwable;
                            } else {
                                if (throwable == throwable12) throw throwable;
                                throwable.addSuppressed(throwable12);
                            }
                            throw throwable;
                        }
                    }
                    if (this.inputType == PartType.URI) {
                        throwable = null;
                        var3_12 = null;
                        try {
                            fis = new FileInputStream(new File(new URI(this.text.toString())));
                            try {
                                this.text = null;
                                IOUtils.copy((InputStream)fis, (OutputStream)localConn.getOutputStream());
                            }
                            finally {
                                if (fis != null) {
                                    fis.close();
                                }
                            }
                        }
                        catch (Throwable throwable13) {
                            if (throwable == null) {
                                throwable = throwable13;
                                throw throwable;
                            } else {
                                if (throwable == throwable13) throw throwable;
                                throwable.addSuppressed(throwable13);
                            }
                            throw throwable;
                        }
                    }
                }
            }
            this.text = null;
            return this.call(localConn);
        }
        catch (IOException e) {
            this.exception = e;
            if (localConn == null) return -1;
            this.err = localConn.getErrorStream();
            this.err = this.serializeInput(this.err);
            try {
                this.responseMessage = localConn.getResponseMessage();
                this.responseCode = localConn.getResponseCode();
                return -1;
            }
            catch (Exception e2) {
                this.logger.warn(Messages.getString("HttpOperation.12"), (Throwable)e);
            }
            return -1;
        }
    }

    private int invoke2(boolean isOnFail) throws Exception {
        this.is = null;
        this.err = null;
        int ret = 0;
        if (this.ctx.getDelayBetweenInvocation() > 0 && !isOnFail) {
            Thread.sleep(this.ctx.getDelayBetweenInvocation());
        }
        ret = this.isGetOrDeleteVerb() ? this.getInvoke() : this.postInvoke();
        return ret;
    }

    public HttpVerb getVerb() {
        if (this.method != null && this.method.value != null) {
            return HttpVerb.valueOf(this.method.value.toUpperCase());
        }
        return ((HttpPort)this.port).verb;
    }

    public boolean isGetOrDeleteVerb() {
        HttpVerb verb = this.getVerb();
        return verb == HttpVerb.GET || verb == HttpVerb.DELETE;
    }

    @Override
    public void clear() {
        this.queryEncodedParams = new Params();
        this.contentEncodedParams = new Params();
        this.headerParams = new Params();
        this.queryReplacementParams = new Params();
        this.outputHeaderParamsName.clear();
        this.responseCodeName = null;
        this.responseMessageName = null;
        this.errorExceptionName = null;
        this.errorMessageName = null;
        this.inputContentType = null;
        this.lastQueryString = null;
        this.method = null;
        this.conn = null;
    }

    @Override
    public int invoke() throws Exception {
        if (this.parameterStatus) {
            int technicalErrorCount = 0;
            int functionalErrorCount = 0;
            while (technicalErrorCount <= this.ctx.getTechnicalErrorRetryNumber() && functionalErrorCount <= this.ctx.getRetryNumber()) {
                int ret = this.invoke2(technicalErrorCount + functionalErrorCount > 0);
                if (ret == 1) {
                    return 1;
                }
                if (this.responseCode == 0) {
                    if (this.ctx.getTechnicalErrorRetryDelay() <= 0 || ++technicalErrorCount > this.ctx.getTechnicalErrorRetryNumber()) continue;
                    Thread.sleep(this.ctx.getTechnicalErrorRetryDelay().intValue());
                    continue;
                }
                if (this.ctx.getRetryDelay() <= 0 || ++functionalErrorCount > this.ctx.getRetryNumber()) continue;
                Thread.sleep(this.ctx.getRetryDelay());
            }
        }
        if (this.responseCode == 0 && this.responseMessage == null) {
            ++this.port.wsdl.technicalErrorNumber;
            if (this.ctx.getTechnicalErrorAcceptanceNumber() > -1 && this.port.wsdl.technicalErrorNumber > this.ctx.getTechnicalErrorAcceptanceNumber()) {
                throw this.exception;
            }
        } else {
            ++this.port.wsdl.errorNumber;
        }
        if (this.port.wsdl.errorAcceptanceNumber > -1 && this.port.wsdl.errorAcceptanceNumber < this.port.wsdl.errorNumber) {
            throw new IOException(Messages.getString("HttpOperation.3") + this.port.wsdl.errorNumber + ")", this.exception);
        }
        return -1;
    }

    @Override
    public void writeMessage(AbstractXmlWriterAPI xwa, String localName, String firstLocalName) throws EngineExceptionI {
        block66: {
            if (this.outputHeaderParamsName.contains(localName) && this.conn != null) {
                try {
                    String header = this.conn.getHeaderField(localName);
                    if (header != null) {
                        xwa.getXMLStreamWriter().writeCharacters(header);
                    }
                }
                catch (XMLStreamException e) {
                    this.logger.warn(Messages.getString("HttpOperation.12"), (Throwable)e);
                }
            } else if (this.responseCodeName != null && this.responseCodeName.equals(localName)) {
                try {
                    xwa.getXMLStreamWriter().writeCharacters(String.valueOf(this.responseCode));
                }
                catch (XMLStreamException e) {
                    this.logger.warn(Messages.getString("HttpOperation.12"), (Throwable)e);
                }
            } else if (this.responseMessageName != null && this.responseMessageName.equals(localName) && this.responseMessage != null) {
                try {
                    xwa.getXMLStreamWriter().writeCharacters(this.responseMessage);
                }
                catch (XMLStreamException e) {
                    this.logger.warn(Messages.getString("HttpOperation.12"), (Throwable)e);
                }
            } else if (this.errorMessageName != null && this.errorMessageName.equals(localName)) {
                try {
                    if (this.exception != null) {
                        xwa.getXMLStreamWriter().writeCharacters(this.exception.getLocalizedMessage());
                    }
                }
                catch (XMLStreamException e) {
                    this.logger.warn(Messages.getString("HttpOperation.12"), (Throwable)e);
                }
            } else if (this.errorExceptionName != null && this.errorExceptionName.equals(localName)) {
                try {
                    if (this.exception != null) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw322 = new PrintWriter(sw);
                        this.exception.printStackTrace(pw322);
                        xwa.getXMLStreamWriter().writeCharacters(sw.toString());
                    }
                }
                catch (XMLStreamException e) {
                    this.logger.warn(Messages.getString("HttpOperation.12"), (Throwable)e);
                }
            } else if (this.is != null) {
                try {
                    if (this.outputType == PartType.BINARY) {
                        Throwable e = null;
                        Object pw322 = null;
                        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                            IOUtils.copy((InputStream)this.is, (OutputStream)baos);
                            xwa.getXMLStreamWriter().writeCharacters(DatatypeConverter.printBase64Binary((byte[])baos.toByteArray()));
                            break block66;
                        }
                        catch (Throwable pw322) {
                            if (e == null) {
                                e = pw322;
                            } else if (e != pw322) {
                                e.addSuppressed(pw322);
                            }
                            throw e;
                        }
                    }
                    if (this.outputType == PartType.STRING) {
                        Throwable e = null;
                        Object pw322 = null;
                        try (ByteArrayOutputStream baos22 = new ByteArrayOutputStream();){
                            IOUtils.copy((InputStream)this.is, (OutputStream)baos22);
                            xwa.getXMLStreamWriter().writeCharacters(DatatypeConverter.printString((String)new String(baos22.toByteArray(), StandardCharsets.UTF_8)));
                            break block66;
                        }
                        catch (Throwable pw322) {
                            if (e == null) {
                                e = pw322;
                            } else if (e != pw322) {
                                e.addSuppressed(pw322);
                            }
                            throw e;
                        }
                    }
                    if (this.outputType == PartType.URI) {
                        File file = new File(this.tempFolder + File.separator + this.uuid + "_" + this.fileConunter++ + ".data");
                        Throwable pw322 = null;
                        Object baos22 = null;
                        try (FileOutputStream os = new FileOutputStream(file);){
                            IOUtils.copy((InputStream)this.is, (OutputStream)os);
                            xwa.getXMLStreamWriter().writeCharacters(file.toURI().toASCIIString());
                            break block66;
                        }
                        catch (Throwable baos22) {
                            if (pw322 == null) {
                                pw322 = baos22;
                            } else if (pw322 != baos22) {
                                pw322.addSuppressed(baos22);
                            }
                            throw pw322;
                        }
                    }
                    InputStream tempInputStream = this.is;
                    if (this.outputType == PartType.JSON) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        JsonUtils.convertJsonToXml((InputStream)this.is, (OutputStream)baos, (String)this.outputEncoding, (String)this.ctx.getEncoding(), (boolean)false, (boolean)true, null, (String)this.xmlVersion);
                        tempInputStream = new ByteArrayInputStream(baos.toByteArray());
                    }
                    try (XMLStreamReader xsr = this.factory.createXMLStreamReader(tempInputStream, this.ctx.getEncoding());){
                        XmlReaderToWriter xw = XmlReaderToWriter.createInstance();
                        if (this.outputType == PartType.JSON) {
                            xw.setSkipProof(1);
                        }
                        xw.writeAll(xsr, xwa.getXMLStreamWriter());
                    }
                }
                catch (Exception e) {
                    InputStreamReader isr = new InputStreamReader(this.is);
                    StringBuilder sb = new StringBuilder();
                    int c = -1;
                    do {
                        if (c != -1) {
                            sb.append((char)c);
                        }
                        try {
                            c = isr.read();
                        }
                        catch (IOException e1) {
                            this.logger.warn("unexpected", (Throwable)e1);
                        }
                    } while (c != -1);
                    if (this.lastQueryString != null) {
                        throw new EngineExceptionI("Query: " + this.lastQueryString + "\nResponse: " + String.valueOf(sb), (Throwable)e);
                    }
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean stopOpenOrClose() {
        return this.state == Operation.OperationState.OUTPUT && this.outputPartState == Operation.PartState.OPEN || this.state == Operation.OperationState.FAULT && this.faultPartState == Operation.PartState.OPEN;
    }

    @Override
    public void writeFault(AbstractXmlWriterAPI xwa) throws EngineExceptionI {
        block48: {
            if (this.err != null) {
                XMLInputFactory localFactory = XMLInputFactory.newInstance();
                localFactory.setProperty("javax.xml.stream.supportDTD", false);
                localFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                try {
                    if (this.faultType == PartType.BINARY) {
                        Throwable throwable = null;
                        Object var4_10 = null;
                        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                            IOUtils.copy((InputStream)this.err, (OutputStream)baos);
                            xwa.getXMLStreamWriter().writeCharacters(DatatypeConverter.printBase64Binary((byte[])baos.toByteArray()));
                            break block48;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    if (this.faultType == PartType.STRING) {
                        Throwable throwable = null;
                        Object var4_12 = null;
                        try (ByteArrayOutputStream baos322 = new ByteArrayOutputStream();){
                            IOUtils.copy((InputStream)this.err, (OutputStream)baos322);
                            xwa.getXMLStreamWriter().writeCharacters(DatatypeConverter.printString((String)new String(baos322.toByteArray(), StandardCharsets.UTF_8)));
                            break block48;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    if (this.faultType == PartType.URI) {
                        File file = new File(this.tempFolder + File.separator + this.uuid + "_" + this.fileConunter++ + ".data");
                        Throwable throwable = null;
                        Object baos322 = null;
                        try (FileOutputStream os = new FileOutputStream(file);){
                            IOUtils.copy((InputStream)this.err, (OutputStream)os);
                            xwa.getXMLStreamWriter().writeCharacters(file.toURI().toASCIIString());
                            break block48;
                        }
                        catch (Throwable baos322) {
                            if (throwable == null) {
                                throwable = baos322;
                            } else if (throwable != baos322) {
                                throwable.addSuppressed(baos322);
                            }
                            throw throwable;
                        }
                    }
                    InputStream tempInputStream = this.err;
                    if (this.faultType == PartType.JSON) {
                        Throwable throwable = null;
                        Object baos322 = null;
                        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                            JsonUtils.convertJsonToXml((InputStream)this.err, (OutputStream)baos, (String)this.outputEncoding, (String)this.ctx.getEncoding(), (boolean)false, (boolean)true, null, (String)this.xmlVersion);
                            tempInputStream = new ByteArrayInputStream(baos.toByteArray());
                        }
                        catch (Throwable baos322) {
                            if (throwable == null) {
                                throwable = baos322;
                            } else if (throwable != baos322) {
                                throwable.addSuppressed(baos322);
                            }
                            throw throwable;
                        }
                    }
                    try (XMLStreamReader xsr = localFactory.createXMLStreamReader(tempInputStream, this.ctx.getEncoding());){
                        XmlReaderToWriter xw = XmlReaderToWriter.createInstance();
                        if (this.faultType == PartType.JSON) {
                            xw.setSkipProof(1);
                        }
                        int nbelt = xw.writeAll(xsr, xwa.getXMLStreamWriter());
                        xwa.incNbOpenedElement(nbelt);
                    }
                }
                catch (Exception e) {
                    this.logger.warn(Messages.getString("HttpOperation.12"), (Throwable)e);
                    if (this.responseMessage != null) {
                        throw new EngineExceptionI(this.responseMessage, (Throwable)this.exception);
                    }
                    throw new EngineExceptionI((Throwable)this.exception);
                }
            }
        }
    }

    private void addHeader(HttpURLConnection conn) {
        if (this.port.wsdl.headerParameters != null) {
            for (String key : this.port.wsdl.headerParameters.keySet()) {
                String value = this.port.wsdl.headerParameters.get(key);
                conn.addRequestProperty(key, value);
            }
        }
    }

    private void serializeUrl(URL url) throws IOException {
        if (this.port.wsdl.sentMessagesFolder != null) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileOutputStream fos = new FileOutputStream(new File(this.port.wsdl.sentMessagesFolder, this.msgName + ".in"));){
                fos.write(url.toString().getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void serializeRequestHeader(HttpURLConnection conn) throws IOException {
        if (this.port.wsdl.sentMessagesFolder == null) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream fos = new FileOutputStream(new File(this.port.wsdl.sentMessagesFolder, this.msgName + ".header.in"));){
            Map<String, List<String>> header = conn.getRequestProperties();
            if (header != null) {
                for (Map.Entry<String, List<String>> entry : header.entrySet()) {
                    for (String value : entry.getValue()) {
                        if (entry.getKey() != null) {
                            fos.write(entry.getKey().getBytes());
                            fos.write(": ".getBytes());
                        }
                        if (value == null) continue;
                        fos.write(value.getBytes());
                        fos.write("\n".getBytes());
                    }
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private InputStream serializeInput(InputStream is) throws IOException {
        if (this.port.wsdl.receivedMessagesFolder != null && is != null) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileOutputStream fos = new FileOutputStream(new File(this.port.wsdl.receivedMessagesFolder, this.msgName + ".out"));){
                return HttpOperation.transformToByteArrayInputStream(is, fos);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return is;
    }

    private void serializeResponseHeader(HttpURLConnection conn) throws IOException {
        if (this.port.wsdl.receivedMessagesFolder == null) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream fos = new FileOutputStream(new File(this.port.wsdl.receivedMessagesFolder, this.msgName + ".header.out"));){
            Map<String, List<String>> header = conn.getHeaderFields();
            if (header != null) {
                for (Map.Entry<String, List<String>> entry : header.entrySet()) {
                    for (String value : entry.getValue()) {
                        if (entry.getKey() != null) {
                            fos.write(entry.getKey().getBytes());
                            fos.write(": ".getBytes());
                        }
                        if (value == null) continue;
                        fos.write(value.getBytes());
                        fos.write("\n".getBytes());
                    }
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static ByteArrayInputStream transformToByteArrayInputStream(InputStream is, OutputStream os) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        baos.reset();
        while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, n);
            os.write(buffer, 0, n);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    @Override
    public Element openElement(String localName, String nameSpaceURI, String forcePrefix) throws Exception {
        Element newElement;
        if (this.text != null) {
            this.text = null;
        }
        if (this.currentElement == null) {
            this.initInputDocument();
        }
        if ((nameSpaceURI == null || nameSpaceURI.isEmpty()) && this.port.wsdl.prefixElement && this.port.wsdl.targetNamespace != null) {
            nameSpaceURI = this.port.wsdl.targetNamespace;
        }
        if (nameSpaceURI != null && !nameSpaceURI.isEmpty()) {
            if (forcePrefix != null && !forcePrefix.isEmpty()) {
                newElement = this.document.createElementNS(nameSpaceURI, forcePrefix + ":" + localName);
            } else {
                String prefix = (String)this.port.wsdl.namespaces.getFrom((Object)nameSpaceURI);
                if (prefix == null) {
                    prefix = (String)this.port.wsdl.globalNamespaces.getFrom((Object)nameSpaceURI);
                }
                newElement = prefix != null ? this.document.createElementNS(nameSpaceURI, prefix + ":" + localName) : this.document.createElement(localName);
            }
        } else {
            newElement = this.document.createElement(localName);
        }
        if (this.currentElement == null) {
            if (this.rootElement != null) {
                this.rootElement.appendChild(newElement);
            } else {
                this.document.appendChild(newElement);
            }
        } else if (newElement != null) {
            this.currentElement.appendChild(newElement);
        }
        this.currentElement = newElement;
        return this.currentElement;
    }

    private void initInputDocument() throws ParserConfigurationException {
        DocumentBuilderFactory localFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = localFactory.newDocumentBuilder();
        this.document = builder.newDocument();
        if (this.inputType == PartType.JSON) {
            this.rootElement = this.document.createElement("superRoot");
            this.rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.document.appendChild(this.rootElement);
        }
    }

    @Override
    public void setAttribute(String paramName, String value) throws Exception {
        this.currentElement.setAttribute(paramName, value);
    }

    @Override
    public void addText(String text) throws Exception {
        if (this.text == null) {
            this.text = new StringBuilder();
        }
        this.text.append(text);
    }

    @Override
    public void endElement() throws Exception {
        if (this.text != null && this.getInputMode() == InputMode.XML) {
            this.currentElement.appendChild(this.document.createTextNode(this.text.toString()));
            this.text = null;
        }
        if (this.currentElement.getParentNode() instanceof Element) {
            this.currentElement = (Element)this.currentElement.getParentNode();
        }
    }

    private void transformXmlToJson(OutputStream out, String inEncoding, String outEncoding) throws XMLStreamException, IOException, TransformerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.transformDocumentToOutputStream(new DOMSource(this.document), baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        JsonUtils.convertXmlToJson((InputStream)bais, (OutputStream)out, (String)inEncoding, (String)outEncoding, (int)1);
    }

    void transformDocumentToOutputStream(DOMSource source, OutputStream out) throws TransformerException {
        if (this.transformer == null) {
            TransformerFactory tFactory = TransformerFactory.newInstance(TransformerFactoryImpl.class.getName(), null);
            tFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            this.transformer = tFactory.newTransformer();
        }
        StreamResult result = new StreamResult(out);
        this.transformer.transform(source, result);
    }

    public void setOutputContentType(String outputContentType) throws Exception {
        if (this.outputContentType != null && outputContentType != null && !this.outputContentType.equals(outputContentType)) {
            throw new Exception(Messages.getString("HttpOperation.4") + this.outputContentType + Messages.getString("HttpOperation.5") + outputContentType);
        }
        this.outputContentType = outputContentType;
    }

    public void setOutputEncoding(String outputEncoding) throws IllegalArgumentException {
        if (this.outputEncoding != null && outputEncoding != null && !this.outputEncoding.equals(outputEncoding)) {
            throw new IllegalArgumentException(Messages.getString("HttpOperation.6") + this.outputEncoding + Messages.getString("HttpOperation.7") + outputEncoding);
        }
        this.outputEncoding = outputEncoding;
    }

    public void setInputEncoding(String inputEncoding) throws IllegalArgumentException {
        if (this.inputEncoding != null && inputEncoding != null && !this.inputEncoding.equals(inputEncoding)) {
            throw new IllegalArgumentException(Messages.getString("HttpOperation.8") + this.inputEncoding + Messages.getString("HttpOperation.9") + inputEncoding);
        }
        this.inputEncoding = inputEncoding;
    }

    public void setFaultEncoding(String faultEncoding) throws IllegalArgumentException {
        if (this.faultEncoding != null && faultEncoding != null && !this.faultEncoding.equals(faultEncoding)) {
            throw new IllegalArgumentException(Messages.getString("HttpOperation.10") + this.faultEncoding + Messages.getString("HttpOperation.11") + faultEncoding);
        }
        this.faultEncoding = faultEncoding;
    }

    public void setInputPartType(PartType type) {
        this.inputType = type;
    }

    public void setTemporaryFolder(String tempFolder) {
        this.tempFolder = tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killOpenedConnections() {
        Set<HttpURLConnection> set = this.openedHttpConnections;
        synchronized (set) {
            for (HttpURLConnection c : this.openedHttpConnections) {
                try {
                    c.disconnect();
                }
                catch (Exception ex) {
                    this.logger.warn(Messages.getString("HttpOperation.12"), (Throwable)ex);
                }
            }
            this.openedHttpConnections.clear();
        }
    }

    public void setUrlEncoding(String urlEncoding) {
        this.urlEncoding = urlEncoding;
    }

    public void setMethodAddress(String methodAddress) {
        this.methodAddress = methodAddress;
    }

    public static enum HttpVerb {
        GET,
        DELETE,
        POST,
        PUT,
        PATCH;

    }

    public static enum InputMode {
        PARAM,
        XML,
        HEADER,
        RAW;

    }

    public class Param {
        boolean encode = true;
        String name;
        String value;

        public Param(String localName) {
            this.name = localName;
        }

        public void setEncode(boolean encode) {
            this.encode = encode;
        }

        public String getEncodedValue() throws UnsupportedEncodingException {
            if (this.encode) {
                if (HttpOperation.this.urlEncoding != null) {
                    return URLEncoder.encode(this.value, HttpOperation.this.urlEncoding);
                }
                return URLEncoder.encode(this.value);
            }
            return this.value;
        }

        public void setValue(String value) {
            this.value = this.value == null ? value : String.valueOf(this.value) + value;
        }
    }

    private class Params {
        List<Param> paramList;

        private Params() {
        }

        private void add(Param add) {
            if (this.paramList == null) {
                this.paramList = new ArrayList<Param>();
            }
            this.paramList.add(add);
        }

        private void appendParameterInQuery(StringBuilder queryString, Param param) throws IllegalArgumentException {
            if (!queryString.isEmpty()) {
                queryString.append("&");
            }
            String name = param.name;
            try {
                if (name.startsWith("_.") && name.endsWith("._")) {
                    name = name.substring(2, name.length() - 2);
                    name = JsonUtils.decodeHexString((String)name);
                    if (!HttpOperation.this.disableParamsEncoding) {
                        name = HttpOperation.this.urlEncoding != null ? URLEncoder.encode(name, HttpOperation.this.urlEncoding) : URLEncoder.encode(name);
                    }
                }
                queryString.append(String.format("%s=%s", name, param.getEncodedValue()));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }

        private String encode() throws UnsupportedEncodingException {
            if (this.paramList == null) {
                return null;
            }
            StringBuilder queryString = new StringBuilder();
            try {
                this.paramList.stream().filter(p -> p != null && p.name != null && p.value != null).forEach(p -> this.appendParameterInQuery(queryString, (Param)p));
            }
            catch (IllegalArgumentException e) {
                throw (UnsupportedEncodingException)e.getCause();
            }
            return queryString.toString();
        }

        public String replace(String methodAddress, boolean replacePlus) throws UnsupportedEncodingException {
            String tempMethodAddress = methodAddress;
            if (this.paramList == null) {
                return methodAddress;
            }
            for (Param param : this.paramList) {
                String replace = param.getEncodedValue();
                if (replacePlus) {
                    replace = replace.replace("+", "%20");
                }
                tempMethodAddress = tempMethodAddress.replace("{" + param.name + "}", replace);
            }
            return tempMethodAddress;
        }
    }

    public static enum PartType {
        BINARY,
        STRING,
        JSON,
        URI;


        public static PartType fromMdType(String mdType) {
            return switch (mdType) {
                case "base64Binary" -> BINARY;
                case "string" -> BINARY;
                case "anyURI" -> BINARY;
                default -> null;
            };
        }
    }
}

