/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.wsdl;

import com.indy.engine.actionCodes.wsdl.Messages;
import com.indy.engine.actionCodes.wsdl.Operation;
import com.indy.engine.actionCodes.wsdl.SoapPort;
import com.indy.engine.actionCodes.xml.unload.AbstractXmlWriterAPI;
import com.indy.engine.common.ntlm.NtlmMetadata;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.runtime.utils.IOUtils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.net.proxy.URLUtil;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.Node;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPConnection;
import jakarta.xml.soap.SOAPConnectionFactory;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.CharacterData;
import org.w3c.dom.NodeList;

public class SoapOperation
extends Operation {
    private static final String SOAP_ACTION = "SOAPAction";
    private SoapStyle style;
    private String actionURI;
    private String attachmentsFolder;
    private SOAPConnection connection;
    private SOAPMessage message;
    private SOAPElement currentElement;
    private StringBuilder text;
    private SOAPMessage reply;
    private SOAPEnvelope envelope;
    private static SOAPConnectionFactory factory;
    private String errorMessageName;
    private String errorExceptionName;
    private Exception exception;
    private boolean rpcOperationISOpen = false;
    boolean enloseActionByQUote = false;
    private String xsiPrefix = "xsi";
    private static final String XSI_STD_PREFIX = "xsi";
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private NtlmMetadata ntlmMetadata;

    public void startMessage() throws SOAPException, ScriptException {
        if (this.currentElement == null) {
            if (this.ctx.isActiveScripting() && this.ctx.getSoapStartMessageScript() != null) {
                this.ctx.getBindings().put("operation", (Object)this);
                if (this.ctx.getCompiledScripts() != null && this.ctx.getEngine() instanceof Compilable) {
                    CompiledScript script = this.ctx.getCompiledScripts().get("soapStartMessageScript");
                    if (script == null) {
                        Compilable compilingEngine = (Compilable)((Object)this.ctx.getEngine());
                        script = compilingEngine.compile(this.ctx.getSoapStartMessageScript());
                        this.ctx.getCompiledScripts().put("soapStartMessageScript", script);
                    }
                    script.eval(this.ctx.getBindings());
                } else {
                    this.ctx.getEngine().eval(this.ctx.getSoapStartMessageScript());
                }
            } else {
                if (factory == null) {
                    factory = SOAPConnectionFactory.newInstance();
                }
                this.connection = factory.createConnection();
                MessageFactory messageFactory = MessageFactory.newInstance();
                this.message = messageFactory.createMessage();
                SOAPPart soapPart = this.message.getSOAPPart();
                this.envelope = soapPart.getEnvelope();
                boolean xsiPrefixAlread = false;
                for (Object prefix : this.port.wsdl.globalNamespaces.keySet()) {
                    String uri = (String)this.port.wsdl.globalNamespaces.get(prefix);
                    this.envelope.addNamespaceDeclaration((String)prefix, uri);
                    if (uri.equals(XSI_URI)) {
                        this.xsiPrefix = (String)prefix;
                    }
                    if (!prefix.equals(XSI_STD_PREFIX)) continue;
                    xsiPrefixAlread = true;
                }
                if (this.xsiPrefix == null) {
                    if (xsiPrefixAlread) {
                        this.xsiPrefix = "xsiStb";
                    }
                    this.envelope.addNamespaceDeclaration(this.xsiPrefix, XSI_URI);
                }
            }
        }
    }

    public void setCurrentElementToBody() throws SOAPException {
        this.currentElement = this.envelope.getBody();
    }

    public void setCurrentElementToHeader() throws SOAPException {
        this.currentElement = this.envelope.getHeader();
    }

    public SOAPElement openElement(String localName, String nameSpaceURI, String forcePrefix) throws SOAPException {
        this.text = null;
        if ((nameSpaceURI == null || nameSpaceURI.isEmpty()) && (this.currentElement instanceof SOAPBody || this.port.wsdl.prefixElement) && this.port.wsdl.targetNamespace != null) {
            nameSpaceURI = this.port.wsdl.targetNamespace;
        }
        if (nameSpaceURI != null && !nameSpaceURI.isEmpty()) {
            if (forcePrefix != null && !forcePrefix.isEmpty()) {
                this.currentElement = this.currentElement.addChildElement(localName, forcePrefix, nameSpaceURI);
            } else {
                String prefix = (String)this.port.wsdl.namespaces.getFrom((Object)nameSpaceURI);
                if (prefix == null) {
                    prefix = (String)this.port.wsdl.globalNamespaces.getFrom((Object)nameSpaceURI);
                }
                this.currentElement = prefix != null ? this.currentElement.addChildElement(localName, prefix, nameSpaceURI) : this.currentElement.addChildElement(localName);
            }
        } else {
            this.currentElement = this.currentElement.addChildElement(localName);
        }
        return this.currentElement;
    }

    @Override
    public void addText(String text) throws SOAPException {
        if (this.text == null) {
            this.text = new StringBuilder();
        }
        this.text.append(text);
    }

    @Override
    public void setAttribute(String name, String value) throws SOAPException {
        this.currentElement.setAttribute(name, value);
    }

    @Override
    public void endElement() throws SOAPException {
        if (this.text != null) {
            this.currentElement.addTextNode(this.text.toString());
            this.text = null;
        }
        this.currentElement = this.currentElement.getParentElement();
    }

    public void setEnloseActionByQUote(boolean enloseActionByQUote) {
        this.enloseActionByQUote = enloseActionByQUote;
    }

    public void setNtlmMetadata(NtlmMetadata ntlmMetadata) {
        this.ntlmMetadata = ntlmMetadata;
    }

    public void addHeader() throws SOAPException {
        MimeHeaders headers = this.message.getMimeHeaders();
        if (this.actionURI != null && !this.actionURI.isEmpty()) {
            if (headers.getHeader(SOAP_ACTION) != null) {
                headers.removeHeader(SOAP_ACTION);
            }
            if (this.enloseActionByQUote) {
                headers.addHeader(SOAP_ACTION, "\"" + this.actionURI + "\"");
            } else {
                headers.addHeader(SOAP_ACTION, this.actionURI);
            }
        }
        this.message.saveChanges();
    }

    private SOAPMessage doInvoke(URL url, String msgName, Boolean isOnRetry) throws InterruptedException, SOAPException, IOException {
        SOAPMessage result = null;
        if (this.ctx.getDelayBetweenInvocation() > 0 && Boolean.TRUE.equals(isOnRetry == false)) {
            Thread.sleep(this.ctx.getDelayBetweenInvocation());
        }
        result = this.connection.call(this.message, (Object)url);
        if (this.port.wsdl.receivedMessagesFolder != null && result != null) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileOutputStream fos = new FileOutputStream(new File(this.port.wsdl.receivedMessagesFolder, msgName + ".out"));){
                result.writeTo((OutputStream)fos);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public int invoke() throws Exception {
        this.isAlreadyInvokated = true;
        this.addHeader();
        String msgName = Long.toString(System.currentTimeMillis());
        if (this.port.wsdl.sentMessagesFolder != null) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileOutputStream fos = new FileOutputStream(new File(this.port.wsdl.sentMessagesFolder, msgName + ".in"));){
                this.message.writeTo((OutputStream)fos);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        final Proxy proxy = this.ctx.getProxy();
        URL url = (URL)this.ctx.secret((ISecretStatement)new ISecretStatement<URL>(){

            public URL execute(ISecretContext context) throws Throwable {
                URL url = SoapOperation.this.ntlmMetadata != null ? URLUtil.createURL((String)((SoapPort)SoapOperation.this.port).address, (URLUtil.AuthenticationType)URLUtil.AuthenticationType.NTLM, (String)SoapOperation.this.ntlmMetadata.getFullNtlmUser(), (String)SoapOperation.this.ntlmMetadata.getNtlmPassword(), (Proxy)proxy, (String)SoapOperation.this.ctx.getProxyUser(), (String)SoapOperation.this.ctx.getProxyPassword().decryptString(context), (SSLSocketFactory)SoapOperation.this.ctx.getSslSocketFactory(), (HostnameVerifier)SoapOperation.this.ctx.getHostnameVerifier()) : URLUtil.createURL((String)((SoapPort)SoapOperation.this.port).address, (URLUtil.AuthenticationType)URLUtil.AuthenticationType.BASIC, (String)SoapOperation.this.ctx.getUser(), (String)SoapOperation.this.ctx.getPassword().decryptString(context), (Proxy)proxy, (String)SoapOperation.this.ctx.getProxyUser(), (String)SoapOperation.this.ctx.getProxyPassword().decryptString(context), (SSLSocketFactory)SoapOperation.this.ctx.getSslSocketFactory(), (HostnameVerifier)SoapOperation.this.ctx.getHostnameVerifier());
                return url;
            }
        });
        this.exception = null;
        this.reply = null;
        int technicalErrorCount = 0;
        int functionalErrorCount = 0;
        while (technicalErrorCount <= this.ctx.getTechnicalErrorRetryNumber() && functionalErrorCount <= this.ctx.getRetryNumber()) {
            try {
                this.reply = null;
                this.reply = this.doInvoke(url, msgName, technicalErrorCount + functionalErrorCount > 0);
                if (this.reply == null || this.reply != null && this.reply.getSOAPBody().getFault() == null) break;
                if (this.reply != null && this.reply.getSOAPBody().getFault() != null && this.ctx.getRetryDelay() > 0 && ++functionalErrorCount <= this.ctx.getRetryNumber()) {
                    Thread.sleep(this.ctx.getRetryDelay());
                }
                this.exception = null;
            }
            catch (Exception e2) {
                Thread.currentThread().interrupt();
                this.exception = e2;
                if (this.ctx.getTechnicalErrorRetryDelay() <= 0 || ++technicalErrorCount > this.ctx.getTechnicalErrorRetryNumber()) continue;
                Thread.sleep(this.ctx.getTechnicalErrorRetryDelay().intValue());
            }
        }
        if (this.exception != null) {
            ++this.port.wsdl.technicalErrorNumber;
            if (this.ctx.getTechnicalErrorAcceptanceNumber() > -1 && this.port.wsdl.technicalErrorNumber > this.ctx.getTechnicalErrorAcceptanceNumber()) {
                throw this.exception;
            }
        }
        if (this.reply != null && this.reply.getSOAPBody().getFault() != null) {
            ++this.port.wsdl.errorNumber;
            if (this.port.wsdl.errorAcceptanceNumber > -1 && this.port.wsdl.errorAcceptanceNumber < this.port.wsdl.errorNumber) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                this.reply.writeTo((OutputStream)outStream);
                throw new EngineExceptionI(Messages.getString("SoapOperation.0") + this.port.wsdl.errorNumber + ")\n" + outStream.toString());
            }
            return -1;
        }
        return 1;
    }

    @Override
    public void writeMessage(AbstractXmlWriterAPI xwa, String localName, String firstLocalName) throws EngineExceptionI {
        try {
            if (this.reply != null) {
                SOAPBody localBody = this.reply.getSOAPBody();
                if (localBody.getFault() == null) {
                    Iterator it = localBody.getChildElements();
                    while (it.hasNext()) {
                        Node node = (Node)it.next();
                        if (node.getLocalName() != null) {
                            if (this.getStyle() == SoapStyle.RPC && node.getChildNodes().getLength() > 0) {
                                node = this.findFirstElementNode(node.getChildNodes(), localName);
                            } else if (firstLocalName == null || !node.getLocalName().equals(firstLocalName)) {
                                node = null;
                            }
                        } else {
                            node = null;
                        }
                        if (node == null) continue;
                        int nbelt = this.writeMessage(xwa.getXMLStreamWriter(), node);
                        xwa.incNbOpenedElement(nbelt);
                    }
                }
            } else if (this.exception != null) {
                if (localName.equals(this.errorExceptionName)) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    this.exception.printStackTrace(pw);
                    xwa.getXMLStreamWriter().writeCharacters(sw.toString());
                } else if (localName.equals(this.errorMessageName)) {
                    xwa.getXMLStreamWriter().writeCharacters(this.exception.getMessage());
                }
            }
        }
        catch (SOAPException | IOException | XMLStreamException e) {
            throw new EngineExceptionI(e);
        }
    }

    private Node findFirstElementNode(NodeList list, String localName) {
        Node node = null;
        int i = 0;
        while (i < list.getLength()) {
            node = (Node)list.item(i);
            if (node.getNodeType() == 1 && node.getLocalName().equals(localName)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int writeMessage(XMLStreamWriter xmlw, Node node) throws XMLStreamException, IOException {
        int ret = 0;
        if (node == null) return ret;
        if (this.attachmentsFolder != null) {
            if (!new File(this.attachmentsFolder).exists()) {
                throw new FileNotFoundException(Messages.getString("SoapOperation.1") + this.attachmentsFolder + Messages.getString("SoapOperation.2"));
            }
            if (!new File(this.attachmentsFolder).canWrite()) {
                throw new IOException(Messages.getString("SoapOperation.3") + this.attachmentsFolder + ".");
            }
            Iterator it = this.reply.getAttachments();
            while (it.hasNext()) {
                AttachmentPart part = (AttachmentPart)it.next();
                String filename = part.getContentId();
                File f = new File(this.attachmentsFolder + "/" + filename.replaceAll("[\\\\/:*?\"<>|]", ""));
                f.getParentFile().mkdirs();
                try {
                    Throwable throwable = null;
                    Object var9_14 = null;
                    try (FileOutputStream fos = new FileOutputStream(f);){
                        IOUtils.copy((InputStream)part.getRawContent(), (OutputStream)fos);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                catch (FileNotFoundException e) {
                    throw new IOException(Messages.getString("SoapOperation.4") + f.getAbsolutePath());
                }
                catch (Exception e) {
                    throw new IOException(Messages.getString("SoapOperation.5") + f.getAbsolutePath());
                }
            }
        }
        try {
            Node refItem;
            if (node.getNamespaceURI() != null && node.getNamespaceURI().equals("http://www.w3.org/2004/08/xop/include") && node.getLocalName().equals("Include") && (refItem = (Node)node.getAttributes().getNamedItem("href")) != null) {
                Object str = refItem.getNodeValue();
                URI uri = URI.create((String)str).normalize();
                str = "<" + URLDecoder.decode(uri.toString(), "UTF-8") + ">";
                Iterator it = this.reply.getAttachments();
                while (it.hasNext()) {
                    InputStream input;
                    AttachmentPart part = (AttachmentPart)it.next();
                    String str2 = part.getContentId().replaceFirst("<", "<cid:");
                    if (!str2.equals(str) || (input = part.getBase64Content()) == null) continue;
                    byte[] buffer = new byte[1024];
                    int bytesRead;
                    while ((bytesRead = input.read(buffer)) != -1) {
                        if (bytesRead < 1024) {
                            xmlw.writeCharacters(new String(Arrays.copyOf(buffer, bytesRead), StandardCharsets.UTF_8));
                            continue;
                        }
                        xmlw.writeCharacters(new String(buffer, StandardCharsets.UTF_8));
                    }
                    return 0;
                }
            }
        }
        catch (Exception e) {
            throw new XMLStreamException(Messages.getString("SoapOperation.6"), e);
        }
        xmlw.writeStartElement(node.getLocalName());
        ret = 1;
        int i = 0;
        while (node.getAttributes().getLength() > i) {
            Node attr = (Node)node.getAttributes().item(i);
            String name = attr.getLocalName();
            if (name == null) {
                name = attr.getNodeName();
            }
            if (attr.getNamespaceURI() != null && !attr.getNamespaceURI().isEmpty() && attr.getNamespaceURI().equals(XSI_URI)) {
                xmlw.writeAttribute(attr.getNamespaceURI(), name, attr.getNodeValue());
            } else {
                xmlw.writeAttribute(name, attr.getNodeValue());
            }
            ++i;
        }
        i = 0;
        while (node.getChildNodes().getLength() > i) {
            Node child = (Node)node.getChildNodes().item(i);
            if (child.getNodeType() == 4) {
                xmlw.writeCData(((CharacterData)child).getData());
            } else if (child.getNodeType() == 3) {
                String data = ((CharacterData)child).getData();
                xmlw.writeCharacters(data);
            } else {
                ret += this.writeMessage(xmlw, child);
            }
            ++i;
        }
        xmlw.writeEndElement();
        return ret;
    }

    @Override
    public boolean stopOpenOrClose() {
        return this.state == Operation.OperationState.OUTPUT && this.outputPartState == Operation.PartState.OPEN || this.state == Operation.OperationState.FAULT && this.faultPartState == Operation.PartState.OPEN || this.intoOutput && this.getStyle() == SoapStyle.RPC;
    }

    @Override
    public void writeFault(AbstractXmlWriterAPI xwa) throws EngineExceptionI {
        if (this.reply == null) {
            return;
        }
        try {
            SOAPBody localBody = this.reply.getSOAPBody();
            if (localBody.getFault() != null) {
                if (localBody.getFault().getFaultCode() != null) {
                    xwa.writeStartElement("faultcode");
                    xwa.getXMLStreamWriter().writeCharacters(localBody.getFault().getFaultCode());
                    xwa.getXMLStreamWriter().writeEndElement();
                }
                if (localBody.getFault().getFaultActor() != null) {
                    xwa.writeStartElement("faultactor");
                    xwa.getXMLStreamWriter().writeCharacters(localBody.getFault().getFaultActor());
                    xwa.getXMLStreamWriter().writeEndElement();
                }
                if (localBody.getFault().getFaultString() != null) {
                    xwa.writeStartElement("faultstring");
                    xwa.getXMLStreamWriter().writeCharacters(localBody.getFault().getFaultString());
                    xwa.getXMLStreamWriter().writeEndElement();
                }
                if (localBody.getFault() != null && localBody.getFault().getDetail() != null) {
                    Iterator it = localBody.getFault().getDetail().getChildElements();
                    while (it.hasNext()) {
                        Node node = (Node)it.next();
                        int nbElt = this.writeMessage(xwa.getXMLStreamWriter(), node);
                        xwa.incNbOpenedElement(nbElt);
                    }
                } else {
                    int nbElt = this.writeMessage(xwa.getXMLStreamWriter(), (Node)localBody.getFault());
                    xwa.incNbOpenedElement(nbElt);
                }
            }
        }
        catch (SOAPException | IOException | XMLStreamException e) {
            throw new EngineExceptionI(e);
        }
    }

    @Override
    public void clear() {
    }

    public void appendChild(Node doc) {
        this.currentElement.getOwnerDocument().adoptNode((org.w3c.dom.Node)doc);
        this.currentElement.appendChild((org.w3c.dom.Node)doc);
    }

    @Override
    public void killOpenedConnections() {
    }

    public void setErrorExceptionName(String errorExceptionName) {
        this.errorExceptionName = errorExceptionName;
    }

    public void setErrorMessageName(String errorMessageName) {
        this.errorMessageName = errorMessageName;
    }

    public void setAttachmentsFolder(String attachmentsFolder) {
        this.attachmentsFolder = attachmentsFolder;
    }

    public SoapStyle getStyle() {
        return this.style;
    }

    public boolean isRPCOperationISOpen() {
        return this.rpcOperationISOpen;
    }

    public void setRPCOperationISOpen(boolean rPCOperationISOpen) {
        this.rpcOperationISOpen = rPCOperationISOpen;
    }

    public void setStyle(SoapStyle style) {
        this.style = style;
    }

    public void setActionURI(String actionURI) {
        this.actionURI = actionURI;
    }

    public String getXsiPrefix() {
        return this.xsiPrefix;
    }

    public static enum SoapStyle {
        DOCUMENT,
        RPC;

    }
}

