/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.ui.mapper;

import com.indy.gmf.map.edit.provider.custom.MapperAdapter;
import com.indy.gmf.map.ui.mapper.FilteredViewerComponent;
import com.indy.gmf.map.ui.mapper.Messages;
import com.indy.gmf.map.ui.mapper.TextEditor;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.InputParameter;
import com.indy.map.MapPackage;
import com.indy.map.Variable;
import com.indy.map.impl.custom.Outliner;
import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.udf.ui.ViewUDFRegistryAction;
import com.semarchy.xdi.designer.core.CodeCapability;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class MapperUI
implements MapperAdapter.EditionHelperListener {
    static ImageDescriptor clearImg;
    static Image sortImg;
    public static ImageDescriptor mapperImg;
    private FilteredViewerComponent sourceComponent;
    private FilteredViewerComponent targetComponent;
    private TextEditor editor;
    private Canvas canvas;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private MapperAdapter.EditionHelper editionHelper;
    private Composite main;
    private MapperAdapter input;
    private boolean alpabeticalSorting = true;
    private FilteredViewerComponent.Listener targetListener;
    private Adapter setDescAdapter = new Adapter(){

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == MapPackage.eINSTANCE.getDatastore_SetDescriptor() || notification.getFeature() == MapPackage.eINSTANCE.getQuery_SetDescriptor()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).MapperUI.this.sourceComponent.getViewer().getTree().redraw();
                        (this).MapperUI.this.targetComponent.getViewer().getTree().redraw();
                    }
                });
            }
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }
    };

    static {
        try {
            clearImg = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui/icons/full/etool16/clear.png"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            mapperImg = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.ui.mapper/icons/16x16/mapper-16x16.png"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            sortImg = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.wst.xml.ui/icons/full/obj16/sort.gif")).createImage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Control getControl() {
        return this.main;
    }

    public Composite createControl(Composite parent, boolean isAlpabeticalSorting) {
        this.alpabeticalSorting = isAlpabeticalSorting;
        this.widgetFactory = new TabbedPropertySheetWidgetFactory();
        Composite p = this.widgetFactory.createComposite(parent, 0);
        GridLayout gl = null;
        gl = new GridLayout();
        p.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        ToolBar tb = new ToolBar(p, 0x800100);
        tb.setLayoutData((Object)new GridData(4, 1, true, false));
        this.widgetFactory.adapt((Composite)tb);
        ToolItem it = new ToolItem(tb, 32);
        it.setToolTipText(Messages.MapperUI_3);
        it.setImage(sortImg);
        it.setSelection(isAlpabeticalSorting);
        it.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((ToolItem)e.widget).getSelection()) {
                    MapperUI.this.alpabeticalSorting = true;
                    MapperUI.this.sourceComponent.setSortingMode(FilteredViewerComponent.SortingMode.ALPHA);
                    MapperUI.this.targetComponent.setSortingMode(FilteredViewerComponent.SortingMode.ALPHA);
                } else {
                    MapperUI.this.alpabeticalSorting = false;
                    MapperUI.this.sourceComponent.setSortingMode(FilteredViewerComponent.SortingMode.POSITION);
                    MapperUI.this.targetComponent.setSortingMode(FilteredViewerComponent.SortingMode.POSITION);
                }
            }
        });
        this.sourceComponent = new FilteredViewerComponent(this.widgetFactory, FilteredViewerComponent.Mode.SOURCE);
        this.targetComponent = new FilteredViewerComponent(this.widgetFactory, FilteredViewerComponent.Mode.TARGET);
        this.sourceComponent.setSortingMode(this.alpabeticalSorting ? FilteredViewerComponent.SortingMode.ALPHA : FilteredViewerComponent.SortingMode.POSITION);
        this.targetComponent.setSortingMode(this.alpabeticalSorting ? FilteredViewerComponent.SortingMode.ALPHA : FilteredViewerComponent.SortingMode.POSITION);
        this.editor = new TextEditor(this.widgetFactory);
        parent.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (MapperUI.this.widgetFactory != null) {
                    MapperUI.this.widgetFactory.dispose();
                }
            }
        });
        this.main = new SashForm(p, 512);
        this.main.setLayoutData((Object)new GridData(1808));
        this.widgetFactory.adapt(this.main);
        Composite c = this.widgetFactory.createComposite(this.main, 0);
        GridLayout gl2 = null;
        gl2 = new GridLayout(10, true);
        c.setLayout((Layout)gl2);
        gl2.horizontalSpacing = 0;
        gl2.marginWidth = 0;
        gl2.marginHeight = 0;
        gl2.verticalSpacing = 0;
        this.sourceComponent.createControl(c).setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.canvas = new Canvas(c, 0);
        this.canvas.setBackground(this.widgetFactory.getColors().getBackground());
        this.canvas.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setAdvanced(true);
                e.gc.setAntialias(1);
                for (Object trg : MapperUI.this.targetComponent.getAll().toList()) {
                    Point end = MapperUI.this.targetComponent.getAnchor(trg);
                    if (end == null) continue;
                    end = MapperUI.this.targetComponent.getControl().toDisplay(end);
                    end = ((Canvas)e.widget).toControl(end);
                    for (Object src : MapperUI.this.editionHelper.getSources(trg)) {
                        Point start = MapperUI.this.sourceComponent.getAnchor(src);
                        if (start == null) continue;
                        start = MapperUI.this.sourceComponent.getControl().toDisplay(start);
                        start = ((Canvas)e.widget).toControl(start);
                        RGB color = StringConverter.asRGB((String)Platform.getPreferencesService().getString("com.indy.gmf.map.diagram", "Appearance.targetColor", "#000000", new IScopeContext[]{InstanceScope.INSTANCE}));
                        if (MapperUI.this.targetComponent.getSelection().toList().contains(trg)) {
                            e.gc.setForeground(Activator.getDefault().getColor(color));
                            e.gc.setLineStyle(1);
                        } else {
                            e.gc.setForeground(e.gc.getDevice().getSystemColor(15));
                            e.gc.setLineStyle(3);
                        }
                        Point2D.Double p1 = new Point2D.Double(start.x, start.y);
                        Point2D.Double p4 = new Point2D.Double(end.x, end.y);
                        Point2D.Double vector = new Point2D.Double(p4.x - p1.x, p4.y - p1.x);
                        double sign = Math.signum(vector.getY() / vector.getX());
                        double coef = 0.25;
                        Path p = new Path(e.gc.getDevice());
                        p.moveTo((float)p1.x, (float)p1.y);
                        p.cubicTo((float)start.x + (float)coef * (float)((Canvas)e.widget).getBounds().width, (float)((double)start.y + sign * 1.0), (float)((double)end.x - Math.abs(coef * (double)((Canvas)e.widget).getBounds().width)), (float)((double)end.y - sign * 1.0), (float)p4.x, (float)p4.y);
                        e.gc.drawPath(p);
                        p.dispose();
                    }
                }
            }
        });
        this.targetComponent.createControl(c).setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        ToolBar tb2 = new ToolBar(c, 0x800100);
        tb2.setLayoutData((Object)new GridData(4, 1, true, false, 10, 1));
        this.widgetFactory.adapt((Composite)tb2);
        Composite expressionComposite = this.widgetFactory.createComposite(this.main, 2048);
        gl2 = new GridLayout();
        expressionComposite.setLayout((Layout)gl2);
        gl2.horizontalSpacing = 0;
        gl2.marginWidth = 0;
        gl2.verticalSpacing = 0;
        this.editor.createContent(expressionComposite).setLayoutData((Object)new GridData(4, 4, true, true));
        final ToolBarManager mgr = new ToolBarManager(tb2);
        final ViewUDFRegistryAction a = new ViewUDFRegistryAction(this.editor.adapt(SourceViewer.class));
        mgr.add((IAction)a);
        final Action clearAction = new Action(Messages.MapperUI_7){

            public void run() {
                MapperUI.this.editor.clearText();
            }
        };
        clearAction.setImageDescriptor(clearImg);
        this.targetComponent.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                a.setAllowed(!event.getSelection().isEmpty() && MapperUI.this.editionHelper.getCodeCapability() != null && MapperUI.this.editionHelper.getCodeCapability().getCodingStyleInfo() == CodeCapability.MAPPING_SQL);
                clearAction.setEnabled(!event.getSelection().isEmpty() && ((IStructuredSelection)event.getSelection()).getFirstElement() instanceof ILogicalField);
                mgr.update(false);
                MapperUI.this.editor.setFocus();
            }
        });
        mgr.add((IAction)clearAction);
        mgr.update(true);
        this.hookListeners();
        ((SashForm)this.main).setWeights(new int[]{70, 30});
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MapperUI.this.disposeListeners();
            }
        });
        return this.main;
    }

    protected void disposeListeners() {
        for (IContainer o : this.input.getSourceContainers()) {
            o.eAdapters().remove((Object)this.setDescAdapter);
        }
        this.input.getTargetContainer().eAdapters().remove((Object)this.setDescAdapter);
    }

    private void hookListeners() {
        this.sourceComponent.configureDnd();
        this.targetComponent.configureDnd();
        this.sourceComponent.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                String text = MapperUI.this.editionHelper.convertToText((Object)event.getSelection());
                MapperUI.this.editor.addTextInCurrentSelection(text, null);
            }
        });
    }

    public void setInput(MapperAdapter adapter) {
        this.input = adapter;
        this.editionHelper = adapter.getEditionHelper();
        this.sourceComponent.setInput(adapter.getSourceContainers());
        this.sourceComponent.configure(new FilteredViewerComponent.Listener(){

            @Override
            public void doDrop(Object dropedObject, Object dropTarget) {
            }

            @Override
            public void handleSelectionChanged(IStructuredSelection selection) {
            }

            @Override
            public void handleRepaint() {
                MapperUI.this.canvas.redraw();
            }
        }, adapter.getSrcImgProvider());
        this.targetComponent.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(parentElement instanceof Outliner) || !((Outliner)parentElement).getOutputField().contains(element);
            }
        });
        this.targetComponent.setInput(Collections.singletonList(adapter.getTargetContainer()));
        this.targetListener = new FilteredViewerComponent.Listener(){

            @Override
            public void doDrop(Object dropedObject, Object dropTarget) {
                Object addValue = "";
                for (Object o : ((IStructuredSelection)dropedObject).toList()) {
                    Variable srcObject;
                    if (o instanceof ILogicalField) {
                        addValue = (String)addValue + ((ILogicalField)o).getFullPath();
                        continue;
                    }
                    if (o instanceof Variable) {
                        srcObject = (Variable)o;
                        addValue = (String)addValue + "%{" + srcObject.getAlias().toString() + "}%";
                        continue;
                    }
                    if (!(o instanceof InputParameter)) continue;
                    srcObject = (InputParameter)o;
                    addValue = (String)addValue + "%{" + srcObject.getName().toString() + "}%";
                }
                if (addValue != null) {
                    EObject formerEdition = MapperUI.this.editionHelper.getEditedObject();
                    try {
                        MapperUI.this.editor.disableListener();
                        MapperUI.this.editionHelper.setEditionContext(dropTarget);
                        Object curValue = null;
                        if (MapperUI.this.editionHelper.getCodeCapability() != null) {
                            curValue = MapperUI.this.editionHelper.getEditedObject().eGet(MapperUI.this.editionHelper.getCodeCapability().getEStructuralFeature());
                        }
                        boolean append = curValue instanceof String && !((String)curValue).isEmpty();
                        Object newValue = null;
                        newValue = append ? String.valueOf(curValue) + " + " + (String)addValue : addValue;
                        MapperUI.this.editionHelper.performEdition((String)newValue);
                    }
                    catch (Throwable throwable) {
                        if (!((IStructuredSelection)MapperUI.this.targetComponent.getViewer().getSelection()).toList().contains(dropTarget)) {
                            Display.getDefault().asyncExec(new Runnable(dropTarget){
                                private final /* synthetic */ Object val$dropTarget;
                                {
                                    this.val$dropTarget = object;
                                }

                                @Override
                                public void run() {
                                    (this).MapperUI.this.targetComponent.getViewer().setSelection((ISelection)new StructuredSelection(this.val$dropTarget));
                                }
                            });
                        }
                        throw throwable;
                    }
                    if (!((IStructuredSelection)MapperUI.this.targetComponent.getViewer().getSelection()).toList().contains(dropTarget)) {
                        Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                }
            }

            @Override
            public void handleSelectionChanged(IStructuredSelection selection) {
                ((Composite)MapperUI.this.main.getChildren()[0]).getChildren()[1].redraw();
                MapperUI.this.editor.disableListener();
                MapperUI.this.editionHelper.setEditionContext(selection.getFirstElement());
                MapperUI.this.editor.setInput(MapperUI.this.editionHelper);
                HashSet<Object> toColor = new HashSet<Object>();
                for (Object o : selection.toList()) {
                    toColor.addAll(MapperUI.this.editionHelper.getSources(o));
                }
                MapperUI.this.sourceComponent.setColoredObjects(toColor);
            }

            @Override
            public void handleRepaint() {
                MapperUI.this.canvas.redraw();
            }
        };
        this.targetComponent.configure(this.targetListener, adapter.getTrgImgProvider());
        this.editionHelper.addListener((MapperAdapter.EditionHelperListener)this);
        this.main.layout(true, true);
        this.targetComponent.setSelection(adapter.getInitialSelection());
        for (IContainer o : adapter.getSourceContainers()) {
            o.eAdapters().add((Object)this.setDescAdapter);
        }
        adapter.getTargetContainer().eAdapters().add((Object)this.setDescAdapter);
    }

    public void handleValueChange() {
        for (Object o : this.targetComponent.getSelection().toList()) {
            this.targetComponent.getViewer().refresh(o, true);
        }
        for (Object o : this.sourceComponent.getSelection().toList()) {
            this.sourceComponent.getViewer().refresh(o, true);
        }
        this.canvas.redraw();
    }

    public boolean isAlphabeticalSorting() {
        return this.alpabeticalSorting;
    }
}

